/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.impl.VirtualHostImpl;
import com.liferay.portal.model.impl.VirtualHostModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class VirtualHostPersistenceImpl
extends BasePersistenceImpl<VirtualHost>
implements VirtualHostPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = VirtualHostImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByHostname;
    private FinderPath _finderPathCountByHostname;
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_2 = "virtualHost.hostname = ?";
    private static final String _FINDER_COLUMN_HOSTNAME_HOSTNAME_3 = "(virtualHost.hostname IS NULL OR virtualHost.hostname = '')";
    private FinderPath _finderPathFetchByC_L;
    private FinderPath _finderPathCountByC_L;
    private static final String _FINDER_COLUMN_C_L_COMPANYID_2 = "virtualHost.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_L_LAYOUTSETID_2 = "virtualHost.layoutSetId = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_VIRTUALHOST = "SELECT virtualHost FROM VirtualHost virtualHost";
    private static final String _SQL_SELECT_VIRTUALHOST_WHERE = "SELECT virtualHost FROM VirtualHost virtualHost WHERE ";
    private static final String _SQL_COUNT_VIRTUALHOST = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost";
    private static final String _SQL_COUNT_VIRTUALHOST_WHERE = "SELECT COUNT(virtualHost) FROM VirtualHost virtualHost WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "virtualHost.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No VirtualHost exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No VirtualHost exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(VirtualHostPersistenceImpl.class);

    @Override
    public VirtualHost findByHostname(String hostname) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByHostname(hostname);
        if (virtualHost == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("hostname=");
            msg.append(hostname);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchVirtualHostException(msg.toString());
        }
        return virtualHost;
    }

    @Override
    public VirtualHost fetchByHostname(String hostname) {
        return this.fetchByHostname(hostname, true);
    }

    @Override
    public VirtualHost fetchByHostname(String hostname, boolean retrieveFromCache) {
        VirtualHost virtualHost;
        hostname = Objects.toString(hostname, "");
        Object[] finderArgs = new Object[]{hostname};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByHostname, finderArgs, this);
        }
        if (result instanceof VirtualHost && !Objects.equals(hostname, (virtualHost = (VirtualHost)result).getHostname())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname.isEmpty()) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindHostname) {
                    qPos.add(hostname);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByHostname, finderArgs, list);
                } else {
                    VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                    result = virtualHost2;
                    this.cacheResult(virtualHost2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByHostname, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    @Override
    public VirtualHost removeByHostname(String hostname) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByHostname(hostname);
        return this.remove(virtualHost);
    }

    @Override
    public int countByHostname(String hostname) {
        hostname = Objects.toString(hostname, "");
        FinderPath finderPath = this._finderPathCountByHostname;
        Object[] finderArgs = new Object[]{hostname};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            boolean bindHostname = false;
            if (hostname.isEmpty()) {
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_3);
            } else {
                bindHostname = true;
                query.append(_FINDER_COLUMN_HOSTNAME_HOSTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindHostname) {
                    qPos.add(hostname);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public VirtualHost findByC_L(long companyId, long layoutSetId) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.fetchByC_L(companyId, layoutSetId);
        if (virtualHost == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", layoutSetId=");
            msg.append(layoutSetId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchVirtualHostException(msg.toString());
        }
        return virtualHost;
    }

    @Override
    public VirtualHost fetchByC_L(long companyId, long layoutSetId) {
        return this.fetchByC_L(companyId, layoutSetId, true);
    }

    @Override
    public VirtualHost fetchByC_L(long companyId, long layoutSetId, boolean retrieveFromCache) {
        VirtualHost virtualHost;
        Object[] finderArgs = new Object[]{companyId, layoutSetId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_L, finderArgs, this);
        }
        if (result instanceof VirtualHost && (companyId != (virtualHost = (VirtualHost)result).getCompanyId() || layoutSetId != virtualHost.getLayoutSetId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_VIRTUALHOST_WHERE);
            query.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(layoutSetId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_L, finderArgs, list);
                } else {
                    VirtualHost virtualHost2 = (VirtualHost)list.get(0);
                    result = virtualHost2;
                    this.cacheResult(virtualHost2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_L, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (VirtualHost)result;
    }

    @Override
    public VirtualHost removeByC_L(long companyId, long layoutSetId) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = this.findByC_L(companyId, layoutSetId);
        return this.remove(virtualHost);
    }

    @Override
    public int countByC_L(long companyId, long layoutSetId) {
        FinderPath finderPath = this._finderPathCountByC_L;
        Object[] finderArgs = new Object[]{companyId, layoutSetId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_VIRTUALHOST_WHERE);
            query.append(_FINDER_COLUMN_C_L_COMPANYID_2);
            query.append(_FINDER_COLUMN_C_L_LAYOUTSETID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(layoutSetId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public VirtualHostPersistenceImpl() {
        this.setModelClass(VirtualHost.class);
        this.setModelImplClass(VirtualHostImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(VirtualHostModelImpl.ENTITY_CACHE_ENABLED);
    }

    @Override
    public void cacheResult(VirtualHost virtualHost) {
        EntityCacheUtil.putResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, Long.valueOf(virtualHost.getPrimaryKey()), virtualHost);
        FinderCacheUtil.putResult(this._finderPathFetchByHostname, new Object[]{virtualHost.getHostname()}, virtualHost);
        FinderCacheUtil.putResult(this._finderPathFetchByC_L, new Object[]{virtualHost.getCompanyId(), virtualHost.getLayoutSetId()}, virtualHost);
        virtualHost.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<VirtualHost> virtualHosts) {
        for (VirtualHost virtualHost : virtualHosts) {
            if (EntityCacheUtil.getResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, Long.valueOf(virtualHost.getPrimaryKey())) == null) {
                this.cacheResult(virtualHost);
                continue;
            }
            virtualHost.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(VirtualHostImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(VirtualHost virtualHost) {
        EntityCacheUtil.removeResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, Long.valueOf(virtualHost.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((VirtualHostModelImpl)((Object)virtualHost), true);
    }

    @Override
    public void clearCache(List<VirtualHost> virtualHosts) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (VirtualHost virtualHost : virtualHosts) {
            EntityCacheUtil.removeResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, Long.valueOf(virtualHost.getPrimaryKey()));
            this.clearUniqueFindersCache((VirtualHostModelImpl)((Object)virtualHost), true);
        }
    }

    protected void cacheUniqueFindersCache(VirtualHostModelImpl virtualHostModelImpl) {
        Object[] args = new Object[]{virtualHostModelImpl.getHostname()};
        FinderCacheUtil.putResult(this._finderPathCountByHostname, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByHostname, args, virtualHostModelImpl, false);
        args = new Object[]{virtualHostModelImpl.getCompanyId(), virtualHostModelImpl.getLayoutSetId()};
        FinderCacheUtil.putResult(this._finderPathCountByC_L, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_L, args, virtualHostModelImpl, false);
    }

    protected void clearUniqueFindersCache(VirtualHostModelImpl virtualHostModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{virtualHostModelImpl.getHostname()};
            FinderCacheUtil.removeResult(this._finderPathCountByHostname, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByHostname, args);
        }
        if ((virtualHostModelImpl.getColumnBitmask() & this._finderPathFetchByHostname.getColumnBitmask()) != 0L) {
            args = new Object[]{virtualHostModelImpl.getOriginalHostname()};
            FinderCacheUtil.removeResult(this._finderPathCountByHostname, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByHostname, args);
        }
        if (clearCurrent) {
            args = new Object[]{virtualHostModelImpl.getCompanyId(), virtualHostModelImpl.getLayoutSetId()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_L, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_L, args);
        }
        if ((virtualHostModelImpl.getColumnBitmask() & this._finderPathFetchByC_L.getColumnBitmask()) != 0L) {
            args = new Object[]{virtualHostModelImpl.getOriginalCompanyId(), virtualHostModelImpl.getOriginalLayoutSetId()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_L, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_L, args);
        }
    }

    @Override
    public VirtualHost create(long virtualHostId) {
        VirtualHostImpl virtualHost = new VirtualHostImpl();
        virtualHost.setNew(true);
        virtualHost.setPrimaryKey(virtualHostId);
        virtualHost.setCompanyId(this.companyProvider.getCompanyId());
        return virtualHost;
    }

    @Override
    public VirtualHost remove(long virtualHostId) throws NoSuchVirtualHostException {
        return this.remove(Long.valueOf(virtualHostId));
    }

    @Override
    public VirtualHost remove(Serializable primaryKey) throws NoSuchVirtualHostException {
        Session session = null;
        try {
            session = this.openSession();
            VirtualHost virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, primaryKey);
            if (virtualHost == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            VirtualHost virtualHost2 = this.remove(virtualHost);
            return virtualHost2;
        }
        catch (NoSuchVirtualHostException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected VirtualHost removeImpl(VirtualHost virtualHost) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(virtualHost)) {
                virtualHost = (VirtualHost)session.get(VirtualHostImpl.class, virtualHost.getPrimaryKeyObj());
            }
            if (virtualHost != null) {
                session.delete(virtualHost);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (virtualHost != null) {
            this.clearCache(virtualHost);
        }
        return virtualHost;
    }

    @Override
    public VirtualHost updateImpl(VirtualHost virtualHost) {
        boolean isNew = virtualHost.isNew();
        if (!(virtualHost instanceof VirtualHostModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(virtualHost.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(virtualHost);
                throw new IllegalArgumentException("Implement ModelWrapper in virtualHost proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom VirtualHost implementation " + virtualHost.getClass());
        }
        VirtualHostModelImpl virtualHostModelImpl = (VirtualHostModelImpl)((Object)virtualHost);
        Session session = null;
        try {
            session = this.openSession();
            if (virtualHost.isNew()) {
                session.save(virtualHost);
                virtualHost.setNew(false);
            } else {
                virtualHost = (VirtualHost)session.merge(virtualHost);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!VirtualHostModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        EntityCacheUtil.putResult(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostImpl.class, Long.valueOf(virtualHost.getPrimaryKey()), virtualHost, false);
        this.clearUniqueFindersCache(virtualHostModelImpl, false);
        this.cacheUniqueFindersCache(virtualHostModelImpl);
        virtualHost.resetOriginalValues();
        return virtualHost;
    }

    @Override
    public VirtualHost findByPrimaryKey(Serializable primaryKey) throws NoSuchVirtualHostException {
        VirtualHost virtualHost = (VirtualHost)this.fetchByPrimaryKey(primaryKey);
        if (virtualHost == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchVirtualHostException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return virtualHost;
    }

    @Override
    public VirtualHost findByPrimaryKey(long virtualHostId) throws NoSuchVirtualHostException {
        return this.findByPrimaryKey(Long.valueOf(virtualHostId));
    }

    @Override
    public VirtualHost fetchByPrimaryKey(long virtualHostId) {
        return (VirtualHost)this.fetchByPrimaryKey(Long.valueOf(virtualHostId));
    }

    @Override
    public List<VirtualHost> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<VirtualHost> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<VirtualHost> findAll(int start, int end, OrderByComparator<VirtualHost> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<VirtualHost> findAll(int start, int end, OrderByComparator<VirtualHost> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<VirtualHost> list = null;
        if (retrieveFromCache) {
            list = (List<VirtualHost>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_VIRTUALHOST);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_VIRTUALHOST;
                if (pagination) {
                    sql = sql.concat(" ORDER BY virtualHost.virtualHostId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (VirtualHost virtualHost : this.findAll()) {
            this.remove(virtualHost);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_VIRTUALHOST);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "virtualHostId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_VIRTUALHOST;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return VirtualHostModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByHostname = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByHostname", new String[]{String.class.getName()}, 2L);
        this._finderPathCountByHostname = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByHostname", new String[]{String.class.getName()});
        this._finderPathFetchByC_L = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, VirtualHostImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_L", new String[]{Long.class.getName(), Long.class.getName()}, 5L);
        this._finderPathCountByC_L = new FinderPath(VirtualHostModelImpl.ENTITY_CACHE_ENABLED, VirtualHostModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_L", new String[]{Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(VirtualHostImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

