/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchUserGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.persistence.UserGroupFinder;
import com.liferay.portal.kernel.service.persistence.UserGroupUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.UserGroupImpl;
import com.liferay.portal.service.persistence.constants.UserGroupFinderConstants;
import com.liferay.portal.service.persistence.impl.UserGroupFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UserGroupFinderImpl
extends UserGroupFinderBaseImpl
implements UserGroupFinder {
    public static final String COUNT_BY_C_N_D = UserGroupFinder.class.getName() + ".countByC_N_D";
    public static final String FIND_BY_C_N_D = UserGroupFinder.class.getName() + ".findByC_N_D";
    public static final String JOIN_BY_USER_GROUP_GROUP_ROLE = UserGroupFinder.class.getName() + ".joinByUserGroupGroupRole";
    public static final String JOIN_BY_USER_GROUPS_GROUPS = UserGroupFinder.class.getName() + ".joinByUserGroupsGroups";
    public static final String JOIN_BY_USER_GROUPS_ROLES = UserGroupFinder.class.getName() + ".joinByUserGroupsRoles";
    public static final String JOIN_BY_USER_GROUPS_TEAMS = UserGroupFinder.class.getName() + ".joinByUserGroupsTeams";
    public static final String JOIN_BY_USER_GROUPS_USERS = UserGroupFinder.class.getName() + ".joinByUserGroupsUsers";

    @Override
    public int countByKeywords(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        return this.doCountByKeywords(companyId, keywords, params, false);
    }

    @Override
    public int countByC_N_D(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] names = CustomSQLUtil.keywords(name);
        String[] descriptions = CustomSQLUtil.keywords(description);
        return this.countByC_N_D(companyId, names, descriptions, params, andOperator);
    }

    @Override
    public int countByC_N_D(long companyId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.doCountByC_N_D(companyId, names, descriptions, params, andOperator, false);
    }

    @Override
    public int filterCountByKeywords(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        return this.doCountByKeywords(companyId, keywords, params, true);
    }

    @Override
    public int filterCountByC_N_D(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] names = CustomSQLUtil.keywords(name);
        String[] descriptions = CustomSQLUtil.keywords(description);
        return this.filterCountByC_N_D(companyId, names, descriptions, params, andOperator);
    }

    @Override
    public int filterCountByC_N_D(long companyId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.doCountByC_N_D(companyId, names, descriptions, params, andOperator, true);
    }

    @Override
    public List<UserGroup> filterFindByKeywords(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<UserGroup> obc) {
        return this.doFindByKeywords(companyId, keywords, params, start, end, obc, true);
    }

    @Override
    public List<UserGroup> filterFindByC_N_D(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> obc) {
        String[] names = CustomSQLUtil.keywords(name);
        String[] descriptions = CustomSQLUtil.keywords(description);
        return this.filterFindByC_N_D(companyId, names, descriptions, params, andOperator, start, end, obc);
    }

    @Override
    public List<UserGroup> filterFindByC_N_D(long companyId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> obc) {
        return this.doFindByC_N_D(companyId, names, descriptions, params, andOperator, start, end, obc, true);
    }

    @Override
    public List<UserGroup> findByKeywords(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<UserGroup> obc) {
        return this.doFindByKeywords(companyId, keywords, params, start, end, obc, false);
    }

    @Override
    @Deprecated
    public UserGroup findByC_N(long companyId, String name) throws NoSuchUserGroupException {
        return UserGroupUtil.findByC_N(companyId, name);
    }

    @Override
    public List<UserGroup> findByC_N_D(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> obc) {
        String[] names = CustomSQLUtil.keywords(name);
        String[] descriptions = CustomSQLUtil.keywords(description);
        return this.findByC_N_D(companyId, names, descriptions, params, andOperator, start, end, obc);
    }

    @Override
    public List<UserGroup> findByC_N_D(long companyId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> obc) {
        return this.doFindByC_N_D(companyId, names, descriptions, params, andOperator, start, end, obc, false);
    }

    protected int doCountByKeywords(long companyId, String keywords, LinkedHashMap<String, Object> params, boolean inlineSQLHelper) {
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            names = CustomSQLUtil.keywords(keywords);
            descriptions = CustomSQLUtil.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.doCountByC_N_D(companyId, names, descriptions, params, andOperator, inlineSQLHelper);
    }

    protected int doCountByC_N_D(long companyId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, boolean inlineSQLHelper) {
        names = CustomSQLUtil.keywords(names);
        descriptions = CustomSQLUtil.keywords(descriptions);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get(COUNT_BY_C_N_D);
            sql = CustomSQLUtil.replaceKeywords(sql, "LOWER(UserGroup.name)", "LIKE", false, names);
            sql = CustomSQLUtil.replaceKeywords(sql, "LOWER(UserGroup.description)", "LIKE", true, descriptions);
            sql = StringUtil.replace(sql, "[$JOIN$]", this.getJoin(params));
            sql = StringUtil.replace(sql, "[$WHERE$]", this.getWhere(params));
            sql = CustomSQLUtil.replaceAndOperator(sql, andOperator);
            if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
                sql = InlineSQLHelperUtil.replacePermissionCheck(sql, UserGroup.class.getName(), "UserGroup.userGroupId", null, null, new long[]{0L}, null);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<UserGroup> doFindByKeywords(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<UserGroup> obc, boolean inlineSQLHelper) {
        String[] names = null;
        String[] descriptions = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            names = CustomSQLUtil.keywords(keywords);
            descriptions = CustomSQLUtil.keywords(keywords);
        } else {
            andOperator = true;
        }
        return this.doFindByC_N_D(companyId, names, descriptions, params, andOperator, start, end, obc, inlineSQLHelper);
    }

    protected List<UserGroup> doFindByC_N_D(long companyId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> obc, boolean inlineSQLHelper) {
        names = CustomSQLUtil.keywords(names);
        descriptions = CustomSQLUtil.keywords(descriptions);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(FIND_BY_C_N_D);
            sql = CustomSQLUtil.replaceKeywords(sql, "LOWER(UserGroup.name)", "LIKE", false, names);
            sql = CustomSQLUtil.replaceKeywords(sql, "LOWER(UserGroup.description)", "LIKE", true, descriptions);
            sql = StringUtil.replace(sql, "[$JOIN$]", this.getJoin(params));
            sql = StringUtil.replace(sql, "[$WHERE$]", this.getWhere(params));
            sql = CustomSQLUtil.replaceAndOperator(sql, andOperator);
            sql = CustomSQLUtil.replaceOrderBy(sql, obc);
            if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
                sql = InlineSQLHelperUtil.replacePermissionCheck(sql, UserGroup.class.getName(), "UserGroup.userGroupId", null, null, new long[]{0L}, null);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("UserGroup", UserGroupImpl.class);
            QueryPos qPos = QueryPos.getInstance(q);
            this.setJoin(qPos, params);
            qPos.add(companyId);
            qPos.add(names, 2);
            qPos.add(descriptions, 2);
            List<UserGroup> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!this._isFinderParam(key) || !Validator.isNotNull(value = entry.getValue())) continue;
            sb.append(this.getJoin(key));
        }
        return sb.toString();
    }

    protected String getJoin(String key) {
        int pos;
        String join = "";
        if (key.equals("userGroupGroupRole")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUP_GROUP_ROLE);
        } else if (key.equals("userGroupsGroups")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_GROUPS);
        } else if (key.equals("userGroupsRoles")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_ROLES);
        } else if (key.equals("userGroupsTeams")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_TEAMS);
        } else if (key.equals("userGroupsUsers")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_USERS);
        }
        if (Validator.isNotNull(join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!this._isFinderParam(key) || !Validator.isNotNull(value = entry.getValue())) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key, Object value) {
        String join = "";
        if (key.equals("userGroupGroupRole")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUP_GROUP_ROLE);
        } else if (key.equals("userGroupsGroups")) {
            if (value instanceof Long) {
                join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_GROUPS);
            } else if (value instanceof Long[]) {
                Long[] userGroupIds = (Long[])value;
                if (userGroupIds.length == 0) {
                    join = "WHERE (Groups_UserGroups.groupId = -1)";
                } else {
                    StringBundler sb = new StringBundler(userGroupIds.length * 2 + 1);
                    sb.append("WHERE (");
                    for (int i = 0; i < userGroupIds.length; ++i) {
                        sb.append("(Groups_UserGroups.groupId = ?) ");
                        if (i + 1 >= userGroupIds.length) continue;
                        sb.append("OR ");
                    }
                    sb.append(")");
                    join = sb.toString();
                }
            }
        } else if (key.equals("userGroupsRoles")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_ROLES);
        } else if (key.equals("userGroupsTeams")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_TEAMS);
        } else if (key.equals("userGroupsUsers")) {
            join = CustomSQLUtil.get(JOIN_BY_USER_GROUPS_USERS);
        }
        if (Validator.isNotNull(join)) {
            int pos = join.indexOf("WHERE");
            if (pos != -1) {
                join = join.substring(pos + 5);
                join = join.concat(" AND ");
            } else {
                join = "";
            }
        }
        return join;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            String key = entry.getKey();
            if (!this._isFinderParam(key)) continue;
            Object value = entry.getValue();
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull(valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (value instanceof Long[]) {
                Long[] valueArray;
                for (Long curValue : valueArray = (Long[])value) {
                    if (!Validator.isNotNull(curValue)) continue;
                    qPos.add(curValue);
                }
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull(valueString = (String)value)) continue;
            qPos.add(valueString);
        }
    }

    private boolean _isFinderParam(String key) {
        return ArrayUtil.contains(UserGroupFinderConstants.PARAM_KEYS, key);
    }
}

