/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchTicketException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.TicketPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.TicketImpl;
import com.liferay.portal.model.impl.TicketModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TicketPersistenceImpl
extends BasePersistenceImpl<Ticket>
implements TicketPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TicketImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByKey;
    private FinderPath _finderPathCountByKey;
    private static final String _FINDER_COLUMN_KEY_KEY_2 = "ticket.key = ?";
    private static final String _FINDER_COLUMN_KEY_KEY_3 = "(ticket.key IS NULL OR ticket.key = '')";
    private FinderPath _finderPathWithPaginationFindByC_C_T;
    private FinderPath _finderPathWithoutPaginationFindByC_C_T;
    private FinderPath _finderPathCountByC_C_T;
    private static final String _FINDER_COLUMN_C_C_T_CLASSNAMEID_2 = "ticket.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_T_CLASSPK_2 = "ticket.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_T_TYPE_2 = "ticket.type = ?";
    private FinderPath _finderPathWithPaginationFindByC_C_C_T;
    private FinderPath _finderPathWithoutPaginationFindByC_C_C_T;
    private FinderPath _finderPathCountByC_C_C_T;
    private static final String _FINDER_COLUMN_C_C_C_T_COMPANYID_2 = "ticket.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_T_CLASSNAMEID_2 = "ticket.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_T_CLASSPK_2 = "ticket.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_T_TYPE_2 = "ticket.type = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_TICKET = "SELECT ticket FROM Ticket ticket";
    private static final String _SQL_SELECT_TICKET_WHERE = "SELECT ticket FROM Ticket ticket WHERE ";
    private static final String _SQL_COUNT_TICKET = "SELECT COUNT(ticket) FROM Ticket ticket";
    private static final String _SQL_COUNT_TICKET_WHERE = "SELECT COUNT(ticket) FROM Ticket ticket WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ticket.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Ticket exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Ticket exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(TicketPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"key", "type"});

    @Override
    public Ticket findByKey(String key) throws NoSuchTicketException {
        Ticket ticket = this.fetchByKey(key);
        if (ticket == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("key=");
            msg.append(key);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchTicketException(msg.toString());
        }
        return ticket;
    }

    @Override
    public Ticket fetchByKey(String key) {
        return this.fetchByKey(key, true);
    }

    @Override
    public Ticket fetchByKey(String key, boolean retrieveFromCache) {
        Ticket ticket;
        key = Objects.toString(key, "");
        Object[] finderArgs = new Object[]{key};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByKey, finderArgs, this);
        }
        if (result instanceof Ticket && !Objects.equals(key, (ticket = (Ticket)result).getKey())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_TICKET_WHERE);
            boolean bindKey = false;
            if (key.isEmpty()) {
                query.append(_FINDER_COLUMN_KEY_KEY_3);
            } else {
                bindKey = true;
                query.append(_FINDER_COLUMN_KEY_KEY_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindKey) {
                    qPos.add(key);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByKey, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("TicketPersistenceImpl.fetchByKey(String, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    Ticket ticket2 = (Ticket)list.get(0);
                    result = ticket2;
                    this.cacheResult(ticket2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByKey, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Ticket)result;
    }

    @Override
    public Ticket removeByKey(String key) throws NoSuchTicketException {
        Ticket ticket = this.findByKey(key);
        return this.remove(ticket);
    }

    @Override
    public int countByKey(String key) {
        key = Objects.toString(key, "");
        FinderPath finderPath = this._finderPathCountByKey;
        Object[] finderArgs = new Object[]{key};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_TICKET_WHERE);
            boolean bindKey = false;
            if (key.isEmpty()) {
                query.append(_FINDER_COLUMN_KEY_KEY_3);
            } else {
                bindKey = true;
                query.append(_FINDER_COLUMN_KEY_KEY_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindKey) {
                    qPos.add(key);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type) {
        return this.findByC_C_T(classNameId, classPK, type, -1, -1, null);
    }

    @Override
    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type, int start, int end) {
        return this.findByC_C_T(classNameId, classPK, type, start, end, null);
    }

    @Override
    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator) {
        return this.findByC_C_T(classNameId, classPK, type, start, end, orderByComparator, true);
    }

    @Override
    public List<Ticket> findByC_C_T(long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_C_T;
            finderArgs = new Object[]{classNameId, classPK, type};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_C_T;
            finderArgs = new Object[]{classNameId, classPK, type, start, end, orderByComparator};
        }
        List<Ticket> list = null;
        if (retrieveFromCache && (list = (List<Ticket>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Ticket ticket : list) {
                if (classNameId == ticket.getClassNameId() && classPK == ticket.getClassPK() && type == ticket.getType()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_TICKET_WHERE);
            query.append("ticket.classNameId = ? AND ");
            query.append("ticket.classPK = ? AND ");
            query.append("ticket.type = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ticket.ticketId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(type);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Ticket findByC_C_T_First(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_T_First(classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", type=");
        msg.append(type);
        msg.append("}");
        throw new NoSuchTicketException(msg.toString());
    }

    @Override
    public Ticket fetchByC_C_T_First(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        List<Ticket> list = this.findByC_C_T(classNameId, classPK, type, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Ticket findByC_C_T_Last(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_T_Last(classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", type=");
        msg.append(type);
        msg.append("}");
        throw new NoSuchTicketException(msg.toString());
    }

    @Override
    public Ticket fetchByC_C_T_Last(long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        int count = this.countByC_C_T(classNameId, classPK, type);
        if (count == 0) {
            return null;
        }
        List<Ticket> list = this.findByC_C_T(classNameId, classPK, type, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Ticket[] findByC_C_T_PrevAndNext(long ticketId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.findByPrimaryKey(ticketId);
        Session session = null;
        try {
            session = this.openSession();
            Ticket[] array = new TicketImpl[]{this.getByC_C_T_PrevAndNext(session, ticket, classNameId, classPK, type, orderByComparator, true), ticket, this.getByC_C_T_PrevAndNext(session, ticket, classNameId, classPK, type, orderByComparator, false)};
            Ticket[] ticketArray = array;
            return ticketArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Ticket getByC_C_T_PrevAndNext(Session session, Ticket ticket, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_TICKET_WHERE);
        query.append("ticket.classNameId = ? AND ");
        query.append("ticket.classPK = ? AND ");
        query.append("ticket.type = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ticket.ticketId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(classNameId);
        qPos.add(classPK);
        qPos.add(type);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(ticket)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Ticket)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_C_T(long classNameId, long classPK, int type) {
        for (Ticket ticket : this.findByC_C_T(classNameId, classPK, type, -1, -1, null)) {
            this.remove(ticket);
        }
    }

    @Override
    public int countByC_C_T(long classNameId, long classPK, int type) {
        FinderPath finderPath = this._finderPathCountByC_C_T;
        Object[] finderArgs = new Object[]{classNameId, classPK, type};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_TICKET_WHERE);
            query.append("ticket.classNameId = ? AND ");
            query.append("ticket.classPK = ? AND ");
            query.append("ticket.type = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(type);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type) {
        return this.findByC_C_C_T(companyId, classNameId, classPK, type, -1, -1, null);
    }

    @Override
    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type, int start, int end) {
        return this.findByC_C_C_T(companyId, classNameId, classPK, type, start, end, null);
    }

    @Override
    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator) {
        return this.findByC_C_C_T(companyId, classNameId, classPK, type, start, end, orderByComparator, true);
    }

    @Override
    public List<Ticket> findByC_C_C_T(long companyId, long classNameId, long classPK, int type, int start, int end, OrderByComparator<Ticket> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_C_C_T;
            finderArgs = new Object[]{companyId, classNameId, classPK, type};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_C_C_T;
            finderArgs = new Object[]{companyId, classNameId, classPK, type, start, end, orderByComparator};
        }
        List<Ticket> list = null;
        if (retrieveFromCache && (list = (List<Ticket>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Ticket ticket : list) {
                if (companyId == ticket.getCompanyId() && classNameId == ticket.getClassNameId() && classPK == ticket.getClassPK() && type == ticket.getType()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_TICKET_WHERE);
            query.append(_FINDER_COLUMN_C_C_C_T_COMPANYID_2);
            query.append("ticket.classNameId = ? AND ");
            query.append("ticket.classPK = ? AND ");
            query.append("ticket.type = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY ticket.ticketId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(type);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Ticket findByC_C_C_T_First(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_C_T_First(companyId, classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", type=");
        msg.append(type);
        msg.append("}");
        throw new NoSuchTicketException(msg.toString());
    }

    @Override
    public Ticket fetchByC_C_C_T_First(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        List<Ticket> list = this.findByC_C_C_T(companyId, classNameId, classPK, type, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Ticket findByC_C_C_T_Last(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.fetchByC_C_C_T_Last(companyId, classNameId, classPK, type, orderByComparator);
        if (ticket != null) {
            return ticket;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", type=");
        msg.append(type);
        msg.append("}");
        throw new NoSuchTicketException(msg.toString());
    }

    @Override
    public Ticket fetchByC_C_C_T_Last(long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) {
        int count = this.countByC_C_C_T(companyId, classNameId, classPK, type);
        if (count == 0) {
            return null;
        }
        List<Ticket> list = this.findByC_C_C_T(companyId, classNameId, classPK, type, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Ticket[] findByC_C_C_T_PrevAndNext(long ticketId, long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator) throws NoSuchTicketException {
        Ticket ticket = this.findByPrimaryKey(ticketId);
        Session session = null;
        try {
            session = this.openSession();
            Ticket[] array = new TicketImpl[]{this.getByC_C_C_T_PrevAndNext(session, ticket, companyId, classNameId, classPK, type, orderByComparator, true), ticket, this.getByC_C_C_T_PrevAndNext(session, ticket, companyId, classNameId, classPK, type, orderByComparator, false)};
            Ticket[] ticketArray = array;
            return ticketArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Ticket getByC_C_C_T_PrevAndNext(Session session, Ticket ticket, long companyId, long classNameId, long classPK, int type, OrderByComparator<Ticket> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_TICKET_WHERE);
        query.append(_FINDER_COLUMN_C_C_C_T_COMPANYID_2);
        query.append("ticket.classNameId = ? AND ");
        query.append("ticket.classPK = ? AND ");
        query.append("ticket.type = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY ticket.ticketId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        qPos.add(type);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(ticket)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Ticket)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_C_C_T(long companyId, long classNameId, long classPK, int type) {
        for (Ticket ticket : this.findByC_C_C_T(companyId, classNameId, classPK, type, -1, -1, null)) {
            this.remove(ticket);
        }
    }

    @Override
    public int countByC_C_C_T(long companyId, long classNameId, long classPK, int type) {
        FinderPath finderPath = this._finderPathCountByC_C_C_T;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK, type};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_TICKET_WHERE);
            query.append(_FINDER_COLUMN_C_C_C_T_COMPANYID_2);
            query.append("ticket.classNameId = ? AND ");
            query.append("ticket.classPK = ? AND ");
            query.append("ticket.type = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(type);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TicketPersistenceImpl() {
        this.setModelClass(Ticket.class);
        this.setModelImplClass(TicketImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(TicketModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("key", "key_");
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Ticket ticket) {
        EntityCacheUtil.putResult(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketImpl.class, Long.valueOf(ticket.getPrimaryKey()), ticket);
        FinderCacheUtil.putResult(this._finderPathFetchByKey, new Object[]{ticket.getKey()}, ticket);
        ticket.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Ticket> tickets) {
        for (Ticket ticket : tickets) {
            if (EntityCacheUtil.getResult(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketImpl.class, Long.valueOf(ticket.getPrimaryKey())) == null) {
                this.cacheResult(ticket);
                continue;
            }
            ticket.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(TicketImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Ticket ticket) {
        EntityCacheUtil.removeResult(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketImpl.class, Long.valueOf(ticket.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((TicketModelImpl)((Object)ticket), true);
    }

    @Override
    public void clearCache(List<Ticket> tickets) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Ticket ticket : tickets) {
            EntityCacheUtil.removeResult(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketImpl.class, Long.valueOf(ticket.getPrimaryKey()));
            this.clearUniqueFindersCache((TicketModelImpl)((Object)ticket), true);
        }
    }

    protected void cacheUniqueFindersCache(TicketModelImpl ticketModelImpl) {
        Object[] args = new Object[]{ticketModelImpl.getKey()};
        FinderCacheUtil.putResult(this._finderPathCountByKey, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByKey, args, ticketModelImpl, false);
    }

    protected void clearUniqueFindersCache(TicketModelImpl ticketModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{ticketModelImpl.getKey()};
            FinderCacheUtil.removeResult(this._finderPathCountByKey, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByKey, args);
        }
        if ((ticketModelImpl.getColumnBitmask() & this._finderPathFetchByKey.getColumnBitmask()) != 0L) {
            args = new Object[]{ticketModelImpl.getOriginalKey()};
            FinderCacheUtil.removeResult(this._finderPathCountByKey, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByKey, args);
        }
    }

    @Override
    public Ticket create(long ticketId) {
        TicketImpl ticket = new TicketImpl();
        ticket.setNew(true);
        ticket.setPrimaryKey(ticketId);
        ticket.setCompanyId(this.companyProvider.getCompanyId());
        return ticket;
    }

    @Override
    public Ticket remove(long ticketId) throws NoSuchTicketException {
        return this.remove(Long.valueOf(ticketId));
    }

    @Override
    public Ticket remove(Serializable primaryKey) throws NoSuchTicketException {
        Session session = null;
        try {
            session = this.openSession();
            Ticket ticket = (Ticket)session.get(TicketImpl.class, primaryKey);
            if (ticket == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchTicketException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Ticket ticket2 = this.remove(ticket);
            return ticket2;
        }
        catch (NoSuchTicketException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Ticket removeImpl(Ticket ticket) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(ticket)) {
                ticket = (Ticket)session.get(TicketImpl.class, ticket.getPrimaryKeyObj());
            }
            if (ticket != null) {
                session.delete(ticket);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (ticket != null) {
            this.clearCache(ticket);
        }
        return ticket;
    }

    @Override
    public Ticket updateImpl(Ticket ticket) {
        boolean isNew = ticket.isNew();
        if (!(ticket instanceof TicketModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ticket.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(ticket);
                throw new IllegalArgumentException("Implement ModelWrapper in ticket proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Ticket implementation " + ticket.getClass());
        }
        TicketModelImpl ticketModelImpl = (TicketModelImpl)((Object)ticket);
        Session session = null;
        try {
            session = this.openSession();
            if (ticket.isNew()) {
                session.save(ticket);
                ticket.setNew(false);
            } else {
                ticket = (Ticket)session.merge(ticket);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!TicketModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{ticketModelImpl.getClassNameId(), ticketModelImpl.getClassPK(), ticketModelImpl.getType()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C_T, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_T, args);
            args = new Object[]{ticketModelImpl.getCompanyId(), ticketModelImpl.getClassNameId(), ticketModelImpl.getClassPK(), ticketModelImpl.getType()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_T, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_T, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((ticketModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C_T.getColumnBitmask()) != 0L) {
                args = new Object[]{ticketModelImpl.getOriginalClassNameId(), ticketModelImpl.getOriginalClassPK(), ticketModelImpl.getOriginalType()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_T, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_T, args);
                args = new Object[]{ticketModelImpl.getClassNameId(), ticketModelImpl.getClassPK(), ticketModelImpl.getType()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_T, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_T, args);
            }
            if ((ticketModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C_C_T.getColumnBitmask()) != 0L) {
                args = new Object[]{ticketModelImpl.getOriginalCompanyId(), ticketModelImpl.getOriginalClassNameId(), ticketModelImpl.getOriginalClassPK(), ticketModelImpl.getOriginalType()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_T, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_T, args);
                args = new Object[]{ticketModelImpl.getCompanyId(), ticketModelImpl.getClassNameId(), ticketModelImpl.getClassPK(), ticketModelImpl.getType()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_T, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_T, args);
            }
        }
        EntityCacheUtil.putResult(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketImpl.class, Long.valueOf(ticket.getPrimaryKey()), ticket, false);
        this.clearUniqueFindersCache(ticketModelImpl, false);
        this.cacheUniqueFindersCache(ticketModelImpl);
        ticket.resetOriginalValues();
        return ticket;
    }

    @Override
    public Ticket findByPrimaryKey(Serializable primaryKey) throws NoSuchTicketException {
        Ticket ticket = (Ticket)this.fetchByPrimaryKey(primaryKey);
        if (ticket == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchTicketException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ticket;
    }

    @Override
    public Ticket findByPrimaryKey(long ticketId) throws NoSuchTicketException {
        return this.findByPrimaryKey(Long.valueOf(ticketId));
    }

    @Override
    public Ticket fetchByPrimaryKey(long ticketId) {
        return (Ticket)this.fetchByPrimaryKey(Long.valueOf(ticketId));
    }

    @Override
    public List<Ticket> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Ticket> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Ticket> findAll(int start, int end, OrderByComparator<Ticket> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Ticket> findAll(int start, int end, OrderByComparator<Ticket> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Ticket> list = null;
        if (retrieveFromCache) {
            list = (List<Ticket>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_TICKET);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_TICKET;
                if (pagination) {
                    sql = sql.concat(" ORDER BY ticket.ticketId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Ticket ticket : this.findAll()) {
            this.remove(ticket);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_TICKET);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "ticketId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_TICKET;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return TicketModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByKey = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByKey", new String[]{String.class.getName()}, 8L);
        this._finderPathCountByKey = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKey", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByC_C_T = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_T", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C_T = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_T", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, 19L);
        this._finderPathCountByC_C_T = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_T", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()});
        this._finderPathWithPaginationFindByC_C_C_T = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C_T", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C_C_T = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, TicketImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C_T", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName()}, 23L);
        this._finderPathCountByC_C_C_T = new FinderPath(TicketModelImpl.ENTITY_CACHE_ENABLED, TicketModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C_T", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(TicketImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

