/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchTeamException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.service.persistence.impl.TableMapperFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.TeamImpl;
import com.liferay.portal.model.impl.TeamModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class TeamPersistenceImpl
extends BasePersistenceImpl<Team>
implements TeamPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TeamImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "team.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(team.uuid IS NULL OR team.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "team.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(team.uuid IS NULL OR team.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "team.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "team.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(team.uuid IS NULL OR team.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "team.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "team.groupId = ?";
    private FinderPath _finderPathFetchByG_N;
    private FinderPath _finderPathCountByG_N;
    private static final String _FINDER_COLUMN_G_N_GROUPID_2 = "team.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_NAME_2 = "team.name = ?";
    private static final String _FINDER_COLUMN_G_N_NAME_3 = "(team.name IS NULL OR team.name = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    protected TableMapper<Team, User> teamToUserTableMapper;
    @BeanReference(type=UserGroupPersistence.class)
    protected UserGroupPersistence userGroupPersistence;
    protected TableMapper<Team, UserGroup> teamToUserGroupTableMapper;
    private static final String _SQL_SELECT_TEAM = "SELECT team FROM Team team";
    private static final String _SQL_SELECT_TEAM_WHERE = "SELECT team FROM Team team WHERE ";
    private static final String _SQL_COUNT_TEAM = "SELECT COUNT(team) FROM Team team";
    private static final String _SQL_COUNT_TEAM_WHERE = "SELECT COUNT(team) FROM Team team WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "team.teamId";
    private static final String _FILTER_SQL_SELECT_TEAM_WHERE = "SELECT DISTINCT {team.*} FROM Team team WHERE ";
    private static final String _FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {Team.*} FROM (SELECT DISTINCT team.teamId FROM Team team WHERE ";
    private static final String _FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN Team ON TEMP_TABLE.teamId = Team.teamId";
    private static final String _FILTER_SQL_COUNT_TEAM_WHERE = "SELECT COUNT(DISTINCT team.teamId) AS COUNT_VALUE FROM Team team WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "team";
    private static final String _FILTER_ENTITY_TABLE = "Team";
    private static final String _ORDER_BY_ENTITY_ALIAS = "team.";
    private static final String _ORDER_BY_ENTITY_TABLE = "Team.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Team exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Team exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(TeamPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"uuid"});

    @Override
    public List<Team> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<Team> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    @Override
    public List<Team> findByUuid(String uuid, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    @Override
    public List<Team> findByUuid(String uuid, int start, int end, OrderByComparator<Team> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Team> list = null;
        if (retrieveFromCache && (list = (List<Team>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Team team : list) {
                if (uuid.equals(team.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_TEAM_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY team.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Team findByUuid_First(String uuid, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.fetchByUuid_First(uuid, orderByComparator);
        if (team != null) {
            return team;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchTeamException(msg.toString());
    }

    @Override
    public Team fetchByUuid_First(String uuid, OrderByComparator<Team> orderByComparator) {
        List<Team> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Team findByUuid_Last(String uuid, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.fetchByUuid_Last(uuid, orderByComparator);
        if (team != null) {
            return team;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchTeamException(msg.toString());
    }

    @Override
    public Team fetchByUuid_Last(String uuid, OrderByComparator<Team> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Team> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Team[] findByUuid_PrevAndNext(long teamId, String uuid, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        uuid = Objects.toString(uuid, "");
        Team team = this.findByPrimaryKey(teamId);
        Session session = null;
        try {
            session = this.openSession();
            Team[] array = new TeamImpl[]{this.getByUuid_PrevAndNext(session, team, uuid, orderByComparator, true), team, this.getByUuid_PrevAndNext(session, team, uuid, orderByComparator, false)};
            Team[] teamArray = array;
            return teamArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Team getByUuid_PrevAndNext(Session session, Team team, String uuid, OrderByComparator<Team> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_TEAM_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY team.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(team)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Team)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid(String uuid) {
        for (Team team : this.findByUuid(uuid, -1, -1, null)) {
            this.remove(team);
        }
    }

    @Override
    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_TEAM_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Team findByUUID_G(String uuid, long groupId) throws NoSuchTeamException {
        Team team = this.fetchByUUID_G(uuid, groupId);
        if (team == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchTeamException(msg.toString());
        }
        return team;
    }

    @Override
    public Team fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    @Override
    public Team fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        Team team;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByUUID_G, finderArgs, this);
        }
        if (result instanceof Team && (!Objects.equals(uuid, (team = (Team)result).getUuid()) || groupId != team.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_TEAM_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(team.uuid IS NULL OR team.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("team.uuid = ? AND ");
            }
            query.append("team.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, finderArgs, list);
                } else {
                    Team team2 = (Team)list.get(0);
                    result = team2;
                    this.cacheResult(team2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Team)result;
    }

    @Override
    public Team removeByUUID_G(String uuid, long groupId) throws NoSuchTeamException {
        Team team = this.findByUUID_G(uuid, groupId);
        return this.remove(team);
    }

    @Override
    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_TEAM_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(team.uuid IS NULL OR team.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("team.uuid = ? AND ");
            }
            query.append("team.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Team> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<Team> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<Team> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Team> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Team> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Team> list = null;
        if (retrieveFromCache && (list = (List<Team>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Team team : list) {
                if (uuid.equals(team.getUuid()) && companyId == team.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_TEAM_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(team.uuid IS NULL OR team.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("team.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY team.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Team findByUuid_C_First(String uuid, long companyId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (team != null) {
            return team;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchTeamException(msg.toString());
    }

    @Override
    public Team fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Team> orderByComparator) {
        List<Team> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Team findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (team != null) {
            return team;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchTeamException(msg.toString());
    }

    @Override
    public Team fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Team> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Team> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Team[] findByUuid_C_PrevAndNext(long teamId, String uuid, long companyId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        uuid = Objects.toString(uuid, "");
        Team team = this.findByPrimaryKey(teamId);
        Session session = null;
        try {
            session = this.openSession();
            Team[] array = new TeamImpl[]{this.getByUuid_C_PrevAndNext(session, team, uuid, companyId, orderByComparator, true), team, this.getByUuid_C_PrevAndNext(session, team, uuid, companyId, orderByComparator, false)};
            Team[] teamArray = array;
            return teamArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Team getByUuid_C_PrevAndNext(Session session, Team team, String uuid, long companyId, OrderByComparator<Team> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_TEAM_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append("(team.uuid IS NULL OR team.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("team.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY team.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(team)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Team)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid_C(String uuid, long companyId) {
        for (Team team : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove(team);
        }
    }

    @Override
    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_TEAM_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(team.uuid IS NULL OR team.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("team.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Team> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    @Override
    public List<Team> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    @Override
    public List<Team> findByGroupId(long groupId, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    @Override
    public List<Team> findByGroupId(long groupId, int start, int end, OrderByComparator<Team> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByGroupId;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<Team> list = null;
        if (retrieveFromCache && (list = (List<Team>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Team team : list) {
                if (groupId == team.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_TEAM_WHERE);
            query.append("team.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY team.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Team findByGroupId_First(long groupId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.fetchByGroupId_First(groupId, orderByComparator);
        if (team != null) {
            return team;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchTeamException(msg.toString());
    }

    @Override
    public Team fetchByGroupId_First(long groupId, OrderByComparator<Team> orderByComparator) {
        List<Team> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Team findByGroupId_Last(long groupId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (team != null) {
            return team;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchTeamException(msg.toString());
    }

    @Override
    public Team fetchByGroupId_Last(long groupId, OrderByComparator<Team> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<Team> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Team[] findByGroupId_PrevAndNext(long teamId, long groupId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        Team team = this.findByPrimaryKey(teamId);
        Session session = null;
        try {
            session = this.openSession();
            Team[] array = new TeamImpl[]{this.getByGroupId_PrevAndNext(session, team, groupId, orderByComparator, true), team, this.getByGroupId_PrevAndNext(session, team, groupId, orderByComparator, false)};
            Team[] teamArray = array;
            return teamArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Team getByGroupId_PrevAndNext(Session session, Team team, long groupId, OrderByComparator<Team> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_TEAM_WHERE);
        query.append("team.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY team.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(team)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Team)list.get(1);
        }
        return null;
    }

    @Override
    public List<Team> filterFindByGroupId(long groupId) {
        return this.filterFindByGroupId(groupId, -1, -1, null);
    }

    @Override
    public List<Team> filterFindByGroupId(long groupId, int start, int end) {
        return this.filterFindByGroupId(groupId, start, end, null);
    }

    @Override
    public List<Team> filterFindByGroupId(long groupId, int start, int end, OrderByComparator<Team> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(groupId)) {
            return this.findByGroupId(groupId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_TEAM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("team.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY team.name ASC");
        } else {
            query.append(" ORDER BY Team.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Team.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, TeamImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, TeamImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(groupId);
            List<Team> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Team[] filterFindByGroupId_PrevAndNext(long teamId, long groupId, OrderByComparator<Team> orderByComparator) throws NoSuchTeamException {
        if (!InlineSQLHelperUtil.isEnabled(groupId)) {
            return this.findByGroupId_PrevAndNext(teamId, groupId, orderByComparator);
        }
        Team team = this.findByPrimaryKey(teamId);
        Session session = null;
        try {
            session = this.openSession();
            Team[] array = new TeamImpl[]{this.filterGetByGroupId_PrevAndNext(session, team, groupId, orderByComparator, true), team, this.filterGetByGroupId_PrevAndNext(session, team, groupId, orderByComparator, false)};
            Team[] teamArray = array;
            return teamArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Team filterGetByGroupId_PrevAndNext(Session session, Team team, long groupId, OrderByComparator<Team> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_TEAM_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("team.groupId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_TEAM_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY team.name ASC");
        } else {
            query.append(" ORDER BY Team.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Team.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, groupId);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, TeamImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, TeamImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(team)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Team)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByGroupId(long groupId) {
        for (Team team : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove(team);
        }
    }

    @Override
    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_TEAM_WHERE);
            query.append("team.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByGroupId(long groupId) {
        if (!InlineSQLHelperUtil.isEnabled(groupId)) {
            return this.countByGroupId(groupId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_TEAM_WHERE);
        query.append("team.groupId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Team.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN, groupId);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(groupId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Team findByG_N(long groupId, String name) throws NoSuchTeamException {
        Team team = this.fetchByG_N(groupId, name);
        if (team == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchTeamException(msg.toString());
        }
        return team;
    }

    @Override
    public Team fetchByG_N(long groupId, String name) {
        return this.fetchByG_N(groupId, name, true);
    }

    @Override
    public Team fetchByG_N(long groupId, String name, boolean retrieveFromCache) {
        Team team;
        name = Objects.toString(name, "");
        Object[] finderArgs = new Object[]{groupId, name};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByG_N, finderArgs, this);
        }
        if (result instanceof Team && (groupId != (team = (Team)result).getGroupId() || !Objects.equals(name, team.getName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_TEAM_WHERE);
            query.append(_FINDER_COLUMN_G_N_GROUPID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByG_N, finderArgs, list);
                } else {
                    Team team2 = (Team)list.get(0);
                    result = team2;
                    this.cacheResult(team2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByG_N, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Team)result;
    }

    @Override
    public Team removeByG_N(long groupId, String name) throws NoSuchTeamException {
        Team team = this.findByG_N(groupId, name);
        return this.remove(team);
    }

    @Override
    public int countByG_N(long groupId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathCountByG_N;
        Object[] finderArgs = new Object[]{groupId, name};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_TEAM_WHERE);
            query.append(_FINDER_COLUMN_G_N_GROUPID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TeamPersistenceImpl() {
        this.setModelClass(Team.class);
        this.setModelImplClass(TeamImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(TeamModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Team team) {
        EntityCacheUtil.putResult(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, Long.valueOf(team.getPrimaryKey()), team);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, new Object[]{team.getUuid(), team.getGroupId()}, team);
        FinderCacheUtil.putResult(this._finderPathFetchByG_N, new Object[]{team.getGroupId(), team.getName()}, team);
        team.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Team> teams) {
        for (Team team : teams) {
            if (EntityCacheUtil.getResult(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, Long.valueOf(team.getPrimaryKey())) == null) {
                this.cacheResult(team);
                continue;
            }
            team.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(TeamImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Team team) {
        EntityCacheUtil.removeResult(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, Long.valueOf(team.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((TeamModelImpl)((Object)team), true);
    }

    @Override
    public void clearCache(List<Team> teams) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Team team : teams) {
            EntityCacheUtil.removeResult(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, Long.valueOf(team.getPrimaryKey()));
            this.clearUniqueFindersCache((TeamModelImpl)((Object)team), true);
        }
    }

    protected void cacheUniqueFindersCache(TeamModelImpl teamModelImpl) {
        Object[] args = new Object[]{teamModelImpl.getUuid(), teamModelImpl.getGroupId()};
        FinderCacheUtil.putResult(this._finderPathCountByUUID_G, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, args, teamModelImpl, false);
        args = new Object[]{teamModelImpl.getGroupId(), teamModelImpl.getName()};
        FinderCacheUtil.putResult(this._finderPathCountByG_N, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByG_N, args, teamModelImpl, false);
    }

    protected void clearUniqueFindersCache(TeamModelImpl teamModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{teamModelImpl.getUuid(), teamModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((teamModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{teamModelImpl.getOriginalUuid(), teamModelImpl.getOriginalGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{teamModelImpl.getGroupId(), teamModelImpl.getName()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_N, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_N, args);
        }
        if ((teamModelImpl.getColumnBitmask() & this._finderPathFetchByG_N.getColumnBitmask()) != 0L) {
            args = new Object[]{teamModelImpl.getOriginalGroupId(), teamModelImpl.getOriginalName()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_N, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_N, args);
        }
    }

    @Override
    public Team create(long teamId) {
        TeamImpl team = new TeamImpl();
        team.setNew(true);
        team.setPrimaryKey(teamId);
        String uuid = PortalUUIDUtil.generate();
        team.setUuid(uuid);
        team.setCompanyId(this.companyProvider.getCompanyId());
        return team;
    }

    @Override
    public Team remove(long teamId) throws NoSuchTeamException {
        return this.remove(Long.valueOf(teamId));
    }

    @Override
    public Team remove(Serializable primaryKey) throws NoSuchTeamException {
        Session session = null;
        try {
            session = this.openSession();
            Team team = (Team)session.get(TeamImpl.class, primaryKey);
            if (team == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchTeamException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Team team2 = this.remove(team);
            return team2;
        }
        catch (NoSuchTeamException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Team removeImpl(Team team) {
        this.teamToUserTableMapper.deleteLeftPrimaryKeyTableMappings(team.getPrimaryKey());
        this.teamToUserGroupTableMapper.deleteLeftPrimaryKeyTableMappings(team.getPrimaryKey());
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(team)) {
                team = (Team)session.get(TeamImpl.class, team.getPrimaryKeyObj());
            }
            if (team != null) {
                session.delete(team);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (team != null) {
            this.clearCache(team);
        }
        return team;
    }

    @Override
    public Team updateImpl(Team team) {
        boolean isNew = team.isNew();
        if (!(team instanceof TeamModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(team.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(team);
                throw new IllegalArgumentException("Implement ModelWrapper in team proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Team implementation " + team.getClass());
        }
        TeamModelImpl teamModelImpl = (TeamModelImpl)((Object)team);
        if (Validator.isNull(team.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            team.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && team.getCreateDate() == null) {
            if (serviceContext == null) {
                team.setCreateDate(now);
            } else {
                team.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!teamModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                team.setModifiedDate(now);
            } else {
                team.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (team.isNew()) {
                session.save(team);
                team.setNew(false);
            } else {
                team = (Team)session.merge(team);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!TeamModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{teamModelImpl.getUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{teamModelImpl.getUuid(), teamModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{teamModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((teamModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{teamModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{teamModelImpl.getUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((teamModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{teamModelImpl.getOriginalUuid(), teamModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{teamModelImpl.getUuid(), teamModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((teamModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{teamModelImpl.getOriginalGroupId()};
                FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{teamModelImpl.getGroupId()};
                FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
        }
        EntityCacheUtil.putResult(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamImpl.class, Long.valueOf(team.getPrimaryKey()), team, false);
        this.clearUniqueFindersCache(teamModelImpl, false);
        this.cacheUniqueFindersCache(teamModelImpl);
        team.resetOriginalValues();
        return team;
    }

    @Override
    public Team findByPrimaryKey(Serializable primaryKey) throws NoSuchTeamException {
        Team team = (Team)this.fetchByPrimaryKey(primaryKey);
        if (team == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchTeamException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return team;
    }

    @Override
    public Team findByPrimaryKey(long teamId) throws NoSuchTeamException {
        return this.findByPrimaryKey(Long.valueOf(teamId));
    }

    @Override
    public Team fetchByPrimaryKey(long teamId) {
        return (Team)this.fetchByPrimaryKey(Long.valueOf(teamId));
    }

    @Override
    public List<Team> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Team> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Team> findAll(int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Team> findAll(int start, int end, OrderByComparator<Team> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Team> list = null;
        if (retrieveFromCache) {
            list = (List<Team>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_TEAM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_TEAM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY team.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Team team : this.findAll()) {
            this.remove(team);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_TEAM);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public long[] getUserPrimaryKeys(long pk) {
        long[] pks = this.teamToUserTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    @Override
    public List<User> getUsers(long pk) {
        return this.getUsers(pk, -1, -1);
    }

    @Override
    public List<User> getUsers(long pk, int start, int end) {
        return this.getUsers(pk, start, end, null);
    }

    @Override
    public List<User> getUsers(long pk, int start, int end, OrderByComparator<User> orderByComparator) {
        return this.teamToUserTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    @Override
    public int getUsersSize(long pk) {
        long[] pks = this.teamToUserTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    @Override
    public boolean containsUser(long pk, long userPK) {
        return this.teamToUserTableMapper.containsTableMapping(pk, userPK);
    }

    @Override
    public boolean containsUsers(long pk) {
        return this.getUsersSize(pk) > 0;
    }

    @Override
    public void addUser(long pk, long userPK) {
        Team team = this.fetchByPrimaryKey(pk);
        if (team == null) {
            this.teamToUserTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, userPK);
        } else {
            this.teamToUserTableMapper.addTableMapping(team.getCompanyId(), pk, userPK);
        }
    }

    @Override
    public void addUser(long pk, User user) {
        Team team = this.fetchByPrimaryKey(pk);
        if (team == null) {
            this.teamToUserTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, user.getPrimaryKey());
        } else {
            this.teamToUserTableMapper.addTableMapping(team.getCompanyId(), pk, user.getPrimaryKey());
        }
    }

    @Override
    public void addUsers(long pk, long[] userPKs) {
        long companyId = 0L;
        Team team = this.fetchByPrimaryKey(pk);
        companyId = team == null ? this.companyProvider.getCompanyId() : team.getCompanyId();
        this.teamToUserTableMapper.addTableMappings(companyId, pk, userPKs);
    }

    @Override
    public void addUsers(long pk, List<User> users) {
        this.addUsers(pk, ListUtil.toLongArray(users, User.USER_ID_ACCESSOR));
    }

    @Override
    public void clearUsers(long pk) {
        this.teamToUserTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    @Override
    public void removeUser(long pk, long userPK) {
        this.teamToUserTableMapper.deleteTableMapping(pk, userPK);
    }

    @Override
    public void removeUser(long pk, User user) {
        this.teamToUserTableMapper.deleteTableMapping(pk, user.getPrimaryKey());
    }

    @Override
    public void removeUsers(long pk, long[] userPKs) {
        this.teamToUserTableMapper.deleteTableMappings(pk, userPKs);
    }

    @Override
    public void removeUsers(long pk, List<User> users) {
        this.removeUsers(pk, ListUtil.toLongArray(users, User.USER_ID_ACCESSOR));
    }

    @Override
    public void setUsers(long pk, long[] userPKs) {
        Set<Long> newUserPKsSet = SetUtil.fromArray(userPKs);
        Set<Long> oldUserPKsSet = SetUtil.fromArray(this.teamToUserTableMapper.getRightPrimaryKeys(pk));
        HashSet<Long> removeUserPKsSet = new HashSet<Long>(oldUserPKsSet);
        removeUserPKsSet.removeAll(newUserPKsSet);
        this.teamToUserTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeUserPKsSet));
        newUserPKsSet.removeAll(oldUserPKsSet);
        long companyId = 0L;
        Team team = this.fetchByPrimaryKey(pk);
        companyId = team == null ? this.companyProvider.getCompanyId() : team.getCompanyId();
        this.teamToUserTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray(newUserPKsSet));
    }

    @Override
    public void setUsers(long pk, List<User> users) {
        try {
            long[] userPKs = new long[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                User user = users.get(i);
                userPKs[i] = user.getPrimaryKey();
            }
            this.setUsers(pk, userPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public long[] getUserGroupPrimaryKeys(long pk) {
        long[] pks = this.teamToUserGroupTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    @Override
    public List<UserGroup> getUserGroups(long pk) {
        return this.getUserGroups(pk, -1, -1);
    }

    @Override
    public List<UserGroup> getUserGroups(long pk, int start, int end) {
        return this.getUserGroups(pk, start, end, null);
    }

    @Override
    public List<UserGroup> getUserGroups(long pk, int start, int end, OrderByComparator<UserGroup> orderByComparator) {
        return this.teamToUserGroupTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    @Override
    public int getUserGroupsSize(long pk) {
        long[] pks = this.teamToUserGroupTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    @Override
    public boolean containsUserGroup(long pk, long userGroupPK) {
        return this.teamToUserGroupTableMapper.containsTableMapping(pk, userGroupPK);
    }

    @Override
    public boolean containsUserGroups(long pk) {
        return this.getUserGroupsSize(pk) > 0;
    }

    @Override
    public void addUserGroup(long pk, long userGroupPK) {
        Team team = this.fetchByPrimaryKey(pk);
        if (team == null) {
            this.teamToUserGroupTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, userGroupPK);
        } else {
            this.teamToUserGroupTableMapper.addTableMapping(team.getCompanyId(), pk, userGroupPK);
        }
    }

    @Override
    public void addUserGroup(long pk, UserGroup userGroup) {
        Team team = this.fetchByPrimaryKey(pk);
        if (team == null) {
            this.teamToUserGroupTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, userGroup.getPrimaryKey());
        } else {
            this.teamToUserGroupTableMapper.addTableMapping(team.getCompanyId(), pk, userGroup.getPrimaryKey());
        }
    }

    @Override
    public void addUserGroups(long pk, long[] userGroupPKs) {
        long companyId = 0L;
        Team team = this.fetchByPrimaryKey(pk);
        companyId = team == null ? this.companyProvider.getCompanyId() : team.getCompanyId();
        this.teamToUserGroupTableMapper.addTableMappings(companyId, pk, userGroupPKs);
    }

    @Override
    public void addUserGroups(long pk, List<UserGroup> userGroups) {
        this.addUserGroups(pk, ListUtil.toLongArray(userGroups, UserGroup.USER_GROUP_ID_ACCESSOR));
    }

    @Override
    public void clearUserGroups(long pk) {
        this.teamToUserGroupTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    @Override
    public void removeUserGroup(long pk, long userGroupPK) {
        this.teamToUserGroupTableMapper.deleteTableMapping(pk, userGroupPK);
    }

    @Override
    public void removeUserGroup(long pk, UserGroup userGroup) {
        this.teamToUserGroupTableMapper.deleteTableMapping(pk, userGroup.getPrimaryKey());
    }

    @Override
    public void removeUserGroups(long pk, long[] userGroupPKs) {
        this.teamToUserGroupTableMapper.deleteTableMappings(pk, userGroupPKs);
    }

    @Override
    public void removeUserGroups(long pk, List<UserGroup> userGroups) {
        this.removeUserGroups(pk, ListUtil.toLongArray(userGroups, UserGroup.USER_GROUP_ID_ACCESSOR));
    }

    @Override
    public void setUserGroups(long pk, long[] userGroupPKs) {
        Set<Long> newUserGroupPKsSet = SetUtil.fromArray(userGroupPKs);
        Set<Long> oldUserGroupPKsSet = SetUtil.fromArray(this.teamToUserGroupTableMapper.getRightPrimaryKeys(pk));
        HashSet<Long> removeUserGroupPKsSet = new HashSet<Long>(oldUserGroupPKsSet);
        removeUserGroupPKsSet.removeAll(newUserGroupPKsSet);
        this.teamToUserGroupTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeUserGroupPKsSet));
        newUserGroupPKsSet.removeAll(oldUserGroupPKsSet);
        long companyId = 0L;
        Team team = this.fetchByPrimaryKey(pk);
        companyId = team == null ? this.companyProvider.getCompanyId() : team.getCompanyId();
        this.teamToUserGroupTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray(newUserGroupPKsSet));
    }

    @Override
    public void setUserGroups(long pk, List<UserGroup> userGroups) {
        try {
            long[] userGroupPKs = new long[userGroups.size()];
            for (int i = 0; i < userGroups.size(); ++i) {
                UserGroup userGroup = userGroups.get(i);
                userGroupPKs[i] = userGroup.getPrimaryKey();
            }
            this.setUserGroups(pk, userGroupPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "teamId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_TEAM;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return TeamModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this.teamToUserTableMapper = TableMapperFactory.getTableMapper("Users_Teams", "companyId", "teamId", "userId", this, this.userPersistence);
        this.teamToUserGroupTableMapper = TableMapperFactory.getTableMapper("UserGroups_Teams", "companyId", "teamId", "userGroupId", this, this.userGroupPersistence);
        this._finderPathWithPaginationFindAll = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 12L);
        this._finderPathCountByUuid = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 10L);
        this._finderPathCountByUUID_G = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 13L);
        this._finderPathCountByUuid_C = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByGroupId = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 6L);
        this._finderPathCountByGroupId = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathFetchByG_N = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, TeamImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N", new String[]{Long.class.getName(), String.class.getName()}, 6L);
        this._finderPathCountByG_N = new FinderPath(TeamModelImpl.ENTITY_CACHE_ENABLED, TeamModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N", new String[]{Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(TeamImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        TableMapperFactory.removeTableMapper("Users_Teams");
        TableMapperFactory.removeTableMapper("UserGroups_Teams");
    }
}

