/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.RepositoryImpl;
import com.liferay.portal.model.impl.RepositoryModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RepositoryPersistenceImpl
extends BasePersistenceImpl<Repository>
implements RepositoryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RepositoryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "repository.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "repository.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "repository.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "repository.groupId = ?";
    private FinderPath _finderPathFetchByG_N_P;
    private FinderPath _finderPathCountByG_N_P;
    private static final String _FINDER_COLUMN_G_N_P_GROUPID_2 = "repository.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_2 = "repository.name = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_3 = "(repository.name IS NULL OR repository.name = '') AND ";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_2 = "repository.portletId = ?";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_3 = "(repository.portletId IS NULL OR repository.portletId = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_REPOSITORY = "SELECT repository FROM Repository repository";
    private static final String _SQL_SELECT_REPOSITORY_WHERE = "SELECT repository FROM Repository repository WHERE ";
    private static final String _SQL_COUNT_REPOSITORY = "SELECT COUNT(repository) FROM Repository repository";
    private static final String _SQL_COUNT_REPOSITORY_WHERE = "SELECT COUNT(repository) FROM Repository repository WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "repository.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Repository exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Repository exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RepositoryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"uuid"});

    @Override
    public List<Repository> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<Repository> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    @Override
    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    @Override
    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache && (list = (List<Repository>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (uuid.equals(repository.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Repository findByUuid_First(String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_First(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    @Override
    public Repository fetchByUuid_First(String uuid, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Repository findByUuid_Last(String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_Last(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    @Override
    public Repository fetchByUuid_Last(String uuid, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Repository[] findByUuid_PrevAndNext(long repositoryId, String uuid, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        uuid = Objects.toString(uuid, "");
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, true), repository, this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_PrevAndNext(Session session, Repository repository, String uuid, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(repository)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid(String uuid) {
        for (Repository repository : this.findByUuid(uuid, -1, -1, null)) {
            this.remove(repository);
        }
    }

    @Override
    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Repository findByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUUID_G(uuid, groupId);
        if (repository == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchRepositoryException(msg.toString());
        }
        return repository;
    }

    @Override
    public Repository fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    @Override
    public Repository fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        Repository repository;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByUUID_G, finderArgs, this);
        }
        if (result instanceof Repository && (!Objects.equals(uuid, (repository = (Repository)result).getUuid()) || groupId != repository.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, finderArgs, list);
                } else {
                    Repository repository2 = (Repository)list.get(0);
                    result = repository2;
                    this.cacheResult(repository2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    @Override
    public Repository removeByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException {
        Repository repository = this.findByUUID_G(uuid, groupId);
        return this.remove(repository);
    }

    @Override
    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Repository> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache && (list = (List<Repository>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (uuid.equals(repository.getUuid()) && companyId == repository.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Repository findByUuid_C_First(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    @Override
    public Repository fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Repository findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    @Override
    public Repository fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Repository[] findByUuid_C_PrevAndNext(long repositoryId, String uuid, long companyId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        uuid = Objects.toString(uuid, "");
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, true), repository, this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_C_PrevAndNext(Session session, Repository repository, String uuid, long companyId, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("repository.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(repository)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid_C(String uuid, long companyId) {
        for (Repository repository : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove(repository);
        }
    }

    @Override
    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Repository> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    @Override
    public List<Repository> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    @Override
    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    @Override
    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByGroupId;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache && (list = (List<Repository>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (groupId == repository.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            query.append("repository.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Repository findByGroupId_First(long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByGroupId_First(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    @Override
    public Repository fetchByGroupId_First(long groupId, OrderByComparator<Repository> orderByComparator) {
        List<Repository> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Repository findByGroupId_Last(long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    @Override
    public Repository fetchByGroupId_Last(long groupId, OrderByComparator<Repository> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<Repository> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Repository[] findByGroupId_PrevAndNext(long repositoryId, long groupId, OrderByComparator<Repository> orderByComparator) throws NoSuchRepositoryException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, true), repository, this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByGroupId_PrevAndNext(Session session, Repository repository, long groupId, OrderByComparator<Repository> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        query.append("repository.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(repository)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByGroupId(long groupId) {
        for (Repository repository : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove(repository);
        }
    }

    @Override
    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Repository findByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException {
        Repository repository = this.fetchByG_N_P(groupId, name, portletId);
        if (repository == null) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", portletId=");
            msg.append(portletId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchRepositoryException(msg.toString());
        }
        return repository;
    }

    @Override
    public Repository fetchByG_N_P(long groupId, String name, String portletId) {
        return this.fetchByG_N_P(groupId, name, portletId, true);
    }

    @Override
    public Repository fetchByG_N_P(long groupId, String name, String portletId, boolean retrieveFromCache) {
        Repository repository;
        name = Objects.toString(name, "");
        portletId = Objects.toString(portletId, "");
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByG_N_P, finderArgs, this);
        }
        if (!(!(result instanceof Repository) || groupId == (repository = (Repository)result).getGroupId() && Objects.equals(name, repository.getName()) && Objects.equals(portletId, repository.getPortletId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            query.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByG_N_P, finderArgs, list);
                } else {
                    Repository repository2 = (Repository)list.get(0);
                    result = repository2;
                    this.cacheResult(repository2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByG_N_P, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    @Override
    public Repository removeByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException {
        Repository repository = this.findByG_N_P(groupId, name, portletId);
        return this.remove(repository);
    }

    @Override
    public int countByG_N_P(long groupId, String name, String portletId) {
        name = Objects.toString(name, "");
        portletId = Objects.toString(portletId, "");
        FinderPath finderPath = this._finderPathCountByG_N_P;
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            query.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public RepositoryPersistenceImpl() {
        this.setModelClass(Repository.class);
        this.setModelImplClass(RepositoryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(RepositoryModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Repository repository) {
        EntityCacheUtil.putResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, Long.valueOf(repository.getPrimaryKey()), repository);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, new Object[]{repository.getUuid(), repository.getGroupId()}, repository);
        FinderCacheUtil.putResult(this._finderPathFetchByG_N_P, new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()}, repository);
        repository.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Repository> repositories) {
        for (Repository repository : repositories) {
            if (EntityCacheUtil.getResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, Long.valueOf(repository.getPrimaryKey())) == null) {
                this.cacheResult(repository);
                continue;
            }
            repository.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(RepositoryImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Repository repository) {
        EntityCacheUtil.removeResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, Long.valueOf(repository.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((RepositoryModelImpl)((Object)repository), true);
    }

    @Override
    public void clearCache(List<Repository> repositories) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Repository repository : repositories) {
            EntityCacheUtil.removeResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, Long.valueOf(repository.getPrimaryKey()));
            this.clearUniqueFindersCache((RepositoryModelImpl)((Object)repository), true);
        }
    }

    protected void cacheUniqueFindersCache(RepositoryModelImpl repositoryModelImpl) {
        Object[] args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getGroupId()};
        FinderCacheUtil.putResult(this._finderPathCountByUUID_G, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, args, repositoryModelImpl, false);
        args = new Object[]{repositoryModelImpl.getGroupId(), repositoryModelImpl.getName(), repositoryModelImpl.getPortletId()};
        FinderCacheUtil.putResult(this._finderPathCountByG_N_P, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByG_N_P, args, repositoryModelImpl, false);
    }

    protected void clearUniqueFindersCache(RepositoryModelImpl repositoryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((repositoryModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryModelImpl.getOriginalUuid(), repositoryModelImpl.getOriginalGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{repositoryModelImpl.getGroupId(), repositoryModelImpl.getName(), repositoryModelImpl.getPortletId()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_N_P, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_N_P, args);
        }
        if ((repositoryModelImpl.getColumnBitmask() & this._finderPathFetchByG_N_P.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryModelImpl.getOriginalGroupId(), repositoryModelImpl.getOriginalName(), repositoryModelImpl.getOriginalPortletId()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_N_P, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_N_P, args);
        }
    }

    @Override
    public Repository create(long repositoryId) {
        RepositoryImpl repository = new RepositoryImpl();
        repository.setNew(true);
        repository.setPrimaryKey(repositoryId);
        String uuid = PortalUUIDUtil.generate();
        repository.setUuid(uuid);
        repository.setCompanyId(this.companyProvider.getCompanyId());
        return repository;
    }

    @Override
    public Repository remove(long repositoryId) throws NoSuchRepositoryException {
        return this.remove(Long.valueOf(repositoryId));
    }

    @Override
    public Repository remove(Serializable primaryKey) throws NoSuchRepositoryException {
        Session session = null;
        try {
            session = this.openSession();
            Repository repository = (Repository)session.get(RepositoryImpl.class, primaryKey);
            if (repository == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Repository repository2 = this.remove(repository);
            return repository2;
        }
        catch (NoSuchRepositoryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Repository removeImpl(Repository repository) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(repository)) {
                repository = (Repository)session.get(RepositoryImpl.class, repository.getPrimaryKeyObj());
            }
            if (repository != null) {
                session.delete(repository);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (repository != null) {
            this.clearCache(repository);
        }
        return repository;
    }

    @Override
    public Repository updateImpl(Repository repository) {
        boolean isNew = repository.isNew();
        if (!(repository instanceof RepositoryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(repository.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(repository);
                throw new IllegalArgumentException("Implement ModelWrapper in repository proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Repository implementation " + repository.getClass());
        }
        RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)((Object)repository);
        if (Validator.isNull(repository.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            repository.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && repository.getCreateDate() == null) {
            if (serviceContext == null) {
                repository.setCreateDate(now);
            } else {
                repository.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!repositoryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                repository.setModifiedDate(now);
            } else {
                repository.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (repository.isNew()) {
                session.save(repository);
                repository.setNew(false);
            } else {
                repository = (Repository)session.merge(repository);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!RepositoryModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{repositoryModelImpl.getUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{repositoryModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((repositoryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{repositoryModelImpl.getUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((repositoryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalUuid(), repositoryModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((repositoryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalGroupId()};
                FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{repositoryModelImpl.getGroupId()};
                FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
        }
        EntityCacheUtil.putResult(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, Long.valueOf(repository.getPrimaryKey()), repository, false);
        this.clearUniqueFindersCache(repositoryModelImpl, false);
        this.cacheUniqueFindersCache(repositoryModelImpl);
        repository.resetOriginalValues();
        return repository;
    }

    @Override
    public Repository findByPrimaryKey(Serializable primaryKey) throws NoSuchRepositoryException {
        Repository repository = (Repository)this.fetchByPrimaryKey(primaryKey);
        if (repository == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return repository;
    }

    @Override
    public Repository findByPrimaryKey(long repositoryId) throws NoSuchRepositoryException {
        return this.findByPrimaryKey(Long.valueOf(repositoryId));
    }

    @Override
    public Repository fetchByPrimaryKey(long repositoryId) {
        return (Repository)this.fetchByPrimaryKey(Long.valueOf(repositoryId));
    }

    @Override
    public List<Repository> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Repository> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Repository> findAll(int start, int end, OrderByComparator<Repository> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Repository> findAll(int start, int end, OrderByComparator<Repository> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Repository> list = null;
        if (retrieveFromCache) {
            list = (List<Repository>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_REPOSITORY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_REPOSITORY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY repository.repositoryId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Repository repository : this.findAll()) {
            this.remove(repository);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_REPOSITORY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "repositoryId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_REPOSITORY;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return RepositoryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
        this._finderPathCountByUuid = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
        this._finderPathCountByUUID_G = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 17L);
        this._finderPathCountByUuid_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByGroupId = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByGroupId = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathFetchByG_N_P = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, 14L);
        this._finderPathCountByG_N_P = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(RepositoryImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

