/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.RepositoryEntryPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.RepositoryEntryImpl;
import com.liferay.portal.model.impl.RepositoryEntryModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RepositoryEntryPersistenceImpl
extends BasePersistenceImpl<RepositoryEntry>
implements RepositoryEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RepositoryEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "repositoryEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "repositoryEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "repositoryEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "repositoryEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "repositoryEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByRepositoryId;
    private FinderPath _finderPathWithoutPaginationFindByRepositoryId;
    private FinderPath _finderPathCountByRepositoryId;
    private static final String _FINDER_COLUMN_REPOSITORYID_REPOSITORYID_2 = "repositoryEntry.repositoryId = ?";
    private FinderPath _finderPathFetchByR_M;
    private FinderPath _finderPathCountByR_M;
    private static final String _FINDER_COLUMN_R_M_REPOSITORYID_2 = "repositoryEntry.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_R_M_MAPPEDID_2 = "repositoryEntry.mappedId = ?";
    private static final String _FINDER_COLUMN_R_M_MAPPEDID_3 = "(repositoryEntry.mappedId IS NULL OR repositoryEntry.mappedId = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_REPOSITORYENTRY = "SELECT repositoryEntry FROM RepositoryEntry repositoryEntry";
    private static final String _SQL_SELECT_REPOSITORYENTRY_WHERE = "SELECT repositoryEntry FROM RepositoryEntry repositoryEntry WHERE ";
    private static final String _SQL_COUNT_REPOSITORYENTRY = "SELECT COUNT(repositoryEntry) FROM RepositoryEntry repositoryEntry";
    private static final String _SQL_COUNT_REPOSITORYENTRY_WHERE = "SELECT COUNT(repositoryEntry) FROM RepositoryEntry repositoryEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "repositoryEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No RepositoryEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No RepositoryEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RepositoryEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"uuid"});

    @Override
    public List<RepositoryEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<RepositoryEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    @Override
    public List<RepositoryEntry> findByUuid(String uuid, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    @Override
    public List<RepositoryEntry> findByUuid(String uuid, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<RepositoryEntry> list = null;
        if (retrieveFromCache && (list = (List<RepositoryEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (RepositoryEntry repositoryEntry : list) {
                if (uuid.equals(repositoryEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repositoryEntry.repositoryEntryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public RepositoryEntry findByUuid_First(String uuid, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryEntryException(msg.toString());
    }

    @Override
    public RepositoryEntry fetchByUuid_First(String uuid, OrderByComparator<RepositoryEntry> orderByComparator) {
        List<RepositoryEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public RepositoryEntry findByUuid_Last(String uuid, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryEntryException(msg.toString());
    }

    @Override
    public RepositoryEntry fetchByUuid_Last(String uuid, OrderByComparator<RepositoryEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<RepositoryEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public RepositoryEntry[] findByUuid_PrevAndNext(long repositoryEntryId, String uuid, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        uuid = Objects.toString(uuid, "");
        RepositoryEntry repositoryEntry = this.findByPrimaryKey(repositoryEntryId);
        Session session = null;
        try {
            session = this.openSession();
            RepositoryEntry[] array = new RepositoryEntryImpl[]{this.getByUuid_PrevAndNext(session, repositoryEntry, uuid, orderByComparator, true), repositoryEntry, this.getByUuid_PrevAndNext(session, repositoryEntry, uuid, orderByComparator, false)};
            RepositoryEntry[] repositoryEntryArray = array;
            return repositoryEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected RepositoryEntry getByUuid_PrevAndNext(Session session, RepositoryEntry repositoryEntry, String uuid, OrderByComparator<RepositoryEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repositoryEntry.repositoryEntryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(repositoryEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (RepositoryEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid(String uuid) {
        for (RepositoryEntry repositoryEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove(repositoryEntry);
        }
    }

    @Override
    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORYENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public RepositoryEntry findByUUID_G(String uuid, long groupId) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByUUID_G(uuid, groupId);
        if (repositoryEntry == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchRepositoryEntryException(msg.toString());
        }
        return repositoryEntry;
    }

    @Override
    public RepositoryEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    @Override
    public RepositoryEntry fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) {
        RepositoryEntry repositoryEntry;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByUUID_G, finderArgs, this);
        }
        if (result instanceof RepositoryEntry && (!Objects.equals(uuid, (repositoryEntry = (RepositoryEntry)result).getUuid()) || groupId != repositoryEntry.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repositoryEntry.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, finderArgs, list);
                } else {
                    RepositoryEntry repositoryEntry2 = (RepositoryEntry)list.get(0);
                    result = repositoryEntry2;
                    this.cacheResult(repositoryEntry2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (RepositoryEntry)result;
    }

    @Override
    public RepositoryEntry removeByUUID_G(String uuid, long groupId) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.findByUUID_G(uuid, groupId);
        return this.remove(repositoryEntry);
    }

    @Override
    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORYENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repositoryEntry.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<RepositoryEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<RepositoryEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<RepositoryEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<RepositoryEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<RepositoryEntry> list = null;
        if (retrieveFromCache && (list = (List<RepositoryEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (RepositoryEntry repositoryEntry : list) {
                if (uuid.equals(repositoryEntry.getUuid()) && companyId == repositoryEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repositoryEntry.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repositoryEntry.repositoryEntryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public RepositoryEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryEntryException(msg.toString());
    }

    @Override
    public RepositoryEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<RepositoryEntry> orderByComparator) {
        List<RepositoryEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public RepositoryEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryEntryException(msg.toString());
    }

    @Override
    public RepositoryEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<RepositoryEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<RepositoryEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public RepositoryEntry[] findByUuid_C_PrevAndNext(long repositoryEntryId, String uuid, long companyId, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        uuid = Objects.toString(uuid, "");
        RepositoryEntry repositoryEntry = this.findByPrimaryKey(repositoryEntryId);
        Session session = null;
        try {
            session = this.openSession();
            RepositoryEntry[] array = new RepositoryEntryImpl[]{this.getByUuid_C_PrevAndNext(session, repositoryEntry, uuid, companyId, orderByComparator, true), repositoryEntry, this.getByUuid_C_PrevAndNext(session, repositoryEntry, uuid, companyId, orderByComparator, false)};
            RepositoryEntry[] repositoryEntryArray = array;
            return repositoryEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected RepositoryEntry getByUuid_C_PrevAndNext(Session session, RepositoryEntry repositoryEntry, String uuid, long companyId, OrderByComparator<RepositoryEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append("(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("repositoryEntry.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repositoryEntry.repositoryEntryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(repositoryEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (RepositoryEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid_C(String uuid, long companyId) {
        for (RepositoryEntry repositoryEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove(repositoryEntry);
        }
    }

    @Override
    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORYENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append("(repositoryEntry.uuid IS NULL OR repositoryEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repositoryEntry.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<RepositoryEntry> findByRepositoryId(long repositoryId) {
        return this.findByRepositoryId(repositoryId, -1, -1, null);
    }

    @Override
    public List<RepositoryEntry> findByRepositoryId(long repositoryId, int start, int end) {
        return this.findByRepositoryId(repositoryId, start, end, null);
    }

    @Override
    public List<RepositoryEntry> findByRepositoryId(long repositoryId, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator) {
        return this.findByRepositoryId(repositoryId, start, end, orderByComparator, true);
    }

    @Override
    public List<RepositoryEntry> findByRepositoryId(long repositoryId, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByRepositoryId;
            finderArgs = new Object[]{repositoryId};
        } else {
            finderPath = this._finderPathWithPaginationFindByRepositoryId;
            finderArgs = new Object[]{repositoryId, start, end, orderByComparator};
        }
        List<RepositoryEntry> list = null;
        if (retrieveFromCache && (list = (List<RepositoryEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (RepositoryEntry repositoryEntry : list) {
                if (repositoryId == repositoryEntry.getRepositoryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
            query.append(_FINDER_COLUMN_REPOSITORYID_REPOSITORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repositoryEntry.repositoryEntryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(repositoryId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public RepositoryEntry findByRepositoryId_First(long repositoryId, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByRepositoryId_First(repositoryId, orderByComparator);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("repositoryId=");
        msg.append(repositoryId);
        msg.append("}");
        throw new NoSuchRepositoryEntryException(msg.toString());
    }

    @Override
    public RepositoryEntry fetchByRepositoryId_First(long repositoryId, OrderByComparator<RepositoryEntry> orderByComparator) {
        List<RepositoryEntry> list = this.findByRepositoryId(repositoryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public RepositoryEntry findByRepositoryId_Last(long repositoryId, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByRepositoryId_Last(repositoryId, orderByComparator);
        if (repositoryEntry != null) {
            return repositoryEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("repositoryId=");
        msg.append(repositoryId);
        msg.append("}");
        throw new NoSuchRepositoryEntryException(msg.toString());
    }

    @Override
    public RepositoryEntry fetchByRepositoryId_Last(long repositoryId, OrderByComparator<RepositoryEntry> orderByComparator) {
        int count = this.countByRepositoryId(repositoryId);
        if (count == 0) {
            return null;
        }
        List<RepositoryEntry> list = this.findByRepositoryId(repositoryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public RepositoryEntry[] findByRepositoryId_PrevAndNext(long repositoryEntryId, long repositoryId, OrderByComparator<RepositoryEntry> orderByComparator) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.findByPrimaryKey(repositoryEntryId);
        Session session = null;
        try {
            session = this.openSession();
            RepositoryEntry[] array = new RepositoryEntryImpl[]{this.getByRepositoryId_PrevAndNext(session, repositoryEntry, repositoryId, orderByComparator, true), repositoryEntry, this.getByRepositoryId_PrevAndNext(session, repositoryEntry, repositoryId, orderByComparator, false)};
            RepositoryEntry[] repositoryEntryArray = array;
            return repositoryEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected RepositoryEntry getByRepositoryId_PrevAndNext(Session session, RepositoryEntry repositoryEntry, long repositoryId, OrderByComparator<RepositoryEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
        query.append(_FINDER_COLUMN_REPOSITORYID_REPOSITORYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY repositoryEntry.repositoryEntryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(repositoryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(repositoryEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (RepositoryEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByRepositoryId(long repositoryId) {
        for (RepositoryEntry repositoryEntry : this.findByRepositoryId(repositoryId, -1, -1, null)) {
            this.remove(repositoryEntry);
        }
    }

    @Override
    public int countByRepositoryId(long repositoryId) {
        FinderPath finderPath = this._finderPathCountByRepositoryId;
        Object[] finderArgs = new Object[]{repositoryId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORYENTRY_WHERE);
            query.append(_FINDER_COLUMN_REPOSITORYID_REPOSITORYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(repositoryId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public RepositoryEntry findByR_M(long repositoryId, String mappedId) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.fetchByR_M(repositoryId, mappedId);
        if (repositoryEntry == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("repositoryId=");
            msg.append(repositoryId);
            msg.append(", mappedId=");
            msg.append(mappedId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchRepositoryEntryException(msg.toString());
        }
        return repositoryEntry;
    }

    @Override
    public RepositoryEntry fetchByR_M(long repositoryId, String mappedId) {
        return this.fetchByR_M(repositoryId, mappedId, true);
    }

    @Override
    public RepositoryEntry fetchByR_M(long repositoryId, String mappedId, boolean retrieveFromCache) {
        RepositoryEntry repositoryEntry;
        mappedId = Objects.toString(mappedId, "");
        Object[] finderArgs = new Object[]{repositoryId, mappedId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByR_M, finderArgs, this);
        }
        if (result instanceof RepositoryEntry && (repositoryId != (repositoryEntry = (RepositoryEntry)result).getRepositoryId() || !Objects.equals(mappedId, repositoryEntry.getMappedId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORYENTRY_WHERE);
            query.append(_FINDER_COLUMN_R_M_REPOSITORYID_2);
            boolean bindMappedId = false;
            if (mappedId.isEmpty()) {
                query.append(_FINDER_COLUMN_R_M_MAPPEDID_3);
            } else {
                bindMappedId = true;
                query.append(_FINDER_COLUMN_R_M_MAPPEDID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(repositoryId);
                if (bindMappedId) {
                    qPos.add(mappedId);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByR_M, finderArgs, list);
                } else {
                    RepositoryEntry repositoryEntry2 = (RepositoryEntry)list.get(0);
                    result = repositoryEntry2;
                    this.cacheResult(repositoryEntry2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByR_M, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (RepositoryEntry)result;
    }

    @Override
    public RepositoryEntry removeByR_M(long repositoryId, String mappedId) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = this.findByR_M(repositoryId, mappedId);
        return this.remove(repositoryEntry);
    }

    @Override
    public int countByR_M(long repositoryId, String mappedId) {
        mappedId = Objects.toString(mappedId, "");
        FinderPath finderPath = this._finderPathCountByR_M;
        Object[] finderArgs = new Object[]{repositoryId, mappedId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORYENTRY_WHERE);
            query.append(_FINDER_COLUMN_R_M_REPOSITORYID_2);
            boolean bindMappedId = false;
            if (mappedId.isEmpty()) {
                query.append(_FINDER_COLUMN_R_M_MAPPEDID_3);
            } else {
                bindMappedId = true;
                query.append(_FINDER_COLUMN_R_M_MAPPEDID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(repositoryId);
                if (bindMappedId) {
                    qPos.add(mappedId);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public RepositoryEntryPersistenceImpl() {
        this.setModelClass(RepositoryEntry.class);
        this.setModelImplClass(RepositoryEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(RepositoryEntry repositoryEntry) {
        EntityCacheUtil.putResult(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryImpl.class, Long.valueOf(repositoryEntry.getPrimaryKey()), repositoryEntry);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, new Object[]{repositoryEntry.getUuid(), repositoryEntry.getGroupId()}, repositoryEntry);
        FinderCacheUtil.putResult(this._finderPathFetchByR_M, new Object[]{repositoryEntry.getRepositoryId(), repositoryEntry.getMappedId()}, repositoryEntry);
        repositoryEntry.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<RepositoryEntry> repositoryEntries) {
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            if (EntityCacheUtil.getResult(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryImpl.class, Long.valueOf(repositoryEntry.getPrimaryKey())) == null) {
                this.cacheResult(repositoryEntry);
                continue;
            }
            repositoryEntry.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(RepositoryEntryImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(RepositoryEntry repositoryEntry) {
        EntityCacheUtil.removeResult(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryImpl.class, Long.valueOf(repositoryEntry.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((RepositoryEntryModelImpl)((Object)repositoryEntry), true);
    }

    @Override
    public void clearCache(List<RepositoryEntry> repositoryEntries) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            EntityCacheUtil.removeResult(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryImpl.class, Long.valueOf(repositoryEntry.getPrimaryKey()));
            this.clearUniqueFindersCache((RepositoryEntryModelImpl)((Object)repositoryEntry), true);
        }
    }

    protected void cacheUniqueFindersCache(RepositoryEntryModelImpl repositoryEntryModelImpl) {
        Object[] args = new Object[]{repositoryEntryModelImpl.getUuid(), repositoryEntryModelImpl.getGroupId()};
        FinderCacheUtil.putResult(this._finderPathCountByUUID_G, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByUUID_G, args, repositoryEntryModelImpl, false);
        args = new Object[]{repositoryEntryModelImpl.getRepositoryId(), repositoryEntryModelImpl.getMappedId()};
        FinderCacheUtil.putResult(this._finderPathCountByR_M, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByR_M, args, repositoryEntryModelImpl, false);
    }

    protected void clearUniqueFindersCache(RepositoryEntryModelImpl repositoryEntryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{repositoryEntryModelImpl.getUuid(), repositoryEntryModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if ((repositoryEntryModelImpl.getColumnBitmask() & this._finderPathFetchByUUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryEntryModelImpl.getOriginalUuid(), repositoryEntryModelImpl.getOriginalGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUUID_G, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByUUID_G, args);
        }
        if (clearCurrent) {
            args = new Object[]{repositoryEntryModelImpl.getRepositoryId(), repositoryEntryModelImpl.getMappedId()};
            FinderCacheUtil.removeResult(this._finderPathCountByR_M, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByR_M, args);
        }
        if ((repositoryEntryModelImpl.getColumnBitmask() & this._finderPathFetchByR_M.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryEntryModelImpl.getOriginalRepositoryId(), repositoryEntryModelImpl.getOriginalMappedId()};
            FinderCacheUtil.removeResult(this._finderPathCountByR_M, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByR_M, args);
        }
    }

    @Override
    public RepositoryEntry create(long repositoryEntryId) {
        RepositoryEntryImpl repositoryEntry = new RepositoryEntryImpl();
        repositoryEntry.setNew(true);
        repositoryEntry.setPrimaryKey(repositoryEntryId);
        String uuid = PortalUUIDUtil.generate();
        repositoryEntry.setUuid(uuid);
        repositoryEntry.setCompanyId(this.companyProvider.getCompanyId());
        return repositoryEntry;
    }

    @Override
    public RepositoryEntry remove(long repositoryEntryId) throws NoSuchRepositoryEntryException {
        return this.remove(Long.valueOf(repositoryEntryId));
    }

    @Override
    public RepositoryEntry remove(Serializable primaryKey) throws NoSuchRepositoryEntryException {
        Session session = null;
        try {
            session = this.openSession();
            RepositoryEntry repositoryEntry = (RepositoryEntry)session.get(RepositoryEntryImpl.class, primaryKey);
            if (repositoryEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchRepositoryEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            RepositoryEntry repositoryEntry2 = this.remove(repositoryEntry);
            return repositoryEntry2;
        }
        catch (NoSuchRepositoryEntryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected RepositoryEntry removeImpl(RepositoryEntry repositoryEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(repositoryEntry)) {
                repositoryEntry = (RepositoryEntry)session.get(RepositoryEntryImpl.class, repositoryEntry.getPrimaryKeyObj());
            }
            if (repositoryEntry != null) {
                session.delete(repositoryEntry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (repositoryEntry != null) {
            this.clearCache(repositoryEntry);
        }
        return repositoryEntry;
    }

    @Override
    public RepositoryEntry updateImpl(RepositoryEntry repositoryEntry) {
        boolean isNew = repositoryEntry.isNew();
        if (!(repositoryEntry instanceof RepositoryEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(repositoryEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(repositoryEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in repositoryEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom RepositoryEntry implementation " + repositoryEntry.getClass());
        }
        RepositoryEntryModelImpl repositoryEntryModelImpl = (RepositoryEntryModelImpl)((Object)repositoryEntry);
        if (Validator.isNull(repositoryEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            repositoryEntry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && repositoryEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                repositoryEntry.setCreateDate(now);
            } else {
                repositoryEntry.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!repositoryEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                repositoryEntry.setModifiedDate(now);
            } else {
                repositoryEntry.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (repositoryEntry.isNew()) {
                session.save(repositoryEntry);
                repositoryEntry.setNew(false);
            } else {
                repositoryEntry = (RepositoryEntry)session.merge(repositoryEntry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!RepositoryEntryModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{repositoryEntryModelImpl.getUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{repositoryEntryModelImpl.getUuid(), repositoryEntryModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{repositoryEntryModelImpl.getRepositoryId()};
            FinderCacheUtil.removeResult(this._finderPathCountByRepositoryId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByRepositoryId, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((repositoryEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryEntryModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{repositoryEntryModelImpl.getUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((repositoryEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryEntryModelImpl.getOriginalUuid(), repositoryEntryModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{repositoryEntryModelImpl.getUuid(), repositoryEntryModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((repositoryEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByRepositoryId.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryEntryModelImpl.getOriginalRepositoryId()};
                FinderCacheUtil.removeResult(this._finderPathCountByRepositoryId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByRepositoryId, args);
                args = new Object[]{repositoryEntryModelImpl.getRepositoryId()};
                FinderCacheUtil.removeResult(this._finderPathCountByRepositoryId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByRepositoryId, args);
            }
        }
        EntityCacheUtil.putResult(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryImpl.class, Long.valueOf(repositoryEntry.getPrimaryKey()), repositoryEntry, false);
        this.clearUniqueFindersCache(repositoryEntryModelImpl, false);
        this.cacheUniqueFindersCache(repositoryEntryModelImpl);
        repositoryEntry.resetOriginalValues();
        return repositoryEntry;
    }

    @Override
    public RepositoryEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchRepositoryEntryException {
        RepositoryEntry repositoryEntry = (RepositoryEntry)this.fetchByPrimaryKey(primaryKey);
        if (repositoryEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchRepositoryEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return repositoryEntry;
    }

    @Override
    public RepositoryEntry findByPrimaryKey(long repositoryEntryId) throws NoSuchRepositoryEntryException {
        return this.findByPrimaryKey(Long.valueOf(repositoryEntryId));
    }

    @Override
    public RepositoryEntry fetchByPrimaryKey(long repositoryEntryId) {
        return (RepositoryEntry)this.fetchByPrimaryKey(Long.valueOf(repositoryEntryId));
    }

    @Override
    public List<RepositoryEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<RepositoryEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<RepositoryEntry> findAll(int start, int end, OrderByComparator<RepositoryEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<RepositoryEntry> findAll(int start, int end, OrderByComparator<RepositoryEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<RepositoryEntry> list = null;
        if (retrieveFromCache) {
            list = (List<RepositoryEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_REPOSITORYENTRY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_REPOSITORYENTRY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY repositoryEntry.repositoryEntryId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (RepositoryEntry repositoryEntry : this.findAll()) {
            this.remove(repositoryEntry);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_REPOSITORYENTRY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "repositoryEntryId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_REPOSITORYENTRY;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return RepositoryEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 16L);
        this._finderPathCountByUuid = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathFetchByUUID_G = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, 18L);
        this._finderPathCountByUUID_G = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 17L);
        this._finderPathCountByUuid_C = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByRepositoryId = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByRepositoryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByRepositoryId = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByRepositoryId", new String[]{Long.class.getName()}, 8L);
        this._finderPathCountByRepositoryId = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRepositoryId", new String[]{Long.class.getName()});
        this._finderPathFetchByR_M = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, RepositoryEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByR_M", new String[]{Long.class.getName(), String.class.getName()}, 12L);
        this._finderPathCountByR_M = new FinderPath(RepositoryEntryModelImpl.ENTITY_CACHE_ENABLED, RepositoryEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByR_M", new String[]{Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(RepositoryEntryImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

