/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchReleaseException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.ReleasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.ReleaseImpl;
import com.liferay.portal.model.impl.ReleaseModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ReleasePersistenceImpl
extends BasePersistenceImpl<Release>
implements ReleasePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ReleaseImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByServletContextName;
    private FinderPath _finderPathCountByServletContextName;
    private static final String _FINDER_COLUMN_SERVLETCONTEXTNAME_SERVLETCONTEXTNAME_2 = "lower(release_.servletContextName) = ?";
    private static final String _FINDER_COLUMN_SERVLETCONTEXTNAME_SERVLETCONTEXTNAME_3 = "(release_.servletContextName IS NULL OR release_.servletContextName = '')";
    private static final String _SQL_SELECT_RELEASE_ = "SELECT release_ FROM Release release_";
    private static final String _SQL_SELECT_RELEASE__WHERE = "SELECT release_ FROM Release release_ WHERE ";
    private static final String _SQL_COUNT_RELEASE_ = "SELECT COUNT(release_) FROM Release release_";
    private static final String _SQL_COUNT_RELEASE__WHERE = "SELECT COUNT(release_) FROM Release release_ WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "release_.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Release exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Release exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ReleasePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"state"});

    @Override
    public Release findByServletContextName(String servletContextName) throws NoSuchReleaseException {
        Release release = this.fetchByServletContextName(servletContextName);
        if (release == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("servletContextName=");
            msg.append(servletContextName);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchReleaseException(msg.toString());
        }
        return release;
    }

    @Override
    public Release fetchByServletContextName(String servletContextName) {
        return this.fetchByServletContextName(servletContextName, true);
    }

    @Override
    public Release fetchByServletContextName(String servletContextName, boolean retrieveFromCache) {
        Release release;
        servletContextName = Objects.toString(servletContextName, "");
        Object[] finderArgs = new Object[]{servletContextName};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByServletContextName, finderArgs, this);
        }
        if (result instanceof Release && !Objects.equals(servletContextName, (release = (Release)result).getServletContextName())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_RELEASE__WHERE);
            boolean bindServletContextName = false;
            if (servletContextName.isEmpty()) {
                query.append(_FINDER_COLUMN_SERVLETCONTEXTNAME_SERVLETCONTEXTNAME_3);
            } else {
                bindServletContextName = true;
                query.append(_FINDER_COLUMN_SERVLETCONTEXTNAME_SERVLETCONTEXTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindServletContextName) {
                    qPos.add(StringUtil.toLowerCase(servletContextName));
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByServletContextName, finderArgs, list);
                } else {
                    Release release2 = (Release)list.get(0);
                    result = release2;
                    this.cacheResult(release2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByServletContextName, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Release)result;
    }

    @Override
    public Release removeByServletContextName(String servletContextName) throws NoSuchReleaseException {
        Release release = this.findByServletContextName(servletContextName);
        return this.remove(release);
    }

    @Override
    public int countByServletContextName(String servletContextName) {
        servletContextName = Objects.toString(servletContextName, "");
        FinderPath finderPath = this._finderPathCountByServletContextName;
        Object[] finderArgs = new Object[]{servletContextName};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_RELEASE__WHERE);
            boolean bindServletContextName = false;
            if (servletContextName.isEmpty()) {
                query.append(_FINDER_COLUMN_SERVLETCONTEXTNAME_SERVLETCONTEXTNAME_3);
            } else {
                bindServletContextName = true;
                query.append(_FINDER_COLUMN_SERVLETCONTEXTNAME_SERVLETCONTEXTNAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindServletContextName) {
                    qPos.add(StringUtil.toLowerCase(servletContextName));
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ReleasePersistenceImpl() {
        this.setModelClass(Release.class);
        this.setModelImplClass(ReleaseImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(ReleaseModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("state", "state_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Release release) {
        EntityCacheUtil.putResult(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseImpl.class, Long.valueOf(release.getPrimaryKey()), release);
        FinderCacheUtil.putResult(this._finderPathFetchByServletContextName, new Object[]{release.getServletContextName()}, release);
        release.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Release> releases) {
        for (Release release : releases) {
            if (EntityCacheUtil.getResult(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseImpl.class, Long.valueOf(release.getPrimaryKey())) == null) {
                this.cacheResult(release);
                continue;
            }
            release.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(ReleaseImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Release release) {
        EntityCacheUtil.removeResult(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseImpl.class, Long.valueOf(release.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ReleaseModelImpl)((Object)release), true);
    }

    @Override
    public void clearCache(List<Release> releases) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Release release : releases) {
            EntityCacheUtil.removeResult(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseImpl.class, Long.valueOf(release.getPrimaryKey()));
            this.clearUniqueFindersCache((ReleaseModelImpl)((Object)release), true);
        }
    }

    protected void cacheUniqueFindersCache(ReleaseModelImpl releaseModelImpl) {
        Object[] args = new Object[]{releaseModelImpl.getServletContextName()};
        FinderCacheUtil.putResult(this._finderPathCountByServletContextName, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByServletContextName, args, releaseModelImpl, false);
    }

    protected void clearUniqueFindersCache(ReleaseModelImpl releaseModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{releaseModelImpl.getServletContextName()};
            FinderCacheUtil.removeResult(this._finderPathCountByServletContextName, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByServletContextName, args);
        }
        if ((releaseModelImpl.getColumnBitmask() & this._finderPathFetchByServletContextName.getColumnBitmask()) != 0L) {
            args = new Object[]{releaseModelImpl.getOriginalServletContextName()};
            FinderCacheUtil.removeResult(this._finderPathCountByServletContextName, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByServletContextName, args);
        }
    }

    @Override
    public Release create(long releaseId) {
        ReleaseImpl release = new ReleaseImpl();
        release.setNew(true);
        release.setPrimaryKey(releaseId);
        return release;
    }

    @Override
    public Release remove(long releaseId) throws NoSuchReleaseException {
        return this.remove(Long.valueOf(releaseId));
    }

    @Override
    public Release remove(Serializable primaryKey) throws NoSuchReleaseException {
        Session session = null;
        try {
            session = this.openSession();
            Release release = (Release)session.get(ReleaseImpl.class, primaryKey);
            if (release == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchReleaseException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Release release2 = this.remove(release);
            return release2;
        }
        catch (NoSuchReleaseException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Release removeImpl(Release release) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(release)) {
                release = (Release)session.get(ReleaseImpl.class, release.getPrimaryKeyObj());
            }
            if (release != null) {
                session.delete(release);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (release != null) {
            this.clearCache(release);
        }
        return release;
    }

    @Override
    public Release updateImpl(Release release) {
        boolean isNew = release.isNew();
        if (!(release instanceof ReleaseModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(release.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(release);
                throw new IllegalArgumentException("Implement ModelWrapper in release proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Release implementation " + release.getClass());
        }
        ReleaseModelImpl releaseModelImpl = (ReleaseModelImpl)((Object)release);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && release.getCreateDate() == null) {
            if (serviceContext == null) {
                release.setCreateDate(now);
            } else {
                release.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!releaseModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                release.setModifiedDate(now);
            } else {
                release.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (release.isNew()) {
                session.save(release);
                release.setNew(false);
            } else {
                release = (Release)session.merge(release);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ReleaseModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        EntityCacheUtil.putResult(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseImpl.class, Long.valueOf(release.getPrimaryKey()), release, false);
        this.clearUniqueFindersCache(releaseModelImpl, false);
        this.cacheUniqueFindersCache(releaseModelImpl);
        release.resetOriginalValues();
        return release;
    }

    @Override
    public Release findByPrimaryKey(Serializable primaryKey) throws NoSuchReleaseException {
        Release release = (Release)this.fetchByPrimaryKey(primaryKey);
        if (release == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchReleaseException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return release;
    }

    @Override
    public Release findByPrimaryKey(long releaseId) throws NoSuchReleaseException {
        return this.findByPrimaryKey(Long.valueOf(releaseId));
    }

    @Override
    public Release fetchByPrimaryKey(long releaseId) {
        return (Release)this.fetchByPrimaryKey(Long.valueOf(releaseId));
    }

    @Override
    public List<Release> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Release> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Release> findAll(int start, int end, OrderByComparator<Release> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Release> findAll(int start, int end, OrderByComparator<Release> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Release> list = null;
        if (retrieveFromCache) {
            list = (List<Release>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_RELEASE_);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_RELEASE_;
                if (pagination) {
                    sql = sql.concat(" ORDER BY release_.releaseId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Release release : this.findAll()) {
            this.remove(release);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_RELEASE_);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "releaseId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_RELEASE_;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return ReleaseModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseModelImpl.FINDER_CACHE_ENABLED, ReleaseImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseModelImpl.FINDER_CACHE_ENABLED, ReleaseImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByServletContextName = new FinderPath(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseModelImpl.FINDER_CACHE_ENABLED, ReleaseImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByServletContextName", new String[]{String.class.getName()}, 1L);
        this._finderPathCountByServletContextName = new FinderPath(ReleaseModelImpl.ENTITY_CACHE_ENABLED, ReleaseModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByServletContextName", new String[]{String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ReleaseImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

