/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.persistence.RegionPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.RegionImpl;
import com.liferay.portal.model.impl.RegionModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RegionPersistenceImpl
extends BasePersistenceImpl<Region>
implements RegionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RegionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCountryId;
    private FinderPath _finderPathWithoutPaginationFindByCountryId;
    private FinderPath _finderPathCountByCountryId;
    private static final String _FINDER_COLUMN_COUNTRYID_COUNTRYID_2 = "region.countryId = ?";
    private FinderPath _finderPathWithPaginationFindByActive;
    private FinderPath _finderPathWithoutPaginationFindByActive;
    private FinderPath _finderPathCountByActive;
    private static final String _FINDER_COLUMN_ACTIVE_ACTIVE_2 = "region.active = ?";
    private FinderPath _finderPathFetchByC_R;
    private FinderPath _finderPathCountByC_R;
    private static final String _FINDER_COLUMN_C_R_COUNTRYID_2 = "region.countryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_REGIONCODE_2 = "region.regionCode = ?";
    private static final String _FINDER_COLUMN_C_R_REGIONCODE_3 = "(region.regionCode IS NULL OR region.regionCode = '')";
    private FinderPath _finderPathWithPaginationFindByC_A;
    private FinderPath _finderPathWithoutPaginationFindByC_A;
    private FinderPath _finderPathCountByC_A;
    private static final String _FINDER_COLUMN_C_A_COUNTRYID_2 = "region.countryId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_ACTIVE_2 = "region.active = ?";
    private static final String _SQL_SELECT_REGION = "SELECT region FROM Region region";
    private static final String _SQL_SELECT_REGION_WHERE = "SELECT region FROM Region region WHERE ";
    private static final String _SQL_COUNT_REGION = "SELECT COUNT(region) FROM Region region";
    private static final String _SQL_COUNT_REGION_WHERE = "SELECT COUNT(region) FROM Region region WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "region.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Region exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Region exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(RegionPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"active"});

    @Override
    public List<Region> findByCountryId(long countryId) {
        return this.findByCountryId(countryId, -1, -1, null);
    }

    @Override
    public List<Region> findByCountryId(long countryId, int start, int end) {
        return this.findByCountryId(countryId, start, end, null);
    }

    @Override
    public List<Region> findByCountryId(long countryId, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findByCountryId(countryId, start, end, orderByComparator, true);
    }

    @Override
    public List<Region> findByCountryId(long countryId, int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCountryId;
            finderArgs = new Object[]{countryId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCountryId;
            finderArgs = new Object[]{countryId, start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache && (list = (List<Region>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Region region : list) {
                if (countryId == region.getCountryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append(_FINDER_COLUMN_COUNTRYID_COUNTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY region.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(countryId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Region findByCountryId_First(long countryId, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByCountryId_First(countryId, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    @Override
    public Region fetchByCountryId_First(long countryId, OrderByComparator<Region> orderByComparator) {
        List<Region> list = this.findByCountryId(countryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Region findByCountryId_Last(long countryId, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByCountryId_Last(countryId, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    @Override
    public Region fetchByCountryId_Last(long countryId, OrderByComparator<Region> orderByComparator) {
        int count = this.countByCountryId(countryId);
        if (count == 0) {
            return null;
        }
        List<Region> list = this.findByCountryId(countryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Region[] findByCountryId_PrevAndNext(long regionId, long countryId, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.findByPrimaryKey(regionId);
        Session session = null;
        try {
            session = this.openSession();
            Region[] array = new RegionImpl[]{this.getByCountryId_PrevAndNext(session, region, countryId, orderByComparator, true), region, this.getByCountryId_PrevAndNext(session, region, countryId, orderByComparator, false)};
            Region[] regionArray = array;
            return regionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region getByCountryId_PrevAndNext(Session session, Region region, long countryId, OrderByComparator<Region> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REGION_WHERE);
        query.append(_FINDER_COLUMN_COUNTRYID_COUNTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY region.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(countryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(region)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Region)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByCountryId(long countryId) {
        for (Region region : this.findByCountryId(countryId, -1, -1, null)) {
            this.remove(region);
        }
    }

    @Override
    public int countByCountryId(long countryId) {
        FinderPath finderPath = this._finderPathCountByCountryId;
        Object[] finderArgs = new Object[]{countryId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append(_FINDER_COLUMN_COUNTRYID_COUNTRYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(countryId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Region> findByActive(boolean active) {
        return this.findByActive(active, -1, -1, null);
    }

    @Override
    public List<Region> findByActive(boolean active, int start, int end) {
        return this.findByActive(active, start, end, null);
    }

    @Override
    public List<Region> findByActive(boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findByActive(active, start, end, orderByComparator, true);
    }

    @Override
    public List<Region> findByActive(boolean active, int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByActive;
            finderArgs = new Object[]{active};
        } else {
            finderPath = this._finderPathWithPaginationFindByActive;
            finderArgs = new Object[]{active, start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache && (list = (List<Region>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Region region : list) {
                if (active == region.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append("region.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY region.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Region findByActive_First(boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByActive_First(active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    @Override
    public Region fetchByActive_First(boolean active, OrderByComparator<Region> orderByComparator) {
        List<Region> list = this.findByActive(active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Region findByActive_Last(boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByActive_Last(active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    @Override
    public Region fetchByActive_Last(boolean active, OrderByComparator<Region> orderByComparator) {
        int count = this.countByActive(active);
        if (count == 0) {
            return null;
        }
        List<Region> list = this.findByActive(active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Region[] findByActive_PrevAndNext(long regionId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.findByPrimaryKey(regionId);
        Session session = null;
        try {
            session = this.openSession();
            Region[] array = new RegionImpl[]{this.getByActive_PrevAndNext(session, region, active, orderByComparator, true), region, this.getByActive_PrevAndNext(session, region, active, orderByComparator, false)};
            Region[] regionArray = array;
            return regionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region getByActive_PrevAndNext(Session session, Region region, boolean active, OrderByComparator<Region> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_REGION_WHERE);
        query.append("region.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY region.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(region)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Region)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByActive(boolean active) {
        for (Region region : this.findByActive(active, -1, -1, null)) {
            this.remove(region);
        }
    }

    @Override
    public int countByActive(boolean active) {
        FinderPath finderPath = this._finderPathCountByActive;
        Object[] finderArgs = new Object[]{active};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append("region.active = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Region findByC_R(long countryId, String regionCode) throws NoSuchRegionException {
        Region region = this.fetchByC_R(countryId, regionCode);
        if (region == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("countryId=");
            msg.append(countryId);
            msg.append(", regionCode=");
            msg.append(regionCode);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchRegionException(msg.toString());
        }
        return region;
    }

    @Override
    public Region fetchByC_R(long countryId, String regionCode) {
        return this.fetchByC_R(countryId, regionCode, true);
    }

    @Override
    public Region fetchByC_R(long countryId, String regionCode, boolean retrieveFromCache) {
        Region region;
        regionCode = Objects.toString(regionCode, "");
        Object[] finderArgs = new Object[]{countryId, regionCode};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_R, finderArgs, this);
        }
        if (result instanceof Region && (countryId != (region = (Region)result).getCountryId() || !Objects.equals(regionCode, region.getRegionCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            boolean bindRegionCode = false;
            if (regionCode.isEmpty()) {
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_3);
            } else {
                bindRegionCode = true;
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(countryId);
                if (bindRegionCode) {
                    qPos.add(regionCode);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_R, finderArgs, list);
                } else {
                    Region region2 = (Region)list.get(0);
                    result = region2;
                    this.cacheResult(region2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_R, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Region)result;
    }

    @Override
    public Region removeByC_R(long countryId, String regionCode) throws NoSuchRegionException {
        Region region = this.findByC_R(countryId, regionCode);
        return this.remove(region);
    }

    @Override
    public int countByC_R(long countryId, String regionCode) {
        regionCode = Objects.toString(regionCode, "");
        FinderPath finderPath = this._finderPathCountByC_R;
        Object[] finderArgs = new Object[]{countryId, regionCode};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            boolean bindRegionCode = false;
            if (regionCode.isEmpty()) {
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_3);
            } else {
                bindRegionCode = true;
                query.append(_FINDER_COLUMN_C_R_REGIONCODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(countryId);
                if (bindRegionCode) {
                    qPos.add(regionCode);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Region> findByC_A(long countryId, boolean active) {
        return this.findByC_A(countryId, active, -1, -1, null);
    }

    @Override
    public List<Region> findByC_A(long countryId, boolean active, int start, int end) {
        return this.findByC_A(countryId, active, start, end, null);
    }

    @Override
    public List<Region> findByC_A(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findByC_A(countryId, active, start, end, orderByComparator, true);
    }

    @Override
    public List<Region> findByC_A(long countryId, boolean active, int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_A;
            finderArgs = new Object[]{countryId, active};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_A;
            finderArgs = new Object[]{countryId, active, start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache && (list = (List<Region>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Region region : list) {
                if (countryId == region.getCountryId() && active == region.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            query.append("region.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY region.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(countryId);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Region findByC_A_First(long countryId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByC_A_First(countryId, active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append(", active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    @Override
    public Region fetchByC_A_First(long countryId, boolean active, OrderByComparator<Region> orderByComparator) {
        List<Region> list = this.findByC_A(countryId, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Region findByC_A_Last(long countryId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.fetchByC_A_Last(countryId, active, orderByComparator);
        if (region != null) {
            return region;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("countryId=");
        msg.append(countryId);
        msg.append(", active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchRegionException(msg.toString());
    }

    @Override
    public Region fetchByC_A_Last(long countryId, boolean active, OrderByComparator<Region> orderByComparator) {
        int count = this.countByC_A(countryId, active);
        if (count == 0) {
            return null;
        }
        List<Region> list = this.findByC_A(countryId, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Region[] findByC_A_PrevAndNext(long regionId, long countryId, boolean active, OrderByComparator<Region> orderByComparator) throws NoSuchRegionException {
        Region region = this.findByPrimaryKey(regionId);
        Session session = null;
        try {
            session = this.openSession();
            Region[] array = new RegionImpl[]{this.getByC_A_PrevAndNext(session, region, countryId, active, orderByComparator, true), region, this.getByC_A_PrevAndNext(session, region, countryId, active, orderByComparator, false)};
            Region[] regionArray = array;
            return regionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Region getByC_A_PrevAndNext(Session session, Region region, long countryId, boolean active, OrderByComparator<Region> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_REGION_WHERE);
        query.append("region.countryId = ? AND ");
        query.append("region.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY region.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(countryId);
        qPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(region)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Region)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_A(long countryId, boolean active) {
        for (Region region : this.findByC_A(countryId, active, -1, -1, null)) {
            this.remove(region);
        }
    }

    @Override
    public int countByC_A(long countryId, boolean active) {
        FinderPath finderPath = this._finderPathCountByC_A;
        Object[] finderArgs = new Object[]{countryId, active};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REGION_WHERE);
            query.append("region.countryId = ? AND ");
            query.append("region.active = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(countryId);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public RegionPersistenceImpl() {
        this.setModelClass(Region.class);
        this.setModelImplClass(RegionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(RegionModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Region region) {
        EntityCacheUtil.putResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, Long.valueOf(region.getPrimaryKey()), region);
        FinderCacheUtil.putResult(this._finderPathFetchByC_R, new Object[]{region.getCountryId(), region.getRegionCode()}, region);
        region.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Region> regions) {
        for (Region region : regions) {
            if (EntityCacheUtil.getResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, Long.valueOf(region.getPrimaryKey())) == null) {
                this.cacheResult(region);
                continue;
            }
            region.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(RegionImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Region region) {
        EntityCacheUtil.removeResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, Long.valueOf(region.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((RegionModelImpl)((Object)region), true);
    }

    @Override
    public void clearCache(List<Region> regions) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Region region : regions) {
            EntityCacheUtil.removeResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, Long.valueOf(region.getPrimaryKey()));
            this.clearUniqueFindersCache((RegionModelImpl)((Object)region), true);
        }
    }

    protected void cacheUniqueFindersCache(RegionModelImpl regionModelImpl) {
        Object[] args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.getRegionCode()};
        FinderCacheUtil.putResult(this._finderPathCountByC_R, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_R, args, regionModelImpl, false);
    }

    protected void clearUniqueFindersCache(RegionModelImpl regionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.getRegionCode()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_R, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_R, args);
        }
        if ((regionModelImpl.getColumnBitmask() & this._finderPathFetchByC_R.getColumnBitmask()) != 0L) {
            args = new Object[]{regionModelImpl.getOriginalCountryId(), regionModelImpl.getOriginalRegionCode()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_R, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_R, args);
        }
    }

    @Override
    public Region create(long regionId) {
        RegionImpl region = new RegionImpl();
        region.setNew(true);
        region.setPrimaryKey(regionId);
        return region;
    }

    @Override
    public Region remove(long regionId) throws NoSuchRegionException {
        return this.remove(Long.valueOf(regionId));
    }

    @Override
    public Region remove(Serializable primaryKey) throws NoSuchRegionException {
        Session session = null;
        try {
            session = this.openSession();
            Region region = (Region)session.get(RegionImpl.class, primaryKey);
            if (region == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchRegionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Region region2 = this.remove(region);
            return region2;
        }
        catch (NoSuchRegionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Region removeImpl(Region region) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(region)) {
                region = (Region)session.get(RegionImpl.class, region.getPrimaryKeyObj());
            }
            if (region != null) {
                session.delete(region);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (region != null) {
            this.clearCache(region);
        }
        return region;
    }

    @Override
    public Region updateImpl(Region region) {
        boolean isNew = region.isNew();
        if (!(region instanceof RegionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(region.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(region);
                throw new IllegalArgumentException("Implement ModelWrapper in region proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Region implementation " + region.getClass());
        }
        RegionModelImpl regionModelImpl = (RegionModelImpl)((Object)region);
        Session session = null;
        try {
            session = this.openSession();
            if (region.isNew()) {
                session.save(region);
                region.setNew(false);
            } else {
                region = (Region)session.merge(region);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!RegionModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{regionModelImpl.getCountryId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCountryId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCountryId, args);
            args = new Object[]{regionModelImpl.isActive()};
            FinderCacheUtil.removeResult(this._finderPathCountByActive, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByActive, args);
            args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.isActive()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_A, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_A, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((regionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCountryId.getColumnBitmask()) != 0L) {
                args = new Object[]{regionModelImpl.getOriginalCountryId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCountryId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCountryId, args);
                args = new Object[]{regionModelImpl.getCountryId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCountryId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCountryId, args);
            }
            if ((regionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByActive.getColumnBitmask()) != 0L) {
                args = new Object[]{regionModelImpl.getOriginalActive()};
                FinderCacheUtil.removeResult(this._finderPathCountByActive, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByActive, args);
                args = new Object[]{regionModelImpl.isActive()};
                FinderCacheUtil.removeResult(this._finderPathCountByActive, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByActive, args);
            }
            if ((regionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_A.getColumnBitmask()) != 0L) {
                args = new Object[]{regionModelImpl.getOriginalCountryId(), regionModelImpl.getOriginalActive()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_A, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_A, args);
                args = new Object[]{regionModelImpl.getCountryId(), regionModelImpl.isActive()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_A, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_A, args);
            }
        }
        EntityCacheUtil.putResult(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionImpl.class, Long.valueOf(region.getPrimaryKey()), region, false);
        this.clearUniqueFindersCache(regionModelImpl, false);
        this.cacheUniqueFindersCache(regionModelImpl);
        region.resetOriginalValues();
        return region;
    }

    @Override
    public Region findByPrimaryKey(Serializable primaryKey) throws NoSuchRegionException {
        Region region = (Region)this.fetchByPrimaryKey(primaryKey);
        if (region == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchRegionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return region;
    }

    @Override
    public Region findByPrimaryKey(long regionId) throws NoSuchRegionException {
        return this.findByPrimaryKey(Long.valueOf(regionId));
    }

    @Override
    public Region fetchByPrimaryKey(long regionId) {
        return (Region)this.fetchByPrimaryKey(Long.valueOf(regionId));
    }

    @Override
    public List<Region> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Region> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Region> findAll(int start, int end, OrderByComparator<Region> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Region> findAll(int start, int end, OrderByComparator<Region> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Region> list = null;
        if (retrieveFromCache) {
            list = (List<Region>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_REGION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_REGION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY region.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Region region : this.findAll()) {
            this.remove(region);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_REGION);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "regionId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_REGION;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return RegionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCountryId = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCountryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCountryId = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCountryId", new String[]{Long.class.getName()}, 10L);
        this._finderPathCountByCountryId = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCountryId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByActive = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByActive", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByActive = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByActive", new String[]{Boolean.class.getName()}, 9L);
        this._finderPathCountByActive = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByActive", new String[]{Boolean.class.getName()});
        this._finderPathFetchByC_R = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_R", new String[]{Long.class.getName(), String.class.getName()}, 6L);
        this._finderPathCountByC_R = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByC_A = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_A = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, RegionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, 11L);
        this._finderPathCountByC_A = new FinderPath(RegionModelImpl.ENTITY_CACHE_ENABLED, RegionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A", new String[]{Long.class.getName(), Boolean.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(RegionImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

