/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchPortletException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.PortletPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PortletPersistenceImpl
extends BasePersistenceImpl<Portlet>
implements PortletPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = PortletImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "portlet.companyId = ?";
    private FinderPath _finderPathFetchByC_P;
    private FinderPath _finderPathCountByC_P;
    private static final String _FINDER_COLUMN_C_P_COMPANYID_2 = "portlet.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_PORTLETID_2 = "portlet.portletId = ?";
    private static final String _FINDER_COLUMN_C_P_PORTLETID_3 = "(portlet.portletId IS NULL OR portlet.portletId = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_PORTLET = "SELECT portlet FROM Portlet portlet";
    private static final String _SQL_SELECT_PORTLET_WHERE = "SELECT portlet FROM Portlet portlet WHERE ";
    private static final String _SQL_COUNT_PORTLET = "SELECT COUNT(portlet) FROM Portlet portlet";
    private static final String _SQL_COUNT_PORTLET_WHERE = "SELECT COUNT(portlet) FROM Portlet portlet WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "portlet.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Portlet exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Portlet exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(PortletPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"id", "active"});

    @Override
    public List<Portlet> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    @Override
    public List<Portlet> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    @Override
    public List<Portlet> findByCompanyId(long companyId, int start, int end, OrderByComparator<Portlet> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Portlet> findByCompanyId(long companyId, int start, int end, OrderByComparator<Portlet> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<Portlet> list = null;
        if (retrieveFromCache && (list = (List<Portlet>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Portlet portlet : list) {
                if (companyId == portlet.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_PORTLET_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY portlet.id ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Portlet findByCompanyId_First(long companyId, OrderByComparator<Portlet> orderByComparator) throws NoSuchPortletException {
        Portlet portlet = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (portlet != null) {
            return portlet;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchPortletException(msg.toString());
    }

    @Override
    public Portlet fetchByCompanyId_First(long companyId, OrderByComparator<Portlet> orderByComparator) {
        List<Portlet> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Portlet findByCompanyId_Last(long companyId, OrderByComparator<Portlet> orderByComparator) throws NoSuchPortletException {
        Portlet portlet = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (portlet != null) {
            return portlet;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchPortletException(msg.toString());
    }

    @Override
    public Portlet fetchByCompanyId_Last(long companyId, OrderByComparator<Portlet> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Portlet> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Portlet[] findByCompanyId_PrevAndNext(long id, long companyId, OrderByComparator<Portlet> orderByComparator) throws NoSuchPortletException {
        Portlet portlet = this.findByPrimaryKey(id);
        Session session = null;
        try {
            session = this.openSession();
            Portlet[] array = new PortletImpl[]{this.getByCompanyId_PrevAndNext(session, portlet, companyId, orderByComparator, true), portlet, this.getByCompanyId_PrevAndNext(session, portlet, companyId, orderByComparator, false)};
            Portlet[] portletArray = array;
            return portletArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Portlet getByCompanyId_PrevAndNext(Session session, Portlet portlet, long companyId, OrderByComparator<Portlet> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_PORTLET_WHERE);
        query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY portlet.id ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(portlet)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Portlet)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByCompanyId(long companyId) {
        for (Portlet portlet : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove(portlet);
        }
    }

    @Override
    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_PORTLET_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Portlet findByC_P(long companyId, String portletId) throws NoSuchPortletException {
        Portlet portlet = this.fetchByC_P(companyId, portletId);
        if (portlet == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", portletId=");
            msg.append(portletId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchPortletException(msg.toString());
        }
        return portlet;
    }

    @Override
    public Portlet fetchByC_P(long companyId, String portletId) {
        return this.fetchByC_P(companyId, portletId, true);
    }

    @Override
    public Portlet fetchByC_P(long companyId, String portletId, boolean retrieveFromCache) {
        Portlet portlet;
        portletId = Objects.toString(portletId, "");
        Object[] finderArgs = new Object[]{companyId, portletId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_P, finderArgs, this);
        }
        if (result instanceof Portlet && (companyId != (portlet = (Portlet)result).getCompanyId() || !Objects.equals(portletId, portlet.getPortletId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_PORTLET_WHERE);
            query.append(_FINDER_COLUMN_C_P_COMPANYID_2);
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append(_FINDER_COLUMN_C_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_C_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_P, finderArgs, list);
                } else {
                    Portlet portlet2 = (Portlet)list.get(0);
                    result = portlet2;
                    this.cacheResult(portlet2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_P, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Portlet)result;
    }

    @Override
    public Portlet removeByC_P(long companyId, String portletId) throws NoSuchPortletException {
        Portlet portlet = this.findByC_P(companyId, portletId);
        return this.remove(portlet);
    }

    @Override
    public int countByC_P(long companyId, String portletId) {
        portletId = Objects.toString(portletId, "");
        FinderPath finderPath = this._finderPathCountByC_P;
        Object[] finderArgs = new Object[]{companyId, portletId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_PORTLET_WHERE);
            query.append(_FINDER_COLUMN_C_P_COMPANYID_2);
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append(_FINDER_COLUMN_C_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_C_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public PortletPersistenceImpl() {
        this.setModelClass(Portlet.class);
        this.setModelImplClass(PortletImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(PortletModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("id", "id_");
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Portlet portlet) {
        EntityCacheUtil.putResult(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletImpl.class, Long.valueOf(portlet.getPrimaryKey()), portlet);
        FinderCacheUtil.putResult(this._finderPathFetchByC_P, new Object[]{portlet.getCompanyId(), portlet.getPortletId()}, portlet);
        portlet.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Portlet> portlets) {
        for (Portlet portlet : portlets) {
            if (EntityCacheUtil.getResult(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletImpl.class, Long.valueOf(portlet.getPrimaryKey())) == null) {
                this.cacheResult(portlet);
                continue;
            }
            portlet.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(PortletImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Portlet portlet) {
        EntityCacheUtil.removeResult(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletImpl.class, Long.valueOf(portlet.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((PortletModelImpl)((Object)portlet), true);
    }

    @Override
    public void clearCache(List<Portlet> portlets) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Portlet portlet : portlets) {
            EntityCacheUtil.removeResult(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletImpl.class, Long.valueOf(portlet.getPrimaryKey()));
            this.clearUniqueFindersCache((PortletModelImpl)((Object)portlet), true);
        }
    }

    protected void cacheUniqueFindersCache(PortletModelImpl portletModelImpl) {
        Object[] args = new Object[]{portletModelImpl.getCompanyId(), portletModelImpl.getPortletId()};
        FinderCacheUtil.putResult(this._finderPathCountByC_P, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_P, args, portletModelImpl, false);
    }

    protected void clearUniqueFindersCache(PortletModelImpl portletModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{portletModelImpl.getCompanyId(), portletModelImpl.getPortletId()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_P, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_P, args);
        }
        if ((portletModelImpl.getColumnBitmask() & this._finderPathFetchByC_P.getColumnBitmask()) != 0L) {
            args = new Object[]{portletModelImpl.getOriginalCompanyId(), portletModelImpl.getOriginalPortletId()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_P, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_P, args);
        }
    }

    @Override
    public Portlet create(long id) {
        PortletImpl portlet = new PortletImpl();
        portlet.setNew(true);
        portlet.setPrimaryKey(id);
        portlet.setCompanyId(this.companyProvider.getCompanyId());
        return portlet;
    }

    @Override
    public Portlet remove(long id) throws NoSuchPortletException {
        return this.remove(Long.valueOf(id));
    }

    @Override
    public Portlet remove(Serializable primaryKey) throws NoSuchPortletException {
        Session session = null;
        try {
            session = this.openSession();
            Portlet portlet = (Portlet)session.get(PortletImpl.class, primaryKey);
            if (portlet == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchPortletException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Portlet portlet2 = this.remove(portlet);
            return portlet2;
        }
        catch (NoSuchPortletException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Portlet removeImpl(Portlet portlet) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(portlet)) {
                portlet = (Portlet)session.get(PortletImpl.class, portlet.getPrimaryKeyObj());
            }
            if (portlet != null) {
                session.delete(portlet);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (portlet != null) {
            this.clearCache(portlet);
        }
        return portlet;
    }

    @Override
    public Portlet updateImpl(Portlet portlet) {
        boolean isNew = portlet.isNew();
        if (!(portlet instanceof PortletModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(portlet.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(portlet);
                throw new IllegalArgumentException("Implement ModelWrapper in portlet proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Portlet implementation " + portlet.getClass());
        }
        PortletModelImpl portletModelImpl = (PortletModelImpl)((Object)portlet);
        Session session = null;
        try {
            session = this.openSession();
            if (portlet.isNew()) {
                session.save(portlet);
                portlet.setNew(false);
            } else {
                portlet = (Portlet)session.merge(portlet);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!PortletModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{portletModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((portletModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{portletModelImpl.getOriginalCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{portletModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
        }
        EntityCacheUtil.putResult(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletImpl.class, Long.valueOf(portlet.getPrimaryKey()), portlet, false);
        this.clearUniqueFindersCache(portletModelImpl, false);
        this.cacheUniqueFindersCache(portletModelImpl);
        portlet.resetOriginalValues();
        return portlet;
    }

    @Override
    public Portlet findByPrimaryKey(Serializable primaryKey) throws NoSuchPortletException {
        Portlet portlet = (Portlet)this.fetchByPrimaryKey(primaryKey);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchPortletException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return portlet;
    }

    @Override
    public Portlet findByPrimaryKey(long id) throws NoSuchPortletException {
        return this.findByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public Portlet fetchByPrimaryKey(long id) {
        return (Portlet)this.fetchByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public List<Portlet> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Portlet> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Portlet> findAll(int start, int end, OrderByComparator<Portlet> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Portlet> findAll(int start, int end, OrderByComparator<Portlet> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Portlet> list = null;
        if (retrieveFromCache) {
            list = (List<Portlet>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_PORTLET);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_PORTLET;
                if (pagination) {
                    sql = sql.concat(" ORDER BY portlet.id ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Portlet portlet : this.findAll()) {
            this.remove(portlet);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_PORTLET);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "id_";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_PORTLET;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return PortletModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, PortletImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, PortletImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, PortletImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, PortletImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCompanyId = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathFetchByC_P = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, PortletImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_P", new String[]{Long.class.getName(), String.class.getName()}, 3L);
        this._finderPathCountByC_P = new FinderPath(PortletModelImpl.ENTITY_CACHE_ENABLED, PortletModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_P", new String[]{Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(PortletImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

