/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchPortletItemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.PortletItemPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.PortletItemImpl;
import com.liferay.portal.model.impl.PortletItemModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class PortletItemPersistenceImpl
extends BasePersistenceImpl<PortletItem>
implements PortletItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = PortletItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByG_C;
    private FinderPath _finderPathWithoutPaginationFindByG_C;
    private FinderPath _finderPathCountByG_C;
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "portletItem.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_CLASSNAMEID_2 = "portletItem.classNameId = ?";
    private FinderPath _finderPathWithPaginationFindByG_P_C;
    private FinderPath _finderPathWithoutPaginationFindByG_P_C;
    private FinderPath _finderPathCountByG_P_C;
    private static final String _FINDER_COLUMN_G_P_C_GROUPID_2 = "portletItem.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_P_C_PORTLETID_2 = "portletItem.portletId = ? AND ";
    private static final String _FINDER_COLUMN_G_P_C_PORTLETID_3 = "(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ";
    private static final String _FINDER_COLUMN_G_P_C_CLASSNAMEID_2 = "portletItem.classNameId = ?";
    private FinderPath _finderPathFetchByG_N_P_C;
    private FinderPath _finderPathCountByG_N_P_C;
    private static final String _FINDER_COLUMN_G_N_P_C_GROUPID_2 = "portletItem.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_C_NAME_2 = "lower(portletItem.name) = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_C_NAME_3 = "(portletItem.name IS NULL OR portletItem.name = '') AND ";
    private static final String _FINDER_COLUMN_G_N_P_C_PORTLETID_2 = "portletItem.portletId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_C_PORTLETID_3 = "(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ";
    private static final String _FINDER_COLUMN_G_N_P_C_CLASSNAMEID_2 = "portletItem.classNameId = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_PORTLETITEM = "SELECT portletItem FROM PortletItem portletItem";
    private static final String _SQL_SELECT_PORTLETITEM_WHERE = "SELECT portletItem FROM PortletItem portletItem WHERE ";
    private static final String _SQL_COUNT_PORTLETITEM = "SELECT COUNT(portletItem) FROM PortletItem portletItem";
    private static final String _SQL_COUNT_PORTLETITEM_WHERE = "SELECT COUNT(portletItem) FROM PortletItem portletItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "portletItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No PortletItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No PortletItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(PortletItemPersistenceImpl.class);

    @Override
    public List<PortletItem> findByG_C(long groupId, long classNameId) {
        return this.findByG_C(groupId, classNameId, -1, -1, null);
    }

    @Override
    public List<PortletItem> findByG_C(long groupId, long classNameId, int start, int end) {
        return this.findByG_C(groupId, classNameId, start, end, null);
    }

    @Override
    public List<PortletItem> findByG_C(long groupId, long classNameId, int start, int end, OrderByComparator<PortletItem> orderByComparator) {
        return this.findByG_C(groupId, classNameId, start, end, orderByComparator, true);
    }

    @Override
    public List<PortletItem> findByG_C(long groupId, long classNameId, int start, int end, OrderByComparator<PortletItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByG_C;
            finderArgs = new Object[]{groupId, classNameId};
        } else {
            finderPath = this._finderPathWithPaginationFindByG_C;
            finderArgs = new Object[]{groupId, classNameId, start, end, orderByComparator};
        }
        List<PortletItem> list = null;
        if (retrieveFromCache && (list = (List<PortletItem>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (PortletItem portletItem : list) {
                if (groupId == portletItem.getGroupId() && classNameId == portletItem.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_PORTLETITEM_WHERE);
            query.append("portletItem.groupId = ? AND ");
            query.append("portletItem.classNameId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY portletItem.portletItemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(classNameId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public PortletItem findByG_C_First(long groupId, long classNameId, OrderByComparator<PortletItem> orderByComparator) throws NoSuchPortletItemException {
        PortletItem portletItem = this.fetchByG_C_First(groupId, classNameId, orderByComparator);
        if (portletItem != null) {
            return portletItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchPortletItemException(msg.toString());
    }

    @Override
    public PortletItem fetchByG_C_First(long groupId, long classNameId, OrderByComparator<PortletItem> orderByComparator) {
        List<PortletItem> list = this.findByG_C(groupId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public PortletItem findByG_C_Last(long groupId, long classNameId, OrderByComparator<PortletItem> orderByComparator) throws NoSuchPortletItemException {
        PortletItem portletItem = this.fetchByG_C_Last(groupId, classNameId, orderByComparator);
        if (portletItem != null) {
            return portletItem;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchPortletItemException(msg.toString());
    }

    @Override
    public PortletItem fetchByG_C_Last(long groupId, long classNameId, OrderByComparator<PortletItem> orderByComparator) {
        int count = this.countByG_C(groupId, classNameId);
        if (count == 0) {
            return null;
        }
        List<PortletItem> list = this.findByG_C(groupId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public PortletItem[] findByG_C_PrevAndNext(long portletItemId, long groupId, long classNameId, OrderByComparator<PortletItem> orderByComparator) throws NoSuchPortletItemException {
        PortletItem portletItem = this.findByPrimaryKey(portletItemId);
        Session session = null;
        try {
            session = this.openSession();
            PortletItem[] array = new PortletItemImpl[]{this.getByG_C_PrevAndNext(session, portletItem, groupId, classNameId, orderByComparator, true), portletItem, this.getByG_C_PrevAndNext(session, portletItem, groupId, classNameId, orderByComparator, false)};
            PortletItem[] portletItemArray = array;
            return portletItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected PortletItem getByG_C_PrevAndNext(Session session, PortletItem portletItem, long groupId, long classNameId, OrderByComparator<PortletItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_PORTLETITEM_WHERE);
        query.append("portletItem.groupId = ? AND ");
        query.append("portletItem.classNameId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY portletItem.portletItemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        qPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(portletItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (PortletItem)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByG_C(long groupId, long classNameId) {
        for (PortletItem portletItem : this.findByG_C(groupId, classNameId, -1, -1, null)) {
            this.remove(portletItem);
        }
    }

    @Override
    public int countByG_C(long groupId, long classNameId) {
        FinderPath finderPath = this._finderPathCountByG_C;
        Object[] finderArgs = new Object[]{groupId, classNameId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_PORTLETITEM_WHERE);
            query.append("portletItem.groupId = ? AND ");
            query.append("portletItem.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<PortletItem> findByG_P_C(long groupId, String portletId, long classNameId) {
        return this.findByG_P_C(groupId, portletId, classNameId, -1, -1, null);
    }

    @Override
    public List<PortletItem> findByG_P_C(long groupId, String portletId, long classNameId, int start, int end) {
        return this.findByG_P_C(groupId, portletId, classNameId, start, end, null);
    }

    @Override
    public List<PortletItem> findByG_P_C(long groupId, String portletId, long classNameId, int start, int end, OrderByComparator<PortletItem> orderByComparator) {
        return this.findByG_P_C(groupId, portletId, classNameId, start, end, orderByComparator, true);
    }

    @Override
    public List<PortletItem> findByG_P_C(long groupId, String portletId, long classNameId, int start, int end, OrderByComparator<PortletItem> orderByComparator, boolean retrieveFromCache) {
        portletId = Objects.toString(portletId, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByG_P_C;
            finderArgs = new Object[]{groupId, portletId, classNameId};
        } else {
            finderPath = this._finderPathWithPaginationFindByG_P_C;
            finderArgs = new Object[]{groupId, portletId, classNameId, start, end, orderByComparator};
        }
        List<PortletItem> list = null;
        if (retrieveFromCache && (list = (List<PortletItem>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (PortletItem portletItem : list) {
                if (groupId == portletItem.getGroupId() && portletId.equals(portletItem.getPortletId()) && classNameId == portletItem.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_PORTLETITEM_WHERE);
            query.append("portletItem.groupId = ? AND ");
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append("(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ");
            } else {
                bindPortletId = true;
                query.append("portletItem.portletId = ? AND ");
            }
            query.append("portletItem.classNameId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY portletItem.portletItemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                qPos.add(classNameId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public PortletItem findByG_P_C_First(long groupId, String portletId, long classNameId, OrderByComparator<PortletItem> orderByComparator) throws NoSuchPortletItemException {
        PortletItem portletItem = this.fetchByG_P_C_First(groupId, portletId, classNameId, orderByComparator);
        if (portletItem != null) {
            return portletItem;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", portletId=");
        msg.append(portletId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchPortletItemException(msg.toString());
    }

    @Override
    public PortletItem fetchByG_P_C_First(long groupId, String portletId, long classNameId, OrderByComparator<PortletItem> orderByComparator) {
        List<PortletItem> list = this.findByG_P_C(groupId, portletId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public PortletItem findByG_P_C_Last(long groupId, String portletId, long classNameId, OrderByComparator<PortletItem> orderByComparator) throws NoSuchPortletItemException {
        PortletItem portletItem = this.fetchByG_P_C_Last(groupId, portletId, classNameId, orderByComparator);
        if (portletItem != null) {
            return portletItem;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", portletId=");
        msg.append(portletId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchPortletItemException(msg.toString());
    }

    @Override
    public PortletItem fetchByG_P_C_Last(long groupId, String portletId, long classNameId, OrderByComparator<PortletItem> orderByComparator) {
        int count = this.countByG_P_C(groupId, portletId, classNameId);
        if (count == 0) {
            return null;
        }
        List<PortletItem> list = this.findByG_P_C(groupId, portletId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public PortletItem[] findByG_P_C_PrevAndNext(long portletItemId, long groupId, String portletId, long classNameId, OrderByComparator<PortletItem> orderByComparator) throws NoSuchPortletItemException {
        portletId = Objects.toString(portletId, "");
        PortletItem portletItem = this.findByPrimaryKey(portletItemId);
        Session session = null;
        try {
            session = this.openSession();
            PortletItem[] array = new PortletItemImpl[]{this.getByG_P_C_PrevAndNext(session, portletItem, groupId, portletId, classNameId, orderByComparator, true), portletItem, this.getByG_P_C_PrevAndNext(session, portletItem, groupId, portletId, classNameId, orderByComparator, false)};
            PortletItem[] portletItemArray = array;
            return portletItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected PortletItem getByG_P_C_PrevAndNext(Session session, PortletItem portletItem, long groupId, String portletId, long classNameId, OrderByComparator<PortletItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_PORTLETITEM_WHERE);
        query.append("portletItem.groupId = ? AND ");
        boolean bindPortletId = false;
        if (portletId.isEmpty()) {
            query.append("(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ");
        } else {
            bindPortletId = true;
            query.append("portletItem.portletId = ? AND ");
        }
        query.append("portletItem.classNameId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY portletItem.portletItemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        if (bindPortletId) {
            qPos.add(portletId);
        }
        qPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(portletItem)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (PortletItem)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByG_P_C(long groupId, String portletId, long classNameId) {
        for (PortletItem portletItem : this.findByG_P_C(groupId, portletId, classNameId, -1, -1, null)) {
            this.remove(portletItem);
        }
    }

    @Override
    public int countByG_P_C(long groupId, String portletId, long classNameId) {
        portletId = Objects.toString(portletId, "");
        FinderPath finderPath = this._finderPathCountByG_P_C;
        Object[] finderArgs = new Object[]{groupId, portletId, classNameId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_PORTLETITEM_WHERE);
            query.append("portletItem.groupId = ? AND ");
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append("(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ");
            } else {
                bindPortletId = true;
                query.append("portletItem.portletId = ? AND ");
            }
            query.append("portletItem.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public PortletItem findByG_N_P_C(long groupId, String name, String portletId, long classNameId) throws NoSuchPortletItemException {
        PortletItem portletItem = this.fetchByG_N_P_C(groupId, name, portletId, classNameId);
        if (portletItem == null) {
            StringBundler msg = new StringBundler(10);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", portletId=");
            msg.append(portletId);
            msg.append(", classNameId=");
            msg.append(classNameId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchPortletItemException(msg.toString());
        }
        return portletItem;
    }

    @Override
    public PortletItem fetchByG_N_P_C(long groupId, String name, String portletId, long classNameId) {
        return this.fetchByG_N_P_C(groupId, name, portletId, classNameId, true);
    }

    @Override
    public PortletItem fetchByG_N_P_C(long groupId, String name, String portletId, long classNameId, boolean retrieveFromCache) {
        PortletItem portletItem;
        name = Objects.toString(name, "");
        portletId = Objects.toString(portletId, "");
        Object[] finderArgs = new Object[]{groupId, name, portletId, classNameId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByG_N_P_C, finderArgs, this);
        }
        if (!(!(result instanceof PortletItem) || groupId == (portletItem = (PortletItem)result).getGroupId() && Objects.equals(name, portletItem.getName()) && Objects.equals(portletId, portletItem.getPortletId()) && classNameId == portletItem.getClassNameId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(6);
            query.append(_SQL_SELECT_PORTLETITEM_WHERE);
            query.append("portletItem.groupId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_P_C_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_C_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append("(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ");
            } else {
                bindPortletId = true;
                query.append("portletItem.portletId = ? AND ");
            }
            query.append("portletItem.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(StringUtil.toLowerCase(name));
                }
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                qPos.add(classNameId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByG_N_P_C, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("PortletItemPersistenceImpl.fetchByG_N_P_C(long, String, String, long, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    PortletItem portletItem2 = (PortletItem)list.get(0);
                    result = portletItem2;
                    this.cacheResult(portletItem2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByG_N_P_C, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (PortletItem)result;
    }

    @Override
    public PortletItem removeByG_N_P_C(long groupId, String name, String portletId, long classNameId) throws NoSuchPortletItemException {
        PortletItem portletItem = this.findByG_N_P_C(groupId, name, portletId, classNameId);
        return this.remove(portletItem);
    }

    @Override
    public int countByG_N_P_C(long groupId, String name, String portletId, long classNameId) {
        name = Objects.toString(name, "");
        portletId = Objects.toString(portletId, "");
        FinderPath finderPath = this._finderPathCountByG_N_P_C;
        Object[] finderArgs = new Object[]{groupId, name, portletId, classNameId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_PORTLETITEM_WHERE);
            query.append("portletItem.groupId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_G_N_P_C_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_C_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId.isEmpty()) {
                query.append("(portletItem.portletId IS NULL OR portletItem.portletId = '') AND ");
            } else {
                bindPortletId = true;
                query.append("portletItem.portletId = ? AND ");
            }
            query.append("portletItem.classNameId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindName) {
                    qPos.add(StringUtil.toLowerCase(name));
                }
                if (bindPortletId) {
                    qPos.add(portletId);
                }
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public PortletItemPersistenceImpl() {
        this.setModelClass(PortletItem.class);
        this.setModelImplClass(PortletItemImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(PortletItemModelImpl.ENTITY_CACHE_ENABLED);
    }

    @Override
    public void cacheResult(PortletItem portletItem) {
        EntityCacheUtil.putResult(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemImpl.class, Long.valueOf(portletItem.getPrimaryKey()), portletItem);
        FinderCacheUtil.putResult(this._finderPathFetchByG_N_P_C, new Object[]{portletItem.getGroupId(), portletItem.getName(), portletItem.getPortletId(), portletItem.getClassNameId()}, portletItem);
        portletItem.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<PortletItem> portletItems) {
        for (PortletItem portletItem : portletItems) {
            if (EntityCacheUtil.getResult(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemImpl.class, Long.valueOf(portletItem.getPrimaryKey())) == null) {
                this.cacheResult(portletItem);
                continue;
            }
            portletItem.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(PortletItemImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(PortletItem portletItem) {
        EntityCacheUtil.removeResult(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemImpl.class, Long.valueOf(portletItem.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((PortletItemModelImpl)((Object)portletItem), true);
    }

    @Override
    public void clearCache(List<PortletItem> portletItems) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (PortletItem portletItem : portletItems) {
            EntityCacheUtil.removeResult(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemImpl.class, Long.valueOf(portletItem.getPrimaryKey()));
            this.clearUniqueFindersCache((PortletItemModelImpl)((Object)portletItem), true);
        }
    }

    protected void cacheUniqueFindersCache(PortletItemModelImpl portletItemModelImpl) {
        Object[] args = new Object[]{portletItemModelImpl.getGroupId(), portletItemModelImpl.getName(), portletItemModelImpl.getPortletId(), portletItemModelImpl.getClassNameId()};
        FinderCacheUtil.putResult(this._finderPathCountByG_N_P_C, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByG_N_P_C, args, portletItemModelImpl, false);
    }

    protected void clearUniqueFindersCache(PortletItemModelImpl portletItemModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{portletItemModelImpl.getGroupId(), portletItemModelImpl.getName(), portletItemModelImpl.getPortletId(), portletItemModelImpl.getClassNameId()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_N_P_C, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_N_P_C, args);
        }
        if ((portletItemModelImpl.getColumnBitmask() & this._finderPathFetchByG_N_P_C.getColumnBitmask()) != 0L) {
            args = new Object[]{portletItemModelImpl.getOriginalGroupId(), portletItemModelImpl.getOriginalName(), portletItemModelImpl.getOriginalPortletId(), portletItemModelImpl.getOriginalClassNameId()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_N_P_C, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_N_P_C, args);
        }
    }

    @Override
    public PortletItem create(long portletItemId) {
        PortletItemImpl portletItem = new PortletItemImpl();
        portletItem.setNew(true);
        portletItem.setPrimaryKey(portletItemId);
        portletItem.setCompanyId(this.companyProvider.getCompanyId());
        return portletItem;
    }

    @Override
    public PortletItem remove(long portletItemId) throws NoSuchPortletItemException {
        return this.remove(Long.valueOf(portletItemId));
    }

    @Override
    public PortletItem remove(Serializable primaryKey) throws NoSuchPortletItemException {
        Session session = null;
        try {
            session = this.openSession();
            PortletItem portletItem = (PortletItem)session.get(PortletItemImpl.class, primaryKey);
            if (portletItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchPortletItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            PortletItem portletItem2 = this.remove(portletItem);
            return portletItem2;
        }
        catch (NoSuchPortletItemException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected PortletItem removeImpl(PortletItem portletItem) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(portletItem)) {
                portletItem = (PortletItem)session.get(PortletItemImpl.class, portletItem.getPrimaryKeyObj());
            }
            if (portletItem != null) {
                session.delete(portletItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (portletItem != null) {
            this.clearCache(portletItem);
        }
        return portletItem;
    }

    @Override
    public PortletItem updateImpl(PortletItem portletItem) {
        boolean isNew = portletItem.isNew();
        if (!(portletItem instanceof PortletItemModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(portletItem.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(portletItem);
                throw new IllegalArgumentException("Implement ModelWrapper in portletItem proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom PortletItem implementation " + portletItem.getClass());
        }
        PortletItemModelImpl portletItemModelImpl = (PortletItemModelImpl)((Object)portletItem);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && portletItem.getCreateDate() == null) {
            if (serviceContext == null) {
                portletItem.setCreateDate(now);
            } else {
                portletItem.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!portletItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                portletItem.setModifiedDate(now);
            } else {
                portletItem.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (portletItem.isNew()) {
                session.save(portletItem);
                portletItem.setNew(false);
            } else {
                portletItem = (PortletItem)session.merge(portletItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!PortletItemModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{portletItemModelImpl.getGroupId(), portletItemModelImpl.getClassNameId()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C, args);
            args = new Object[]{portletItemModelImpl.getGroupId(), portletItemModelImpl.getPortletId(), portletItemModelImpl.getClassNameId()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_P_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_P_C, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((portletItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_C.getColumnBitmask()) != 0L) {
                args = new Object[]{portletItemModelImpl.getOriginalGroupId(), portletItemModelImpl.getOriginalClassNameId()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C, args);
                args = new Object[]{portletItemModelImpl.getGroupId(), portletItemModelImpl.getClassNameId()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C, args);
            }
            if ((portletItemModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_P_C.getColumnBitmask()) != 0L) {
                args = new Object[]{portletItemModelImpl.getOriginalGroupId(), portletItemModelImpl.getOriginalPortletId(), portletItemModelImpl.getOriginalClassNameId()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_P_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_P_C, args);
                args = new Object[]{portletItemModelImpl.getGroupId(), portletItemModelImpl.getPortletId(), portletItemModelImpl.getClassNameId()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_P_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_P_C, args);
            }
        }
        EntityCacheUtil.putResult(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemImpl.class, Long.valueOf(portletItem.getPrimaryKey()), portletItem, false);
        this.clearUniqueFindersCache(portletItemModelImpl, false);
        this.cacheUniqueFindersCache(portletItemModelImpl);
        portletItem.resetOriginalValues();
        return portletItem;
    }

    @Override
    public PortletItem findByPrimaryKey(Serializable primaryKey) throws NoSuchPortletItemException {
        PortletItem portletItem = (PortletItem)this.fetchByPrimaryKey(primaryKey);
        if (portletItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchPortletItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return portletItem;
    }

    @Override
    public PortletItem findByPrimaryKey(long portletItemId) throws NoSuchPortletItemException {
        return this.findByPrimaryKey(Long.valueOf(portletItemId));
    }

    @Override
    public PortletItem fetchByPrimaryKey(long portletItemId) {
        return (PortletItem)this.fetchByPrimaryKey(Long.valueOf(portletItemId));
    }

    @Override
    public List<PortletItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<PortletItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<PortletItem> findAll(int start, int end, OrderByComparator<PortletItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<PortletItem> findAll(int start, int end, OrderByComparator<PortletItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<PortletItem> list = null;
        if (retrieveFromCache) {
            list = (List<PortletItem>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_PORTLETITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_PORTLETITEM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY portletItem.portletItemId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (PortletItem portletItem : this.findAll()) {
            this.remove(portletItem);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_PORTLETITEM);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "portletItemId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_PORTLETITEM;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return PortletItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByG_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByG_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByG_P_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_P_C", new String[]{Long.class.getName(), String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_P_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_P_C", new String[]{Long.class.getName(), String.class.getName(), Long.class.getName()}, 11L);
        this._finderPathCountByG_P_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_P_C", new String[]{Long.class.getName(), String.class.getName(), Long.class.getName()});
        this._finderPathFetchByG_N_P_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, PortletItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N_P_C", new String[]{Long.class.getName(), String.class.getName(), String.class.getName(), Long.class.getName()}, 15L);
        this._finderPathCountByG_N_P_C = new FinderPath(PortletItemModelImpl.ENTITY_CACHE_ENABLED, PortletItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N_P_C", new String[]{Long.class.getName(), String.class.getName(), String.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(PortletItemImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

