/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.persistence.PasswordPolicyFinder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.impl.PasswordPolicyImpl;
import com.liferay.portal.service.persistence.impl.PasswordPolicyFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

public class PasswordPolicyFinderImpl
extends PasswordPolicyFinderBaseImpl
implements PasswordPolicyFinder {
    public static final String COUNT_BY_C_N = PasswordPolicyFinder.class.getName() + ".countByC_N";
    public static final String FIND_BY_C_N = PasswordPolicyFinder.class.getName() + ".findByC_N";

    @Override
    public int countByC_N(long companyId, String name) {
        return this.doCountByC_N(companyId, name, false);
    }

    @Override
    public int filterCountByC_N(long companyId, String name) {
        return this.doCountByC_N(companyId, name, true);
    }

    @Override
    public List<PasswordPolicy> filterFindByC_N(long companyId, String name, int start, int end, OrderByComparator<PasswordPolicy> obc) {
        return this.doFindByC_N(companyId, name, start, end, obc, true);
    }

    @Override
    public List<PasswordPolicy> findByC_N(long companyId, String name, int start, int end, OrderByComparator<PasswordPolicy> obc) {
        return this.doFindByC_N(companyId, name, start, end, obc, false);
    }

    protected int doCountByC_N(long companyId, String name, boolean inlineSQLHelper) {
        name = CustomSQLUtil.keywords(name)[0];
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get(COUNT_BY_C_N);
            if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
                sql = InlineSQLHelperUtil.replacePermissionCheck(sql, PasswordPolicy.class.getName(), "PasswordPolicy.passwordPolicyId", null, null, new long[]{0L}, null);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(name);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<PasswordPolicy> doFindByC_N(long companyId, String name, int start, int end, OrderByComparator<PasswordPolicy> obc, boolean inlineSQLHelper) {
        name = CustomSQLUtil.keywords(name)[0];
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(FIND_BY_C_N);
            sql = CustomSQLUtil.replaceOrderBy(sql, obc);
            if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
                sql = InlineSQLHelperUtil.replacePermissionCheck(sql, PasswordPolicy.class.getName(), "PasswordPolicy.passwordPolicyId", null, null, new long[]{0L}, null);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("PasswordPolicy", PasswordPolicyImpl.class);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(name);
            List<PasswordPolicy> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

