/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.service.persistence.impl.TableMapperFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.OrganizationImpl;
import com.liferay.portal.model.impl.OrganizationModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class OrganizationPersistenceImpl
extends BasePersistenceImpl<Organization>
implements OrganizationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OrganizationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "organization.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(organization.uuid IS NULL OR organization.uuid = '')";
    private static final String _FINDER_COLUMN_UUID_UUID_2_SQL = "organization.uuid_ = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3_SQL = "(organization.uuid_ IS NULL OR organization.uuid_ = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "organization.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(organization.uuid IS NULL OR organization.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2_SQL = "organization.uuid_ = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3_SQL = "(organization.uuid_ IS NULL OR organization.uuid_ = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "organization.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "organization.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByLocations;
    private FinderPath _finderPathWithoutPaginationFindByLocations;
    private FinderPath _finderPathCountByLocations;
    private static final String _FINDER_COLUMN_LOCATIONS_COMPANYID_2 = "organization.companyId = ? AND organization.parentOrganizationId != 0";
    private FinderPath _finderPathWithPaginationFindByC_P;
    private FinderPath _finderPathWithoutPaginationFindByC_P;
    private FinderPath _finderPathCountByC_P;
    private static final String _FINDER_COLUMN_C_P_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_PARENTORGANIZATIONID_2 = "organization.parentOrganizationId = ?";
    private FinderPath _finderPathWithPaginationFindByC_T;
    private FinderPath _finderPathWithPaginationCountByC_T;
    private static final String _FINDER_COLUMN_C_T_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_T_TREEPATH_2 = "organization.treePath LIKE ?";
    private static final String _FINDER_COLUMN_C_T_TREEPATH_3 = "(organization.treePath IS NULL OR organization.treePath LIKE '')";
    private FinderPath _finderPathFetchByC_N;
    private FinderPath _finderPathCountByC_N;
    private static final String _FINDER_COLUMN_C_N_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_N_NAME_2 = "organization.name = ?";
    private static final String _FINDER_COLUMN_C_N_NAME_3 = "(organization.name IS NULL OR organization.name = '')";
    private FinderPath _finderPathWithPaginationFindByC_LikeN;
    private FinderPath _finderPathWithPaginationCountByC_LikeN;
    private static final String _FINDER_COLUMN_C_LIKEN_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_LIKEN_NAME_2 = "lower(organization.name) LIKE ?";
    private static final String _FINDER_COLUMN_C_LIKEN_NAME_3 = "(organization.name IS NULL OR organization.name LIKE '')";
    private FinderPath _finderPathWithPaginationFindByO_C_P;
    private FinderPath _finderPathWithPaginationCountByO_C_P;
    private static final String _FINDER_COLUMN_O_C_P_ORGANIZATIONID_2 = "organization.organizationId > ? AND ";
    private static final String _FINDER_COLUMN_O_C_P_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_O_C_P_PARENTORGANIZATIONID_2 = "organization.parentOrganizationId = ?";
    private FinderPath _finderPathWithPaginationFindByC_P_LikeN;
    private FinderPath _finderPathWithPaginationCountByC_P_LikeN;
    private static final String _FINDER_COLUMN_C_P_LIKEN_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2 = "organization.parentOrganizationId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_LIKEN_NAME_2 = "lower(organization.name) LIKE ?";
    private static final String _FINDER_COLUMN_C_P_LIKEN_NAME_3 = "(organization.name IS NULL OR organization.name LIKE '')";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "organization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "organization.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(organization.externalReferenceCode IS NULL OR organization.externalReferenceCode = '')";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @BeanReference(type=GroupPersistence.class)
    protected GroupPersistence groupPersistence;
    protected TableMapper<Organization, Group> organizationToGroupTableMapper;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    protected TableMapper<Organization, User> organizationToUserTableMapper;
    private static final String _SQL_SELECT_ORGANIZATION = "SELECT organization FROM Organization organization";
    private static final String _SQL_SELECT_ORGANIZATION_WHERE = "SELECT organization FROM Organization organization WHERE ";
    private static final String _SQL_COUNT_ORGANIZATION = "SELECT COUNT(organization) FROM Organization organization";
    private static final String _SQL_COUNT_ORGANIZATION_WHERE = "SELECT COUNT(organization) FROM Organization organization WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "organization.organizationId";
    private static final String _FILTER_SQL_SELECT_ORGANIZATION_WHERE = "SELECT DISTINCT {organization.*} FROM Organization_ organization WHERE ";
    private static final String _FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {Organization_.*} FROM (SELECT DISTINCT organization.organizationId FROM Organization_ organization WHERE ";
    private static final String _FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN Organization_ ON TEMP_TABLE.organizationId = Organization_.organizationId";
    private static final String _FILTER_SQL_COUNT_ORGANIZATION_WHERE = "SELECT COUNT(DISTINCT organization.organizationId) AS COUNT_VALUE FROM Organization_ organization WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "organization";
    private static final String _FILTER_ENTITY_TABLE = "Organization_";
    private static final String _ORDER_BY_ENTITY_ALIAS = "organization.";
    private static final String _ORDER_BY_ENTITY_TABLE = "Organization_.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Organization exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Organization exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OrganizationPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"uuid", "type", "groups"});

    @Override
    public List<Organization> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<Organization> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    @Override
    public List<Organization> findByUuid(String uuid, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByUuid(String uuid, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (uuid.equals(organization.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByUuid_First(String uuid, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByUuid_First(uuid, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByUuid_First(String uuid, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByUuid_Last(String uuid, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByUuid_Last(uuid, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByUuid_Last(String uuid, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByUuid_PrevAndNext(long organizationId, String uuid, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        uuid = Objects.toString(uuid, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByUuid_PrevAndNext(session, organization, uuid, orderByComparator, true), organization, this.getByUuid_PrevAndNext(session, organization, uuid, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByUuid_PrevAndNext(Session session, Organization organization, String uuid, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByUuid(String uuid) {
        return this.filterFindByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByUuid(String uuid, int start, int end) {
        return this.filterFindByUuid(uuid, start, end, null);
    }

    @Override
    public List<Organization> filterFindByUuid(String uuid, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUuid(uuid, start, end, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3_SQL);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2_SQL);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            if (bindUuid) {
                qPos.add(uuid);
            }
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByUuid_PrevAndNext(long organizationId, String uuid, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUuid_PrevAndNext(organizationId, uuid, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByUuid_PrevAndNext(session, organization, uuid, orderByComparator, true), organization, this.filterGetByUuid_PrevAndNext(session, organization, uuid, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByUuid_PrevAndNext(Session session, Organization organization, String uuid, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3_SQL);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2_SQL);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid(String uuid) {
        for (Organization organization : this.findByUuid(uuid, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByUuid(String uuid) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByUuid(uuid);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3_SQL);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2_SQL);
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            if (bindUuid) {
                qPos.add(uuid);
            }
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<Organization> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<Organization> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (uuid.equals(organization.getUuid()) && companyId == organization.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("organization.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByUuid_C_First(String uuid, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByUuid_C_PrevAndNext(long organizationId, String uuid, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        uuid = Objects.toString(uuid, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByUuid_C_PrevAndNext(session, organization, uuid, companyId, orderByComparator, true), organization, this.getByUuid_C_PrevAndNext(session, organization, uuid, companyId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByUuid_C_PrevAndNext(Session session, Organization organization, String uuid, long companyId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        query.append("organization.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByUuid_C(String uuid, long companyId) {
        return this.filterFindByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByUuid_C(String uuid, long companyId, int start, int end) {
        return this.filterFindByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<Organization> filterFindByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByUuid_C(uuid, companyId, start, end, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3_SQL);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2_SQL);
        }
        query.append("organization.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            if (bindUuid) {
                qPos.add(uuid);
            }
            qPos.add(companyId);
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByUuid_C_PrevAndNext(long organizationId, String uuid, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByUuid_C_PrevAndNext(organizationId, uuid, companyId, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByUuid_C_PrevAndNext(session, organization, uuid, companyId, orderByComparator, true), organization, this.filterGetByUuid_C_PrevAndNext(session, organization, uuid, companyId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByUuid_C_PrevAndNext(Session session, Organization organization, String uuid, long companyId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3_SQL);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2_SQL);
        }
        query.append("organization.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid_C(String uuid, long companyId) {
        for (Organization organization : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("organization.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByUuid_C(String uuid, long companyId) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByUuid_C(uuid, companyId);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3_SQL);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2_SQL);
        }
        query.append("organization.companyId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            if (bindUuid) {
                qPos.add(uuid);
            }
            qPos.add(companyId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    @Override
    public List<Organization> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    @Override
    public List<Organization> findByCompanyId(long companyId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByCompanyId(long companyId, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (companyId == organization.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByCompanyId_First(long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByCompanyId_First(long companyId, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByCompanyId_Last(long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByCompanyId_Last(long companyId, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByCompanyId_PrevAndNext(long organizationId, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByCompanyId_PrevAndNext(session, organization, companyId, orderByComparator, true), organization, this.getByCompanyId_PrevAndNext(session, organization, companyId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByCompanyId_PrevAndNext(Session session, Organization organization, long companyId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    @Override
    public List<Organization> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByCompanyId_PrevAndNext(long organizationId, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByCompanyId_PrevAndNext(organizationId, companyId, orderByComparator);
        }
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByCompanyId_PrevAndNext(session, organization, companyId, orderByComparator, true), organization, this.filterGetByCompanyId_PrevAndNext(session, organization, companyId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByCompanyId_PrevAndNext(Session session, Organization organization, long companyId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByCompanyId(long companyId) {
        for (Organization organization : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByLocations(long companyId) {
        return this.findByLocations(companyId, -1, -1, null);
    }

    @Override
    public List<Organization> findByLocations(long companyId, int start, int end) {
        return this.findByLocations(companyId, start, end, null);
    }

    @Override
    public List<Organization> findByLocations(long companyId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByLocations(companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByLocations(long companyId, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByLocations;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByLocations;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (companyId == organization.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append(_FINDER_COLUMN_LOCATIONS_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByLocations_First(long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByLocations_First(companyId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByLocations_First(long companyId, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByLocations(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByLocations_Last(long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByLocations_Last(companyId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByLocations_Last(long companyId, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByLocations(companyId);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByLocations(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByLocations_PrevAndNext(long organizationId, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByLocations_PrevAndNext(session, organization, companyId, orderByComparator, true), organization, this.getByLocations_PrevAndNext(session, organization, companyId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByLocations_PrevAndNext(Session session, Organization organization, long companyId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        query.append(_FINDER_COLUMN_LOCATIONS_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByLocations(long companyId) {
        return this.filterFindByLocations(companyId, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByLocations(long companyId, int start, int end) {
        return this.filterFindByLocations(companyId, start, end, null);
    }

    @Override
    public List<Organization> filterFindByLocations(long companyId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByLocations(companyId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_LOCATIONS_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByLocations_PrevAndNext(long organizationId, long companyId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByLocations_PrevAndNext(organizationId, companyId, orderByComparator);
        }
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByLocations_PrevAndNext(session, organization, companyId, orderByComparator, true), organization, this.filterGetByLocations_PrevAndNext(session, organization, companyId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByLocations_PrevAndNext(Session session, Organization organization, long companyId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_LOCATIONS_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByLocations(long companyId) {
        for (Organization organization : this.findByLocations(companyId, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByLocations(long companyId) {
        FinderPath finderPath = this._finderPathCountByLocations;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append(_FINDER_COLUMN_LOCATIONS_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByLocations(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByLocations(companyId);
        }
        StringBundler query = new StringBundler(2);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append(_FINDER_COLUMN_LOCATIONS_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByC_P(long companyId, long parentOrganizationId) {
        return this.findByC_P(companyId, parentOrganizationId, -1, -1, null);
    }

    @Override
    public List<Organization> findByC_P(long companyId, long parentOrganizationId, int start, int end) {
        return this.findByC_P(companyId, parentOrganizationId, start, end, null);
    }

    @Override
    public List<Organization> findByC_P(long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByC_P(companyId, parentOrganizationId, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByC_P(long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_P;
            finderArgs = new Object[]{companyId, parentOrganizationId};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_P;
            finderArgs = new Object[]{companyId, parentOrganizationId, start, end, orderByComparator};
        }
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (companyId == organization.getCompanyId() && parentOrganizationId == organization.getParentOrganizationId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            query.append("organization.parentOrganizationId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByC_P_First(long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_P_First(companyId, parentOrganizationId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", parentOrganizationId=");
        msg.append(parentOrganizationId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_P_First(long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByC_P(companyId, parentOrganizationId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByC_P_Last(long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_P_Last(companyId, parentOrganizationId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", parentOrganizationId=");
        msg.append(parentOrganizationId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_P_Last(long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByC_P(companyId, parentOrganizationId);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByC_P(companyId, parentOrganizationId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByC_P_PrevAndNext(long organizationId, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByC_P_PrevAndNext(session, organization, companyId, parentOrganizationId, orderByComparator, true), organization, this.getByC_P_PrevAndNext(session, organization, companyId, parentOrganizationId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByC_P_PrevAndNext(Session session, Organization organization, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        query.append("organization.parentOrganizationId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(parentOrganizationId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByC_P(long companyId, long parentOrganizationId) {
        return this.filterFindByC_P(companyId, parentOrganizationId, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByC_P(long companyId, long parentOrganizationId, int start, int end) {
        return this.filterFindByC_P(companyId, parentOrganizationId, start, end, null);
    }

    @Override
    public List<Organization> filterFindByC_P(long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_P(companyId, parentOrganizationId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        query.append("organization.parentOrganizationId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByC_P_PrevAndNext(long organizationId, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_P_PrevAndNext(organizationId, companyId, parentOrganizationId, orderByComparator);
        }
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByC_P_PrevAndNext(session, organization, companyId, parentOrganizationId, orderByComparator, true), organization, this.filterGetByC_P_PrevAndNext(session, organization, companyId, parentOrganizationId, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByC_P_PrevAndNext(Session session, Organization organization, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        query.append("organization.parentOrganizationId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(parentOrganizationId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_P(long companyId, long parentOrganizationId) {
        for (Organization organization : this.findByC_P(companyId, parentOrganizationId, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByC_P(long companyId, long parentOrganizationId) {
        FinderPath finderPath = this._finderPathCountByC_P;
        Object[] finderArgs = new Object[]{companyId, parentOrganizationId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            query.append("organization.parentOrganizationId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByC_P(long companyId, long parentOrganizationId) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByC_P(companyId, parentOrganizationId);
        }
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        query.append("organization.parentOrganizationId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByC_T(long companyId, String treePath) {
        return this.findByC_T(companyId, treePath, -1, -1, null);
    }

    @Override
    public List<Organization> findByC_T(long companyId, String treePath, int start, int end) {
        return this.findByC_T(companyId, treePath, start, end, null);
    }

    @Override
    public List<Organization> findByC_T(long companyId, String treePath, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByC_T(companyId, treePath, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByC_T(long companyId, String treePath, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        treePath = Objects.toString(treePath, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_T;
        finderArgs = new Object[]{companyId, treePath, start, end, orderByComparator};
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (companyId == organization.getCompanyId() && StringUtil.wildcardMatches(organization.getTreePath(), treePath, '_', '%', '\\', true)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindTreePath = false;
            if (treePath.isEmpty()) {
                query.append(_FINDER_COLUMN_C_T_TREEPATH_3);
            } else {
                bindTreePath = true;
                query.append(_FINDER_COLUMN_C_T_TREEPATH_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindTreePath) {
                    qPos.add(treePath);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByC_T_First(long companyId, String treePath, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_T_First(companyId, treePath, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", treePath=");
        msg.append(treePath);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_T_First(long companyId, String treePath, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByC_T(companyId, treePath, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByC_T_Last(long companyId, String treePath, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_T_Last(companyId, treePath, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", treePath=");
        msg.append(treePath);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_T_Last(long companyId, String treePath, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByC_T(companyId, treePath);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByC_T(companyId, treePath, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByC_T_PrevAndNext(long organizationId, long companyId, String treePath, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        treePath = Objects.toString(treePath, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByC_T_PrevAndNext(session, organization, companyId, treePath, orderByComparator, true), organization, this.getByC_T_PrevAndNext(session, organization, companyId, treePath, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByC_T_PrevAndNext(Session session, Organization organization, long companyId, String treePath, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        boolean bindTreePath = false;
        if (treePath.isEmpty()) {
            query.append(_FINDER_COLUMN_C_T_TREEPATH_3);
        } else {
            bindTreePath = true;
            query.append(_FINDER_COLUMN_C_T_TREEPATH_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (bindTreePath) {
            qPos.add(treePath);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByC_T(long companyId, String treePath) {
        return this.filterFindByC_T(companyId, treePath, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByC_T(long companyId, String treePath, int start, int end) {
        return this.filterFindByC_T(companyId, treePath, start, end, null);
    }

    @Override
    public List<Organization> filterFindByC_T(long companyId, String treePath, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_T(companyId, treePath, start, end, orderByComparator);
        }
        treePath = Objects.toString(treePath, "");
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        boolean bindTreePath = false;
        if (treePath.isEmpty()) {
            query.append(_FINDER_COLUMN_C_T_TREEPATH_3);
        } else {
            bindTreePath = true;
            query.append(_FINDER_COLUMN_C_T_TREEPATH_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            if (bindTreePath) {
                qPos.add(treePath);
            }
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByC_T_PrevAndNext(long organizationId, long companyId, String treePath, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_T_PrevAndNext(organizationId, companyId, treePath, orderByComparator);
        }
        treePath = Objects.toString(treePath, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByC_T_PrevAndNext(session, organization, companyId, treePath, orderByComparator, true), organization, this.filterGetByC_T_PrevAndNext(session, organization, companyId, treePath, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByC_T_PrevAndNext(Session session, Organization organization, long companyId, String treePath, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        boolean bindTreePath = false;
        if (treePath.isEmpty()) {
            query.append(_FINDER_COLUMN_C_T_TREEPATH_3);
        } else {
            bindTreePath = true;
            query.append(_FINDER_COLUMN_C_T_TREEPATH_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (bindTreePath) {
            qPos.add(treePath);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_T(long companyId, String treePath) {
        for (Organization organization : this.findByC_T(companyId, treePath, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByC_T(long companyId, String treePath) {
        treePath = Objects.toString(treePath, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_T;
        Object[] finderArgs = new Object[]{companyId, treePath};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindTreePath = false;
            if (treePath.isEmpty()) {
                query.append(_FINDER_COLUMN_C_T_TREEPATH_3);
            } else {
                bindTreePath = true;
                query.append(_FINDER_COLUMN_C_T_TREEPATH_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindTreePath) {
                    qPos.add(treePath);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByC_T(long companyId, String treePath) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByC_T(companyId, treePath);
        }
        treePath = Objects.toString(treePath, "");
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        boolean bindTreePath = false;
        if (treePath.isEmpty()) {
            query.append(_FINDER_COLUMN_C_T_TREEPATH_3);
        } else {
            bindTreePath = true;
            query.append(_FINDER_COLUMN_C_T_TREEPATH_2);
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            if (bindTreePath) {
                qPos.add(treePath);
            }
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization findByC_N(long companyId, String name) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_N(companyId, name);
        if (organization == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchOrganizationException(msg.toString());
        }
        return organization;
    }

    @Override
    public Organization fetchByC_N(long companyId, String name) {
        return this.fetchByC_N(companyId, name, true);
    }

    @Override
    public Organization fetchByC_N(long companyId, String name, boolean retrieveFromCache) {
        Organization organization;
        name = Objects.toString(name, "");
        Object[] finderArgs = new Object[]{companyId, name};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_N, finderArgs, this);
        }
        if (result instanceof Organization && (companyId != (organization = (Organization)result).getCompanyId() || !Objects.equals(name, organization.getName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_C_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_C_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindName) {
                    qPos.add(name);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_N, finderArgs, list);
                } else {
                    Organization organization2 = (Organization)list.get(0);
                    result = organization2;
                    this.cacheResult(organization2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_N, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Organization)result;
    }

    @Override
    public Organization removeByC_N(long companyId, String name) throws NoSuchOrganizationException {
        Organization organization = this.findByC_N(companyId, name);
        return this.remove(organization);
    }

    @Override
    public int countByC_N(long companyId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathCountByC_N;
        Object[] finderArgs = new Object[]{companyId, name};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_C_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_C_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Organization> findByC_LikeN(long companyId, String name) {
        return this.findByC_LikeN(companyId, name, -1, -1, null);
    }

    @Override
    public List<Organization> findByC_LikeN(long companyId, String name, int start, int end) {
        return this.findByC_LikeN(companyId, name, start, end, null);
    }

    @Override
    public List<Organization> findByC_LikeN(long companyId, String name, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByC_LikeN(companyId, name, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByC_LikeN(long companyId, String name, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        name = Objects.toString(name, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_LikeN;
        finderArgs = new Object[]{companyId, name, start, end, orderByComparator};
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (companyId == organization.getCompanyId() && StringUtil.wildcardMatches(organization.getName(), name, '_', '%', '\\', false)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append("(organization.name IS NULL OR organization.name LIKE '')");
            } else {
                bindName = true;
                query.append("lower(organization.name) LIKE ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindName) {
                    qPos.add(StringUtil.toLowerCase(name));
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByC_LikeN_First(long companyId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_LikeN_First(companyId, name, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_LikeN_First(long companyId, String name, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByC_LikeN(companyId, name, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByC_LikeN_Last(long companyId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_LikeN_Last(companyId, name, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_LikeN_Last(long companyId, String name, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByC_LikeN(companyId, name);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByC_LikeN(companyId, name, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByC_LikeN_PrevAndNext(long organizationId, long companyId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        name = Objects.toString(name, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByC_LikeN_PrevAndNext(session, organization, companyId, name, orderByComparator, true), organization, this.getByC_LikeN_PrevAndNext(session, organization, companyId, name, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByC_LikeN_PrevAndNext(Session session, Organization organization, long companyId, String name, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (bindName) {
            qPos.add(StringUtil.toLowerCase(name));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByC_LikeN(long companyId, String name) {
        return this.filterFindByC_LikeN(companyId, name, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByC_LikeN(long companyId, String name, int start, int end) {
        return this.filterFindByC_LikeN(companyId, name, start, end, null);
    }

    @Override
    public List<Organization> filterFindByC_LikeN(long companyId, String name, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_LikeN(companyId, name, start, end, orderByComparator);
        }
        name = Objects.toString(name, "");
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            if (bindName) {
                qPos.add(StringUtil.toLowerCase(name));
            }
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByC_LikeN_PrevAndNext(long organizationId, long companyId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_LikeN_PrevAndNext(organizationId, companyId, name, orderByComparator);
        }
        name = Objects.toString(name, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByC_LikeN_PrevAndNext(session, organization, companyId, name, orderByComparator, true), organization, this.filterGetByC_LikeN_PrevAndNext(session, organization, companyId, name, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByC_LikeN_PrevAndNext(Session session, Organization organization, long companyId, String name, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (bindName) {
            qPos.add(StringUtil.toLowerCase(name));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_LikeN(long companyId, String name) {
        for (Organization organization : this.findByC_LikeN(companyId, name, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByC_LikeN(long companyId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_LikeN;
        Object[] finderArgs = new Object[]{companyId, name};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append("(organization.name IS NULL OR organization.name LIKE '')");
            } else {
                bindName = true;
                query.append("lower(organization.name) LIKE ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindName) {
                    qPos.add(StringUtil.toLowerCase(name));
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByC_LikeN(long companyId, String name) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByC_LikeN(companyId, name);
        }
        name = Objects.toString(name, "");
        StringBundler query = new StringBundler(3);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            if (bindName) {
                qPos.add(StringUtil.toLowerCase(name));
            }
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByO_C_P(long organizationId, long companyId, long parentOrganizationId) {
        return this.findByO_C_P(organizationId, companyId, parentOrganizationId, -1, -1, null);
    }

    @Override
    public List<Organization> findByO_C_P(long organizationId, long companyId, long parentOrganizationId, int start, int end) {
        return this.findByO_C_P(organizationId, companyId, parentOrganizationId, start, end, null);
    }

    @Override
    public List<Organization> findByO_C_P(long organizationId, long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByO_C_P(organizationId, companyId, parentOrganizationId, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByO_C_P(long organizationId, long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByO_C_P;
        finderArgs = new Object[]{organizationId, companyId, parentOrganizationId, start, end, orderByComparator};
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (organizationId < organization.getOrganizationId() && companyId == organization.getCompanyId() && parentOrganizationId == organization.getParentOrganizationId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append(_FINDER_COLUMN_O_C_P_ORGANIZATIONID_2);
            query.append("organization.companyId = ? AND ");
            query.append("organization.parentOrganizationId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(organizationId);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByO_C_P_First(long organizationId, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByO_C_P_First(organizationId, companyId, parentOrganizationId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("organizationId=");
        msg.append(organizationId);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append(", parentOrganizationId=");
        msg.append(parentOrganizationId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByO_C_P_First(long organizationId, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByO_C_P(organizationId, companyId, parentOrganizationId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByO_C_P_Last(long organizationId, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByO_C_P_Last(organizationId, companyId, parentOrganizationId, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("organizationId=");
        msg.append(organizationId);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append(", parentOrganizationId=");
        msg.append(parentOrganizationId);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByO_C_P_Last(long organizationId, long companyId, long parentOrganizationId, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByO_C_P(organizationId, companyId, parentOrganizationId);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByO_C_P(organizationId, companyId, parentOrganizationId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByO_C_P(long organizationId, long companyId, long parentOrganizationId) {
        return this.filterFindByO_C_P(organizationId, companyId, parentOrganizationId, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByO_C_P(long organizationId, long companyId, long parentOrganizationId, int start, int end) {
        return this.filterFindByO_C_P(organizationId, companyId, parentOrganizationId, start, end, null);
    }

    @Override
    public List<Organization> filterFindByO_C_P(long organizationId, long companyId, long parentOrganizationId, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByO_C_P(organizationId, companyId, parentOrganizationId, start, end, orderByComparator);
        }
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append(_FINDER_COLUMN_O_C_P_ORGANIZATIONID_2);
        query.append("organization.companyId = ? AND ");
        query.append("organization.parentOrganizationId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(organizationId);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void removeByO_C_P(long organizationId, long companyId, long parentOrganizationId) {
        for (Organization organization : this.findByO_C_P(organizationId, companyId, parentOrganizationId, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByO_C_P(long organizationId, long companyId, long parentOrganizationId) {
        FinderPath finderPath = this._finderPathWithPaginationCountByO_C_P;
        Object[] finderArgs = new Object[]{organizationId, companyId, parentOrganizationId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append(_FINDER_COLUMN_O_C_P_ORGANIZATIONID_2);
            query.append("organization.companyId = ? AND ");
            query.append("organization.parentOrganizationId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(organizationId);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByO_C_P(long organizationId, long companyId, long parentOrganizationId) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByO_C_P(organizationId, companyId, parentOrganizationId);
        }
        StringBundler query = new StringBundler(4);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append(_FINDER_COLUMN_O_C_P_ORGANIZATIONID_2);
        query.append("organization.companyId = ? AND ");
        query.append("organization.parentOrganizationId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(organizationId);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<Organization> findByC_P_LikeN(long companyId, long parentOrganizationId, String name) {
        return this.findByC_P_LikeN(companyId, parentOrganizationId, name, -1, -1, null);
    }

    @Override
    public List<Organization> findByC_P_LikeN(long companyId, long parentOrganizationId, String name, int start, int end) {
        return this.findByC_P_LikeN(companyId, parentOrganizationId, name, start, end, null);
    }

    @Override
    public List<Organization> findByC_P_LikeN(long companyId, long parentOrganizationId, String name, int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findByC_P_LikeN(companyId, parentOrganizationId, name, start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findByC_P_LikeN(long companyId, long parentOrganizationId, String name, int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        name = Objects.toString(name, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_P_LikeN;
        finderArgs = new Object[]{companyId, parentOrganizationId, name, start, end, orderByComparator};
        List<Organization> list = null;
        if (retrieveFromCache && (list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Organization organization : list) {
                if (companyId == organization.getCompanyId() && parentOrganizationId == organization.getParentOrganizationId() && StringUtil.wildcardMatches(organization.getName(), name, '_', '%', '\\', false)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            query.append(_FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append("(organization.name IS NULL OR organization.name LIKE '')");
            } else {
                bindName = true;
                query.append("lower(organization.name) LIKE ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY organization.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (bindName) {
                    qPos.add(StringUtil.toLowerCase(name));
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Organization findByC_P_LikeN_First(long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_P_LikeN_First(companyId, parentOrganizationId, name, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", parentOrganizationId=");
        msg.append(parentOrganizationId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_P_LikeN_First(long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator) {
        List<Organization> list = this.findByC_P_LikeN(companyId, parentOrganizationId, name, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization findByC_P_LikeN_Last(long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_P_LikeN_Last(companyId, parentOrganizationId, name, orderByComparator);
        if (organization != null) {
            return organization;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", parentOrganizationId=");
        msg.append(parentOrganizationId);
        msg.append(", name=");
        msg.append(name);
        msg.append("}");
        throw new NoSuchOrganizationException(msg.toString());
    }

    @Override
    public Organization fetchByC_P_LikeN_Last(long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator) {
        int count = this.countByC_P_LikeN(companyId, parentOrganizationId, name);
        if (count == 0) {
            return null;
        }
        List<Organization> list = this.findByC_P_LikeN(companyId, parentOrganizationId, name, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Organization[] findByC_P_LikeN_PrevAndNext(long organizationId, long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        name = Objects.toString(name, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.getByC_P_LikeN_PrevAndNext(session, organization, companyId, parentOrganizationId, name, orderByComparator, true), organization, this.getByC_P_LikeN_PrevAndNext(session, organization, companyId, parentOrganizationId, name, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization getByC_P_LikeN_PrevAndNext(Session session, Organization organization, long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        query.append(_FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2);
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY organization.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(parentOrganizationId);
        if (bindName) {
            qPos.add(StringUtil.toLowerCase(name));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public List<Organization> filterFindByC_P_LikeN(long companyId, long parentOrganizationId, String name) {
        return this.filterFindByC_P_LikeN(companyId, parentOrganizationId, name, -1, -1, null);
    }

    @Override
    public List<Organization> filterFindByC_P_LikeN(long companyId, long parentOrganizationId, String name, int start, int end) {
        return this.filterFindByC_P_LikeN(companyId, parentOrganizationId, name, start, end, null);
    }

    @Override
    public List<Organization> filterFindByC_P_LikeN(long companyId, long parentOrganizationId, String name, int start, int end, OrderByComparator<Organization> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_P_LikeN(companyId, parentOrganizationId, name, start, end, orderByComparator);
        }
        name = Objects.toString(name, "");
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        query.append(_FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2);
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
            } else {
                q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
            }
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            if (bindName) {
                qPos.add(StringUtil.toLowerCase(name));
            }
            List<Organization> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization[] filterFindByC_P_LikeN_PrevAndNext(long organizationId, long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator) throws NoSuchOrganizationException {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.findByC_P_LikeN_PrevAndNext(organizationId, companyId, parentOrganizationId, name, orderByComparator);
        }
        name = Objects.toString(name, "");
        Organization organization = this.findByPrimaryKey(organizationId);
        Session session = null;
        try {
            session = this.openSession();
            Organization[] array = new OrganizationImpl[]{this.filterGetByC_P_LikeN_PrevAndNext(session, organization, companyId, parentOrganizationId, name, orderByComparator, true), organization, this.filterGetByC_P_LikeN_PrevAndNext(session, organization, companyId, parentOrganizationId, name, orderByComparator, false)};
            Organization[] organizationArray = array;
            return organizationArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Organization filterGetByC_P_LikeN_PrevAndNext(Session session, Organization organization, long companyId, long parentOrganizationId, String name, OrderByComparator<Organization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        if (this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_WHERE);
        } else {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        query.append("organization.companyId = ? AND ");
        query.append(_FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2);
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            query.append(_FILTER_SQL_SELECT_ORGANIZATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    query.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            query.append(" ORDER BY organization.name ASC");
        } else {
            query.append(" ORDER BY Organization_.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            q.addEntity(_FILTER_ENTITY_ALIAS, OrganizationImpl.class);
        } else {
            q.addEntity(_FILTER_ENTITY_TABLE, OrganizationImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(parentOrganizationId);
        if (bindName) {
            qPos.add(StringUtil.toLowerCase(name));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(organization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Organization)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_P_LikeN(long companyId, long parentOrganizationId, String name) {
        for (Organization organization : this.findByC_P_LikeN(companyId, parentOrganizationId, name, -1, -1, null)) {
            this.remove(organization);
        }
    }

    @Override
    public int countByC_P_LikeN(long companyId, long parentOrganizationId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_P_LikeN;
        Object[] finderArgs = new Object[]{companyId, parentOrganizationId, name};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            query.append(_FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append("(organization.name IS NULL OR organization.name LIKE '')");
            } else {
                bindName = true;
                query.append("lower(organization.name) LIKE ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(parentOrganizationId);
                if (bindName) {
                    qPos.add(StringUtil.toLowerCase(name));
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public int filterCountByC_P_LikeN(long companyId, long parentOrganizationId, String name) {
        if (!InlineSQLHelperUtil.isEnabled(companyId, 0L)) {
            return this.countByC_P_LikeN(companyId, parentOrganizationId, name);
        }
        name = Objects.toString(name, "");
        StringBundler query = new StringBundler(4);
        query.append(_FILTER_SQL_COUNT_ORGANIZATION_WHERE);
        query.append("organization.companyId = ? AND ");
        query.append(_FINDER_COLUMN_C_P_LIKEN_PARENTORGANIZATIONID_2);
        boolean bindName = false;
        if (name.isEmpty()) {
            query.append("(organization.name IS NULL OR organization.name LIKE '')");
        } else {
            bindName = true;
            query.append("lower(organization.name) LIKE ?");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck(query.toString(), Organization.class.getName(), _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(companyId);
            qPos.add(parentOrganizationId);
            if (bindName) {
                qPos.add(StringUtil.toLowerCase(name));
            }
            Long count = (Long)q.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public Organization findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrganizationException {
        Organization organization = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (organization == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append(", externalReferenceCode=");
            msg.append(externalReferenceCode);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchOrganizationException(msg.toString());
        }
        return organization;
    }

    @Override
    public Organization fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    @Override
    public Organization fetchByC_ERC(long companyId, String externalReferenceCode, boolean retrieveFromCache) {
        Organization organization;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_ERC, finderArgs, this);
        }
        if (result instanceof Organization && (companyId != (organization = (Organization)result).getCompanyId() || !Objects.equals(externalReferenceCode, organization.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindExternalReferenceCode) {
                    qPos.add(externalReferenceCode);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_ERC, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("OrganizationPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    Organization organization2 = (Organization)list.get(0);
                    result = organization2;
                    this.cacheResult(organization2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_ERC, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Organization)result;
    }

    @Override
    public Organization removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrganizationException {
        Organization organization = this.findByC_ERC(companyId, externalReferenceCode);
        return this.remove(organization);
    }

    @Override
    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ORGANIZATION_WHERE);
            query.append("organization.companyId = ? AND ");
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                query.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (bindExternalReferenceCode) {
                    qPos.add(externalReferenceCode);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OrganizationPersistenceImpl() {
        this.setModelClass(Organization.class);
        this.setModelImplClass(OrganizationImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(OrganizationModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("groups", "groups_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Organization organization) {
        EntityCacheUtil.putResult(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationImpl.class, Long.valueOf(organization.getPrimaryKey()), organization);
        FinderCacheUtil.putResult(this._finderPathFetchByC_N, new Object[]{organization.getCompanyId(), organization.getName()}, organization);
        FinderCacheUtil.putResult(this._finderPathFetchByC_ERC, new Object[]{organization.getCompanyId(), organization.getExternalReferenceCode()}, organization);
        organization.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Organization> organizations) {
        for (Organization organization : organizations) {
            if (EntityCacheUtil.getResult(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationImpl.class, Long.valueOf(organization.getPrimaryKey())) == null) {
                this.cacheResult(organization);
                continue;
            }
            organization.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(OrganizationImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Organization organization) {
        EntityCacheUtil.removeResult(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationImpl.class, Long.valueOf(organization.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((OrganizationModelImpl)((Object)organization), true);
    }

    @Override
    public void clearCache(List<Organization> organizations) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Organization organization : organizations) {
            EntityCacheUtil.removeResult(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationImpl.class, Long.valueOf(organization.getPrimaryKey()));
            this.clearUniqueFindersCache((OrganizationModelImpl)((Object)organization), true);
        }
    }

    protected void cacheUniqueFindersCache(OrganizationModelImpl organizationModelImpl) {
        Object[] args = new Object[]{organizationModelImpl.getCompanyId(), organizationModelImpl.getName()};
        FinderCacheUtil.putResult(this._finderPathCountByC_N, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_N, args, organizationModelImpl, false);
        args = new Object[]{organizationModelImpl.getCompanyId(), organizationModelImpl.getExternalReferenceCode()};
        FinderCacheUtil.putResult(this._finderPathCountByC_ERC, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_ERC, args, organizationModelImpl, false);
    }

    protected void clearUniqueFindersCache(OrganizationModelImpl organizationModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{organizationModelImpl.getCompanyId(), organizationModelImpl.getName()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_N, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_N, args);
        }
        if ((organizationModelImpl.getColumnBitmask() & this._finderPathFetchByC_N.getColumnBitmask()) != 0L) {
            args = new Object[]{organizationModelImpl.getOriginalCompanyId(), organizationModelImpl.getOriginalName()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_N, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_N, args);
        }
        if (clearCurrent) {
            args = new Object[]{organizationModelImpl.getCompanyId(), organizationModelImpl.getExternalReferenceCode()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_ERC, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_ERC, args);
        }
        if ((organizationModelImpl.getColumnBitmask() & this._finderPathFetchByC_ERC.getColumnBitmask()) != 0L) {
            args = new Object[]{organizationModelImpl.getOriginalCompanyId(), organizationModelImpl.getOriginalExternalReferenceCode()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_ERC, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_ERC, args);
        }
    }

    @Override
    public Organization create(long organizationId) {
        OrganizationImpl organization = new OrganizationImpl();
        organization.setNew(true);
        organization.setPrimaryKey(organizationId);
        String uuid = PortalUUIDUtil.generate();
        organization.setUuid(uuid);
        organization.setCompanyId(this.companyProvider.getCompanyId());
        return organization;
    }

    @Override
    public Organization remove(long organizationId) throws NoSuchOrganizationException {
        return this.remove(Long.valueOf(organizationId));
    }

    @Override
    public Organization remove(Serializable primaryKey) throws NoSuchOrganizationException {
        Session session = null;
        try {
            session = this.openSession();
            Organization organization = (Organization)session.get(OrganizationImpl.class, primaryKey);
            if (organization == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchOrganizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Organization organization2 = this.remove(organization);
            return organization2;
        }
        catch (NoSuchOrganizationException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Organization removeImpl(Organization organization) {
        this.organizationToGroupTableMapper.deleteLeftPrimaryKeyTableMappings(organization.getPrimaryKey());
        this.organizationToUserTableMapper.deleteLeftPrimaryKeyTableMappings(organization.getPrimaryKey());
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(organization)) {
                organization = (Organization)session.get(OrganizationImpl.class, organization.getPrimaryKeyObj());
            }
            if (organization != null) {
                session.delete(organization);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (organization != null) {
            this.clearCache(organization);
        }
        return organization;
    }

    @Override
    public Organization updateImpl(Organization organization) {
        boolean isNew = organization.isNew();
        if (!(organization instanceof OrganizationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(organization.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(organization);
                throw new IllegalArgumentException("Implement ModelWrapper in organization proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Organization implementation " + organization.getClass());
        }
        OrganizationModelImpl organizationModelImpl = (OrganizationModelImpl)((Object)organization);
        if (Validator.isNull(organization.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            organization.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && organization.getCreateDate() == null) {
            if (serviceContext == null) {
                organization.setCreateDate(now);
            } else {
                organization.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!organizationModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                organization.setModifiedDate(now);
            } else {
                organization.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (organization.isNew()) {
                session.save(organization);
                organization.setNew(false);
            } else {
                organization = (Organization)session.merge(organization);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!OrganizationModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{organizationModelImpl.getUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{organizationModelImpl.getUuid(), organizationModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{organizationModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{organizationModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByLocations, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByLocations, args);
            args = new Object[]{organizationModelImpl.getCompanyId(), organizationModelImpl.getParentOrganizationId()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_P, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_P, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((organizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{organizationModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{organizationModelImpl.getUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((organizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{organizationModelImpl.getOriginalUuid(), organizationModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{organizationModelImpl.getUuid(), organizationModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((organizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{organizationModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{organizationModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((organizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByLocations.getColumnBitmask()) != 0L) {
                args = new Object[]{organizationModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByLocations, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByLocations, args);
                args = new Object[]{organizationModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByLocations, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByLocations, args);
            }
            if ((organizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_P.getColumnBitmask()) != 0L) {
                args = new Object[]{organizationModelImpl.getOriginalCompanyId(), organizationModelImpl.getOriginalParentOrganizationId()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_P, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_P, args);
                args = new Object[]{organizationModelImpl.getCompanyId(), organizationModelImpl.getParentOrganizationId()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_P, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_P, args);
            }
        }
        EntityCacheUtil.putResult(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationImpl.class, Long.valueOf(organization.getPrimaryKey()), organization, false);
        this.clearUniqueFindersCache(organizationModelImpl, false);
        this.cacheUniqueFindersCache(organizationModelImpl);
        organization.resetOriginalValues();
        return organization;
    }

    @Override
    public Organization findByPrimaryKey(Serializable primaryKey) throws NoSuchOrganizationException {
        Organization organization = (Organization)this.fetchByPrimaryKey(primaryKey);
        if (organization == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchOrganizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return organization;
    }

    @Override
    public Organization findByPrimaryKey(long organizationId) throws NoSuchOrganizationException {
        return this.findByPrimaryKey(Long.valueOf(organizationId));
    }

    @Override
    public Organization fetchByPrimaryKey(long organizationId) {
        return (Organization)this.fetchByPrimaryKey(Long.valueOf(organizationId));
    }

    @Override
    public List<Organization> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Organization> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Organization> findAll(int start, int end, OrderByComparator<Organization> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Organization> findAll(int start, int end, OrderByComparator<Organization> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Organization> list = null;
        if (retrieveFromCache) {
            list = (List<Organization>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ORGANIZATION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ORGANIZATION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY organization.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Organization organization : this.findAll()) {
            this.remove(organization);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ORGANIZATION);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public long[] getGroupPrimaryKeys(long pk) {
        long[] pks = this.organizationToGroupTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    @Override
    public List<Group> getGroups(long pk) {
        return this.getGroups(pk, -1, -1);
    }

    @Override
    public List<Group> getGroups(long pk, int start, int end) {
        return this.getGroups(pk, start, end, null);
    }

    @Override
    public List<Group> getGroups(long pk, int start, int end, OrderByComparator<Group> orderByComparator) {
        return this.organizationToGroupTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    @Override
    public int getGroupsSize(long pk) {
        long[] pks = this.organizationToGroupTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    @Override
    public boolean containsGroup(long pk, long groupPK) {
        return this.organizationToGroupTableMapper.containsTableMapping(pk, groupPK);
    }

    @Override
    public boolean containsGroups(long pk) {
        return this.getGroupsSize(pk) > 0;
    }

    @Override
    public void addGroup(long pk, long groupPK) {
        Organization organization = this.fetchByPrimaryKey(pk);
        if (organization == null) {
            this.organizationToGroupTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, groupPK);
        } else {
            this.organizationToGroupTableMapper.addTableMapping(organization.getCompanyId(), pk, groupPK);
        }
    }

    @Override
    public void addGroup(long pk, Group group) {
        Organization organization = this.fetchByPrimaryKey(pk);
        if (organization == null) {
            this.organizationToGroupTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, group.getPrimaryKey());
        } else {
            this.organizationToGroupTableMapper.addTableMapping(organization.getCompanyId(), pk, group.getPrimaryKey());
        }
    }

    @Override
    public void addGroups(long pk, long[] groupPKs) {
        long companyId = 0L;
        Organization organization = this.fetchByPrimaryKey(pk);
        companyId = organization == null ? this.companyProvider.getCompanyId() : organization.getCompanyId();
        this.organizationToGroupTableMapper.addTableMappings(companyId, pk, groupPKs);
    }

    @Override
    public void addGroups(long pk, List<Group> groups) {
        this.addGroups(pk, ListUtil.toLongArray(groups, Group.GROUP_ID_ACCESSOR));
    }

    @Override
    public void clearGroups(long pk) {
        this.organizationToGroupTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    @Override
    public void removeGroup(long pk, long groupPK) {
        this.organizationToGroupTableMapper.deleteTableMapping(pk, groupPK);
    }

    @Override
    public void removeGroup(long pk, Group group) {
        this.organizationToGroupTableMapper.deleteTableMapping(pk, group.getPrimaryKey());
    }

    @Override
    public void removeGroups(long pk, long[] groupPKs) {
        this.organizationToGroupTableMapper.deleteTableMappings(pk, groupPKs);
    }

    @Override
    public void removeGroups(long pk, List<Group> groups) {
        this.removeGroups(pk, ListUtil.toLongArray(groups, Group.GROUP_ID_ACCESSOR));
    }

    @Override
    public void setGroups(long pk, long[] groupPKs) {
        Set<Long> newGroupPKsSet = SetUtil.fromArray(groupPKs);
        Set<Long> oldGroupPKsSet = SetUtil.fromArray(this.organizationToGroupTableMapper.getRightPrimaryKeys(pk));
        HashSet<Long> removeGroupPKsSet = new HashSet<Long>(oldGroupPKsSet);
        removeGroupPKsSet.removeAll(newGroupPKsSet);
        this.organizationToGroupTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeGroupPKsSet));
        newGroupPKsSet.removeAll(oldGroupPKsSet);
        long companyId = 0L;
        Organization organization = this.fetchByPrimaryKey(pk);
        companyId = organization == null ? this.companyProvider.getCompanyId() : organization.getCompanyId();
        this.organizationToGroupTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray(newGroupPKsSet));
    }

    @Override
    public void setGroups(long pk, List<Group> groups) {
        try {
            long[] groupPKs = new long[groups.size()];
            for (int i = 0; i < groups.size(); ++i) {
                Group group = groups.get(i);
                groupPKs[i] = group.getPrimaryKey();
            }
            this.setGroups(pk, groupPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public long[] getUserPrimaryKeys(long pk) {
        long[] pks = this.organizationToUserTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    @Override
    public List<User> getUsers(long pk) {
        return this.getUsers(pk, -1, -1);
    }

    @Override
    public List<User> getUsers(long pk, int start, int end) {
        return this.getUsers(pk, start, end, null);
    }

    @Override
    public List<User> getUsers(long pk, int start, int end, OrderByComparator<User> orderByComparator) {
        return this.organizationToUserTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    @Override
    public int getUsersSize(long pk) {
        long[] pks = this.organizationToUserTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    @Override
    public boolean containsUser(long pk, long userPK) {
        return this.organizationToUserTableMapper.containsTableMapping(pk, userPK);
    }

    @Override
    public boolean containsUsers(long pk) {
        return this.getUsersSize(pk) > 0;
    }

    @Override
    public void addUser(long pk, long userPK) {
        Organization organization = this.fetchByPrimaryKey(pk);
        if (organization == null) {
            this.organizationToUserTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, userPK);
        } else {
            this.organizationToUserTableMapper.addTableMapping(organization.getCompanyId(), pk, userPK);
        }
    }

    @Override
    public void addUser(long pk, User user) {
        Organization organization = this.fetchByPrimaryKey(pk);
        if (organization == null) {
            this.organizationToUserTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, user.getPrimaryKey());
        } else {
            this.organizationToUserTableMapper.addTableMapping(organization.getCompanyId(), pk, user.getPrimaryKey());
        }
    }

    @Override
    public void addUsers(long pk, long[] userPKs) {
        long companyId = 0L;
        Organization organization = this.fetchByPrimaryKey(pk);
        companyId = organization == null ? this.companyProvider.getCompanyId() : organization.getCompanyId();
        this.organizationToUserTableMapper.addTableMappings(companyId, pk, userPKs);
    }

    @Override
    public void addUsers(long pk, List<User> users) {
        this.addUsers(pk, ListUtil.toLongArray(users, User.USER_ID_ACCESSOR));
    }

    @Override
    public void clearUsers(long pk) {
        this.organizationToUserTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    @Override
    public void removeUser(long pk, long userPK) {
        this.organizationToUserTableMapper.deleteTableMapping(pk, userPK);
    }

    @Override
    public void removeUser(long pk, User user) {
        this.organizationToUserTableMapper.deleteTableMapping(pk, user.getPrimaryKey());
    }

    @Override
    public void removeUsers(long pk, long[] userPKs) {
        this.organizationToUserTableMapper.deleteTableMappings(pk, userPKs);
    }

    @Override
    public void removeUsers(long pk, List<User> users) {
        this.removeUsers(pk, ListUtil.toLongArray(users, User.USER_ID_ACCESSOR));
    }

    @Override
    public void setUsers(long pk, long[] userPKs) {
        Set<Long> newUserPKsSet = SetUtil.fromArray(userPKs);
        Set<Long> oldUserPKsSet = SetUtil.fromArray(this.organizationToUserTableMapper.getRightPrimaryKeys(pk));
        HashSet<Long> removeUserPKsSet = new HashSet<Long>(oldUserPKsSet);
        removeUserPKsSet.removeAll(newUserPKsSet);
        this.organizationToUserTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeUserPKsSet));
        newUserPKsSet.removeAll(oldUserPKsSet);
        long companyId = 0L;
        Organization organization = this.fetchByPrimaryKey(pk);
        companyId = organization == null ? this.companyProvider.getCompanyId() : organization.getCompanyId();
        this.organizationToUserTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray(newUserPKsSet));
    }

    @Override
    public void setUsers(long pk, List<User> users) {
        try {
            long[] userPKs = new long[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                User user = users.get(i);
                userPKs[i] = user.getPrimaryKey();
            }
            this.setUsers(pk, userPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "organizationId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_ORGANIZATION;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return OrganizationModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this.organizationToGroupTableMapper = TableMapperFactory.getTableMapper("Groups_Orgs", "companyId", "organizationId", "groupId", this, this.groupPersistence);
        this.organizationToUserTableMapper = TableMapperFactory.getTableMapper("Users_Orgs", "companyId", "organizationId", "userId", this, this.userPersistence);
        this._finderPathWithPaginationFindAll = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 68L);
        this._finderPathCountByUuid = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 69L);
        this._finderPathCountByUuid_C = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 5L);
        this._finderPathCountByCompanyId = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByLocations = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLocations", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByLocations = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByLocations", new String[]{Long.class.getName()}, 5L);
        this._finderPathCountByLocations = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLocations", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_P = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_P", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_P = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_P", new String[]{Long.class.getName(), Long.class.getName()}, 21L);
        this._finderPathCountByC_P = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_P", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByC_T = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_T", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_T = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_T", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathFetchByC_N = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_N", new String[]{Long.class.getName(), String.class.getName()}, 5L);
        this._finderPathCountByC_N = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_N", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByC_LikeN = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_LikeN", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_LikeN = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_LikeN", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByO_C_P = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByO_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByO_C_P = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByO_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByC_P_LikeN = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_P_LikeN", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_P_LikeN = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_P_LikeN", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
        this._finderPathFetchByC_ERC = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, OrganizationImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, 3L);
        this._finderPathCountByC_ERC = new FinderPath(OrganizationModelImpl.ENTITY_CACHE_ENABLED, OrganizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(OrganizationImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        TableMapperFactory.removeTableMapper("Groups_Orgs");
        TableMapperFactory.removeTableMapper("Users_Orgs");
    }
}

