/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchListTypeException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.service.persistence.ListTypePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.ListTypeImpl;
import com.liferay.portal.model.impl.ListTypeModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ListTypePersistenceImpl
extends BasePersistenceImpl<ListType>
implements ListTypePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ListTypeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByType;
    private FinderPath _finderPathWithoutPaginationFindByType;
    private FinderPath _finderPathCountByType;
    private static final String _FINDER_COLUMN_TYPE_TYPE_2 = "listType.type = ?";
    private static final String _FINDER_COLUMN_TYPE_TYPE_3 = "(listType.type IS NULL OR listType.type = '')";
    private FinderPath _finderPathFetchByN_T;
    private FinderPath _finderPathCountByN_T;
    private static final String _FINDER_COLUMN_N_T_NAME_2 = "listType.name = ? AND ";
    private static final String _FINDER_COLUMN_N_T_NAME_3 = "(listType.name IS NULL OR listType.name = '') AND ";
    private static final String _FINDER_COLUMN_N_T_TYPE_2 = "listType.type = ?";
    private static final String _FINDER_COLUMN_N_T_TYPE_3 = "(listType.type IS NULL OR listType.type = '')";
    private static final String _SQL_SELECT_LISTTYPE = "SELECT listType FROM ListType listType";
    private static final String _SQL_SELECT_LISTTYPE_WHERE = "SELECT listType FROM ListType listType WHERE ";
    private static final String _SQL_COUNT_LISTTYPE = "SELECT COUNT(listType) FROM ListType listType";
    private static final String _SQL_COUNT_LISTTYPE_WHERE = "SELECT COUNT(listType) FROM ListType listType WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "listType.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ListType exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ListType exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ListTypePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"type"});

    @Override
    public List<ListType> findByType(String type) {
        return this.findByType(type, -1, -1, null);
    }

    @Override
    public List<ListType> findByType(String type, int start, int end) {
        return this.findByType(type, start, end, null);
    }

    @Override
    public List<ListType> findByType(String type, int start, int end, OrderByComparator<ListType> orderByComparator) {
        return this.findByType(type, start, end, orderByComparator, true);
    }

    @Override
    public List<ListType> findByType(String type, int start, int end, OrderByComparator<ListType> orderByComparator, boolean retrieveFromCache) {
        type = Objects.toString(type, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByType;
            finderArgs = new Object[]{type};
        } else {
            finderPath = this._finderPathWithPaginationFindByType;
            finderArgs = new Object[]{type, start, end, orderByComparator};
        }
        List<ListType> list = null;
        if (retrieveFromCache && (list = (List<ListType>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (ListType listType : list) {
                if (type.equals(listType.getType())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_LISTTYPE_WHERE);
            boolean bindType = false;
            if (type.isEmpty()) {
                query.append("(listType.type IS NULL OR listType.type = '')");
            } else {
                bindType = true;
                query.append("listType.type = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY listType.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindType) {
                    qPos.add(type);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public ListType findByType_First(String type, OrderByComparator<ListType> orderByComparator) throws NoSuchListTypeException {
        ListType listType = this.fetchByType_First(type, orderByComparator);
        if (listType != null) {
            return listType;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("type=");
        msg.append(type);
        msg.append("}");
        throw new NoSuchListTypeException(msg.toString());
    }

    @Override
    public ListType fetchByType_First(String type, OrderByComparator<ListType> orderByComparator) {
        List<ListType> list = this.findByType(type, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ListType findByType_Last(String type, OrderByComparator<ListType> orderByComparator) throws NoSuchListTypeException {
        ListType listType = this.fetchByType_Last(type, orderByComparator);
        if (listType != null) {
            return listType;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("type=");
        msg.append(type);
        msg.append("}");
        throw new NoSuchListTypeException(msg.toString());
    }

    @Override
    public ListType fetchByType_Last(String type, OrderByComparator<ListType> orderByComparator) {
        int count = this.countByType(type);
        if (count == 0) {
            return null;
        }
        List<ListType> list = this.findByType(type, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ListType[] findByType_PrevAndNext(long listTypeId, String type, OrderByComparator<ListType> orderByComparator) throws NoSuchListTypeException {
        type = Objects.toString(type, "");
        ListType listType = this.findByPrimaryKey(listTypeId);
        Session session = null;
        try {
            session = this.openSession();
            ListType[] array = new ListTypeImpl[]{this.getByType_PrevAndNext(session, listType, type, orderByComparator, true), listType, this.getByType_PrevAndNext(session, listType, type, orderByComparator, false)};
            ListType[] listTypeArray = array;
            return listTypeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ListType getByType_PrevAndNext(Session session, ListType listType, String type, OrderByComparator<ListType> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_LISTTYPE_WHERE);
        boolean bindType = false;
        if (type.isEmpty()) {
            query.append("(listType.type IS NULL OR listType.type = '')");
        } else {
            bindType = true;
            query.append("listType.type = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY listType.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindType) {
            qPos.add(type);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(listType)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (ListType)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByType(String type) {
        for (ListType listType : this.findByType(type, -1, -1, null)) {
            this.remove(listType);
        }
    }

    @Override
    public int countByType(String type) {
        type = Objects.toString(type, "");
        FinderPath finderPath = this._finderPathCountByType;
        Object[] finderArgs = new Object[]{type};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_LISTTYPE_WHERE);
            boolean bindType = false;
            if (type.isEmpty()) {
                query.append("(listType.type IS NULL OR listType.type = '')");
            } else {
                bindType = true;
                query.append("listType.type = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindType) {
                    qPos.add(type);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public ListType findByN_T(String name, String type) throws NoSuchListTypeException {
        ListType listType = this.fetchByN_T(name, type);
        if (listType == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("name=");
            msg.append(name);
            msg.append(", type=");
            msg.append(type);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchListTypeException(msg.toString());
        }
        return listType;
    }

    @Override
    public ListType fetchByN_T(String name, String type) {
        return this.fetchByN_T(name, type, true);
    }

    @Override
    public ListType fetchByN_T(String name, String type, boolean retrieveFromCache) {
        ListType listType;
        name = Objects.toString(name, "");
        type = Objects.toString(type, "");
        Object[] finderArgs = new Object[]{name, type};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByN_T, finderArgs, this);
        }
        if (!(!(result instanceof ListType) || Objects.equals(name, (listType = (ListType)result).getName()) && Objects.equals(type, listType.getType()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_LISTTYPE_WHERE);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_N_T_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_N_T_NAME_2);
            }
            boolean bindType = false;
            if (type.isEmpty()) {
                query.append("(listType.type IS NULL OR listType.type = '')");
            } else {
                bindType = true;
                query.append("listType.type = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindType) {
                    qPos.add(type);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByN_T, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("ListTypePersistenceImpl.fetchByN_T(String, String, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    ListType listType2 = (ListType)list.get(0);
                    result = listType2;
                    this.cacheResult(listType2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByN_T, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ListType)result;
    }

    @Override
    public ListType removeByN_T(String name, String type) throws NoSuchListTypeException {
        ListType listType = this.findByN_T(name, type);
        return this.remove(listType);
    }

    @Override
    public int countByN_T(String name, String type) {
        name = Objects.toString(name, "");
        type = Objects.toString(type, "");
        FinderPath finderPath = this._finderPathCountByN_T;
        Object[] finderArgs = new Object[]{name, type};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_LISTTYPE_WHERE);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_N_T_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_N_T_NAME_2);
            }
            boolean bindType = false;
            if (type.isEmpty()) {
                query.append("(listType.type IS NULL OR listType.type = '')");
            } else {
                bindType = true;
                query.append("listType.type = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindName) {
                    qPos.add(name);
                }
                if (bindType) {
                    qPos.add(type);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ListTypePersistenceImpl() {
        this.setModelClass(ListType.class);
        this.setModelImplClass(ListTypeImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(ListTypeModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(ListType listType) {
        EntityCacheUtil.putResult(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeImpl.class, Long.valueOf(listType.getPrimaryKey()), listType);
        FinderCacheUtil.putResult(this._finderPathFetchByN_T, new Object[]{listType.getName(), listType.getType()}, listType);
        listType.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<ListType> listTypes) {
        for (ListType listType : listTypes) {
            if (EntityCacheUtil.getResult(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeImpl.class, Long.valueOf(listType.getPrimaryKey())) == null) {
                this.cacheResult(listType);
                continue;
            }
            listType.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(ListTypeImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(ListType listType) {
        EntityCacheUtil.removeResult(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeImpl.class, Long.valueOf(listType.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ListTypeModelImpl)((Object)listType), true);
    }

    @Override
    public void clearCache(List<ListType> listTypes) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ListType listType : listTypes) {
            EntityCacheUtil.removeResult(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeImpl.class, Long.valueOf(listType.getPrimaryKey()));
            this.clearUniqueFindersCache((ListTypeModelImpl)((Object)listType), true);
        }
    }

    protected void cacheUniqueFindersCache(ListTypeModelImpl listTypeModelImpl) {
        Object[] args = new Object[]{listTypeModelImpl.getName(), listTypeModelImpl.getType()};
        FinderCacheUtil.putResult(this._finderPathCountByN_T, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByN_T, args, listTypeModelImpl, false);
    }

    protected void clearUniqueFindersCache(ListTypeModelImpl listTypeModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{listTypeModelImpl.getName(), listTypeModelImpl.getType()};
            FinderCacheUtil.removeResult(this._finderPathCountByN_T, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByN_T, args);
        }
        if ((listTypeModelImpl.getColumnBitmask() & this._finderPathFetchByN_T.getColumnBitmask()) != 0L) {
            args = new Object[]{listTypeModelImpl.getOriginalName(), listTypeModelImpl.getOriginalType()};
            FinderCacheUtil.removeResult(this._finderPathCountByN_T, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByN_T, args);
        }
    }

    @Override
    public ListType create(long listTypeId) {
        ListTypeImpl listType = new ListTypeImpl();
        listType.setNew(true);
        listType.setPrimaryKey(listTypeId);
        return listType;
    }

    @Override
    public ListType remove(long listTypeId) throws NoSuchListTypeException {
        return this.remove(Long.valueOf(listTypeId));
    }

    @Override
    public ListType remove(Serializable primaryKey) throws NoSuchListTypeException {
        Session session = null;
        try {
            session = this.openSession();
            ListType listType = (ListType)session.get(ListTypeImpl.class, primaryKey);
            if (listType == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchListTypeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ListType listType2 = this.remove(listType);
            return listType2;
        }
        catch (NoSuchListTypeException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected ListType removeImpl(ListType listType) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(listType)) {
                listType = (ListType)session.get(ListTypeImpl.class, listType.getPrimaryKeyObj());
            }
            if (listType != null) {
                session.delete(listType);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (listType != null) {
            this.clearCache(listType);
        }
        return listType;
    }

    @Override
    public ListType updateImpl(ListType listType) {
        boolean isNew = listType.isNew();
        if (!(listType instanceof ListTypeModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(listType.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(listType);
                throw new IllegalArgumentException("Implement ModelWrapper in listType proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ListType implementation " + listType.getClass());
        }
        ListTypeModelImpl listTypeModelImpl = (ListTypeModelImpl)((Object)listType);
        Session session = null;
        try {
            session = this.openSession();
            if (listType.isNew()) {
                session.save(listType);
                listType.setNew(false);
            } else {
                listType = (ListType)session.merge(listType);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ListTypeModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{listTypeModelImpl.getType()};
            FinderCacheUtil.removeResult(this._finderPathCountByType, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByType, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((listTypeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByType.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{listTypeModelImpl.getOriginalType()};
            FinderCacheUtil.removeResult(this._finderPathCountByType, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByType, args);
            args = new Object[]{listTypeModelImpl.getType()};
            FinderCacheUtil.removeResult(this._finderPathCountByType, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByType, args);
        }
        EntityCacheUtil.putResult(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeImpl.class, Long.valueOf(listType.getPrimaryKey()), listType, false);
        this.clearUniqueFindersCache(listTypeModelImpl, false);
        this.cacheUniqueFindersCache(listTypeModelImpl);
        listType.resetOriginalValues();
        return listType;
    }

    @Override
    public ListType findByPrimaryKey(Serializable primaryKey) throws NoSuchListTypeException {
        ListType listType = (ListType)this.fetchByPrimaryKey(primaryKey);
        if (listType == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchListTypeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return listType;
    }

    @Override
    public ListType findByPrimaryKey(long listTypeId) throws NoSuchListTypeException {
        return this.findByPrimaryKey(Long.valueOf(listTypeId));
    }

    @Override
    public ListType fetchByPrimaryKey(long listTypeId) {
        return (ListType)this.fetchByPrimaryKey(Long.valueOf(listTypeId));
    }

    @Override
    public List<ListType> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<ListType> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<ListType> findAll(int start, int end, OrderByComparator<ListType> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<ListType> findAll(int start, int end, OrderByComparator<ListType> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<ListType> list = null;
        if (retrieveFromCache) {
            list = (List<ListType>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_LISTTYPE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_LISTTYPE;
                if (pagination) {
                    sql = sql.concat(" ORDER BY listType.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (ListType listType : this.findAll()) {
            this.remove(listType);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_LISTTYPE);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "listTypeId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_LISTTYPE;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return ListTypeModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, ListTypeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, ListTypeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByType = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, ListTypeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByType", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByType = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, ListTypeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByType", new String[]{String.class.getName()}, 3L);
        this._finderPathCountByType = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByType", new String[]{String.class.getName()});
        this._finderPathFetchByN_T = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, ListTypeImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByN_T", new String[]{String.class.getName(), String.class.getName()}, 3L);
        this._finderPathCountByN_T = new FinderPath(ListTypeModelImpl.ENTITY_CACHE_ENABLED, ListTypeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByN_T", new String[]{String.class.getName(), String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ListTypeImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

