/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.ImagePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.model.impl.ImageModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ImagePersistenceImpl
extends BasePersistenceImpl<Image>
implements ImagePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ImageImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByLtSize;
    private FinderPath _finderPathWithPaginationCountByLtSize;
    private static final String _FINDER_COLUMN_LTSIZE_SIZE_2 = "image.size < ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_IMAGE = "SELECT image FROM Image image";
    private static final String _SQL_SELECT_IMAGE_WHERE = "SELECT image FROM Image image WHERE ";
    private static final String _SQL_COUNT_IMAGE = "SELECT COUNT(image) FROM Image image";
    private static final String _SQL_COUNT_IMAGE_WHERE = "SELECT COUNT(image) FROM Image image WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "image.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Image exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Image exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ImagePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"type", "size"});

    @Override
    public List<Image> findByLtSize(int size) {
        return this.findByLtSize(size, -1, -1, null);
    }

    @Override
    public List<Image> findByLtSize(int size, int start, int end) {
        return this.findByLtSize(size, start, end, null);
    }

    @Override
    public List<Image> findByLtSize(int size, int start, int end, OrderByComparator<Image> orderByComparator) {
        return this.findByLtSize(size, start, end, orderByComparator, true);
    }

    @Override
    public List<Image> findByLtSize(int size, int start, int end, OrderByComparator<Image> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtSize;
        finderArgs = new Object[]{size, start, end, orderByComparator};
        List<Image> list = null;
        if (retrieveFromCache && (list = (List<Image>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Image image : list) {
                if (size > image.getSize()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_IMAGE_WHERE);
            query.append(_FINDER_COLUMN_LTSIZE_SIZE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY image.imageId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(size);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Image findByLtSize_First(int size, OrderByComparator<Image> orderByComparator) throws NoSuchImageException {
        Image image = this.fetchByLtSize_First(size, orderByComparator);
        if (image != null) {
            return image;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("size=");
        msg.append(size);
        msg.append("}");
        throw new NoSuchImageException(msg.toString());
    }

    @Override
    public Image fetchByLtSize_First(int size, OrderByComparator<Image> orderByComparator) {
        List<Image> list = this.findByLtSize(size, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Image findByLtSize_Last(int size, OrderByComparator<Image> orderByComparator) throws NoSuchImageException {
        Image image = this.fetchByLtSize_Last(size, orderByComparator);
        if (image != null) {
            return image;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("size=");
        msg.append(size);
        msg.append("}");
        throw new NoSuchImageException(msg.toString());
    }

    @Override
    public Image fetchByLtSize_Last(int size, OrderByComparator<Image> orderByComparator) {
        int count = this.countByLtSize(size);
        if (count == 0) {
            return null;
        }
        List<Image> list = this.findByLtSize(size, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Image[] findByLtSize_PrevAndNext(long imageId, int size, OrderByComparator<Image> orderByComparator) throws NoSuchImageException {
        Image image = this.findByPrimaryKey(imageId);
        Session session = null;
        try {
            session = this.openSession();
            Image[] array = new ImageImpl[]{this.getByLtSize_PrevAndNext(session, image, size, orderByComparator, true), image, this.getByLtSize_PrevAndNext(session, image, size, orderByComparator, false)};
            Image[] imageArray = array;
            return imageArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Image getByLtSize_PrevAndNext(Session session, Image image, int size, OrderByComparator<Image> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_IMAGE_WHERE);
        query.append(_FINDER_COLUMN_LTSIZE_SIZE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY image.imageId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(size);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(image)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Image)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByLtSize(int size) {
        for (Image image : this.findByLtSize(size, -1, -1, null)) {
            this.remove(image);
        }
    }

    @Override
    public int countByLtSize(int size) {
        FinderPath finderPath = this._finderPathWithPaginationCountByLtSize;
        Object[] finderArgs = new Object[]{size};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_IMAGE_WHERE);
            query.append(_FINDER_COLUMN_LTSIZE_SIZE_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(size);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ImagePersistenceImpl() {
        this.setModelClass(Image.class);
        this.setModelImplClass(ImageImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(ImageModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Image image) {
        EntityCacheUtil.putResult(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageImpl.class, Long.valueOf(image.getPrimaryKey()), image);
        image.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Image> images) {
        for (Image image : images) {
            if (EntityCacheUtil.getResult(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageImpl.class, Long.valueOf(image.getPrimaryKey())) == null) {
                this.cacheResult(image);
                continue;
            }
            image.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(ImageImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Image image) {
        EntityCacheUtil.removeResult(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageImpl.class, Long.valueOf(image.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Image> images) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Image image : images) {
            EntityCacheUtil.removeResult(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageImpl.class, Long.valueOf(image.getPrimaryKey()));
        }
    }

    @Override
    public Image create(long imageId) {
        ImageImpl image = new ImageImpl();
        image.setNew(true);
        image.setPrimaryKey(imageId);
        image.setCompanyId(this.companyProvider.getCompanyId());
        return image;
    }

    @Override
    public Image remove(long imageId) throws NoSuchImageException {
        return this.remove(Long.valueOf(imageId));
    }

    @Override
    public Image remove(Serializable primaryKey) throws NoSuchImageException {
        Session session = null;
        try {
            session = this.openSession();
            Image image = (Image)session.get(ImageImpl.class, primaryKey);
            if (image == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchImageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Image image2 = this.remove(image);
            return image2;
        }
        catch (NoSuchImageException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Image removeImpl(Image image) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(image)) {
                image = (Image)session.get(ImageImpl.class, image.getPrimaryKeyObj());
            }
            if (image != null) {
                session.delete(image);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (image != null) {
            this.clearCache(image);
        }
        return image;
    }

    @Override
    public Image updateImpl(Image image) {
        boolean isNew = image.isNew();
        Session session = null;
        try {
            session = this.openSession();
            if (image.isNew()) {
                session.save(image);
                image.setNew(false);
            } else {
                image = (Image)session.merge(image);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ImageModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        EntityCacheUtil.putResult(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageImpl.class, Long.valueOf(image.getPrimaryKey()), image, false);
        image.resetOriginalValues();
        return image;
    }

    @Override
    public Image findByPrimaryKey(Serializable primaryKey) throws NoSuchImageException {
        Image image = (Image)this.fetchByPrimaryKey(primaryKey);
        if (image == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchImageException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return image;
    }

    @Override
    public Image findByPrimaryKey(long imageId) throws NoSuchImageException {
        return this.findByPrimaryKey(Long.valueOf(imageId));
    }

    @Override
    public Image fetchByPrimaryKey(long imageId) {
        return (Image)this.fetchByPrimaryKey(Long.valueOf(imageId));
    }

    @Override
    public List<Image> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Image> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Image> findAll(int start, int end, OrderByComparator<Image> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Image> findAll(int start, int end, OrderByComparator<Image> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Image> list = null;
        if (retrieveFromCache) {
            list = (List<Image>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_IMAGE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_IMAGE;
                if (pagination) {
                    sql = sql.concat(" ORDER BY image.imageId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Image image : this.findAll()) {
            this.remove(image);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_IMAGE);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "imageId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_IMAGE;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return ImageModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageModelImpl.FINDER_CACHE_ENABLED, ImageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageModelImpl.FINDER_CACHE_ENABLED, ImageImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByLtSize = new FinderPath(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageModelImpl.FINDER_CACHE_ENABLED, ImageImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtSize", new String[]{Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByLtSize = new FinderPath(ImageModelImpl.ENTITY_CACHE_ENABLED, ImageModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtSize", new String[]{Integer.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ImageImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

