/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.service.persistence.CountryPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.CountryImpl;
import com.liferay.portal.model.impl.CountryModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CountryPersistenceImpl
extends BasePersistenceImpl<Country>
implements CountryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CountryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByName;
    private FinderPath _finderPathCountByName;
    private static final String _FINDER_COLUMN_NAME_NAME_2 = "country.name = ?";
    private static final String _FINDER_COLUMN_NAME_NAME_3 = "(country.name IS NULL OR country.name = '')";
    private FinderPath _finderPathFetchByA2;
    private FinderPath _finderPathCountByA2;
    private static final String _FINDER_COLUMN_A2_A2_2 = "country.a2 = ?";
    private static final String _FINDER_COLUMN_A2_A2_3 = "(country.a2 IS NULL OR country.a2 = '')";
    private FinderPath _finderPathFetchByA3;
    private FinderPath _finderPathCountByA3;
    private static final String _FINDER_COLUMN_A3_A3_2 = "country.a3 = ?";
    private static final String _FINDER_COLUMN_A3_A3_3 = "(country.a3 IS NULL OR country.a3 = '')";
    private FinderPath _finderPathWithPaginationFindByActive;
    private FinderPath _finderPathWithoutPaginationFindByActive;
    private FinderPath _finderPathCountByActive;
    private static final String _FINDER_COLUMN_ACTIVE_ACTIVE_2 = "country.active = ?";
    private static final String _SQL_SELECT_COUNTRY = "SELECT country FROM Country country";
    private static final String _SQL_SELECT_COUNTRY_WHERE = "SELECT country FROM Country country WHERE ";
    private static final String _SQL_COUNT_COUNTRY = "SELECT COUNT(country) FROM Country country";
    private static final String _SQL_COUNT_COUNTRY_WHERE = "SELECT COUNT(country) FROM Country country WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "country.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Country exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Country exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CountryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"number", "idd", "active"});

    @Override
    public Country findByName(String name) throws NoSuchCountryException {
        Country country = this.fetchByName(name);
        if (country == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("name=");
            msg.append(name);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchCountryException(msg.toString());
        }
        return country;
    }

    @Override
    public Country fetchByName(String name) {
        return this.fetchByName(name, true);
    }

    @Override
    public Country fetchByName(String name, boolean retrieveFromCache) {
        Country country;
        name = Objects.toString(name, "");
        Object[] finderArgs = new Object[]{name};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByName, finderArgs, this);
        }
        if (result instanceof Country && !Objects.equals(name, (country = (Country)result).getName())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_NAME_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_NAME_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindName) {
                    qPos.add(name);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByName, finderArgs, list);
                } else {
                    Country country2 = (Country)list.get(0);
                    result = country2;
                    this.cacheResult(country2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByName, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Country)result;
    }

    @Override
    public Country removeByName(String name) throws NoSuchCountryException {
        Country country = this.findByName(name);
        return this.remove(country);
    }

    @Override
    public int countByName(String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathCountByName;
        Object[] finderArgs = new Object[]{name};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_NAME_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_NAME_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Country findByA2(String a2) throws NoSuchCountryException {
        Country country = this.fetchByA2(a2);
        if (country == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("a2=");
            msg.append(a2);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchCountryException(msg.toString());
        }
        return country;
    }

    @Override
    public Country fetchByA2(String a2) {
        return this.fetchByA2(a2, true);
    }

    @Override
    public Country fetchByA2(String a2, boolean retrieveFromCache) {
        Country country;
        a2 = Objects.toString(a2, "");
        Object[] finderArgs = new Object[]{a2};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByA2, finderArgs, this);
        }
        if (result instanceof Country && !Objects.equals(a2, (country = (Country)result).getA2())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            boolean bindA2 = false;
            if (a2.isEmpty()) {
                query.append(_FINDER_COLUMN_A2_A2_3);
            } else {
                bindA2 = true;
                query.append(_FINDER_COLUMN_A2_A2_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindA2) {
                    qPos.add(a2);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByA2, finderArgs, list);
                } else {
                    Country country2 = (Country)list.get(0);
                    result = country2;
                    this.cacheResult(country2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByA2, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Country)result;
    }

    @Override
    public Country removeByA2(String a2) throws NoSuchCountryException {
        Country country = this.findByA2(a2);
        return this.remove(country);
    }

    @Override
    public int countByA2(String a2) {
        a2 = Objects.toString(a2, "");
        FinderPath finderPath = this._finderPathCountByA2;
        Object[] finderArgs = new Object[]{a2};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            boolean bindA2 = false;
            if (a2.isEmpty()) {
                query.append(_FINDER_COLUMN_A2_A2_3);
            } else {
                bindA2 = true;
                query.append(_FINDER_COLUMN_A2_A2_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindA2) {
                    qPos.add(a2);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Country findByA3(String a3) throws NoSuchCountryException {
        Country country = this.fetchByA3(a3);
        if (country == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("a3=");
            msg.append(a3);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchCountryException(msg.toString());
        }
        return country;
    }

    @Override
    public Country fetchByA3(String a3) {
        return this.fetchByA3(a3, true);
    }

    @Override
    public Country fetchByA3(String a3, boolean retrieveFromCache) {
        Country country;
        a3 = Objects.toString(a3, "");
        Object[] finderArgs = new Object[]{a3};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByA3, finderArgs, this);
        }
        if (result instanceof Country && !Objects.equals(a3, (country = (Country)result).getA3())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            boolean bindA3 = false;
            if (a3.isEmpty()) {
                query.append(_FINDER_COLUMN_A3_A3_3);
            } else {
                bindA3 = true;
                query.append(_FINDER_COLUMN_A3_A3_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindA3) {
                    qPos.add(a3);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByA3, finderArgs, list);
                } else {
                    Country country2 = (Country)list.get(0);
                    result = country2;
                    this.cacheResult(country2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByA3, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Country)result;
    }

    @Override
    public Country removeByA3(String a3) throws NoSuchCountryException {
        Country country = this.findByA3(a3);
        return this.remove(country);
    }

    @Override
    public int countByA3(String a3) {
        a3 = Objects.toString(a3, "");
        FinderPath finderPath = this._finderPathCountByA3;
        Object[] finderArgs = new Object[]{a3};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            boolean bindA3 = false;
            if (a3.isEmpty()) {
                query.append(_FINDER_COLUMN_A3_A3_3);
            } else {
                bindA3 = true;
                query.append(_FINDER_COLUMN_A3_A3_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindA3) {
                    qPos.add(a3);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Country> findByActive(boolean active) {
        return this.findByActive(active, -1, -1, null);
    }

    @Override
    public List<Country> findByActive(boolean active, int start, int end) {
        return this.findByActive(active, start, end, null);
    }

    @Override
    public List<Country> findByActive(boolean active, int start, int end, OrderByComparator<Country> orderByComparator) {
        return this.findByActive(active, start, end, orderByComparator, true);
    }

    @Override
    public List<Country> findByActive(boolean active, int start, int end, OrderByComparator<Country> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByActive;
            finderArgs = new Object[]{active};
        } else {
            finderPath = this._finderPathWithPaginationFindByActive;
            finderArgs = new Object[]{active, start, end, orderByComparator};
        }
        List<Country> list = null;
        if (retrieveFromCache && (list = (List<Country>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Country country : list) {
                if (active == country.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY country.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Country findByActive_First(boolean active, OrderByComparator<Country> orderByComparator) throws NoSuchCountryException {
        Country country = this.fetchByActive_First(active, orderByComparator);
        if (country != null) {
            return country;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchCountryException(msg.toString());
    }

    @Override
    public Country fetchByActive_First(boolean active, OrderByComparator<Country> orderByComparator) {
        List<Country> list = this.findByActive(active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Country findByActive_Last(boolean active, OrderByComparator<Country> orderByComparator) throws NoSuchCountryException {
        Country country = this.fetchByActive_Last(active, orderByComparator);
        if (country != null) {
            return country;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchCountryException(msg.toString());
    }

    @Override
    public Country fetchByActive_Last(boolean active, OrderByComparator<Country> orderByComparator) {
        int count = this.countByActive(active);
        if (count == 0) {
            return null;
        }
        List<Country> list = this.findByActive(active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Country[] findByActive_PrevAndNext(long countryId, boolean active, OrderByComparator<Country> orderByComparator) throws NoSuchCountryException {
        Country country = this.findByPrimaryKey(countryId);
        Session session = null;
        try {
            session = this.openSession();
            Country[] array = new CountryImpl[]{this.getByActive_PrevAndNext(session, country, active, orderByComparator, true), country, this.getByActive_PrevAndNext(session, country, active, orderByComparator, false)};
            Country[] countryArray = array;
            return countryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Country getByActive_PrevAndNext(Session session, Country country, boolean active, OrderByComparator<Country> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COUNTRY_WHERE);
        query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY country.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(country)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Country)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByActive(boolean active) {
        for (Country country : this.findByActive(active, -1, -1, null)) {
            this.remove(country);
        }
    }

    @Override
    public int countByActive(boolean active) {
        FinderPath finderPath = this._finderPathCountByActive;
        Object[] finderArgs = new Object[]{active};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CountryPersistenceImpl() {
        this.setModelClass(Country.class);
        this.setModelImplClass(CountryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(CountryModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("number", "number_");
        dbColumnNames.put("idd", "idd_");
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Country country) {
        EntityCacheUtil.putResult(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, Long.valueOf(country.getPrimaryKey()), country);
        FinderCacheUtil.putResult(this._finderPathFetchByName, new Object[]{country.getName()}, country);
        FinderCacheUtil.putResult(this._finderPathFetchByA2, new Object[]{country.getA2()}, country);
        FinderCacheUtil.putResult(this._finderPathFetchByA3, new Object[]{country.getA3()}, country);
        country.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Country> countries) {
        for (Country country : countries) {
            if (EntityCacheUtil.getResult(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, Long.valueOf(country.getPrimaryKey())) == null) {
                this.cacheResult(country);
                continue;
            }
            country.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(CountryImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Country country) {
        EntityCacheUtil.removeResult(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, Long.valueOf(country.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CountryModelImpl)((Object)country), true);
    }

    @Override
    public void clearCache(List<Country> countries) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Country country : countries) {
            EntityCacheUtil.removeResult(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, Long.valueOf(country.getPrimaryKey()));
            this.clearUniqueFindersCache((CountryModelImpl)((Object)country), true);
        }
    }

    protected void cacheUniqueFindersCache(CountryModelImpl countryModelImpl) {
        Object[] args = new Object[]{countryModelImpl.getName()};
        FinderCacheUtil.putResult(this._finderPathCountByName, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByName, args, countryModelImpl, false);
        args = new Object[]{countryModelImpl.getA2()};
        FinderCacheUtil.putResult(this._finderPathCountByA2, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByA2, args, countryModelImpl, false);
        args = new Object[]{countryModelImpl.getA3()};
        FinderCacheUtil.putResult(this._finderPathCountByA3, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByA3, args, countryModelImpl, false);
    }

    protected void clearUniqueFindersCache(CountryModelImpl countryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{countryModelImpl.getName()};
            FinderCacheUtil.removeResult(this._finderPathCountByName, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByName, args);
        }
        if ((countryModelImpl.getColumnBitmask() & this._finderPathFetchByName.getColumnBitmask()) != 0L) {
            args = new Object[]{countryModelImpl.getOriginalName()};
            FinderCacheUtil.removeResult(this._finderPathCountByName, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByName, args);
        }
        if (clearCurrent) {
            args = new Object[]{countryModelImpl.getA2()};
            FinderCacheUtil.removeResult(this._finderPathCountByA2, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByA2, args);
        }
        if ((countryModelImpl.getColumnBitmask() & this._finderPathFetchByA2.getColumnBitmask()) != 0L) {
            args = new Object[]{countryModelImpl.getOriginalA2()};
            FinderCacheUtil.removeResult(this._finderPathCountByA2, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByA2, args);
        }
        if (clearCurrent) {
            args = new Object[]{countryModelImpl.getA3()};
            FinderCacheUtil.removeResult(this._finderPathCountByA3, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByA3, args);
        }
        if ((countryModelImpl.getColumnBitmask() & this._finderPathFetchByA3.getColumnBitmask()) != 0L) {
            args = new Object[]{countryModelImpl.getOriginalA3()};
            FinderCacheUtil.removeResult(this._finderPathCountByA3, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByA3, args);
        }
    }

    @Override
    public Country create(long countryId) {
        CountryImpl country = new CountryImpl();
        country.setNew(true);
        country.setPrimaryKey(countryId);
        return country;
    }

    @Override
    public Country remove(long countryId) throws NoSuchCountryException {
        return this.remove(Long.valueOf(countryId));
    }

    @Override
    public Country remove(Serializable primaryKey) throws NoSuchCountryException {
        Session session = null;
        try {
            session = this.openSession();
            Country country = (Country)session.get(CountryImpl.class, primaryKey);
            if (country == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchCountryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Country country2 = this.remove(country);
            return country2;
        }
        catch (NoSuchCountryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Country removeImpl(Country country) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(country)) {
                country = (Country)session.get(CountryImpl.class, country.getPrimaryKeyObj());
            }
            if (country != null) {
                session.delete(country);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (country != null) {
            this.clearCache(country);
        }
        return country;
    }

    @Override
    public Country updateImpl(Country country) {
        boolean isNew = country.isNew();
        if (!(country instanceof CountryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(country.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(country);
                throw new IllegalArgumentException("Implement ModelWrapper in country proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Country implementation " + country.getClass());
        }
        CountryModelImpl countryModelImpl = (CountryModelImpl)((Object)country);
        Session session = null;
        try {
            session = this.openSession();
            if (country.isNew()) {
                session.save(country);
                country.setNew(false);
            } else {
                country = (Country)session.merge(country);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CountryModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{countryModelImpl.isActive()};
            FinderCacheUtil.removeResult(this._finderPathCountByActive, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByActive, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((countryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByActive.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{countryModelImpl.getOriginalActive()};
            FinderCacheUtil.removeResult(this._finderPathCountByActive, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByActive, args);
            args = new Object[]{countryModelImpl.isActive()};
            FinderCacheUtil.removeResult(this._finderPathCountByActive, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByActive, args);
        }
        EntityCacheUtil.putResult(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, Long.valueOf(country.getPrimaryKey()), country, false);
        this.clearUniqueFindersCache(countryModelImpl, false);
        this.cacheUniqueFindersCache(countryModelImpl);
        country.resetOriginalValues();
        return country;
    }

    @Override
    public Country findByPrimaryKey(Serializable primaryKey) throws NoSuchCountryException {
        Country country = (Country)this.fetchByPrimaryKey(primaryKey);
        if (country == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchCountryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return country;
    }

    @Override
    public Country findByPrimaryKey(long countryId) throws NoSuchCountryException {
        return this.findByPrimaryKey(Long.valueOf(countryId));
    }

    @Override
    public Country fetchByPrimaryKey(long countryId) {
        return (Country)this.fetchByPrimaryKey(Long.valueOf(countryId));
    }

    @Override
    public List<Country> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Country> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Country> findAll(int start, int end, OrderByComparator<Country> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Country> findAll(int start, int end, OrderByComparator<Country> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Country> list = null;
        if (retrieveFromCache) {
            list = (List<Country>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COUNTRY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COUNTRY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY country.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Country country : this.findAll()) {
            this.remove(country);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COUNTRY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "countryId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_COUNTRY;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return CountryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByName = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByName", new String[]{String.class.getName()}, 8L);
        this._finderPathCountByName = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByName", new String[]{String.class.getName()});
        this._finderPathFetchByA2 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByA2", new String[]{String.class.getName()}, 1L);
        this._finderPathCountByA2 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByA2", new String[]{String.class.getName()});
        this._finderPathFetchByA3 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByA3", new String[]{String.class.getName()}, 2L);
        this._finderPathCountByA3 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByA3", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByActive = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByActive", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByActive = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByActive", new String[]{Boolean.class.getName()}, 12L);
        this._finderPathCountByActive = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByActive", new String[]{Boolean.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(CountryImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

