/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CompanyPersistenceImpl
extends BasePersistenceImpl<Company>
implements CompanyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CompanyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByWebId;
    private FinderPath _finderPathCountByWebId;
    private static final String _FINDER_COLUMN_WEBID_WEBID_2 = "company.webId = ?";
    private static final String _FINDER_COLUMN_WEBID_WEBID_3 = "(company.webId IS NULL OR company.webId = '')";
    private FinderPath _finderPathFetchByMx;
    private FinderPath _finderPathCountByMx;
    private static final String _FINDER_COLUMN_MX_MX_2 = "company.mx = ?";
    private static final String _FINDER_COLUMN_MX_MX_3 = "(company.mx IS NULL OR company.mx = '')";
    private FinderPath _finderPathFetchByLogoId;
    private FinderPath _finderPathCountByLogoId;
    private static final String _FINDER_COLUMN_LOGOID_LOGOID_2 = "company.logoId = ?";
    private FinderPath _finderPathWithPaginationFindBySystem;
    private FinderPath _finderPathWithoutPaginationFindBySystem;
    private FinderPath _finderPathCountBySystem;
    private static final String _FINDER_COLUMN_SYSTEM_SYSTEM_2 = "company.system = ?";
    private static final String _SQL_SELECT_COMPANY = "SELECT company FROM Company company";
    private static final String _SQL_SELECT_COMPANY_WHERE = "SELECT company FROM Company company WHERE ";
    private static final String _SQL_COUNT_COMPANY = "SELECT COUNT(company) FROM Company company";
    private static final String _SQL_COUNT_COMPANY_WHERE = "SELECT COUNT(company) FROM Company company WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "company.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Company exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Company exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CompanyPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"key", "system", "active"});

    @Override
    public Company findByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.fetchByWebId(webId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("webId=");
            msg.append(webId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    @Override
    public Company fetchByWebId(String webId) {
        return this.fetchByWebId(webId, true);
    }

    @Override
    public Company fetchByWebId(String webId, boolean retrieveFromCache) {
        Company company;
        webId = Objects.toString(webId, "");
        Object[] finderArgs = new Object[]{webId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByWebId, finderArgs, this);
        }
        if (result instanceof Company && !Objects.equals(webId, (company = (Company)result).getWebId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId.isEmpty()) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindWebId) {
                    qPos.add(webId);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByWebId, finderArgs, list);
                } else {
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByWebId, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    @Override
    public Company removeByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.findByWebId(webId);
        return this.remove(company);
    }

    @Override
    public int countByWebId(String webId) {
        webId = Objects.toString(webId, "");
        FinderPath finderPath = this._finderPathCountByWebId;
        Object[] finderArgs = new Object[]{webId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId.isEmpty()) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindWebId) {
                    qPos.add(webId);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Company findByMx(String mx) throws NoSuchCompanyException {
        Company company = this.fetchByMx(mx);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mx=");
            msg.append(mx);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    @Override
    public Company fetchByMx(String mx) {
        return this.fetchByMx(mx, true);
    }

    @Override
    public Company fetchByMx(String mx, boolean retrieveFromCache) {
        Company company;
        mx = Objects.toString(mx, "");
        Object[] finderArgs = new Object[]{mx};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByMx, finderArgs, this);
        }
        if (result instanceof Company && !Objects.equals(mx, (company = (Company)result).getMx())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx.isEmpty()) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindMx) {
                    qPos.add(mx);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByMx, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("CompanyPersistenceImpl.fetchByMx(String, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByMx, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    @Override
    public Company removeByMx(String mx) throws NoSuchCompanyException {
        Company company = this.findByMx(mx);
        return this.remove(company);
    }

    @Override
    public int countByMx(String mx) {
        mx = Objects.toString(mx, "");
        FinderPath finderPath = this._finderPathCountByMx;
        Object[] finderArgs = new Object[]{mx};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx.isEmpty()) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindMx) {
                    qPos.add(mx);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Company findByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.fetchByLogoId(logoId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("logoId=");
            msg.append(logoId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    @Override
    public Company fetchByLogoId(long logoId) {
        return this.fetchByLogoId(logoId, true);
    }

    @Override
    public Company fetchByLogoId(long logoId, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{logoId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByLogoId, finderArgs, this);
        }
        if (result instanceof Company && logoId != (company = (Company)result).getLogoId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(logoId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByLogoId, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("CompanyPersistenceImpl.fetchByLogoId(long, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByLogoId, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    @Override
    public Company removeByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.findByLogoId(logoId);
        return this.remove(company);
    }

    @Override
    public int countByLogoId(long logoId) {
        FinderPath finderPath = this._finderPathCountByLogoId;
        Object[] finderArgs = new Object[]{logoId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(logoId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Company> findBySystem(boolean system) {
        return this.findBySystem(system, -1, -1, null);
    }

    @Override
    public List<Company> findBySystem(boolean system, int start, int end) {
        return this.findBySystem(system, start, end, null);
    }

    @Override
    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator<Company> orderByComparator) {
        return this.findBySystem(system, start, end, orderByComparator, true);
    }

    @Override
    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator<Company> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindBySystem;
            finderArgs = new Object[]{system};
        } else {
            finderPath = this._finderPathWithPaginationFindBySystem;
            finderArgs = new Object[]{system, start, end, orderByComparator};
        }
        List<Company> list = null;
        if (retrieveFromCache && (list = (List<Company>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Company company : list) {
                if (system == company.isSystem()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY company.companyId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(system);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Company findBySystem_First(boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.fetchBySystem_First(system, orderByComparator);
        if (company != null) {
            return company;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("system=");
        msg.append(system);
        msg.append("}");
        throw new NoSuchCompanyException(msg.toString());
    }

    @Override
    public Company fetchBySystem_First(boolean system, OrderByComparator<Company> orderByComparator) {
        List<Company> list = this.findBySystem(system, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Company findBySystem_Last(boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.fetchBySystem_Last(system, orderByComparator);
        if (company != null) {
            return company;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("system=");
        msg.append(system);
        msg.append("}");
        throw new NoSuchCompanyException(msg.toString());
    }

    @Override
    public Company fetchBySystem_Last(boolean system, OrderByComparator<Company> orderByComparator) {
        int count = this.countBySystem(system);
        if (count == 0) {
            return null;
        }
        List<Company> list = this.findBySystem(system, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Company[] findBySystem_PrevAndNext(long companyId, boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.findByPrimaryKey(companyId);
        Session session = null;
        try {
            session = this.openSession();
            Company[] array = new CompanyImpl[]{this.getBySystem_PrevAndNext(session, company, system, orderByComparator, true), company, this.getBySystem_PrevAndNext(session, company, system, orderByComparator, false)};
            Company[] companyArray = array;
            return companyArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company getBySystem_PrevAndNext(Session session, Company company, boolean system, OrderByComparator<Company> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMPANY_WHERE);
        query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY company.companyId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(system);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(company)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Company)list.get(1);
        }
        return null;
    }

    @Override
    public void removeBySystem(boolean system) {
        for (Company company : this.findBySystem(system, -1, -1, null)) {
            this.remove(company);
        }
    }

    @Override
    public int countBySystem(boolean system) {
        FinderPath finderPath = this._finderPathCountBySystem;
        Object[] finderArgs = new Object[]{system};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(system);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CompanyPersistenceImpl() {
        this.setModelClass(Company.class);
        this.setModelImplClass(CompanyImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(CompanyModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("key", "key_");
        dbColumnNames.put("system", "system_");
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Company company) {
        EntityCacheUtil.putResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, Long.valueOf(company.getPrimaryKey()), company);
        FinderCacheUtil.putResult(this._finderPathFetchByWebId, new Object[]{company.getWebId()}, company);
        FinderCacheUtil.putResult(this._finderPathFetchByMx, new Object[]{company.getMx()}, company);
        FinderCacheUtil.putResult(this._finderPathFetchByLogoId, new Object[]{company.getLogoId()}, company);
        company.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Company> companies) {
        for (Company company : companies) {
            if (EntityCacheUtil.getResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, Long.valueOf(company.getPrimaryKey())) == null) {
                this.cacheResult(company);
                continue;
            }
            company.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(CompanyImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Company company) {
        EntityCacheUtil.removeResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, Long.valueOf(company.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CompanyModelImpl)((Object)company), true);
    }

    @Override
    public void clearCache(List<Company> companies) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Company company : companies) {
            EntityCacheUtil.removeResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, Long.valueOf(company.getPrimaryKey()));
            this.clearUniqueFindersCache((CompanyModelImpl)((Object)company), true);
        }
    }

    protected void cacheUniqueFindersCache(CompanyModelImpl companyModelImpl) {
        Object[] args = new Object[]{companyModelImpl.getWebId()};
        FinderCacheUtil.putResult(this._finderPathCountByWebId, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByWebId, args, companyModelImpl, false);
        args = new Object[]{companyModelImpl.getMx()};
        FinderCacheUtil.putResult(this._finderPathCountByMx, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByMx, args, companyModelImpl, false);
        args = new Object[]{companyModelImpl.getLogoId()};
        FinderCacheUtil.putResult(this._finderPathCountByLogoId, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByLogoId, args, companyModelImpl, false);
    }

    protected void clearUniqueFindersCache(CompanyModelImpl companyModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{companyModelImpl.getWebId()};
            FinderCacheUtil.removeResult(this._finderPathCountByWebId, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByWebId, args);
        }
        if ((companyModelImpl.getColumnBitmask() & this._finderPathFetchByWebId.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalWebId()};
            FinderCacheUtil.removeResult(this._finderPathCountByWebId, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByWebId, args);
        }
        if (clearCurrent) {
            args = new Object[]{companyModelImpl.getMx()};
            FinderCacheUtil.removeResult(this._finderPathCountByMx, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByMx, args);
        }
        if ((companyModelImpl.getColumnBitmask() & this._finderPathFetchByMx.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalMx()};
            FinderCacheUtil.removeResult(this._finderPathCountByMx, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByMx, args);
        }
        if (clearCurrent) {
            args = new Object[]{companyModelImpl.getLogoId()};
            FinderCacheUtil.removeResult(this._finderPathCountByLogoId, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByLogoId, args);
        }
        if ((companyModelImpl.getColumnBitmask() & this._finderPathFetchByLogoId.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalLogoId()};
            FinderCacheUtil.removeResult(this._finderPathCountByLogoId, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByLogoId, args);
        }
    }

    @Override
    public Company create(long companyId) {
        CompanyImpl company = new CompanyImpl();
        company.setNew(true);
        company.setPrimaryKey(companyId);
        return company;
    }

    @Override
    public Company remove(long companyId) throws NoSuchCompanyException {
        return this.remove(Long.valueOf(companyId));
    }

    @Override
    public Company remove(Serializable primaryKey) throws NoSuchCompanyException {
        Session session = null;
        try {
            session = this.openSession();
            Company company = (Company)session.get(CompanyImpl.class, primaryKey);
            if (company == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Company company2 = this.remove(company);
            return company2;
        }
        catch (NoSuchCompanyException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Company removeImpl(Company company) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(company)) {
                company = (Company)session.get(CompanyImpl.class, company.getPrimaryKeyObj());
            }
            if (company != null) {
                session.delete(company);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (company != null) {
            this.clearCache(company);
        }
        return company;
    }

    @Override
    public Company updateImpl(Company company) {
        boolean isNew = company.isNew();
        if (!(company instanceof CompanyModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(company.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(company);
                throw new IllegalArgumentException("Implement ModelWrapper in company proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Company implementation " + company.getClass());
        }
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)((Object)company);
        Session session = null;
        try {
            session = this.openSession();
            if (company.isNew()) {
                session.save(company);
                company.setNew(false);
            } else {
                company = (Company)session.merge(company);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CompanyModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{companyModelImpl.isSystem()};
            FinderCacheUtil.removeResult(this._finderPathCountBySystem, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindBySystem, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((companyModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindBySystem.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{companyModelImpl.getOriginalSystem()};
            FinderCacheUtil.removeResult(this._finderPathCountBySystem, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindBySystem, args);
            args = new Object[]{companyModelImpl.isSystem()};
            FinderCacheUtil.removeResult(this._finderPathCountBySystem, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindBySystem, args);
        }
        EntityCacheUtil.putResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, Long.valueOf(company.getPrimaryKey()), company, false);
        this.clearUniqueFindersCache(companyModelImpl, false);
        this.cacheUniqueFindersCache(companyModelImpl);
        company.resetOriginalValues();
        return company;
    }

    @Override
    public Company findByPrimaryKey(Serializable primaryKey) throws NoSuchCompanyException {
        Company company = (Company)this.fetchByPrimaryKey(primaryKey);
        if (company == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return company;
    }

    @Override
    public Company findByPrimaryKey(long companyId) throws NoSuchCompanyException {
        return this.findByPrimaryKey(Long.valueOf(companyId));
    }

    @Override
    public Company fetchByPrimaryKey(long companyId) {
        return (Company)this.fetchByPrimaryKey(Long.valueOf(companyId));
    }

    @Override
    public List<Company> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Company> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Company> list = null;
        if (retrieveFromCache) {
            list = (List<Company>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMPANY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMPANY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY company.companyId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Company company : this.findAll()) {
            this.remove(company);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMPANY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "companyId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_COMPANY;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return CompanyModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByWebId = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByWebId", new String[]{String.class.getName()}, 8L);
        this._finderPathCountByWebId = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByWebId", new String[]{String.class.getName()});
        this._finderPathFetchByMx = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByMx", new String[]{String.class.getName()}, 2L);
        this._finderPathCountByMx = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMx", new String[]{String.class.getName()});
        this._finderPathFetchByLogoId = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByLogoId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByLogoId = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLogoId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindBySystem = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySystem", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindBySystem = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySystem", new String[]{Boolean.class.getName()}, 4L);
        this._finderPathCountBySystem = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySystem", new String[]{Boolean.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(CompanyImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

