/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchClusterGroupException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClusterGroup;
import com.liferay.portal.kernel.service.persistence.ClusterGroupPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.impl.ClusterGroupImpl;
import com.liferay.portal.model.impl.ClusterGroupModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ClusterGroupPersistenceImpl
extends BasePersistenceImpl<ClusterGroup>
implements ClusterGroupPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ClusterGroupImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private static final String _SQL_SELECT_CLUSTERGROUP = "SELECT clusterGroup FROM ClusterGroup clusterGroup";
    private static final String _SQL_COUNT_CLUSTERGROUP = "SELECT COUNT(clusterGroup) FROM ClusterGroup clusterGroup";
    private static final String _ORDER_BY_ENTITY_ALIAS = "clusterGroup.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ClusterGroup exists with the primary key ";
    private static final Log _log = LogFactoryUtil.getLog(ClusterGroupPersistenceImpl.class);

    public ClusterGroupPersistenceImpl() {
        this.setModelClass(ClusterGroup.class);
        this.setModelImplClass(ClusterGroupImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED);
    }

    @Override
    public void cacheResult(ClusterGroup clusterGroup) {
        EntityCacheUtil.putResult(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupImpl.class, Long.valueOf(clusterGroup.getPrimaryKey()), clusterGroup);
        clusterGroup.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<ClusterGroup> clusterGroups) {
        for (ClusterGroup clusterGroup : clusterGroups) {
            if (EntityCacheUtil.getResult(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupImpl.class, Long.valueOf(clusterGroup.getPrimaryKey())) == null) {
                this.cacheResult(clusterGroup);
                continue;
            }
            clusterGroup.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(ClusterGroupImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(ClusterGroup clusterGroup) {
        EntityCacheUtil.removeResult(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupImpl.class, Long.valueOf(clusterGroup.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<ClusterGroup> clusterGroups) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ClusterGroup clusterGroup : clusterGroups) {
            EntityCacheUtil.removeResult(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupImpl.class, Long.valueOf(clusterGroup.getPrimaryKey()));
        }
    }

    @Override
    public ClusterGroup create(long clusterGroupId) {
        ClusterGroupImpl clusterGroup = new ClusterGroupImpl();
        clusterGroup.setNew(true);
        clusterGroup.setPrimaryKey(clusterGroupId);
        return clusterGroup;
    }

    @Override
    public ClusterGroup remove(long clusterGroupId) throws NoSuchClusterGroupException {
        return this.remove(Long.valueOf(clusterGroupId));
    }

    @Override
    public ClusterGroup remove(Serializable primaryKey) throws NoSuchClusterGroupException {
        Session session = null;
        try {
            session = this.openSession();
            ClusterGroup clusterGroup = (ClusterGroup)session.get(ClusterGroupImpl.class, primaryKey);
            if (clusterGroup == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchClusterGroupException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ClusterGroup clusterGroup2 = this.remove(clusterGroup);
            return clusterGroup2;
        }
        catch (NoSuchClusterGroupException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected ClusterGroup removeImpl(ClusterGroup clusterGroup) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(clusterGroup)) {
                clusterGroup = (ClusterGroup)session.get(ClusterGroupImpl.class, clusterGroup.getPrimaryKeyObj());
            }
            if (clusterGroup != null) {
                session.delete(clusterGroup);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (clusterGroup != null) {
            this.clearCache(clusterGroup);
        }
        return clusterGroup;
    }

    @Override
    public ClusterGroup updateImpl(ClusterGroup clusterGroup) {
        boolean isNew = clusterGroup.isNew();
        Session session = null;
        try {
            session = this.openSession();
            if (clusterGroup.isNew()) {
                session.save(clusterGroup);
                clusterGroup.setNew(false);
            } else {
                clusterGroup = (ClusterGroup)session.merge(clusterGroup);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew) {
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        EntityCacheUtil.putResult(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupImpl.class, Long.valueOf(clusterGroup.getPrimaryKey()), clusterGroup, false);
        clusterGroup.resetOriginalValues();
        return clusterGroup;
    }

    @Override
    public ClusterGroup findByPrimaryKey(Serializable primaryKey) throws NoSuchClusterGroupException {
        ClusterGroup clusterGroup = (ClusterGroup)this.fetchByPrimaryKey(primaryKey);
        if (clusterGroup == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchClusterGroupException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return clusterGroup;
    }

    @Override
    public ClusterGroup findByPrimaryKey(long clusterGroupId) throws NoSuchClusterGroupException {
        return this.findByPrimaryKey(Long.valueOf(clusterGroupId));
    }

    @Override
    public ClusterGroup fetchByPrimaryKey(long clusterGroupId) {
        return (ClusterGroup)this.fetchByPrimaryKey(Long.valueOf(clusterGroupId));
    }

    @Override
    public List<ClusterGroup> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<ClusterGroup> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<ClusterGroup> findAll(int start, int end, OrderByComparator<ClusterGroup> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<ClusterGroup> findAll(int start, int end, OrderByComparator<ClusterGroup> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<ClusterGroup> list = null;
        if (retrieveFromCache) {
            list = (List<ClusterGroup>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_CLUSTERGROUP);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CLUSTERGROUP;
                if (pagination) {
                    sql = sql.concat(" ORDER BY clusterGroup.clusterGroupId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (ClusterGroup clusterGroup : this.findAll()) {
            this.remove(clusterGroup);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_CLUSTERGROUP);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "clusterGroupId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_CLUSTERGROUP;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return ClusterGroupModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupModelImpl.FINDER_CACHE_ENABLED, ClusterGroupImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupModelImpl.FINDER_CACHE_ENABLED, ClusterGroupImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ClusterGroupModelImpl.ENTITY_CACHE_ENABLED, ClusterGroupModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ClusterGroupImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

