/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchClassNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.persistence.ClassNamePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.model.impl.ClassNameModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ClassNamePersistenceImpl
extends BasePersistenceImpl<ClassName>
implements ClassNamePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ClassNameImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByValue;
    private FinderPath _finderPathCountByValue;
    private static final String _FINDER_COLUMN_VALUE_VALUE_2 = "className.value = ?";
    private static final String _FINDER_COLUMN_VALUE_VALUE_3 = "(className.value IS NULL OR className.value = '')";
    private static final String _SQL_SELECT_CLASSNAME = "SELECT className FROM ClassName className";
    private static final String _SQL_SELECT_CLASSNAME_WHERE = "SELECT className FROM ClassName className WHERE ";
    private static final String _SQL_COUNT_CLASSNAME = "SELECT COUNT(className) FROM ClassName className";
    private static final String _SQL_COUNT_CLASSNAME_WHERE = "SELECT COUNT(className) FROM ClassName className WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "className.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ClassName exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ClassName exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ClassNamePersistenceImpl.class);

    @Override
    public ClassName findByValue(String value) throws NoSuchClassNameException {
        ClassName className = this.fetchByValue(value);
        if (className == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("value=");
            msg.append(value);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchClassNameException(msg.toString());
        }
        return className;
    }

    @Override
    public ClassName fetchByValue(String value) {
        return this.fetchByValue(value, true);
    }

    @Override
    public ClassName fetchByValue(String value, boolean retrieveFromCache) {
        ClassName className;
        value = Objects.toString(value, "");
        Object[] finderArgs = new Object[]{value};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByValue, finderArgs, this);
        }
        if (result instanceof ClassName && !Objects.equals(value, (className = (ClassName)result).getValue())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_CLASSNAME_WHERE);
            boolean bindValue = false;
            if (value.isEmpty()) {
                query.append(_FINDER_COLUMN_VALUE_VALUE_3);
            } else {
                bindValue = true;
                query.append(_FINDER_COLUMN_VALUE_VALUE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindValue) {
                    qPos.add(value);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByValue, finderArgs, list);
                } else {
                    ClassName className2 = (ClassName)list.get(0);
                    result = className2;
                    this.cacheResult(className2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByValue, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ClassName)result;
    }

    @Override
    public ClassName removeByValue(String value) throws NoSuchClassNameException {
        ClassName className = this.findByValue(value);
        return this.remove(className);
    }

    @Override
    public int countByValue(String value) {
        value = Objects.toString(value, "");
        FinderPath finderPath = this._finderPathCountByValue;
        Object[] finderArgs = new Object[]{value};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_CLASSNAME_WHERE);
            boolean bindValue = false;
            if (value.isEmpty()) {
                query.append(_FINDER_COLUMN_VALUE_VALUE_3);
            } else {
                bindValue = true;
                query.append(_FINDER_COLUMN_VALUE_VALUE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindValue) {
                    qPos.add(value);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ClassNamePersistenceImpl() {
        this.setModelClass(ClassName.class);
        this.setModelImplClass(ClassNameImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(ClassNameModelImpl.ENTITY_CACHE_ENABLED);
    }

    @Override
    public void cacheResult(ClassName className) {
        EntityCacheUtil.putResult(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameImpl.class, Long.valueOf(className.getPrimaryKey()), className);
        FinderCacheUtil.putResult(this._finderPathFetchByValue, new Object[]{className.getValue()}, className);
        className.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<ClassName> classNames) {
        for (ClassName className : classNames) {
            if (EntityCacheUtil.getResult(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameImpl.class, Long.valueOf(className.getPrimaryKey())) == null) {
                this.cacheResult(className);
                continue;
            }
            className.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(ClassNameImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(ClassName className) {
        EntityCacheUtil.removeResult(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameImpl.class, Long.valueOf(className.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((ClassNameModelImpl)((Object)className), true);
    }

    @Override
    public void clearCache(List<ClassName> classNames) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (ClassName className : classNames) {
            EntityCacheUtil.removeResult(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameImpl.class, Long.valueOf(className.getPrimaryKey()));
            this.clearUniqueFindersCache((ClassNameModelImpl)((Object)className), true);
        }
    }

    protected void cacheUniqueFindersCache(ClassNameModelImpl classNameModelImpl) {
        Object[] args = new Object[]{classNameModelImpl.getValue()};
        FinderCacheUtil.putResult(this._finderPathCountByValue, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByValue, args, classNameModelImpl, false);
    }

    protected void clearUniqueFindersCache(ClassNameModelImpl classNameModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{classNameModelImpl.getValue()};
            FinderCacheUtil.removeResult(this._finderPathCountByValue, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByValue, args);
        }
        if ((classNameModelImpl.getColumnBitmask() & this._finderPathFetchByValue.getColumnBitmask()) != 0L) {
            args = new Object[]{classNameModelImpl.getOriginalValue()};
            FinderCacheUtil.removeResult(this._finderPathCountByValue, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByValue, args);
        }
    }

    @Override
    public ClassName create(long classNameId) {
        ClassNameImpl className = new ClassNameImpl();
        className.setNew(true);
        className.setPrimaryKey(classNameId);
        return className;
    }

    @Override
    public ClassName remove(long classNameId) throws NoSuchClassNameException {
        return this.remove(Long.valueOf(classNameId));
    }

    @Override
    public ClassName remove(Serializable primaryKey) throws NoSuchClassNameException {
        Session session = null;
        try {
            session = this.openSession();
            ClassName className = (ClassName)session.get(ClassNameImpl.class, primaryKey);
            if (className == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchClassNameException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ClassName className2 = this.remove(className);
            return className2;
        }
        catch (NoSuchClassNameException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected ClassName removeImpl(ClassName className) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(className)) {
                className = (ClassName)session.get(ClassNameImpl.class, className.getPrimaryKeyObj());
            }
            if (className != null) {
                session.delete(className);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (className != null) {
            this.clearCache(className);
        }
        return className;
    }

    @Override
    public ClassName updateImpl(ClassName className) {
        boolean isNew = className.isNew();
        if (!(className instanceof ClassNameModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(className.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(className);
                throw new IllegalArgumentException("Implement ModelWrapper in className proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ClassName implementation " + className.getClass());
        }
        ClassNameModelImpl classNameModelImpl = (ClassNameModelImpl)((Object)className);
        Session session = null;
        try {
            session = this.openSession();
            if (className.isNew()) {
                session.save(className);
                className.setNew(false);
            } else {
                className = (ClassName)session.merge(className);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!ClassNameModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        EntityCacheUtil.putResult(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameImpl.class, Long.valueOf(className.getPrimaryKey()), className, false);
        this.clearUniqueFindersCache(classNameModelImpl, false);
        this.cacheUniqueFindersCache(classNameModelImpl);
        className.resetOriginalValues();
        return className;
    }

    @Override
    public ClassName findByPrimaryKey(Serializable primaryKey) throws NoSuchClassNameException {
        ClassName className = (ClassName)this.fetchByPrimaryKey(primaryKey);
        if (className == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchClassNameException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return className;
    }

    @Override
    public ClassName findByPrimaryKey(long classNameId) throws NoSuchClassNameException {
        return this.findByPrimaryKey(Long.valueOf(classNameId));
    }

    @Override
    public ClassName fetchByPrimaryKey(long classNameId) {
        return (ClassName)this.fetchByPrimaryKey(Long.valueOf(classNameId));
    }

    @Override
    public List<ClassName> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<ClassName> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<ClassName> findAll(int start, int end, OrderByComparator<ClassName> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<ClassName> findAll(int start, int end, OrderByComparator<ClassName> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<ClassName> list = null;
        if (retrieveFromCache) {
            list = (List<ClassName>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_CLASSNAME);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_CLASSNAME;
                if (pagination) {
                    sql = sql.concat(" ORDER BY className.classNameId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (ClassName className : this.findAll()) {
            this.remove(className);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_CLASSNAME);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "classNameId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_CLASSNAME;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return ClassNameModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameModelImpl.FINDER_CACHE_ENABLED, ClassNameImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameModelImpl.FINDER_CACHE_ENABLED, ClassNameImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathFetchByValue = new FinderPath(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameModelImpl.FINDER_CACHE_ENABLED, ClassNameImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByValue", new String[]{String.class.getName()}, 1L);
        this._finderPathCountByValue = new FinderPath(ClassNameModelImpl.ENTITY_CACHE_ENABLED, ClassNameModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByValue", new String[]{String.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(ClassNameImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

