/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.AddressPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.model.impl.AddressModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AddressPersistenceImpl
extends BasePersistenceImpl<Address>
implements AddressPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AddressImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "address.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(address.uuid IS NULL OR address.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "address.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(address.uuid IS NULL OR address.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "address.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "address.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "address.userId = ?";
    private FinderPath _finderPathWithPaginationFindByC_C;
    private FinderPath _finderPathWithoutPaginationFindByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "address.classNameId = ?";
    private FinderPath _finderPathWithPaginationFindByC_C_C;
    private FinderPath _finderPathWithoutPaginationFindByC_C_C;
    private FinderPath _finderPathCountByC_C_C;
    private static final String _FINDER_COLUMN_C_C_C_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_CLASSNAMEID_2 = "address.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_CLASSPK_2 = "address.classPK = ?";
    private FinderPath _finderPathWithPaginationFindByC_C_C_M;
    private FinderPath _finderPathWithoutPaginationFindByC_C_C_M;
    private FinderPath _finderPathCountByC_C_C_M;
    private static final String _FINDER_COLUMN_C_C_C_M_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_M_CLASSNAMEID_2 = "address.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_M_CLASSPK_2 = "address.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_M_MAILING_2 = "address.mailing = ?";
    private FinderPath _finderPathWithPaginationFindByC_C_C_P;
    private FinderPath _finderPathWithoutPaginationFindByC_C_C_P;
    private FinderPath _finderPathCountByC_C_C_P;
    private static final String _FINDER_COLUMN_C_C_C_P_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_P_CLASSNAMEID_2 = "address.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_P_CLASSPK_2 = "address.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_P_PRIMARY_2 = "address.primary = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_ADDRESS = "SELECT address FROM Address address";
    private static final String _SQL_SELECT_ADDRESS_WHERE = "SELECT address FROM Address address WHERE ";
    private static final String _SQL_COUNT_ADDRESS = "SELECT COUNT(address) FROM Address address";
    private static final String _SQL_COUNT_ADDRESS_WHERE = "SELECT COUNT(address) FROM Address address WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "address.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Address exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Address exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AddressPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"uuid", "primary"});

    @Override
    public List<Address> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    @Override
    public List<Address> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    @Override
    public List<Address> findByUuid(String uuid, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByUuid(String uuid, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (uuid.equals(address.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByUuid_First(String uuid, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_First(uuid, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByUuid_First(String uuid, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByUuid_Last(String uuid, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_Last(uuid, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByUuid_Last(String uuid, OrderByComparator<Address> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByUuid_PrevAndNext(long addressId, String uuid, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        uuid = Objects.toString(uuid, "");
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByUuid_PrevAndNext(session, address, uuid, orderByComparator, true), address, this.getByUuid_PrevAndNext(session, address, uuid, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByUuid_PrevAndNext(Session session, Address address, String uuid, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid(String uuid) {
        for (Address address : this.findByUuid(uuid, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    @Override
    public List<Address> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    @Override
    public List<Address> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        uuid = Objects.toString(uuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (uuid.equals(address.getUuid()) && companyId == address.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("address.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByUuid_C_First(String uuid, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByUuid_C_PrevAndNext(long addressId, String uuid, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        uuid = Objects.toString(uuid, "");
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByUuid_C_PrevAndNext(session, address, uuid, companyId, orderByComparator, true), address, this.getByUuid_C_PrevAndNext(session, address, uuid, companyId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByUuid_C_PrevAndNext(Session session, Address address, String uuid, long companyId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        query.append("address.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUuid_C(String uuid, long companyId) {
        for (Address address : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("address.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    @Override
    public List<Address> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    @Override
    public List<Address> findByCompanyId(long companyId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByCompanyId(long companyId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByCompanyId_First(long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByCompanyId_First(long companyId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByCompanyId_Last(long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByCompanyId_Last(long companyId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByCompanyId_PrevAndNext(long addressId, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByCompanyId_PrevAndNext(session, address, companyId, orderByComparator, true), address, this.getByCompanyId_PrevAndNext(session, address, companyId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByCompanyId_PrevAndNext(Session session, Address address, long companyId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByCompanyId(long companyId) {
        for (Address address : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    @Override
    public List<Address> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    @Override
    public List<Address> findByUserId(long userId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByUserId(long userId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByUserId;
            finderArgs = new Object[]{userId};
        } else {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (userId == address.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(userId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByUserId_First(long userId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUserId_First(userId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByUserId_First(long userId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByUserId_Last(long userId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUserId_Last(userId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByUserId_Last(long userId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByUserId_PrevAndNext(long addressId, long userId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByUserId_PrevAndNext(session, address, userId, orderByComparator, true), address, this.getByUserId_PrevAndNext(session, address, userId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByUserId_PrevAndNext(Session session, Address address, long userId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByUserId(long userId) {
        for (Address address : this.findByUserId(userId, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByC_C(long companyId, long classNameId) {
        return this.findByC_C(companyId, classNameId, -1, -1, null);
    }

    @Override
    public List<Address> findByC_C(long companyId, long classNameId, int start, int end) {
        return this.findByC_C(companyId, classNameId, start, end, null);
    }

    @Override
    public List<Address> findByC_C(long companyId, long classNameId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C(companyId, classNameId, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByC_C(long companyId, long classNameId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_C;
            finderArgs = new Object[]{companyId, classNameId};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_C;
            finderArgs = new Object[]{companyId, classNameId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByC_C_First(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_First(companyId, classNameId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_First(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C(companyId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByC_C_Last(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_Last(companyId, classNameId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_Last(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C(companyId, classNameId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C(companyId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByC_C_PrevAndNext(long addressId, long companyId, long classNameId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_PrevAndNext(session, address, companyId, classNameId, orderByComparator, true), address, this.getByC_C_PrevAndNext(session, address, companyId, classNameId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_PrevAndNext(Session session, Address address, long companyId, long classNameId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_C(long companyId, long classNameId) {
        for (Address address : this.findByC_C(companyId, classNameId, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByC_C(long companyId, long classNameId) {
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{companyId, classNameId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK) {
        return this.findByC_C_C(companyId, classNameId, classPK, -1, -1, null);
    }

    @Override
    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK, int start, int end) {
        return this.findByC_C_C(companyId, classNameId, classPK, start, end, null);
    }

    @Override
    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C_C(companyId, classNameId, classPK, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_C_C;
            finderArgs = new Object[]{companyId, classNameId, classPK};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_C_C;
            finderArgs = new Object[]{companyId, classNameId, classPK, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId() && classPK == address.getClassPK()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByC_C_C_First(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_First(companyId, classNameId, classPK, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_C_First(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C_C(companyId, classNameId, classPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByC_C_C_Last(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_Last(companyId, classNameId, classPK, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_C_Last(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C_C(companyId, classNameId, classPK);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C_C(companyId, classNameId, classPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByC_C_C_PrevAndNext(long addressId, long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_C_PrevAndNext(session, address, companyId, classNameId, classPK, orderByComparator, true), address, this.getByC_C_C_PrevAndNext(session, address, companyId, classNameId, classPK, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_C_PrevAndNext(Session session, Address address, long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append("address.classNameId = ? AND ");
        query.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_C_C(long companyId, long classNameId, long classPK) {
        for (Address address : this.findByC_C_C(companyId, classNameId, classPK, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByC_C_C(long companyId, long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByC_C_C;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing) {
        return this.findByC_C_C_M(companyId, classNameId, classPK, mailing, -1, -1, null);
    }

    @Override
    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing, int start, int end) {
        return this.findByC_C_C_M(companyId, classNameId, classPK, mailing, start, end, null);
    }

    @Override
    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C_C_M(companyId, classNameId, classPK, mailing, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_C_C_M;
            finderArgs = new Object[]{companyId, classNameId, classPK, mailing};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_C_C_M;
            finderArgs = new Object[]{companyId, classNameId, classPK, mailing, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId() && classPK == address.getClassPK() && mailing == address.isMailing()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_M_MAILING_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(mailing);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByC_C_C_M_First(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_M_First(companyId, classNameId, classPK, mailing, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", mailing=");
        msg.append(mailing);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_C_M_First(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C_C_M(companyId, classNameId, classPK, mailing, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByC_C_C_M_Last(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_M_Last(companyId, classNameId, classPK, mailing, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", mailing=");
        msg.append(mailing);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_C_M_Last(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C_C_M(companyId, classNameId, classPK, mailing);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C_C_M(companyId, classNameId, classPK, mailing, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByC_C_C_M_PrevAndNext(long addressId, long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_C_M_PrevAndNext(session, address, companyId, classNameId, classPK, mailing, orderByComparator, true), address, this.getByC_C_C_M_PrevAndNext(session, address, companyId, classNameId, classPK, mailing, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_C_M_PrevAndNext(Session session, Address address, long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append("address.classNameId = ? AND ");
        query.append("address.classPK = ? AND ");
        query.append(_FINDER_COLUMN_C_C_C_M_MAILING_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        qPos.add(mailing);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing) {
        for (Address address : this.findByC_C_C_M(companyId, classNameId, classPK, mailing, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing) {
        FinderPath finderPath = this._finderPathCountByC_C_C_M;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK, mailing};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_M_MAILING_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(mailing);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary) {
        return this.findByC_C_C_P(companyId, classNameId, classPK, primary, -1, -1, null);
    }

    @Override
    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary, int start, int end) {
        return this.findByC_C_C_P(companyId, classNameId, classPK, primary, start, end, null);
    }

    @Override
    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C_C_P(companyId, classNameId, classPK, primary, start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_C_C_P;
            finderArgs = new Object[]{companyId, classNameId, classPK, primary};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_C_C_P;
            finderArgs = new Object[]{companyId, classNameId, classPK, primary, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId() && classPK == address.getClassPK() && primary == address.isPrimary()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_P_PRIMARY_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(primary);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public Address findByC_C_C_P_First(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_P_First(companyId, classNameId, classPK, primary, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", primary=");
        msg.append(primary);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_C_P_First(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C_C_P(companyId, classNameId, classPK, primary, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address findByC_C_C_P_Last(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_P_Last(companyId, classNameId, classPK, primary, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", primary=");
        msg.append(primary);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    @Override
    public Address fetchByC_C_C_P_Last(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C_C_P(companyId, classNameId, classPK, primary);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C_C_P(companyId, classNameId, classPK, primary, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Address[] findByC_C_C_P_PrevAndNext(long addressId, long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_C_P_PrevAndNext(session, address, companyId, classNameId, classPK, primary, orderByComparator, true), address, this.getByC_C_C_P_PrevAndNext(session, address, companyId, classNameId, classPK, primary, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_C_P_PrevAndNext(Session session, Address address, long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append("address.classNameId = ? AND ");
        query.append("address.classPK = ? AND ");
        query.append(_FINDER_COLUMN_C_C_C_P_PRIMARY_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        qPos.add(primary);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(address)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary) {
        for (Address address : this.findByC_C_C_P(companyId, classNameId, classPK, primary, -1, -1, null)) {
            this.remove(address);
        }
    }

    @Override
    public int countByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary) {
        FinderPath finderPath = this._finderPathCountByC_C_C_P;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK, primary};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_P_PRIMARY_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(primary);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AddressPersistenceImpl() {
        this.setModelClass(Address.class);
        this.setModelImplClass(AddressImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(AddressModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("primary", "primary_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Address address) {
        EntityCacheUtil.putResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, Long.valueOf(address.getPrimaryKey()), address);
        address.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Address> addresses) {
        for (Address address : addresses) {
            if (EntityCacheUtil.getResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, Long.valueOf(address.getPrimaryKey())) == null) {
                this.cacheResult(address);
                continue;
            }
            address.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(AddressImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Address address) {
        EntityCacheUtil.removeResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, Long.valueOf(address.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Address> addresses) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Address address : addresses) {
            EntityCacheUtil.removeResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, Long.valueOf(address.getPrimaryKey()));
        }
    }

    @Override
    public Address create(long addressId) {
        AddressImpl address = new AddressImpl();
        address.setNew(true);
        address.setPrimaryKey(addressId);
        String uuid = PortalUUIDUtil.generate();
        address.setUuid(uuid);
        address.setCompanyId(this.companyProvider.getCompanyId());
        return address;
    }

    @Override
    public Address remove(long addressId) throws NoSuchAddressException {
        return this.remove(Long.valueOf(addressId));
    }

    @Override
    public Address remove(Serializable primaryKey) throws NoSuchAddressException {
        Session session = null;
        try {
            session = this.openSession();
            Address address = (Address)session.get(AddressImpl.class, primaryKey);
            if (address == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchAddressException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Address address2 = this.remove(address);
            return address2;
        }
        catch (NoSuchAddressException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Address removeImpl(Address address) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(address)) {
                address = (Address)session.get(AddressImpl.class, address.getPrimaryKeyObj());
            }
            if (address != null) {
                session.delete(address);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (address != null) {
            this.clearCache(address);
        }
        return address;
    }

    @Override
    public Address updateImpl(Address address) {
        boolean isNew = address.isNew();
        if (!(address instanceof AddressModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(address.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(address);
                throw new IllegalArgumentException("Implement ModelWrapper in address proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Address implementation " + address.getClass());
        }
        AddressModelImpl addressModelImpl = (AddressModelImpl)((Object)address);
        if (Validator.isNull(address.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            address.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && address.getCreateDate() == null) {
            if (serviceContext == null) {
                address.setCreateDate(now);
            } else {
                address.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!addressModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                address.setModifiedDate(now);
            } else {
                address.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (address.isNew()) {
                session.save(address);
                address.setNew(false);
            } else {
                address = (Address)session.merge(address);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!AddressModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{addressModelImpl.getUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{addressModelImpl.getUuid(), addressModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{addressModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{addressModelImpl.getUserId()};
            FinderCacheUtil.removeResult(this._finderPathCountByUserId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
            args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C_C, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C, args);
            args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK(), addressModelImpl.isMailing()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_M, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_M, args);
            args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK(), addressModelImpl.isPrimary()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_P, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_P, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{addressModelImpl.getUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalUuid(), addressModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{addressModelImpl.getUuid(), addressModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUuid_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{addressModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalUserId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUserId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{addressModelImpl.getUserId()};
                FinderCacheUtil.removeResult(this._finderPathCountByUserId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C_C.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId(), addressModelImpl.getOriginalClassPK()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C_C_M.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId(), addressModelImpl.getOriginalClassPK(), addressModelImpl.getOriginalMailing()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_M, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_M, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK(), addressModelImpl.isMailing()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_M, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_M, args);
            }
            if ((addressModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_C_C_P.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId(), addressModelImpl.getOriginalClassPK(), addressModelImpl.getOriginalPrimary()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_P, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_P, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK(), addressModelImpl.isPrimary()};
                FinderCacheUtil.removeResult(this._finderPathCountByC_C_C_P, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByC_C_C_P, args);
            }
        }
        EntityCacheUtil.putResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, Long.valueOf(address.getPrimaryKey()), address, false);
        address.resetOriginalValues();
        return address;
    }

    @Override
    public Address findByPrimaryKey(Serializable primaryKey) throws NoSuchAddressException {
        Address address = (Address)this.fetchByPrimaryKey(primaryKey);
        if (address == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchAddressException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return address;
    }

    @Override
    public Address findByPrimaryKey(long addressId) throws NoSuchAddressException {
        return this.findByPrimaryKey(Long.valueOf(addressId));
    }

    @Override
    public Address fetchByPrimaryKey(long addressId) {
        return (Address)this.fetchByPrimaryKey(Long.valueOf(addressId));
    }

    @Override
    public List<Address> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Address> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Address> findAll(int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Address> findAll(int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache) {
            list = (List<Address>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ADDRESS);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ADDRESS;
                if (pagination) {
                    sql = sql.concat(" ORDER BY address.createDate ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Address address : this.findAll()) {
            this.remove(address);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ADDRESS);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "addressId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_ADDRESS;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return AddressModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 192L);
        this._finderPathCountByUuid = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 196L);
        this._finderPathCountByUuid_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 132L);
        this._finderPathCountByCompanyId = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByUserId = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 160L);
        this._finderPathCountByUserId = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 133L);
        this._finderPathCountByC_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByC_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, 135L);
        this._finderPathCountByC_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByC_C_C_M = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C_M", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C_C_M = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C_M", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, 143L);
        this._finderPathCountByC_C_C_M = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C_M", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()});
        this._finderPathWithPaginationFindByC_C_C_P = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_C_C_P = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, 151L);
        this._finderPathCountByC_C_C_P = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(AddressImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

