/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchAccountException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.AccountPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.impl.AccountImpl;
import com.liferay.portal.model.impl.AccountModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AccountPersistenceImpl
extends BasePersistenceImpl<Account>
implements AccountPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    private static final String _SQL_SELECT_ACCOUNT = "SELECT account FROM Account account";
    private static final String _SQL_COUNT_ACCOUNT = "SELECT COUNT(account) FROM Account account";
    private static final String _ORDER_BY_ENTITY_ALIAS = "account.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Account exists with the primary key ";
    private static final Log _log = LogFactoryUtil.getLog(AccountPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray(new String[]{"type", "size"});

    public AccountPersistenceImpl() {
        this.setModelClass(Account.class);
        this.setModelImplClass(AccountImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(AccountModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
    }

    @Override
    public void cacheResult(Account account) {
        EntityCacheUtil.putResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, Long.valueOf(account.getPrimaryKey()), account);
        account.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<Account> accounts) {
        for (Account account : accounts) {
            if (EntityCacheUtil.getResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, Long.valueOf(account.getPrimaryKey())) == null) {
                this.cacheResult(account);
                continue;
            }
            account.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(AccountImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(Account account) {
        EntityCacheUtil.removeResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, Long.valueOf(account.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(List<Account> accounts) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Account account : accounts) {
            EntityCacheUtil.removeResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, Long.valueOf(account.getPrimaryKey()));
        }
    }

    @Override
    public Account create(long accountId) {
        AccountImpl account = new AccountImpl();
        account.setNew(true);
        account.setPrimaryKey(accountId);
        account.setCompanyId(this.companyProvider.getCompanyId());
        return account;
    }

    @Override
    public Account remove(long accountId) throws NoSuchAccountException {
        return this.remove(Long.valueOf(accountId));
    }

    @Override
    public Account remove(Serializable primaryKey) throws NoSuchAccountException {
        Session session = null;
        try {
            session = this.openSession();
            Account account = (Account)session.get(AccountImpl.class, primaryKey);
            if (account == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Account account2 = this.remove(account);
            return account2;
        }
        catch (NoSuchAccountException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Account removeImpl(Account account) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(account)) {
                account = (Account)session.get(AccountImpl.class, account.getPrimaryKeyObj());
            }
            if (account != null) {
                session.delete(account);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (account != null) {
            this.clearCache(account);
        }
        return account;
    }

    @Override
    public Account updateImpl(Account account) {
        boolean isNew = account.isNew();
        if (!(account instanceof AccountModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(account.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(account);
                throw new IllegalArgumentException("Implement ModelWrapper in account proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Account implementation " + account.getClass());
        }
        AccountModelImpl accountModelImpl = (AccountModelImpl)((Object)account);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && account.getCreateDate() == null) {
            if (serviceContext == null) {
                account.setCreateDate(now);
            } else {
                account.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!accountModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                account.setModifiedDate(now);
            } else {
                account.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (account.isNew()) {
                session.save(account);
                account.setNew(false);
            } else {
                account = (Account)session.merge(account);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew) {
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        }
        EntityCacheUtil.putResult(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountImpl.class, Long.valueOf(account.getPrimaryKey()), account, false);
        account.resetOriginalValues();
        return account;
    }

    @Override
    public Account findByPrimaryKey(Serializable primaryKey) throws NoSuchAccountException {
        Account account = (Account)this.fetchByPrimaryKey(primaryKey);
        if (account == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return account;
    }

    @Override
    public Account findByPrimaryKey(long accountId) throws NoSuchAccountException {
        return this.findByPrimaryKey(Long.valueOf(accountId));
    }

    @Override
    public Account fetchByPrimaryKey(long accountId) {
        return (Account)this.fetchByPrimaryKey(Long.valueOf(accountId));
    }

    @Override
    public List<Account> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<Account> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<Account> list = null;
        if (retrieveFromCache) {
            list = (List<Account>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ACCOUNT);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNT;
                if (pagination) {
                    sql = sql.concat(" ORDER BY account.accountId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (Account account : this.findAll()) {
            this.remove(account);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ACCOUNT);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "accountId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_ACCOUNT;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return AccountModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, AccountImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, AccountImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(AccountModelImpl.ENTITY_CACHE_ENABLED, AccountModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    }

    public void destroy() {
        EntityCacheUtil.removeCache(AccountImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

