/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermission;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.kernel.model.User"})
public class UserPermissionImpl
implements BaseModelPermissionChecker,
UserPermission {
    private static final Log _log = LogFactoryUtil.getLog(UserPermissionImpl.class);

    @Override
    public void check(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, organizationIds, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, User.class.getName(), userId, actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, long userId, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, User.class.getName(), userId, actionId);
        }
    }

    @Override
    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        List<Organization> organizations = OrganizationLocalServiceUtil.getUserOrganizations(primaryKey);
        long[] organizationsIds = new long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            organizationsIds[i] = organization.getOrganizationId();
        }
        this.check(permissionChecker, primaryKey, organizationsIds, actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) {
        try {
            User user = null;
            if (userId != -1L) {
                user = UserLocalServiceUtil.getUserById(userId);
                if (!actionId.equals("VIEW") && !permissionChecker.isOmniadmin() && PortalUtil.isOmniadmin(user)) {
                    return false;
                }
                Contact contact = user.getContact();
                if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), User.class.getName(), userId, contact.getUserId(), actionId) || permissionChecker.getUserId() == userId) {
                    return true;
                }
                if (permissionChecker.hasPermission(null, User.class.getName(), userId, actionId)) {
                    return true;
                }
            } else if (permissionChecker.hasPermission(null, User.class.getName(), User.class.getName(), actionId)) {
                return true;
            }
            if (user == null) {
                return false;
            }
            if (organizationIds == null) {
                organizationIds = user.getOrganizationIds();
            }
            for (long organizationId : organizationIds) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
                if (!OrganizationPermissionUtil.contains(permissionChecker, organization, "MANAGE_USERS")) continue;
                if (permissionChecker.getUserId() == user.getUserId()) {
                    return true;
                }
                for (Organization curOrganization = organization; curOrganization != null; curOrganization = curOrganization.getParentOrganization()) {
                    if (UserGroupRoleLocalServiceUtil.hasUserGroupRole(permissionChecker.getUserId(), curOrganization.getGroupId(), "Organization Owner", true)) {
                        return true;
                    }
                    if (!UserGroupRoleLocalServiceUtil.hasUserGroupRole(permissionChecker.getUserId(), curOrganization.getGroupId(), "Organization Administrator", true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole(user.getUserId(), organization.getGroupId(), "Organization Administrator", true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole(user.getUserId(), organization.getGroupId(), "Organization Owner", true)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long userId, String actionId) {
        return this.contains(permissionChecker, userId, null, actionId);
    }
}

