/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermission;

public class TeamPermissionImpl
implements TeamPermission {
    @Override
    public void check(PermissionChecker permissionChecker, long teamId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, teamId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), teamId, actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, Team team, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, team, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), team.getTeamId(), actionId);
        }
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long teamId, String actionId) throws PortalException {
        Team team = TeamLocalServiceUtil.getTeam(teamId);
        return this.contains(permissionChecker, team, actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, Team team, String actionId) throws PortalException {
        Boolean hasPermission = StagingPermissionUtil.hasPermission(permissionChecker, team.getGroupId(), Team.class.getName(), team.getTeamId(), "", actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (GroupPermissionUtil.contains(permissionChecker, team.getGroupId(), "MANAGE_TEAMS")) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(team.getCompanyId(), Team.class.getName(), team.getTeamId(), team.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(team.getGroupId(), Team.class.getName(), team.getTeamId(), actionId);
    }
}

