/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutSetBranchPermission;

public class LayoutSetBranchPermissionImpl
implements LayoutSetBranchPermission {
    @Override
    public void check(PermissionChecker permissionChecker, LayoutSetBranch layoutSetBranch, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layoutSetBranch, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, LayoutSetBranch.class.getName(), layoutSetBranch.getLayoutSetBranchId(), actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, long layoutSetBranchId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layoutSetBranchId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, LayoutSetBranch.class.getName(), layoutSetBranchId, actionId);
        }
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, LayoutSetBranch layoutSetBranch, String actionId) {
        return permissionChecker.hasPermission(layoutSetBranch.getGroupId(), LayoutSetBranch.class.getName(), layoutSetBranch.getLayoutSetBranchId(), actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long layoutSetBranchId, String actionId) throws PortalException {
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch(layoutSetBranchId);
        return this.contains(permissionChecker, layoutSetBranch, actionId);
    }
}

