/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.kernel.model.Layout"})
public class LayoutPermissionImpl
implements BaseModelPermissionChecker,
LayoutPermission {
    @Override
    public void check(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layout, checkViewableGroup, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getLayoutId(), actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layout, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getLayoutId(), actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, privateLayout, layoutId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layoutId, actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
        this.check(permissionChecker, layout, actionId);
    }

    @Override
    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, primaryKey, actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        CacheKey cacheKey;
        Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(cacheKey = new CacheKey(layout.getPlid(), layout.getMvccVersion(), checkViewableGroup, actionId));
        if (contains == null) {
            contains = this._contains(permissionChecker, layout, checkViewableGroup, actionId);
            permissionChecksMap.put(cacheKey, contains);
        }
        return contains;
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, false, actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout(groupId, privateLayout, layoutId);
        return this.contains(permissionChecker, layout, actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
        return this.contains(permissionChecker, layout, actionId);
    }

    @Override
    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkLayoutUpdateable, String actionId) throws PortalException {
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (checkLayoutUpdateable && !actionId.equals("CUSTOMIZE") && !actionId.equals("VIEW") && layout instanceof VirtualLayout) {
            return false;
        }
        if (actionId.equals("CUSTOMIZE") && layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = (Layout)virtualLayout.getWrappedModel();
        }
        if (actionId.equals("ADD_LAYOUT")) {
            if (!SitesUtil.isLayoutSortable(layout)) {
                return false;
            }
            LayoutType layoutType = layout.getLayoutType();
            if (!layoutType.isParentable()) {
                return false;
            }
        }
        if (actionId.equals("DELETE") && !SitesUtil.isLayoutDeleteable(layout)) {
            return false;
        }
        Group group = layout.getGroup();
        if (checkLayoutUpdateable && !group.isLayoutSetPrototype() && this.isAttemptToModifyLockedLayout(layout, actionId)) {
            return false;
        }
        if (actionId.equals("ADD_LAYOUT") && GroupPermissionUtil.contains(permissionChecker, group, "ADD_LAYOUT")) {
            return true;
        }
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !actionId.equals("VIEW")) {
            long layoutGroupId = layout.getGroupId();
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                layoutGroupId = virtualLayout.getSourceGroupId();
            }
            long parentLayoutId = layout.getParentLayoutId();
            while (parentLayoutId != 0L) {
                Layout parentLayout = LayoutLocalServiceUtil.getLayout(layoutGroupId, layout.isPrivateLayout(), parentLayoutId);
                if (this.contains(permissionChecker, parentLayout, actionId)) {
                    return true;
                }
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        if (permissionChecker.hasPermission(group, Layout.class.getName(), layout.getPlid(), actionId)) {
            return true;
        }
        if (GroupPermissionUtil.contains(permissionChecker, group, "MANAGE_LAYOUTS")) {
            return true;
        }
        User user = permissionChecker.getUser();
        if (!user.isDefaultUser() && !group.isUser()) {
            ResourcePermission resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission(layout.getCompanyId(), Layout.class.getName(), 4, String.valueOf(layout.getPlid()), permissionChecker.getOwnerRoleId());
            if (permissionChecker.hasOwnerPermission(layout.getCompanyId(), Layout.class.getName(), String.valueOf(layout.getPlid()), resourcePermission.getOwnerId(), actionId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        return this.containsWithoutViewableGroup(permissionChecker, layout, true, actionId);
    }

    protected boolean containsWithViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (actionId.equals("VIEW") && checkViewableGroup) {
            return this.isViewableGroup(permissionChecker, layout, checkViewableGroup);
        }
        return this.containsWithoutViewableGroup(permissionChecker, layout, actionId);
    }

    protected boolean isAttemptToModifyLockedLayout(Layout layout, String actionId) {
        return ("CUSTOMIZE".equals(actionId) || "UPDATE".equals(actionId)) && !SitesUtil.isLayoutUpdateable(layout);
    }

    protected boolean isViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkResourcePermission) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup(layout.getGroupId());
        if (group.isControlPanel() && layout.isTypeControlPanel()) {
            return permissionChecker.isSignedIn();
        }
        if (!GroupLocalServiceUtil.isLiveGroupActive(group)) {
            return false;
        }
        if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (groupUserId == permissionChecker.getUserId()) {
                return true;
            }
            User groupUser = UserLocalServiceUtil.getUserById(groupUserId);
            if (!groupUser.isActive()) {
                return false;
            }
            if (layout.isPrivateLayout()) {
                return GroupPermissionUtil.contains(permissionChecker, group, "MANAGE_LAYOUTS") || UserPermissionUtil.contains(permissionChecker, groupUserId, groupUser.getOrganizationIds(), "UPDATE");
            }
        }
        if (group.isStagingGroup()) {
            return GroupPermissionUtil.contains(permissionChecker, group, "VIEW_STAGING");
        }
        if (group.isSite()) {
            if (GroupPermissionUtil.contains(permissionChecker, group, "MANAGE_LAYOUTS") || GroupPermissionUtil.contains(permissionChecker, group, "UPDATE")) {
                return true;
            }
            if (layout.isPrivateLayout() && !permissionChecker.isGroupMember(group.getGroupId())) {
                return false;
            }
        }
        if (group.isCompany()) {
            return false;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains(permissionChecker, group.getClassPK(), "VIEW");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains(permissionChecker, group.getClassPK(), "VIEW");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            if (OrganizationLocalServiceUtil.hasUserOrganization(permissionChecker.getUserId(), organizationId, false, false)) {
                return true;
            }
            if (OrganizationPermissionUtil.contains(permissionChecker, organizationId, "UPDATE")) {
                return true;
            }
            if (!PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
                List<Organization> userOrgs = OrganizationLocalServiceUtil.getUserOrganizations(permissionChecker.getUserId());
                for (Organization organization : userOrgs) {
                    for (Organization ancestorOrganization : organization.getAncestors()) {
                        if (organizationId != ancestorOrganization.getOrganizationId()) continue;
                        return true;
                    }
                }
            }
        } else if (group.isUserGroup() && UserGroupPermissionUtil.contains(permissionChecker, group.getClassPK(), "UPDATE")) {
            return true;
        }
        if (this.containsWithoutViewableGroup(permissionChecker, layout, "VIEW")) {
            return true;
        }
        List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(layout.getGroupId(), layout.isPrivateLayout(), 0L);
        for (Layout curLayout : layouts) {
            if (!this.containsWithoutViewableGroup(permissionChecker, curLayout, "VIEW") || curLayout.isHidden()) continue;
            return true;
        }
        return false;
    }

    private boolean _contains(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        LayoutTypeController layoutTypeController;
        if (actionId.equals("VIEW") && !(layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType())).isCheckLayoutViewPermission()) {
            return true;
        }
        if (actionId.equals("CUSTOMIZE") && layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = (Layout)virtualLayout.getWrappedModel();
        }
        if (this.isAttemptToModifyLockedLayout(layout, actionId)) {
            return false;
        }
        Group group = layout.getGroup();
        if (group.hasLocalOrRemoteStagingGroup()) {
            Boolean hasPermission = StagingPermissionUtil.hasPermission(permissionChecker, group, Layout.class.getName(), layout.getGroupId(), null, actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
        } else if (!checkViewableGroup && group.isUserGroup() && actionId.equals("VIEW")) {
            if (permissionChecker.isGroupAdmin(group.getGroupId())) {
                return true;
            }
            try {
                UserBag userBag = permissionChecker.getUserBag();
                if (userBag == null) {
                    return UserGroupLocalServiceUtil.hasUserUserGroup(permissionChecker.getUserId(), group.getClassPK());
                }
                return Arrays.binarySearch(userBag.getUserUserGroupsIds(), group.getClassPK()) >= 0;
            }
            catch (PortalException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
        }
        return this.containsWithViewableGroup(permissionChecker, layout, checkViewableGroup, actionId);
    }

    private static class CacheKey {
        private final String _actionId;
        private final boolean _checkViewableGroup;
        private final long _mvccVersion;
        private final long _plid;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this._plid == cacheKey._plid && this._mvccVersion == cacheKey._mvccVersion && this._checkViewableGroup == cacheKey._checkViewableGroup && Objects.equals(this._actionId, cacheKey._actionId);
        }

        public int hashCode() {
            int hash = HashUtil.hash(0, this._plid);
            hash = HashUtil.hash(hash, this._mvccVersion);
            hash = HashUtil.hash(hash, this._checkViewableGroup);
            return HashUtil.hash(hash, this._actionId);
        }

        private CacheKey(long plid, long mvccVersion, boolean checkViewableGroup, String actionId) {
            this._plid = plid;
            this._mvccVersion = mvccVersion;
            this._checkViewableGroup = checkViewableGroup;
            this._actionId = actionId;
        }
    }
}

