/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermission;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.Objects;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.kernel.model.Group"})
public class GroupPermissionImpl
implements BaseModelPermissionChecker,
GroupPermission {
    @Override
    public void check(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, group, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), group.getGroupId(), actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), groupId, actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), 0L, actionId);
        }
    }

    @Override
    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, primaryKey, actionId);
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException {
        CacheKey cacheKey;
        Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
        Boolean contains = (Boolean)permissionChecksMap.get(cacheKey = new CacheKey(group.getGroupId(), group.getMvccVersion(), actionId));
        if (contains == null) {
            contains = this._contains(permissionChecker, group, actionId);
            permissionChecksMap.put(cacheKey, contains);
        }
        return contains;
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (groupId > 0L) {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            return this.contains(permissionChecker, group, actionId);
        }
        return false;
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, String actionId) {
        return permissionChecker.hasPermission(null, Group.class.getName(), Group.class.getName(), actionId);
    }

    private boolean _contains(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException {
        if ((actionId.equals("ADD_LAYOUT") || actionId.equals("MANAGE_LAYOUTS")) && (group.hasLocalOrRemoteStagingGroup() && PropsValues.STAGING_LIVE_GROUP_LOCKING_ENABLED || group.isLayoutPrototype())) {
            return false;
        }
        Group originalGroup = group;
        long groupId = group.getGroupId();
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isUser()) {
            User user = UserLocalServiceUtil.getUserById(group.getClassPK());
            if (permissionChecker.getUserId() != user.getUserId() && UserPermissionUtil.contains(permissionChecker, user.getUserId(), user.getOrganizationIds(), "UPDATE")) {
                return true;
            }
        }
        if (actionId.equals("ADD_COMMUNITY") && (permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "MANAGE_SUBGROUPS") || PortalPermissionUtil.contains(permissionChecker, "ADD_COMMUNITY"))) {
            return true;
        }
        if (actionId.equals("ADD_LAYOUT") && permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "MANAGE_LAYOUTS")) {
            return true;
        }
        if ((actionId.equals("EXPORT_IMPORT_LAYOUTS") || actionId.equals("EXPORT_IMPORT_PORTLET_INFO") || actionId.equals("PUBLISH_PORTLET_INFO")) && permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "PUBLISH_STAGING")) {
            return true;
        }
        if (actionId.equals("VIEW") && (permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "ASSIGN_USER_ROLES") || permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "MANAGE_LAYOUTS") || permissionChecker.isGroupMember(originalGroup.getGroupId()))) {
            return true;
        }
        if (actionId.equals("VIEW_STAGING") && (permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "MANAGE_LAYOUTS") || permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "MANAGE_STAGING") || permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "PUBLISH_STAGING") || permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, "UPDATE"))) {
            return true;
        }
        if (permissionChecker.hasPermission(originalGroup, Group.class.getName(), groupId, actionId)) {
            return true;
        }
        while (!group.isRoot()) {
            if (this.contains(permissionChecker, group.getParentGroupId(), "MANAGE_SUBGROUPS")) {
                return true;
            }
            group = group.getParentGroup();
        }
        return false;
    }

    private static class CacheKey {
        private final String _actionId;
        private final long _groupId;
        private final long _mvccVersion;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this._groupId == cacheKey._groupId && this._mvccVersion == cacheKey._mvccVersion && Objects.equals(this._actionId, cacheKey._actionId);
        }

        public int hashCode() {
            int hash = HashUtil.hash(0, this._groupId);
            hash = HashUtil.hash(hash, this._mvccVersion);
            return HashUtil.hash(hash, this._actionId);
        }

        private CacheKey(long groupId, long mvccVersion, String actionId) {
            this._groupId = groupId;
            this._mvccVersion = mvccVersion;
            this._actionId = actionId;
        }
    }
}

