/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.service.base.WorkflowDefinitionLinkLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

public class WorkflowDefinitionLinkLocalServiceImpl
extends WorkflowDefinitionLinkLocalServiceBaseImpl {
    @Override
    public WorkflowDefinitionLink addWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long workflowDefinitionLinkId = this.counterLocalService.increment();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.create(workflowDefinitionLinkId);
        workflowDefinitionLink.setGroupId(StagingUtil.getLiveGroupId(groupId));
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setClassNameId(this.classNameLocalService.getClassNameId(className));
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update(workflowDefinitionLink);
        return workflowDefinitionLink;
    }

    @Override
    public void deleteWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, true);
        if (workflowDefinitionLink != null) {
            this.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
    }

    @Override
    public WorkflowDefinitionLink fetchDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        return this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
    }

    @Override
    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        return this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    @Override
    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(StagingUtil.getLiveGroupId(groupId), companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
        if (!strict && workflowDefinitionLink == null) {
            workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
        }
        return workflowDefinitionLink;
    }

    @Override
    public List<WorkflowDefinitionLink> fetchWorkflowDefinitionLinks(long companyId, long groupId, String className, long classPK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return Collections.emptyList();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C(StagingUtil.getLiveGroupId(groupId), companyId, this.classNameLocalService.getClassNameId(className), classPK);
    }

    @Override
    public WorkflowDefinitionLink getDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C_T(0L, companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
    }

    @Override
    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException {
        return this.getWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    @Override
    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, strict);
        if (workflowDefinitionLink == null) {
            throw new NoSuchWorkflowDefinitionLinkException(StringBundler.concat("No workflow exists with the key {groupId=", StagingUtil.getLiveGroupId(groupId), ", companyId=", companyId, ", and className=", className, "}"));
        }
        return workflowDefinitionLink;
    }

    @Override
    public List<WorkflowDefinitionLink> getWorkflowDefinitionLinks(long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C(companyId, StagingUtil.getLiveGroupId(groupId), this.classNameLocalService.getClassNameId(className), classPK);
    }

    @Override
    public List<WorkflowDefinitionLink> getWorkflowDefinitionLinks(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    @Override
    public int getWorkflowDefinitionLinksCount(long companyId, long groupId, String className) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByG_C_C(StagingUtil.getLiveGroupId(groupId), companyId, this.classNameLocalService.getClassNameId(className));
    }

    @Override
    public int getWorkflowDefinitionLinksCount(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    @Override
    @Transactional(enabled=false)
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        int count = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinksCount(companyId, groupId, className);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinksCount(companyId, 0L, className);
        return count > 0;
    }

    @Override
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        int count = this.workflowDefinitionLinkPersistence.countByG_C_C_C(StagingUtil.getLiveGroupId(groupId), companyId, this.classNameLocalService.getClassNameId(className), classPK);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkPersistence.countByG_C_C_C(0L, companyId, this.classNameLocalService.getClassNameId(className), classPK);
        return count > 0;
    }

    @Override
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        int count = this.workflowDefinitionLinkPersistence.countByG_C_C_C_T(StagingUtil.getLiveGroupId(groupId), companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
        if (count > 0) {
            return true;
        }
        count = this.workflowDefinitionLinkPersistence.countByG_C_C_C_T(0L, companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
        return count > 0;
    }

    @Override
    public void updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinition) throws PortalException {
        if (Validator.isNull(workflowDefinition)) {
            this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
        } else {
            String[] workflowDefinitionParts = StringUtil.split(workflowDefinition, '@');
            String workflowDefinitionName = workflowDefinitionParts[0];
            int workflowDefinitionVersion = GetterUtil.getInteger(workflowDefinitionParts[1]);
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
    }

    @Override
    public WorkflowDefinitionLink updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(StagingUtil.getLiveGroupId(groupId), companyId, this.classNameLocalService.getClassNameId(className), classPK, typePK);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this.addWorkflowDefinitionLink(userId, companyId, StagingUtil.getLiveGroupId(groupId), className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
        workflowDefinitionLink.setGroupId(StagingUtil.getLiveGroupId(groupId));
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setClassNameId(this.classNameLocalService.getClassNameId(className));
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update(workflowDefinitionLink);
        return workflowDefinitionLink;
    }

    @Override
    public void updateWorkflowDefinitionLinks(long userId, long companyId, long groupId, String className, long classPK, List<ObjectValuePair<Long, String>> workflowDefinitionOVPs) throws PortalException {
        for (ObjectValuePair<Long, String> workflowDefinitionOVP : workflowDefinitionOVPs) {
            long typePK = workflowDefinitionOVP.getKey();
            String workflowDefinitionName = workflowDefinitionOVP.getValue();
            if (Validator.isNull(workflowDefinitionName)) {
                this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
                continue;
            }
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName);
        }
    }
}

