/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.CommonPermissionUtil;
import com.liferay.portal.service.base.WebsiteServiceBaseImpl;
import java.util.List;

public class WebsiteServiceImpl
extends WebsiteServiceBaseImpl {
    @Override
    public Website addWebsite(String className, long classPK, String url, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.websiteLocalService.addWebsite(this.getUserId(), className, classPK, url, typeId, primary, serviceContext);
    }

    @Override
    public void deleteWebsite(long websiteId) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), "UPDATE");
        this.websiteLocalService.deleteWebsite(website);
    }

    @Override
    public Website getWebsite(long websiteId) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), "VIEW");
        return website;
    }

    @Override
    public List<Website> getWebsites(String className, long classPK) throws PortalException {
        CommonPermissionUtil.check(this.getPermissionChecker(), className, classPK, "VIEW");
        User user = this.getUser();
        return this.websiteLocalService.getWebsites(user.getCompanyId(), className, classPK);
    }

    @Override
    public Website updateWebsite(long websiteId, String url, long typeId, boolean primary) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        CommonPermissionUtil.check(this.getPermissionChecker(), website.getClassNameId(), website.getClassPK(), "UPDATE");
        return this.websiteLocalService.updateWebsite(websiteId, url, typeId, primary);
    }
}

