/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.WebsiteLocalServiceBaseImpl;
import java.util.List;

public class WebsiteLocalServiceImpl
extends WebsiteLocalServiceBaseImpl {
    @Override
    public Website addWebsite(long userId, String className, long classPK, String url, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, url, typeId, primary);
        long websiteId = this.counterLocalService.increment();
        Website website = this.websitePersistence.create(websiteId);
        website.setUuid(serviceContext.getUuid());
        website.setCompanyId(user.getCompanyId());
        website.setUserId(user.getUserId());
        website.setUserName(user.getFullName());
        website.setClassNameId(classNameId);
        website.setClassPK(classPK);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        this.websitePersistence.update(website);
        return website;
    }

    @Override
    public Website deleteWebsite(long websiteId) throws PortalException {
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        return this.websiteLocalService.deleteWebsite(website);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Website deleteWebsite(Website website) {
        this.websitePersistence.remove(website);
        return website;
    }

    @Override
    public void deleteWebsites(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List<Website> websites = this.websitePersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Website website : websites) {
            this.websiteLocalService.deleteWebsite(website);
        }
    }

    @Override
    public List<Website> getWebsites() {
        return this.websitePersistence.findAll();
    }

    @Override
    public List<Website> getWebsites(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.websitePersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    @Override
    public Website updateWebsite(long websiteId, String url, long typeId, boolean primary) throws PortalException {
        this.validate(websiteId, 0L, 0L, 0L, url, typeId, primary);
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        this.websitePersistence.update(website);
        return website;
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, boolean primary) {
        if (primary) {
            List<Website> websites = this.websitePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Website website : websites) {
                if (websiteId > 0L && website.getWebsiteId() == websiteId) continue;
                website.setPrimary(false);
                this.websitePersistence.update(website);
            }
        }
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, String url, long typeId, boolean primary) throws PortalException {
        if (!Validator.isUrl(url)) {
            throw new WebsiteURLException();
        }
        if (websiteId > 0L) {
            Website website = this.websitePersistence.findByPrimaryKey(websiteId);
            companyId = website.getCompanyId();
            classNameId = website.getClassNameId();
            classPK = website.getClassPK();
        }
        this.listTypeLocalService.validate(typeId, classNameId, ".website");
        this.validate(websiteId, companyId, classNameId, classPK, primary);
    }
}

