/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.service.base.WebDAVPropsLocalServiceBaseImpl;
import java.util.Date;

public class WebDAVPropsLocalServiceImpl
extends WebDAVPropsLocalServiceBaseImpl {
    @Override
    public void deleteWebDAVProps(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        WebDAVProps webDAVProps = this.webDAVPropsPersistence.fetchByC_C(classNameId, classPK);
        if (webDAVProps != null) {
            this.webDAVPropsPersistence.remove(webDAVProps);
        }
    }

    @Override
    public WebDAVProps getWebDAVProps(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        WebDAVProps webDAVProps = this.webDAVPropsPersistence.fetchByC_C(classNameId, classPK);
        if (webDAVProps == null) {
            webDAVProps = this.webDAVPropsPersistence.create(this.counterLocalService.increment());
            Date now = new Date();
            webDAVProps.setCompanyId(companyId);
            webDAVProps.setCreateDate(now);
            webDAVProps.setModifiedDate(now);
            webDAVProps.setClassNameId(classNameId);
            webDAVProps.setClassPK(classPK);
            this.webDAVPropsLocalService.updateWebDAVProps(webDAVProps);
        }
        return webDAVProps;
    }

    @Override
    public void storeWebDAVProps(WebDAVProps webDAVProps) throws PortalException {
        try {
            webDAVProps.store();
        }
        catch (Exception e) {
            throw new WebDAVException("Problem trying to store WebDAVProps", e);
        }
        this.webDAVPropsPersistence.update(webDAVProps);
    }
}

