/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.model.impl.LayoutSetModelImpl;
import com.liferay.portal.service.base.VirtualHostLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.Callable;

public class VirtualHostLocalServiceImpl
extends VirtualHostLocalServiceBaseImpl {
    @Override
    public VirtualHost fetchVirtualHost(long companyId, long layoutSetId) {
        return this.virtualHostPersistence.fetchByC_L(companyId, layoutSetId);
    }

    @Override
    public VirtualHost fetchVirtualHost(String hostname) {
        return this.virtualHostPersistence.fetchByHostname(hostname);
    }

    @Override
    public VirtualHost getVirtualHost(long companyId, long layoutSetId) throws PortalException {
        return this.virtualHostPersistence.findByC_L(companyId, layoutSetId);
    }

    @Override
    public VirtualHost getVirtualHost(String hostname) throws PortalException {
        return this.virtualHostPersistence.findByHostname(hostname);
    }

    @Override
    public VirtualHost updateVirtualHost(long companyId, final long layoutSetId, String hostname) {
        Group group;
        LayoutSet layoutSet;
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByC_L(companyId, layoutSetId);
        if (virtualHost == null) {
            long virtualHostId = this.counterLocalService.increment();
            virtualHost = this.virtualHostPersistence.create(virtualHostId);
            virtualHost.setCompanyId(companyId);
            virtualHost.setLayoutSetId(layoutSetId);
        }
        virtualHost.setHostname(hostname);
        this.virtualHostPersistence.update(virtualHost);
        final Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company != null) {
            TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    EntityCacheUtil.removeResult(company.isEntityCacheEnabled(), company.getClass(), company.getPrimaryKeyObj());
                    return null;
                }
            });
            this.companyPersistence.clearCache(company);
        }
        if ((layoutSet = this.layoutSetPersistence.fetchByPrimaryKey(layoutSetId)) == null && Validator.isNotNull(PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && (group = this.groupPersistence.fetchByC_GK(companyId, PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) != null) {
            layoutSet = this.layoutSetPersistence.fetchByG_P_Head(group.getGroupId(), false, false);
        }
        if (layoutSet != null) {
            this.layoutSetPersistence.clearCache(layoutSet);
            TransactionCommitCallbackUtil.registerCallback(new Callable<Void>(){

                @Override
                public Void call() {
                    EntityCacheUtil.removeResult(LayoutSetModelImpl.ENTITY_CACHE_ENABLED, LayoutSetImpl.class, Long.valueOf(layoutSetId));
                    return null;
                }
            });
        }
        return virtualHost;
    }
}

