/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserFieldException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.comparator.UserIdComparator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.base.UserServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UserServiceImpl
extends UserServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(UserServiceImpl.class);

    @Override
    public void addGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains(permissionChecker, groupId, "ASSIGN_MEMBERS")) {
            User user;
            boolean hasPermission = false;
            if (userIds.length == 1 && (user = this.getUser()).getUserId() == userIds[0]) {
                int type;
                Group group = this.groupPersistence.findByPrimaryKey(groupId);
                if (user.getCompanyId() == group.getCompanyId() && (type = group.getType()) == 1) {
                    hasPermission = true;
                }
            }
            if (!hasPermission) {
                throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), groupId, "ASSIGN_MEMBERS");
            }
        }
        SiteMembershipPolicyUtil.checkMembership(userIds, new long[]{groupId}, null);
        this.userLocalService.addGroupUsers(groupId, userIds);
        SiteMembershipPolicyUtil.propagateMembership(userIds, new long[]{groupId}, null);
    }

    @Override
    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "ASSIGN_MEMBERS");
        this.validateOrganizationUsers(userIds);
        OrganizationMembershipPolicyUtil.checkMembership(userIds, new long[]{organizationId}, null);
        this.userLocalService.addOrganizationUsers(organizationId, userIds);
        OrganizationMembershipPolicyUtil.propagateMembership(userIds, new long[]{organizationId}, null);
    }

    @Override
    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        PasswordPolicyPermissionUtil.check(this.getPermissionChecker(), passwordPolicyId, "ASSIGN_MEMBERS");
        this.userLocalService.addPasswordPolicyUsers(passwordPolicyId, userIds);
    }

    @Override
    public void addRoleUsers(long roleId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        RolePermissionUtil.check(this.getPermissionChecker(), roleId, "ASSIGN_MEMBERS");
        RoleMembershipPolicyUtil.checkRoles(userIds, new long[]{roleId}, null);
        this.userLocalService.addRoleUsers(roleId, userIds);
        RoleMembershipPolicyUtil.propagateRoles(userIds, new long[]{roleId}, null);
    }

    @Override
    public void addTeamUsers(long teamId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        TeamPermissionUtil.check(this.getPermissionChecker(), teamId, "ASSIGN_MEMBERS");
        this.userLocalService.addTeamUsers(teamId, userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled(false);
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled(false);
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, addresses, emailAddresses, phones, websites, announcementsDelivers, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled(workflowEnabled);
        }
    }

    @Override
    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "ASSIGN_MEMBERS");
        UserGroupMembershipPolicyUtil.checkMembership(userIds, new long[]{userGroupId}, null);
        this.userLocalService.addUserGroupUsers(userGroupId, userIds);
        UserGroupMembershipPolicyUtil.propagateMembership(userIds, new long[]{userGroupId}, null);
    }

    @Override
    public User addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        long creatorUserId;
        block2: {
            creatorUserId = 0L;
            try {
                creatorUserId = this.getGuestOrUserId();
            }
            catch (PrincipalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Unable to get guest or current user ID", pe);
            }
        }
        this.checkAddUserPermission(creatorUserId, companyId, emailAddress, groupIds, organizationIds, roleIds, userGroupIds, serviceContext);
        User user = this.userLocalService.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        this.checkMembership(new long[]{user.getUserId()}, groupIds, organizationIds, roleIds, userGroupIds);
        this.propagateMembership(new long[]{user.getUserId()}, groupIds, organizationIds, roleIds, userGroupIds);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean indexingEnabled = true;
        if (serviceContext != null) {
            indexingEnabled = serviceContext.isIndexingEnabled();
            serviceContext.setIndexingEnabled(false);
        }
        try {
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            UsersAdminUtil.updateAddresses(Contact.class.getName(), user.getContactId(), addresses);
            UsersAdminUtil.updateEmailAddresses(Contact.class.getName(), user.getContactId(), emailAddresses);
            UsersAdminUtil.updatePhones(Contact.class.getName(), user.getContactId(), phones);
            UsersAdminUtil.updateWebsites(Contact.class.getName(), user.getContactId(), websites);
            this.updateAnnouncementsDeliveries(user.getUserId(), announcementsDelivers);
            if (indexingEnabled) {
                Indexer<User> indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex(user);
            }
            User user2 = user;
            return user2;
        }
        finally {
            if (serviceContext != null) {
                serviceContext.setIndexingEnabled(indexingEnabled);
            }
        }
    }

    @Override
    public void deletePortrait(long userId) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        this.userLocalService.deletePortrait(userId);
    }

    @Override
    public void deleteRoleUser(long roleId, long userId) throws PortalException {
        RolePermissionUtil.check(this.getPermissionChecker(), roleId, "ASSIGN_MEMBERS");
        this.userLocalService.deleteRoleUser(roleId, userId);
    }

    @Override
    public void deleteUser(long userId) throws PortalException {
        if (this.getUserId() == userId) {
            throw new RequiredUserException();
        }
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "DELETE");
        this.userLocalService.deleteUser(userId);
    }

    @Override
    public List<User> getCompanyUsers(long companyId, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userPersistence.findByCompanyId(companyId, start, end);
    }

    @Override
    public int getCompanyUsersCount(long companyId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userPersistence.countByCompanyId(companyId);
    }

    @Override
    public User getCurrentUser() throws PortalException {
        return this.getUser();
    }

    @Override
    public long[] getGroupUserIds(long groupId) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "VIEW_MEMBERS");
        return this.userLocalService.getGroupUserIds(groupId);
    }

    @Override
    public List<User> getGroupUsers(long groupId) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "VIEW_MEMBERS");
        return this.userLocalService.getGroupUsers(groupId);
    }

    @Override
    public List<User> getGroupUsers(long groupId, int status, int start, int end, OrderByComparator<User> obc) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "VIEW_MEMBERS");
        return this.userLocalService.getGroupUsers(groupId, status, start, end, obc);
    }

    @Override
    public List<User> getGroupUsers(long groupId, int status, OrderByComparator<User> obc) throws PortalException {
        return this.getGroupUsers(groupId, status, -1, -1, obc);
    }

    @Override
    public int getGroupUsersCount(long groupId, int status) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "VIEW");
        return this.userLocalService.getGroupUsersCount(groupId, status);
    }

    @Override
    public List<User> getGtCompanyUsers(long gtUserId, long companyId, int size) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userPersistence.findByU_C(gtUserId, companyId, 0, size, new UserIdComparator(true));
    }

    @Override
    public List<User> getGtOrganizationUsers(long gtUserId, long organizationId, int size) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(organization.getCompanyId())) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userFinder.findByUsersOrgsGtUserId(organization.getCompanyId(), organizationId, gtUserId, size);
    }

    @Override
    public List<User> getGtUserGroupUsers(long gtUserId, long userGroupId, int size) throws PortalException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(userGroup.getCompanyId())) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userFinder.findByUsersUserGroupsGtUserId(userGroup.getCompanyId(), userGroupId, gtUserId, size);
    }

    @Override
    public int getOrganizationsAndUserGroupsUsersCount(long[] organizationIds, long[] userGroupIds) throws PrincipalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userLocalService.getOrganizationsAndUserGroupsUsersCount(organizationIds, userGroupIds);
    }

    @Override
    public long[] getOrganizationUserIds(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUserIds(organizationId);
    }

    @Override
    public List<User> getOrganizationUsers(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUsers(organizationId);
    }

    @Override
    public List<User> getOrganizationUsers(long organizationId, int status, int start, int end, OrderByComparator<User> obc) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUsers(organizationId, status, start, end, obc);
    }

    @Override
    public List<User> getOrganizationUsers(long organizationId, int status, OrderByComparator<User> obc) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUsers(organizationId, status, obc);
    }

    @Override
    public int getOrganizationUsersCount(long organizationId, int status) throws PortalException {
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "VIEW");
        return this.userLocalService.getOrganizationUsersCount(organizationId, status);
    }

    @Override
    public long[] getRoleUserIds(long roleId) throws PortalException {
        RolePermissionUtil.check(this.getPermissionChecker(), roleId, "VIEW");
        return this.userLocalService.getRoleUserIds(roleId);
    }

    @Override
    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.userLocalService.getUserByEmailAddress(companyId, emailAddress);
        UserPermissionUtil.check(this.getPermissionChecker(), user.getUserId(), "VIEW");
        return user;
    }

    @Override
    public User getUserById(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        UserPermissionUtil.check(this.getPermissionChecker(), user.getUserId(), "VIEW");
        return user;
    }

    @Override
    public User getUserByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.userLocalService.getUserByScreenName(companyId, screenName);
        UserPermissionUtil.check(this.getPermissionChecker(), user.getUserId(), "VIEW");
        return user;
    }

    @Override
    public List<User> getUserGroupUsers(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW_MEMBERS");
        return this.userGroupPersistence.getUsers(userGroupId);
    }

    @Override
    public List<User> getUserGroupUsers(long userGroupId, int start, int end) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW_MEMBERS");
        return this.userLocalService.getUserGroupUsers(userGroupId, start, end);
    }

    @Override
    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        UserPermissionUtil.check(this.getPermissionChecker(), user.getUserId(), "VIEW");
        return user.getUserId();
    }

    @Override
    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.getUserByScreenName(companyId, screenName);
        UserPermissionUtil.check(this.getPermissionChecker(), user.getUserId(), "VIEW");
        return user.getUserId();
    }

    @Override
    public boolean hasGroupUser(long groupId, long userId) throws PortalException {
        if (!UserPermissionUtil.contains(this.getPermissionChecker(), userId, "VIEW")) {
            GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "VIEW_MEMBERS");
        }
        return this.userLocalService.hasGroupUser(groupId, userId);
    }

    @Override
    public boolean hasRoleUser(long roleId, long userId) throws PortalException {
        if (!UserPermissionUtil.contains(this.getPermissionChecker(), userId, "VIEW")) {
            RolePermissionUtil.check(this.getPermissionChecker(), roleId, "VIEW_MEMBERS");
        }
        return this.userLocalService.hasRoleUser(roleId, userId);
    }

    @Override
    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException {
        if (!UserPermissionUtil.contains(this.getPermissionChecker(), userId, "VIEW")) {
            Role role = this.roleLocalService.getRole(companyId, name);
            RolePermissionUtil.check(this.getPermissionChecker(), role.getRoleId(), "VIEW_MEMBERS");
        }
        return this.userLocalService.hasRoleUser(companyId, name, userId, inherited);
    }

    @Override
    public boolean sendPasswordByEmailAddress(long companyId, String emailAddress) throws PortalException {
        return this.userLocalService.sendPasswordByEmailAddress(companyId, emailAddress);
    }

    @Override
    public boolean sendPasswordByScreenName(long companyId, String screenName) throws PortalException {
        return this.userLocalService.sendPasswordByScreenName(companyId, screenName);
    }

    @Override
    public boolean sendPasswordByUserId(long userId) throws PortalException {
        return this.userLocalService.sendPasswordByUserId(userId);
    }

    @Override
    public void setRoleUsers(long roleId, long[] userIds) throws PortalException {
        RolePermissionUtil.check(this.getPermissionChecker(), roleId, "ASSIGN_MEMBERS");
        Set<Long> unsetUserIds = SetUtil.fromArray(this.rolePersistence.getUserPrimaryKeys(roleId));
        unsetUserIds.removeAll(SetUtil.fromArray(userIds));
        if (!unsetUserIds.isEmpty()) {
            RoleMembershipPolicyUtil.checkRoles(ArrayUtil.toLongArray(unsetUserIds), null, new long[]{roleId});
        }
        if (userIds.length > 0) {
            RoleMembershipPolicyUtil.checkRoles(userIds, new long[]{roleId}, null);
        }
        this.userLocalService.setRoleUsers(roleId, userIds);
        if (!unsetUserIds.isEmpty()) {
            RoleMembershipPolicyUtil.propagateRoles(ArrayUtil.toLongArray(unsetUserIds), null, new long[]{roleId});
        }
        if (userIds.length > 0) {
            RoleMembershipPolicyUtil.propagateRoles(userIds, new long[]{roleId}, null);
        }
    }

    @Override
    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "ASSIGN_MEMBERS");
        Set<Long> unsetUserIds = SetUtil.fromArray(this.userGroupPersistence.getUserPrimaryKeys(userGroupId));
        unsetUserIds.removeAll(SetUtil.fromArray(userIds));
        if (!unsetUserIds.isEmpty()) {
            UserGroupMembershipPolicyUtil.checkMembership(ArrayUtil.toLongArray(unsetUserIds), null, new long[]{userGroupId});
        }
        if (userIds.length > 0) {
            UserGroupMembershipPolicyUtil.checkMembership(userIds, new long[]{userGroupId}, null);
        }
        this.userLocalService.setUserGroupUsers(userGroupId, userIds);
        if (!unsetUserIds.isEmpty()) {
            UserGroupMembershipPolicyUtil.propagateMembership(ArrayUtil.toLongArray(unsetUserIds), null, new long[]{userGroupId});
        }
        if (userIds.length > 0) {
            UserGroupMembershipPolicyUtil.propagateMembership(userIds, new long[]{userGroupId}, null);
        }
    }

    @Override
    public void unsetGroupTeamsUsers(long groupId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        UserGroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.userLocalService.unsetGroupTeamsUsers(groupId, userIds);
    }

    @Override
    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException {
        userIds = UsersAdminUtil.filterUnsetGroupUserIds(this.getPermissionChecker(), groupId, userIds);
        if (userIds.length == 0) {
            return;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains(permissionChecker, groupId, "ASSIGN_MEMBERS")) {
            User user;
            boolean hasPermission = false;
            if (userIds.length == 1 && (user = this.getUser()).getUserId() == userIds[0]) {
                int type;
                Group group = this.groupPersistence.findByPrimaryKey(groupId);
                if (user.getCompanyId() == group.getCompanyId() && ((type = group.getType()) == 1 || type == 2)) {
                    hasPermission = true;
                }
            }
            if (!hasPermission) {
                throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), groupId, "ASSIGN_MEMBERS");
            }
        }
        SiteMembershipPolicyUtil.checkMembership(userIds, null, new long[]{groupId});
        this.userLocalService.unsetGroupUsers(groupId, userIds, serviceContext);
        SiteMembershipPolicyUtil.propagateMembership(userIds, null, new long[]{groupId});
    }

    @Override
    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        userIds = UsersAdminUtil.filterUnsetOrganizationUserIds(this.getPermissionChecker(), organizationId, userIds);
        if (userIds.length == 0) {
            return;
        }
        OrganizationPermissionUtil.check(this.getPermissionChecker(), organizationId, "ASSIGN_MEMBERS");
        OrganizationMembershipPolicyUtil.checkMembership(userIds, null, new long[]{organizationId});
        this.userLocalService.unsetOrganizationUsers(organizationId, userIds);
        OrganizationMembershipPolicyUtil.propagateMembership(userIds, null, new long[]{organizationId});
    }

    @Override
    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        PasswordPolicyPermissionUtil.check(this.getPermissionChecker(), passwordPolicyId, "ASSIGN_MEMBERS");
        this.userLocalService.unsetPasswordPolicyUsers(passwordPolicyId, userIds);
    }

    @Override
    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        RolePermissionUtil.check(this.getPermissionChecker(), roleId, "ASSIGN_MEMBERS");
        RoleMembershipPolicyUtil.checkRoles(userIds, null, new long[]{roleId});
        this.userLocalService.unsetRoleUsers(roleId, userIds);
        RoleMembershipPolicyUtil.propagateRoles(userIds, null, new long[]{roleId});
    }

    @Override
    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        TeamPermissionUtil.check(this.getPermissionChecker(), teamId, "ASSIGN_MEMBERS");
        this.userLocalService.unsetTeamUsers(teamId, userIds);
    }

    @Override
    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "ASSIGN_MEMBERS");
        UserGroupMembershipPolicyUtil.checkMembership(userIds, null, new long[]{userGroupId});
        this.userLocalService.unsetUserGroupUsers(userGroupId, userIds);
        UserGroupMembershipPolicyUtil.propagateMembership(userIds, null, new long[]{userGroupId});
    }

    @Override
    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.userLocalService.updateAgreedToTermsOfUse(userId, agreedToTermsOfUse);
    }

    @Override
    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress2);
        return this.userLocalService.updateEmailAddress(userId, password, emailAddress1, emailAddress2, serviceContext);
    }

    @Override
    public User updateIncompleteUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        long creatorUserId;
        block2: {
            creatorUserId = 0L;
            try {
                creatorUserId = this.getGuestOrUserId();
            }
            catch (PrincipalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Unable to get guest or current user ID", pe);
            }
        }
        this.checkAddUserPermission(creatorUserId, companyId, emailAddress, null, null, null, null, serviceContext);
        return this.userLocalService.updateIncompleteUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
    }

    @Override
    public User updateLockoutById(long userId, boolean lockout) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "DELETE");
        return this.userLocalService.updateLockoutById(userId, lockout);
    }

    @Override
    public User updateOpenId(long userId, String openId) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.userLocalService.updateOpenId(userId, openId);
    }

    @Override
    public void updateOrganizations(long userId, long[] organizationIds, ServiceContext serviceContext) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        this.checkOrganizations(userId, organizationIds);
        this.userLocalService.updateOrganizations(userId, organizationIds, serviceContext);
    }

    @Override
    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.userLocalService.updatePassword(userId, password1, password2, passwordReset);
    }

    @Override
    public User updatePortrait(long userId, byte[] bytes) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.userLocalService.updatePortrait(userId, bytes);
    }

    @Override
    public User updateReminderQuery(long userId, String question, String answer) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.userLocalService.updateReminderQuery(userId, question, answer);
    }

    @Override
    public User updateScreenName(long userId, String screenName) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.userLocalService.updateScreenName(userId, screenName);
    }

    @Override
    public User updateStatus(long userId, int status, ServiceContext serviceContext) throws PortalException {
        if (this.getUserId() == userId && status != 0) {
            throw new RequiredUserException();
        }
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "DELETE");
        return this.userLocalService.updateStatus(userId, status, serviceContext);
    }

    @Override
    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, boolean portrait, byte[] portraitBytes, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, ServiceContext serviceContext) throws PortalException {
        long curUserId;
        UserPermissionUtil.check(this.getPermissionChecker(), userId, organizationIds, "UPDATE");
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (addresses != null) {
            UsersAdminUtil.updateAddresses(Contact.class.getName(), user.getContactId(), addresses);
        }
        if (emailAddresses != null) {
            UsersAdminUtil.updateEmailAddresses(Contact.class.getName(), user.getContactId(), emailAddresses);
        }
        if (phones != null) {
            UsersAdminUtil.updatePhones(Contact.class.getName(), user.getContactId(), phones);
        }
        if (websites != null) {
            UsersAdminUtil.updateWebsites(Contact.class.getName(), user.getContactId(), websites);
        }
        if (announcementsDelivers != null) {
            this.updateAnnouncementsDeliveries(user.getUserId(), announcementsDelivers);
        }
        if ((curUserId = this.getUserId()) == userId && !StringUtil.equalsIgnoreCase(emailAddress = StringUtil.toLowerCase(StringUtil.trim(emailAddress)), user.getEmailAddress())) {
            this.validateEmailAddress(user, emailAddress);
        }
        this.validateUpdatePermission(user, screenName, emailAddress, firstName, middleName, lastName, prefixId, suffixId, birthdayMonth, birthdayDay, birthdayYear, male, jobTitle);
        ArrayList<Long> addGroupIds = new ArrayList<Long>();
        List<Object> removeGroupIds = Collections.emptyList();
        if (groupIds != null) {
            long[] oldGroupIds = user.getGroupIds();
            removeGroupIds = ListUtil.toList(oldGroupIds);
            for (long groupId : groupIds = this.checkGroups(userId, groupIds)) {
                if (ArrayUtil.contains(oldGroupIds, groupId)) {
                    removeGroupIds.remove(groupId);
                    continue;
                }
                addGroupIds.add(groupId);
            }
            if (!addGroupIds.isEmpty() || !removeGroupIds.isEmpty()) {
                SiteMembershipPolicyUtil.checkMembership(new long[]{userId}, ArrayUtil.toLongArray(addGroupIds), ArrayUtil.toLongArray(removeGroupIds));
            }
        }
        ArrayList<Long> addOrganizationIds = new ArrayList<Long>();
        List<Object> removeOrganizationIds = Collections.emptyList();
        if (organizationIds != null) {
            long[] oldOrganizationIds = user.getOrganizationIds();
            removeOrganizationIds = ListUtil.toList(oldOrganizationIds);
            for (long organizationId : organizationIds = this.checkOrganizations(userId, organizationIds)) {
                if (ArrayUtil.contains(oldOrganizationIds, organizationId)) {
                    removeOrganizationIds.remove(organizationId);
                    continue;
                }
                addOrganizationIds.add(organizationId);
            }
            if (!addOrganizationIds.isEmpty() || !removeOrganizationIds.isEmpty()) {
                OrganizationMembershipPolicyUtil.checkMembership(new long[]{userId}, ArrayUtil.toLongArray(addOrganizationIds), ArrayUtil.toLongArray(removeOrganizationIds));
            }
        }
        ArrayList<Long> addRoleIds = new ArrayList<Long>();
        List<Object> removeRoleIds = Collections.emptyList();
        if (roleIds != null) {
            long[] oldRoleIds = user.getRoleIds();
            removeRoleIds = ListUtil.toList(oldRoleIds);
            for (long roleId : roleIds = this.checkRoles(userId, roleIds)) {
                if (ArrayUtil.contains(oldRoleIds, roleId)) {
                    removeRoleIds.remove(roleId);
                    continue;
                }
                addRoleIds.add(roleId);
            }
            if (!addRoleIds.isEmpty() || !removeRoleIds.isEmpty()) {
                RoleMembershipPolicyUtil.checkRoles(new long[]{userId}, ArrayUtil.toLongArray(addRoleIds), ArrayUtil.toLongArray(removeRoleIds));
            }
        }
        ArrayList<UserGroupRole> oldOrganizationUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> oldSiteUserGroupRoles = new ArrayList<UserGroupRole>();
        List<UserGroupRole> oldUserGroupRoles = this.userGroupRolePersistence.findByUserId(userId);
        for (UserGroupRole oldUserGroupRole : oldUserGroupRoles) {
            Role role = oldUserGroupRole.getRole();
            if (role.getType() == 3) {
                oldOrganizationUserGroupRoles.add(oldUserGroupRole);
                continue;
            }
            if (role.getType() != 2) continue;
            oldSiteUserGroupRoles.add(oldUserGroupRole);
        }
        ArrayList<UserGroupRole> addOrganizationUserGroupRoles = new ArrayList<UserGroupRole>();
        List<Object> removeOrganizationUserGroupRoles = Collections.emptyList();
        ArrayList<UserGroupRole> addSiteUserGroupRoles = new ArrayList<UserGroupRole>();
        List<Object> removeSiteUserGroupRoles = Collections.emptyList();
        if (userGroupRoles != null) {
            userGroupRoles = this.checkUserGroupRoles(userId, userGroupRoles);
            removeOrganizationUserGroupRoles = ListUtil.copy(oldOrganizationUserGroupRoles);
            removeSiteUserGroupRoles = ListUtil.copy(oldSiteUserGroupRoles);
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (role.getType() == 3) {
                    if (oldOrganizationUserGroupRoles.contains(userGroupRole)) {
                        removeOrganizationUserGroupRoles.remove(userGroupRole);
                        continue;
                    }
                    addOrganizationUserGroupRoles.add(userGroupRole);
                    continue;
                }
                if (role.getType() != 2) continue;
                if (oldSiteUserGroupRoles.contains(userGroupRole)) {
                    removeSiteUserGroupRoles.remove(userGroupRole);
                    continue;
                }
                addSiteUserGroupRoles.add(userGroupRole);
            }
            if (!addOrganizationUserGroupRoles.isEmpty() || !removeOrganizationUserGroupRoles.isEmpty()) {
                OrganizationMembershipPolicyUtil.checkRoles(addOrganizationUserGroupRoles, removeOrganizationUserGroupRoles);
            }
            if (!addSiteUserGroupRoles.isEmpty() || !removeSiteUserGroupRoles.isEmpty()) {
                SiteMembershipPolicyUtil.checkRoles(addSiteUserGroupRoles, removeSiteUserGroupRoles);
            }
        }
        ArrayList<Long> addUserGroupIds = new ArrayList<Long>();
        List<Object> removeUserGroupIds = Collections.emptyList();
        if (userGroupIds != null) {
            long[] oldUserGroupIds = user.getUserGroupIds();
            removeUserGroupIds = ListUtil.toList(oldUserGroupIds);
            for (long userGroupId : userGroupIds = this.checkUserGroupIds(userId, userGroupIds)) {
                if (ArrayUtil.contains(oldUserGroupIds, userGroupId)) {
                    removeUserGroupIds.remove(userGroupId);
                    continue;
                }
                addUserGroupIds.add(userGroupId);
            }
            if (!addUserGroupIds.isEmpty() || !removeUserGroupIds.isEmpty()) {
                UserGroupMembershipPolicyUtil.checkMembership(new long[]{userId}, ArrayUtil.toLongArray(addUserGroupIds), ArrayUtil.toLongArray(removeUserGroupIds));
            }
        }
        user = this.userLocalService.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, portrait, portraitBytes, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
        if (!addGroupIds.isEmpty() || !removeGroupIds.isEmpty()) {
            SiteMembershipPolicyUtil.propagateMembership(new long[]{user.getUserId()}, ArrayUtil.toLongArray(addGroupIds), ArrayUtil.toLongArray(removeGroupIds));
        }
        if (!addOrganizationIds.isEmpty() || !removeOrganizationIds.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateMembership(new long[]{user.getUserId()}, ArrayUtil.toLongArray(addOrganizationIds), ArrayUtil.toLongArray(removeOrganizationIds));
        }
        if (!addRoleIds.isEmpty() || !removeRoleIds.isEmpty()) {
            RoleMembershipPolicyUtil.propagateRoles(new long[]{user.getUserId()}, ArrayUtil.toLongArray(addRoleIds), ArrayUtil.toLongArray(removeRoleIds));
        }
        if (!addSiteUserGroupRoles.isEmpty() || !removeSiteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.propagateRoles(addSiteUserGroupRoles, removeSiteUserGroupRoles);
        }
        if (!addOrganizationUserGroupRoles.isEmpty() || !removeOrganizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateRoles(addOrganizationUserGroupRoles, removeOrganizationUserGroupRoles);
        }
        if (!addUserGroupIds.isEmpty() || !removeUserGroupIds.isEmpty()) {
            UserGroupMembershipPolicyUtil.propagateMembership(new long[]{user.getUserId()}, ArrayUtil.toLongArray(addUserGroupIds), ArrayUtil.toLongArray(removeUserGroupIds));
        }
        return user;
    }

    @Override
    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        return this.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, true, null, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, null, null, null, null, null, serviceContext);
    }

    protected void checkAddUserPermission(long creatorUserId, long companyId, String emailAddress, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (groupIds != null) {
            this.checkGroups(0L, groupIds);
        }
        if (organizationIds != null) {
            this.checkOrganizations(0L, organizationIds);
        }
        if (roleIds != null) {
            this.checkRoles(0L, roleIds);
        }
        if (userGroupIds != null) {
            this.checkUserGroupIds(0L, userGroupIds);
        }
        boolean anonymousUser = ParamUtil.getBoolean(serviceContext, "anonymousUser");
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        if ((creatorUserId != 0L && creatorUserId != defaultUserId || !company.isStrangers() && !anonymousUser) && !PortalPermissionUtil.contains(permissionChecker = this.getPermissionChecker(), "ADD_USER") && !OrganizationPermissionUtil.contains(this.getPermissionChecker(), organizationIds, "ASSIGN_MEMBERS")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), 0L, "ADD_USER", "ASSIGN_MEMBERS");
        }
        if ((creatorUserId == 0L || creatorUserId == defaultUserId) && !company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    protected long[] checkGroups(long userId, long[] groupIds) throws PortalException {
        long[] oldGroupIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            List<Group> oldGroups = this.groupLocalService.getUserGroups(userId);
            oldGroupIds = new long[oldGroups.size()];
            for (int i = 0; i < oldGroups.size(); ++i) {
                Group group = oldGroups.get(i);
                if (!ArrayUtil.contains(groupIds, group.getGroupId()) && (!GroupPermissionUtil.contains(permissionChecker, group, "ASSIGN_MEMBERS") || SiteMembershipPolicyUtil.isMembershipProtected(permissionChecker, user.getUserId(), group.getGroupId()) || SiteMembershipPolicyUtil.isMembershipRequired(userId, group.getGroupId()))) {
                    groupIds = ArrayUtil.append(groupIds, group.getGroupId());
                }
                oldGroupIds[i] = group.getGroupId();
            }
        }
        for (long groupId : groupIds) {
            if (oldGroupIds != null && ArrayUtil.contains(oldGroupIds, groupId)) continue;
            Group group = this.groupPersistence.findByPrimaryKey(groupId);
            GroupPermissionUtil.check(permissionChecker, group, "ASSIGN_MEMBERS");
        }
        return groupIds;
    }

    protected void checkMembership(long[] userIds, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds) throws PortalException {
        if (groupIds != null) {
            SiteMembershipPolicyUtil.checkMembership(userIds, groupIds, null);
        }
        if (organizationIds != null) {
            OrganizationMembershipPolicyUtil.checkMembership(userIds, organizationIds, null);
        }
        if (roleIds != null) {
            RoleMembershipPolicyUtil.checkRoles(userIds, roleIds, null);
        }
        if (userGroupIds != null) {
            UserGroupMembershipPolicyUtil.checkMembership(userIds, userGroupIds, null);
        }
    }

    protected long[] checkOrganizations(long userId, long[] organizationIds) throws PortalException {
        long[] oldOrganizationIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            List<Organization> oldOrganizations = this.organizationLocalService.getUserOrganizations(userId);
            oldOrganizationIds = new long[oldOrganizations.size()];
            for (int i = 0; i < oldOrganizations.size(); ++i) {
                Organization organization = oldOrganizations.get(i);
                if (!ArrayUtil.contains(organizationIds, organization.getOrganizationId()) && (!OrganizationPermissionUtil.contains(permissionChecker, organization, "ASSIGN_MEMBERS") || OrganizationMembershipPolicyUtil.isMembershipProtected(permissionChecker, userId, organization.getOrganizationId()) || OrganizationMembershipPolicyUtil.isMembershipRequired(userId, organization.getOrganizationId()))) {
                    organizationIds = ArrayUtil.append(organizationIds, organization.getOrganizationId());
                }
                oldOrganizationIds[i] = organization.getOrganizationId();
            }
        }
        for (long organizationId : organizationIds) {
            if (oldOrganizationIds != null && ArrayUtil.contains(oldOrganizationIds, organizationId)) continue;
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            OrganizationPermissionUtil.check(permissionChecker, organization, "ASSIGN_MEMBERS");
        }
        return organizationIds;
    }

    protected long[] checkRoles(long userId, long[] roleIds) throws PortalException {
        long[] oldRoleIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            List<Role> oldRoles = this.roleLocalService.getUserRoles(userId);
            oldRoleIds = new long[oldRoles.size()];
            for (int i = 0; i < oldRoles.size(); ++i) {
                Role role = oldRoles.get(i);
                if (!(ArrayUtil.contains(roleIds, role.getRoleId()) || RolePermissionUtil.contains(permissionChecker, role.getRoleId(), "ASSIGN_MEMBERS") && !RoleMembershipPolicyUtil.isRoleRequired(userId, role.getRoleId()))) {
                    roleIds = ArrayUtil.append(roleIds, role.getRoleId());
                }
                oldRoleIds[i] = role.getRoleId();
            }
        }
        for (long roleId : roleIds) {
            if (oldRoleIds != null && ArrayUtil.contains(oldRoleIds, roleId)) continue;
            RolePermissionUtil.check(permissionChecker, roleId, "ASSIGN_MEMBERS");
        }
        if (userId != 0L) {
            return UsersAdminUtil.addRequiredRoles(userId, roleIds);
        }
        return roleIds;
    }

    protected long[] checkUserGroupIds(long userId, long[] userGroupIds) throws PortalException {
        long[] oldUserGroupIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            List<UserGroup> oldUserGroups = this.userGroupLocalService.getUserUserGroups(userId);
            oldUserGroupIds = new long[oldUserGroups.size()];
            for (int i = 0; i < oldUserGroups.size(); ++i) {
                UserGroup userGroup = oldUserGroups.get(i);
                if (!(ArrayUtil.contains(userGroupIds, userGroup.getUserGroupId()) || UserGroupPermissionUtil.contains(permissionChecker, userGroup.getUserGroupId(), "ASSIGN_MEMBERS") && !UserGroupMembershipPolicyUtil.isMembershipRequired(userId, userGroup.getUserGroupId()))) {
                    userGroupIds = ArrayUtil.append(userGroupIds, userGroup.getUserGroupId());
                }
                oldUserGroupIds[i] = userGroup.getUserGroupId();
            }
        }
        for (long userGroupId : userGroupIds) {
            if (oldUserGroupIds != null && ArrayUtil.contains(oldUserGroupIds, userGroupId)) continue;
            UserGroupPermissionUtil.check(permissionChecker, userGroupId, "ASSIGN_MEMBERS");
        }
        return userGroupIds;
    }

    protected List<UserGroupRole> checkUserGroupRoles(long userId, List<UserGroupRole> userGroupRoles) throws PortalException {
        List<UserGroupRole> oldUserGroupRoles = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            oldUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
            for (UserGroupRole oldUserGroupRole : oldUserGroupRoles) {
                Role role = oldUserGroupRole.getRole();
                Group group = oldUserGroupRole.getGroup();
                if (userGroupRoles.contains(oldUserGroupRole)) continue;
                if (role.getType() == 3) {
                    Organization organization = this.organizationPersistence.findByPrimaryKey(group.getOrganizationId());
                    if (UserGroupRolePermissionUtil.contains(permissionChecker, group, role) && !OrganizationMembershipPolicyUtil.isRoleProtected(this.getPermissionChecker(), userId, organization.getOrganizationId(), role.getRoleId()) && !OrganizationMembershipPolicyUtil.isRoleRequired(userId, organization.getOrganizationId(), role.getRoleId())) continue;
                    userGroupRoles.add(oldUserGroupRole);
                    continue;
                }
                if (role.getType() != 2 || userGroupRoles.contains(oldUserGroupRole) || UserGroupRolePermissionUtil.contains(permissionChecker, group, role) && !SiteMembershipPolicyUtil.isRoleProtected(this.getPermissionChecker(), userId, group.getGroupId(), role.getRoleId()) && !SiteMembershipPolicyUtil.isRoleRequired(userId, group.getGroupId(), role.getRoleId())) continue;
                userGroupRoles.add(oldUserGroupRole);
            }
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            if (oldUserGroupRoles != null && oldUserGroupRoles.contains(userGroupRole)) continue;
            UserGroupRolePermissionUtil.check(permissionChecker, userGroupRole.getGroupId(), userGroupRole.getRoleId());
        }
        return userGroupRoles;
    }

    protected void propagateMembership(long[] userIds, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds) throws PortalException {
        if (groupIds != null) {
            SiteMembershipPolicyUtil.propagateMembership(userIds, groupIds, null);
        }
        if (organizationIds != null) {
            OrganizationMembershipPolicyUtil.propagateMembership(userIds, organizationIds, null);
        }
        if (roleIds != null) {
            RoleMembershipPolicyUtil.propagateRoles(userIds, roleIds, null);
        }
        if (userGroupIds != null) {
            UserGroupMembershipPolicyUtil.propagateMembership(userIds, userGroupIds, null);
        }
    }

    protected void updateAnnouncementsDeliveries(long userId, List<AnnouncementsDelivery> announcementsDeliveries) throws PortalException {
        for (AnnouncementsDelivery announcementsDelivery : announcementsDeliveries) {
            this.announcementsDeliveryService.updateDelivery(userId, announcementsDelivery.getType(), announcementsDelivery.isEmail(), announcementsDelivery.isSms());
        }
    }

    protected void validateEmailAddress(User user, String emailAddress) throws PortalException {
        Company company;
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && !(company = this.companyPersistence.findByPrimaryKey(user.getCompanyId())).isStrangersWithMx()) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    protected void validateOrganizationUsers(long[] userIds) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT || permissionChecker.isCompanyAdmin()) {
            return;
        }
        for (long userId : userIds) {
            boolean allowed = false;
            List<Organization> organizations = this.organizationLocalService.getUserOrganizations(userId);
            for (Organization organization : organizations) {
                if (!OrganizationPermissionUtil.contains(permissionChecker, organization, "MANAGE_USERS")) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), 0L, "MANAGE_USERS");
        }
    }

    protected void validateUpdatePermission(User user, String screenName, String emailAddress, String firstName, String middleName, String lastName, long prefixId, long suffixId, int birthdayMonth, int birthdayDay, int birthdayYear, boolean male, String jobTitle) throws PortalException {
        ArrayList<String> fields = new ArrayList<String>();
        Contact contact = user.getContact();
        Calendar birthday = CalendarFactoryUtil.getCalendar();
        birthday.setTime(contact.getBirthday());
        if (birthdayMonth != birthday.get(2) || birthdayDay != birthday.get(5) || birthdayYear != birthday.get(1)) {
            fields.add("birthday");
        }
        if (!StringUtil.equalsIgnoreCase(emailAddress, user.getEmailAddress())) {
            fields.add("emailAddress");
        }
        if (!StringUtil.equalsIgnoreCase(firstName, user.getFirstName())) {
            fields.add("firstName");
        }
        if (male != contact.isMale()) {
            fields.add("gender");
        }
        if (!StringUtil.equalsIgnoreCase(jobTitle, user.getJobTitle())) {
            fields.add("jobTitle");
        }
        if (!StringUtil.equalsIgnoreCase(lastName, user.getLastName())) {
            fields.add("lastName");
        }
        if (!StringUtil.equalsIgnoreCase(middleName, user.getMiddleName())) {
            fields.add("middleName");
        }
        if (prefixId != contact.getPrefixId()) {
            fields.add("prefix");
        }
        if (!StringUtil.equalsIgnoreCase(screenName, user.getScreenName())) {
            fields.add("screenName");
        }
        if (suffixId != contact.getSuffixId()) {
            fields.add("suffix");
        }
        UserFieldException ufe = new UserFieldException();
        for (String field : fields) {
            if (UsersAdminUtil.hasUpdateFieldPermission(this.getPermissionChecker(), this.getUser(), user, field)) continue;
            ufe.addField(field);
        }
        if (ufe.hasFields()) {
            throw ufe;
        }
    }
}

