/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicyUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.UserGroupIdComparator;
import com.liferay.portal.service.base.UserGroupServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class UserGroupServiceImpl
extends UserGroupServiceBaseImpl {
    @Override
    public void addGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.userGroupLocalService.addGroupUserGroups(groupId, userGroupIds);
    }

    @Override
    public void addTeamUserGroups(long teamId, long[] userGroupIds) throws PortalException {
        TeamPermissionUtil.check(this.getPermissionChecker(), teamId, "ASSIGN_MEMBERS");
        this.userGroupLocalService.addTeamUserGroups(teamId, userGroupIds);
    }

    @Override
    public UserGroup addUserGroup(String name, String description, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check(this.getPermissionChecker(), "ADD_USER_GROUP");
        User user = this.getUser();
        UserGroup userGroup = this.userGroupLocalService.addUserGroup(user.getUserId(), user.getCompanyId(), name, description, serviceContext);
        UserGroupMembershipPolicyUtil.verifyPolicy(userGroup);
        return userGroup;
    }

    @Override
    public void deleteUserGroup(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "DELETE");
        this.userGroupLocalService.deleteUserGroup(userGroupId);
    }

    @Override
    public UserGroup fetchUserGroup(long userGroupId) throws PortalException {
        UserGroup userGroup = this.userGroupLocalService.fetchUserGroup(userGroupId);
        if (userGroup != null) {
            UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW");
        }
        return userGroup;
    }

    @Override
    public List<UserGroup> getGtUserGroups(long gtUserGroupId, long companyId, long parentUserGroupId, int size) {
        return this.userGroupPersistence.filterFindByU_C_P(gtUserGroupId, companyId, parentUserGroupId, 0, size, new UserGroupIdComparator(true));
    }

    @Override
    public UserGroup getUserGroup(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW");
        return this.userGroupLocalService.getUserGroup(userGroupId);
    }

    @Override
    public UserGroup getUserGroup(String name) throws PortalException {
        User user = this.getUser();
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(user.getCompanyId(), name);
        long userGroupId = userGroup.getUserGroupId();
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "VIEW");
        return userGroup;
    }

    @Override
    public List<UserGroup> getUserGroups(long companyId) throws PortalException {
        return this.filterUserGroups(this.userGroupLocalService.getUserGroups(companyId));
    }

    @Override
    public List<UserGroup> getUserGroups(long companyId, String name, int start, int end) {
        if (Validator.isNull(name)) {
            return this.userGroupPersistence.filterFindByCompanyId(companyId, start, end);
        }
        return this.userGroupPersistence.filterFindByC_LikeN(companyId, name, start, end);
    }

    @Override
    public int getUserGroupsCount(long companyId, String name) {
        if (Validator.isNull(name)) {
            return this.userGroupPersistence.filterCountByCompanyId(companyId);
        }
        return this.userGroupPersistence.filterCountByC_LikeN(companyId, name);
    }

    @Override
    public List<UserGroup> getUserUserGroups(long userId) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "VIEW");
        List<UserGroup> userGroups = this.userGroupLocalService.getUserUserGroups(userId);
        return this.filterUserGroups(userGroups);
    }

    @Override
    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetGroupUserGroups(groupId, userGroupIds);
    }

    @Override
    public void unsetTeamUserGroups(long teamId, long[] userGroupIds) throws PortalException {
        TeamPermissionUtil.check(this.getPermissionChecker(), teamId, "ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetTeamUserGroups(teamId, userGroupIds);
    }

    @Override
    public UserGroup updateUserGroup(long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        UserGroupPermissionUtil.check(this.getPermissionChecker(), userGroupId, "UPDATE");
        User user = this.getUser();
        return this.userGroupLocalService.updateUserGroup(user.getCompanyId(), userGroupId, name, description, serviceContext);
    }

    protected List<UserGroup> filterUserGroups(List<UserGroup> userGroups) throws PortalException {
        ArrayList<UserGroup> filteredGroups = new ArrayList<UserGroup>();
        for (UserGroup userGroup : userGroups) {
            if (!UserGroupPermissionUtil.contains(this.getPermissionChecker(), userGroup.getUserGroupId(), "VIEW")) continue;
            filteredGroups.add(userGroup);
        }
        return filteredGroups;
    }
}

