/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchUserGroupRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.persistence.UserGroupRolePK;
import com.liferay.portal.service.base.UserGroupRoleLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class UserGroupRoleLocalServiceImpl
extends UserGroupRoleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupRoleLocalServiceImpl.class);

    @Override
    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long roleId : roleIds) {
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group.isRegularSite()) {
            this.groupPersistence.addUser(groupId, userId);
        }
        return userGroupRoles;
    }

    @Override
    public List<UserGroupRole> addUserGroupRoles(long[] userIds, long groupId, long roleId) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long userId : userIds) {
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group.isRegularSite()) {
            this.groupPersistence.addUsers(groupId, userIds);
        }
        return userGroupRoles;
    }

    @Override
    public void deleteUserGroupRoles(long groupId, int roleType) {
        List<UserGroupRole> userGroupRoles = this.userGroupRoleFinder.findByGroupRoleType(groupId, roleType);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            this.userGroupRolePersistence.removeByG_R(groupId, userGroupRole.getRoleId());
        }
    }

    @Override
    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(userGroupRolePK);
            }
            catch (NoSuchUserGroupRoleException nsugre) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(nsugre, nsugre);
            }
        }
    }

    @Override
    public void deleteUserGroupRoles(long userId, long[] groupIds) {
        for (long groupId : groupIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
    }

    @Override
    public void deleteUserGroupRoles(long[] userIds, long groupId) {
        for (long userId : userIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
    }

    @Override
    public void deleteUserGroupRoles(long[] userIds, long groupId, int roleType) {
        List<Role> roles = this.rolePersistence.findByT_S(roleType, "");
        for (long userId : userIds) {
            for (Role role : roles) {
                UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, role.getRoleId());
                try {
                    this.userGroupRolePersistence.remove(userGroupRolePK);
                }
                catch (NoSuchUserGroupRoleException nsugre) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug(nsugre, nsugre);
                }
            }
        }
    }

    @Override
    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) {
        for (long userId : userIds) {
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupRoleException nsugre) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(nsugre, nsugre);
            }
        }
    }

    @Override
    public void deleteUserGroupRolesByGroupId(long groupId) {
        this.userGroupRolePersistence.removeByGroupId(groupId);
    }

    @Override
    public void deleteUserGroupRolesByRoleId(long roleId) {
        this.userGroupRolePersistence.removeByRoleId(roleId);
    }

    @Override
    public void deleteUserGroupRolesByUserId(long userId) {
        this.userGroupRolePersistence.removeByUserId(userId);
    }

    @Override
    public List<UserGroupRole> getUserGroupRoles(long userId) {
        return this.userGroupRolePersistence.findByUserId(userId);
    }

    @Override
    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId) {
        return this.userGroupRolePersistence.findByU_G(userId, groupId);
    }

    @Override
    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId, int start, int end) {
        return this.userGroupRolePersistence.findByU_G(userId, groupId, start, end);
    }

    @Override
    public List<UserGroupRole> getUserGroupRolesByGroup(long groupId) {
        return this.userGroupRolePersistence.findByGroupId(groupId);
    }

    @Override
    public List<UserGroupRole> getUserGroupRolesByGroupAndRole(long groupId, long roleId) {
        return this.userGroupRolePersistence.findByG_R(groupId, roleId);
    }

    @Override
    public List<UserGroupRole> getUserGroupRolesByUserUserGroupAndGroup(long userId, long groupId) {
        return this.userGroupRoleFinder.findByUserUserGroupGroupRole(userId, groupId);
    }

    @Override
    public int getUserGroupRolesCount(long userId, long groupId) {
        return this.userGroupRolePersistence.countByU_G(userId, groupId);
    }

    @Override
    public boolean hasUserGroupRole(long userId, long groupId, long roleId) {
        return this.hasUserGroupRole(userId, groupId, roleId, false);
    }

    @Override
    public boolean hasUserGroupRole(long userId, long groupId, long roleId, boolean inherit) {
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(userGroupRolePK);
        if (userGroupRole != null) {
            return true;
        }
        return inherit && this.roleFinder.countByU_G_R(userId, groupId, roleId) > 0;
    }

    @Override
    public boolean hasUserGroupRole(long userId, long groupId, String roleName) throws PortalException {
        return this.hasUserGroupRole(userId, groupId, roleName, false);
    }

    @Override
    public boolean hasUserGroupRole(long userId, long groupId, String roleName, boolean inherit) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long companyId = user.getCompanyId();
        Role role = this.rolePersistence.fetchByC_N(companyId, roleName);
        if (role == null) {
            return false;
        }
        return this.hasUserGroupRole(userId, groupId, role.getRoleId(), inherit);
    }

    protected UserGroupRole addUserGroupRole(long userId, long groupId, long roleId) {
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(userGroupRolePK);
        if (userGroupRole == null) {
            userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            this.userGroupRolePersistence.update(userGroupRole);
        }
        return userGroupRole;
    }
}

