/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactoryUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.DuplicateUserGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredUserGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.exception.UserGroupNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.exportimport.UserGroupImportTransactionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.UserGroupLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.constants.UserGroupFinderConstants;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserGroupLocalServiceImpl
extends UserGroupLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupLocalServiceImpl.class);

    @Override
    public void addGroupUserGroup(long groupId, long userGroupId) {
        super.addGroupUserGroup(groupId, userGroupId);
        try {
            this.reindexUsers(userGroupId);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void addGroupUserGroup(long groupId, UserGroup userGroup) {
        super.addGroupUserGroup(groupId, userGroup);
        try {
            this.reindexUsers(userGroup);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void addGroupUserGroups(long groupId, List<UserGroup> userGroups) {
        super.addGroupUserGroups(groupId, userGroups);
        try {
            this.reindexUsers(userGroups);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void addGroupUserGroups(long groupId, long[] userGroupIds) {
        super.addGroupUserGroups(groupId, userGroupIds);
        try {
            this.reindexUsers(userGroupIds);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public UserGroup addUserGroup(long userId, long companyId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validate(0L, companyId, name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        long userGroupId = this.counterLocalService.increment();
        UserGroup userGroup = this.userGroupPersistence.create(userGroupId);
        if (serviceContext != null) {
            userGroup.setUuid(serviceContext.getUuid());
        }
        userGroup.setCompanyId(companyId);
        userGroup.setUserId(user.getUserId());
        userGroup.setUserName(user.getFullName());
        userGroup.setParentUserGroupId(0L);
        userGroup.setName(name);
        userGroup.setDescription(description);
        userGroup.setAddedByLDAPImport(UserGroupImportTransactionThreadLocal.isOriginatesFromImport());
        userGroup.setExpandoBridgeAttributes(serviceContext);
        this.userGroupPersistence.update(userGroup);
        this.groupLocalService.addGroup(userId, 0L, UserGroup.class.getName(), userGroup.getUserGroupId(), 0L, this.getLocalizationMap(String.valueOf(userGroupId)), null, 0, true, 0, null, false, true, null);
        this.resourceLocalService.addResources(companyId, 0L, userId, UserGroup.class.getName(), userGroup.getUserGroupId(), false, false, false);
        Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        indexer.reindex(userGroup);
        return userGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void copyUserGroupLayouts(long userGroupId, long userId) throws PortalException {
        Map<String, String[]> parameterMap = this.getLayoutTemplatesParameters();
        File[] files = this.exportLayouts(userGroupId, parameterMap);
        try {
            this.importLayouts(userId, parameterMap, files[0], files[1]);
        }
        finally {
            if (files[0] != null) {
                files[0].delete();
            }
            if (files[1] != null) {
                files[1].delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void copyUserGroupLayouts(long userGroupId, long[] userIds) throws PortalException {
        Map<String, String[]> parameterMap = this.getLayoutTemplatesParameters();
        File[] files = this.exportLayouts(userGroupId, parameterMap);
        try {
            for (long userId : userIds) {
                if (this.userGroupPersistence.containsUser(userGroupId, userId)) continue;
                this.importLayouts(userId, parameterMap, files[0], files[1]);
            }
        }
        finally {
            if (files[0] != null) {
                files[0].delete();
            }
            if (files[1] != null) {
                files[1].delete();
            }
        }
    }

    @Override
    @Deprecated
    public void copyUserGroupLayouts(long[] userGroupIds, long userId) throws PortalException {
        for (long userGroupId : userGroupIds) {
            if (this.userGroupPersistence.containsUser(userGroupId, userId)) continue;
            this.copyUserGroupLayouts(userGroupId, userId);
        }
    }

    @Override
    public UserGroup deleteUserGroup(long userGroupId) throws PortalException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        return this.userGroupLocalService.deleteUserGroup(userGroup);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public UserGroup deleteUserGroup(UserGroup userGroup) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("usersUserGroups", userGroup.getUserGroupId());
            int count = this.userFinder.countByKeywords(userGroup.getCompanyId(), null, 0, params);
            if (count > 0) {
                throw new RequiredUserGroupException();
            }
        }
        this.expandoRowLocalService.deleteRows(userGroup.getUserGroupId());
        Group group = userGroup.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByUserGroupId(userGroup.getUserGroupId());
        this.resourceLocalService.deleteResource(userGroup.getCompanyId(), UserGroup.class.getName(), 4, userGroup.getUserGroupId());
        this.userGroupPersistence.remove(userGroup);
        return userGroup;
    }

    @Override
    public void deleteUserGroups(long companyId) throws PortalException {
        List<UserGroup> userGroups = this.userGroupPersistence.findByCompanyId(companyId);
        for (UserGroup userGroup : userGroups) {
            this.userGroupLocalService.deleteUserGroup(userGroup);
        }
    }

    @Override
    public UserGroup fetchUserGroup(long companyId, String name) {
        return this.userGroupPersistence.fetchByC_N(companyId, name);
    }

    @Override
    public List<UserGroup> getGroupUserUserGroups(long groupId, long userId) throws PortalException {
        long[] groupUserGroupIds = this.groupPersistence.getUserGroupPrimaryKeys(groupId);
        if (groupUserGroupIds.length == 0) {
            return Collections.emptyList();
        }
        long[] userUserGroupIds = this.userPersistence.getUserGroupPrimaryKeys(userId);
        if (userUserGroupIds.length == 0) {
            return Collections.emptyList();
        }
        Set<Long> userGroupIds = SetUtil.intersect(groupUserGroupIds, userUserGroupIds);
        if (userGroupIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(userGroupIds.size());
        for (Long userGroupId : userGroupIds) {
            userGroups.add((UserGroup)this.userGroupPersistence.findByPrimaryKey(userGroupId));
        }
        return userGroups;
    }

    @Override
    public UserGroup getUserGroup(long companyId, String name) throws PortalException {
        return this.userGroupPersistence.findByC_N(companyId, name);
    }

    @Override
    public List<UserGroup> getUserGroups(long companyId) {
        return this.userGroupPersistence.findByCompanyId(companyId);
    }

    @Override
    public List<UserGroup> getUserGroups(long companyId, String name, int start, int end) {
        if (Validator.isNull(name)) {
            return this.userGroupPersistence.findByCompanyId(companyId, start, end);
        }
        return this.userGroupPersistence.findByC_LikeN(companyId, name, start, end);
    }

    @Override
    public List<UserGroup> getUserGroups(long[] userGroupIds) throws PortalException {
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(userGroupIds.length);
        for (long userGroupId : userGroupIds) {
            UserGroup userGroup = this.getUserGroup(userGroupId);
            userGroups.add(userGroup);
        }
        return userGroups;
    }

    @Override
    public int getUserGroupsCount(long companyId, String name) {
        if (Validator.isNull(name)) {
            return this.userGroupPersistence.countByCompanyId(companyId);
        }
        return this.userGroupPersistence.countByC_LikeN(companyId, name);
    }

    @Override
    public List<UserGroup> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<UserGroup> obc) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterFindByKeywords(companyId, keywords, params, start, end, obc);
        }
        String orderByCol = obc.getOrderByFields()[0];
        String orderByType = "asc";
        if (!obc.isAscending()) {
            orderByType = "desc";
        }
        Sort sort = SortFactoryUtil.getSort(UserGroup.class, orderByCol, orderByType);
        try {
            return UsersAdminUtil.getUserGroups(this.search(companyId, keywords, params, start, end, sort));
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public Hits search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, name, description, params, andOperator, start, end, sort);
    }

    @Override
    public List<UserGroup> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<UserGroup> obc) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterFindByC_N_D(companyId, name, description, params, andOperator, start, end, obc);
        }
        String orderByCol = obc.getOrderByFields()[0];
        String orderByType = "asc";
        if (!obc.isAscending()) {
            orderByType = "desc";
        }
        Sort sort = SortFactoryUtil.getSort(UserGroup.class, orderByCol, orderByType);
        try {
            return UsersAdminUtil.getUserGroups(this.search(companyId, name, description, params, andOperator, start, end, sort));
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public Hits search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterCountByKeywords(companyId, keywords, params);
        }
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, andOperator, -1, -1, null);
            Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) {
        if (this.isUseCustomSQL(params)) {
            return this.userGroupFinder.filterCountByC_N_D(companyId, name, description, params, andOperator);
        }
        try {
            SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, true, -1, -1, null);
            Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public BaseModelSearchResult<UserGroup> searchUserGroups(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull(keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchUserGroups(companyId, name, description, params, andOperator, start, end, sort);
    }

    @Override
    public BaseModelSearchResult<UserGroup> searchUserGroups(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        SearchContext searchContext = this.buildSearchContext(companyId, name, description, params, andSearch, start, end, sort);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<UserGroup> userGroups = UsersAdminUtil.getUserGroups(hits);
            if (userGroups == null) continue;
            return new BaseModelSearchResult<UserGroup>(userGroups, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Override
    public void setUserUserGroups(long userId, long[] userGroupIds) throws PortalException {
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            this.copyUserGroupLayouts(userGroupIds, userId);
        }
        this.userPersistence.setUserGroups(userId, userGroupIds);
        Indexer<User> indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        User user = this.userLocalService.fetchUser(userId);
        indexer.reindex(user);
    }

    @Override
    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) {
        List<Team> teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.teamPersistence.removeUserGroups(team.getTeamId(), userGroupIds);
        }
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupIds, groupId);
        this.groupPersistence.removeUserGroups(groupId, userGroupIds);
        try {
            this.reindexUsers(userGroupIds);
        }
        catch (PortalException pe) {
            throw new SystemException(pe);
        }
    }

    @Override
    public void unsetTeamUserGroups(long teamId, long[] userGroupIds) {
        this.teamPersistence.removeUserGroups(teamId, userGroupIds);
    }

    @Override
    public UserGroup updateUserGroup(long companyId, long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        this.validate(userGroupId, companyId, name);
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        userGroup.setName(name);
        userGroup.setDescription(description);
        userGroup.setExpandoBridgeAttributes(serviceContext);
        this.userGroupPersistence.update(userGroup);
        Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        indexer.reindex(userGroup);
        return userGroup;
    }

    protected SearchContext buildSearchContext(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String keywords;
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("description", (Serializable)((Object)description));
        attributes.put("name", (Serializable)((Object)name));
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (params != null && Validator.isNotNull(keywords = (String)params.remove("keywords"))) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(sort);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected File[] exportLayouts(long userGroupId, Map<String, String[]> parameterMap) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        Map<String, Serializable> exportLayoutSettingsMap;
        File[] files = new File[2];
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        User user = this.userLocalService.getUser(GetterUtil.getLong(PrincipalThreadLocal.getName()));
        Group group = userGroup.getGroup();
        if (userGroup.hasPrivateLayouts()) {
            exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap(user, group.getGroupId(), true, ExportImportHelperUtil.getAllLayoutIds(group.getGroupId(), true), parameterMap);
            exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
            files[0] = this.exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
        }
        if (userGroup.hasPublicLayouts()) {
            exportLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildExportLayoutSettingsMap(user, group.getGroupId(), false, ExportImportHelperUtil.getAllLayoutIds(group.getGroupId(), false), parameterMap);
            exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 0, exportLayoutSettingsMap);
            files[1] = this.exportImportLocalService.exportLayoutsAsFile(exportImportConfiguration);
        }
        return files;
    }

    protected Map<String, String[]> getLayoutTemplatesParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"MERGE_BY_LAYOUT_NAME"});
        parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLETS_MERGE_MODE", new String[]{"ADD_TO_BOTTOM"});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        return parameterMap;
    }

    protected void importLayouts(long userId, Map<String, String[]> parameterMap, File privateLayoutsFile, File publicLayoutsFile) throws PortalException {
        ExportImportConfiguration exportImportConfiguration;
        Map<String, Serializable> importLayoutSettingsMap;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = user.getGroupId();
        if (privateLayoutsFile != null) {
            importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap(user, groupId, true, null, parameterMap);
            exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 6, importLayoutSettingsMap);
            this.exportImportLocalService.importLayouts(exportImportConfiguration, privateLayoutsFile);
        }
        if (publicLayoutsFile != null) {
            importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactoryUtil.buildImportLayoutSettingsMap(user, groupId, false, null, parameterMap);
            exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(user.getUserId(), 6, importLayoutSettingsMap);
            this.exportImportLocalService.importLayouts(exportImportConfiguration, publicLayoutsFile);
        }
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        Indexer<UserGroup> indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        if (indexer.isIndexerEnabled() && PropsValues.USER_GROUPS_SEARCH_WITH_INDEX && MapUtil.isEmpty(params)) {
            return false;
        }
        for (String key : params.keySet()) {
            if (!ArrayUtil.contains(UserGroupFinderConstants.PARAM_KEYS, key)) continue;
            return true;
        }
        return false;
    }

    protected void reindex(long companyId, long[] userIds) throws PortalException {
        Indexer<User> indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.userLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property userId = PropertyFactoryUtil.forName("userId");
            dynamicQuery.add(userId.in(userIds));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(user -> {
            block3: {
                if (!user.isDefaultUser()) {
                    try {
                        Document document = indexer.getDocument((User)user);
                        indexableActionableDynamicQuery.addDocuments(document);
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn("Unable to index user " + user.getUserId(), pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(indexer.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexUsers(List<UserGroup> userGroups) throws PortalException {
        for (UserGroup userGroup : userGroups) {
            this.reindexUsers(userGroup);
        }
    }

    protected void reindexUsers(long userGroupId) throws PortalException {
        UserGroup userGroup = this.getUserGroup(userGroupId);
        this.reindexUsers(userGroup);
    }

    protected void reindexUsers(long[] userGroupIds) throws PortalException {
        for (long userGroupId : userGroupIds) {
            this.reindexUsers(userGroupId);
        }
    }

    protected void reindexUsers(UserGroup userGroup) throws PortalException {
        long companyId = userGroup.getCompanyId();
        long[] userIds = this.getUserPrimaryKeys(userGroup.getUserGroupId());
        if (ArrayUtil.isNotEmpty(userIds)) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this.reindex(companyId, userIds);
                return null;
            });
        }
    }

    protected void validate(long userGroupId, long companyId, String name) throws PortalException {
        if (Validator.isNull(name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new UserGroupNameException();
        }
        if (Validator.isNumber(name) && !PropsValues.USER_GROUPS_NAME_ALLOW_NUMERIC) {
            throw new UserGroupNameException();
        }
        UserGroup userGroup = this.fetchUserGroup(companyId, name);
        if (userGroup != null && userGroup.getUserGroupId() != userGroupId) {
            throw new DuplicateUserGroupException("{name=" + name + "}");
        }
    }
}

