/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.service.base.UserGroupGroupRoleServiceBaseImpl;

public class UserGroupGroupRoleServiceImpl
extends UserGroupGroupRoleServiceBaseImpl {
    @Override
    public void addUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) throws PortalException {
        this.checkPermission(groupId, roleIds);
        this.userGroupGroupRoleLocalService.addUserGroupGroupRoles(userGroupId, groupId, roleIds);
    }

    @Override
    public void addUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) throws PortalException {
        this.checkPermission(groupId, new long[]{roleId});
        this.userGroupGroupRoleLocalService.addUserGroupGroupRoles(userGroupIds, groupId, roleId);
    }

    @Override
    public void deleteUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) throws PortalException {
        this.checkPermission(groupId, roleIds);
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupId, groupId, roleIds);
    }

    @Override
    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) throws PortalException {
        this.checkPermission(groupId, new long[]{roleId});
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupIds, groupId, roleId);
    }

    protected void checkPermission(long groupId, long[] roleIds) throws PortalException {
        for (long roleId : roleIds) {
            UserGroupRolePermissionUtil.check(this.getPermissionChecker(), groupId, roleId);
        }
    }
}

