/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.TicketLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class TicketLocalServiceImpl
extends TicketLocalServiceBaseImpl {
    @Override
    public Ticket addDistinctTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.ticketPersistence.removeByC_C_C_T(companyId, classNameId, classPK, type);
        return this.addTicket(companyId, className, classPK, type, extraInfo, expirationDate, serviceContext);
    }

    @Override
    public Ticket addTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        long ticketId = this.counterLocalService.increment();
        Ticket ticket = this.ticketPersistence.create(ticketId);
        ticket.setCompanyId(companyId);
        ticket.setCreateDate(new Date());
        ticket.setClassNameId(classNameId);
        ticket.setClassPK(classPK);
        ticket.setKey(PortalUUIDUtil.generate());
        ticket.setType(type);
        ticket.setExtraInfo(extraInfo);
        ticket.setExpirationDate(expirationDate);
        this.ticketPersistence.update(ticket);
        return ticket;
    }

    @Override
    public Ticket fetchTicket(String key) {
        return this.ticketPersistence.fetchByKey(key);
    }

    @Override
    public Ticket getTicket(String key) throws PortalException {
        return this.ticketPersistence.findByKey(key);
    }

    @Override
    public List<Ticket> getTickets(long companyId, String className, long classPK, int type) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ticketPersistence.findByC_C_C_T(companyId, classNameId, classPK, type);
    }

    @Override
    public List<Ticket> getTickets(String className, long classPK, int type) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.ticketPersistence.findByC_C_T(classNameId, classPK, type);
    }

    @Override
    public Ticket updateTicket(long ticketId, String className, long classPK, int type, String extraInfo, Date expirationDate) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        Ticket ticket = this.ticketPersistence.findByPrimaryKey(ticketId);
        ticket.setClassNameId(classNameId);
        ticket.setClassPK(classPK);
        ticket.setType(type);
        ticket.setExtraInfo(extraInfo);
        ticket.setExpirationDate(expirationDate);
        this.ticketPersistence.update(ticket);
        return ticket;
    }
}

