/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.theme.PortletDecoratorFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeCompanyId;
import com.liferay.portal.kernel.theme.ThemeCompanyLimit;
import com.liferay.portal.kernel.theme.ThemeGroupId;
import com.liferay.portal.kernel.theme.ThemeGroupLimit;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.plugin.PluginUtil;
import com.liferay.portal.service.base.ThemeLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ContextReplace;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

@Transactional(enabled=false)
public class ThemeLocalServiceImpl
extends ThemeLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ThemeLocalServiceImpl.class);
    private static final Map<String, Theme> _themes = new ConcurrentHashMap<String, Theme>();
    private static final Map<Long, Map<String, Theme>> _themesPool = new ConcurrentHashMap<Long, Map<String, Theme>>();

    @Override
    public ColorScheme fetchColorScheme(long companyId, String themeId, String colorSchemeId) {
        colorSchemeId = GetterUtil.getString(colorSchemeId);
        Theme theme = this.fetchTheme(companyId, themeId);
        if (theme == null) {
            return null;
        }
        Map<String, ColorScheme> colorSchemesMap = theme.getColorSchemesMap();
        return colorSchemesMap.get(colorSchemeId);
    }

    @Override
    public PortletDecorator fetchPortletDecorator(long companyId, String themeId, String colorSchemeId) {
        colorSchemeId = GetterUtil.getString(colorSchemeId);
        Theme theme = this.fetchTheme(companyId, themeId);
        if (theme == null) {
            return null;
        }
        Map<String, PortletDecorator> portletDecoratorsMap = theme.getPortletDecoratorsMap();
        return portletDecoratorsMap.get(colorSchemeId);
    }

    @Override
    public Theme fetchTheme(long companyId, String themeId) {
        themeId = GetterUtil.getString(themeId);
        Map<String, Theme> themes = this._getThemes(companyId);
        return themes.get(themeId);
    }

    @Override
    public ColorScheme getColorScheme(long companyId, String themeId, String colorSchemeId) {
        colorSchemeId = GetterUtil.getString(colorSchemeId);
        Theme theme = this.getTheme(companyId, themeId);
        Map<String, ColorScheme> colorSchemesMap = theme.getColorSchemesMap();
        ColorScheme colorScheme = colorSchemesMap.get(colorSchemeId);
        if (colorScheme != null) {
            return colorScheme;
        }
        List<ColorScheme> colorSchemes = theme.getColorSchemes();
        if (!colorSchemes.isEmpty()) {
            for (int i = colorSchemes.size() - 1; i >= 0; --i) {
                colorScheme = colorSchemes.get(i);
                if (!colorScheme.isDefaultCs()) continue;
                return colorScheme;
            }
        }
        if (colorScheme == null) {
            colorScheme = ColorSchemeFactoryUtil.getDefaultRegularColorScheme();
        }
        return colorScheme;
    }

    @Override
    public List<Theme> getControlPanelThemes(long companyId, long userId) {
        List<Theme> themes = this.getThemes(companyId);
        themes = PluginUtil.restrictPlugins(themes, companyId, userId);
        Iterator<Theme> itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = itr.next();
            if (theme.isControlPanelTheme()) continue;
            itr.remove();
        }
        return themes;
    }

    @Override
    public List<Theme> getPageThemes(long companyId, long groupId, long userId) {
        List<Theme> themes = this.getThemes(companyId);
        themes = PluginUtil.restrictPlugins(themes, companyId, userId);
        Iterator<Theme> itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = itr.next();
            if (theme.isPageTheme() && theme.isGroupAvailable(groupId)) continue;
            itr.remove();
        }
        return themes;
    }

    @Override
    public PortletDecorator getPortletDecorator(long companyId, String themeId, String portletDecoratorId) {
        Theme theme = this.fetchTheme(companyId, themeId);
        Map<String, PortletDecorator> portletDecoratorsMap = theme.getPortletDecoratorsMap();
        PortletDecorator portletDecorator = portletDecoratorsMap.get(portletDecoratorId = GetterUtil.getString(portletDecoratorId));
        if (portletDecorator != null) {
            return portletDecorator;
        }
        ThemeImpl themeImpl = (ThemeImpl)theme;
        return themeImpl.getDefaultPortletDecorator();
    }

    @Override
    public Theme getTheme(long companyId, String themeId) {
        themeId = GetterUtil.getString(themeId);
        Map<String, Theme> themes = this._getThemes(companyId);
        Theme theme = themes.get(themeId);
        if (theme != null) {
            return theme;
        }
        if (_log.isWarnEnabled()) {
            _log.warn("No theme found for specified theme id " + themeId + ". Returning the default theme.");
        }
        if ((theme = _themes.get(themeId = ThemeFactoryUtil.getDefaultRegularThemeId(companyId))) != null) {
            return theme;
        }
        if (_themes.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("No themes are installed");
            }
            return null;
        }
        if (!themeId.contains("_WAR_")) {
            _log.error("No theme found for default theme id " + themeId + ". Returning a random theme.");
        }
        for (Map.Entry<String, Theme> entry : _themes.entrySet()) {
            theme = entry.getValue();
            if (theme == null || theme.isControlPanelTheme()) continue;
            return theme;
        }
        return null;
    }

    @Override
    public List<Theme> getThemes(long companyId) {
        Map<String, Theme> themes = this._getThemes(companyId);
        List<Theme> themesList = ListUtil.fromMapValues(themes);
        return ListUtil.sort(themesList);
    }

    @Override
    public List<Theme> getWARThemes() {
        List<Theme> themes = ListUtil.fromMapValues(_themes);
        Iterator<Theme> itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = itr.next();
            if (theme.isWARFile()) continue;
            itr.remove();
        }
        return themes;
    }

    @Override
    public List<Theme> init(ServletContext servletContext, String themesPath, boolean loadFromServletContext, String[] xmls, PluginPackage pluginPackage) {
        return this.init(null, servletContext, themesPath, loadFromServletContext, xmls, pluginPackage);
    }

    @Override
    public List<Theme> init(String servletContextName, ServletContext servletContext, String themesPath, boolean loadFromServletContext, String[] xmls, PluginPackage pluginPackage) {
        LinkedHashSet<Theme> themes = new LinkedHashSet<Theme>();
        try {
            for (String xml : xmls) {
                themes.addAll(this._readThemes(servletContextName, servletContext, themesPath, loadFromServletContext, xml, pluginPackage));
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        _themesPool.clear();
        return new ArrayList<Theme>(themes);
    }

    @Override
    public void uninstallThemes(List<Theme> themes) {
        for (Theme theme : themes) {
            String themeId = theme.getThemeId();
            _themes.remove(themeId);
            this.layoutTemplateLocalService.uninstallLayoutTemplates(themeId);
        }
        _themesPool.clear();
    }

    private List<ThemeCompanyId> _getCompanyLimitExcludes(Element element) {
        ArrayList<ThemeCompanyId> includes = new ArrayList<ThemeCompanyId>();
        if (element == null) {
            return includes;
        }
        List<Element> companyIdsElements = element.elements("company-id");
        for (Element companyIdElement : companyIdsElements) {
            String name = companyIdElement.attributeValue("name");
            String pattern = companyIdElement.attributeValue("pattern");
            ThemeCompanyId themeCompanyId = null;
            if (Validator.isNotNull(name)) {
                themeCompanyId = new ThemeCompanyId(name, false);
            } else if (Validator.isNotNull(pattern)) {
                themeCompanyId = new ThemeCompanyId(pattern, true);
            }
            if (themeCompanyId == null) continue;
            includes.add(themeCompanyId);
        }
        return includes;
    }

    private List<ThemeCompanyId> _getCompanyLimitIncludes(Element element) {
        return this._getCompanyLimitExcludes(element);
    }

    private List<ThemeGroupId> _getGroupLimitExcludes(Element element) {
        ArrayList<ThemeGroupId> includes = new ArrayList<ThemeGroupId>();
        if (element == null) {
            return includes;
        }
        List<Element> groupIdsElements = element.elements("group-id");
        for (Element groupIdElement : groupIdsElements) {
            String name = groupIdElement.attributeValue("name");
            String pattern = groupIdElement.attributeValue("pattern");
            ThemeGroupId themeGroupId = null;
            if (Validator.isNotNull(name)) {
                themeGroupId = new ThemeGroupId(name, false);
            } else if (Validator.isNotNull(pattern)) {
                themeGroupId = new ThemeGroupId(pattern, true);
            }
            if (themeGroupId == null) continue;
            includes.add(themeGroupId);
        }
        return includes;
    }

    private List<ThemeGroupId> _getGroupLimitIncludes(Element element) {
        return this._getGroupLimitExcludes(element);
    }

    private Map<String, Theme> _getThemes(long companyId) {
        Map<String, Theme> themes = _themesPool.get(companyId);
        if (themes != null) {
            return themes;
        }
        themes = new ConcurrentHashMap<String, Theme>();
        for (Map.Entry<String, Theme> entry : _themes.entrySet()) {
            Theme theme = entry.getValue();
            if (!theme.isCompanyAvailable(companyId)) continue;
            themes.put(entry.getKey(), theme);
        }
        _themesPool.put(companyId, themes);
        return themes;
    }

    private Version _getVersion(String version) {
        if (version.equals("${current-version}")) {
            version = ReleaseInfo.getVersion();
        }
        return Version.getInstance(version);
    }

    private void _readColorSchemes(Element themeElement, Map<String, ColorScheme> colorSchemes, ContextReplace themeContextReplace) {
        List<Element> colorSchemeElements = themeElement.elements("color-scheme");
        for (Element colorSchemeElement : colorSchemeElements) {
            ContextReplace colorSchemeContextReplace = (ContextReplace)themeContextReplace.clone();
            String id = colorSchemeElement.attributeValue("id");
            colorSchemeContextReplace.addValue("color-scheme-id", id);
            ColorScheme colorSchemeModel = colorSchemes.get(id);
            if (colorSchemeModel == null) {
                colorSchemeModel = ColorSchemeFactoryUtil.getColorScheme(id);
            }
            String name = GetterUtil.getString(colorSchemeElement.attributeValue("name"), colorSchemeModel.getName());
            name = colorSchemeContextReplace.replace(name);
            boolean defaultCs = GetterUtil.getBoolean(colorSchemeElement.elementText("default-cs"), colorSchemeModel.isDefaultCs());
            String cssClass = GetterUtil.getString(colorSchemeElement.elementText("css-class"), colorSchemeModel.getCssClass());
            cssClass = colorSchemeContextReplace.replace(cssClass);
            colorSchemeContextReplace.addValue("css-class", cssClass);
            String colorSchemeImagesPath = GetterUtil.getString(colorSchemeElement.elementText("color-scheme-images-path"), colorSchemeModel.getColorSchemeImagesPath());
            colorSchemeImagesPath = colorSchemeContextReplace.replace(colorSchemeImagesPath);
            colorSchemeContextReplace.addValue("color-scheme-images-path", colorSchemeImagesPath);
            colorSchemeModel.setName(name);
            colorSchemeModel.setDefaultCs(defaultCs);
            colorSchemeModel.setCssClass(cssClass);
            colorSchemeModel.setColorSchemeImagesPath(colorSchemeImagesPath);
            colorSchemes.put(id, colorSchemeModel);
        }
    }

    private void _readPortletDecorators(Element themeElement, Map<String, PortletDecorator> portletDecorators, ContextReplace themeContextReplace) {
        List<Element> portletDecoratorElements = themeElement.elements("portlet-decorator");
        for (Element portletDecoratorElement : portletDecoratorElements) {
            ContextReplace portletDecoratorContextReplace = (ContextReplace)themeContextReplace.clone();
            String id = portletDecoratorElement.attributeValue("id");
            portletDecoratorContextReplace.addValue("portlet-decorator-id", id);
            PortletDecorator portletDecoratorModel = portletDecorators.get(id);
            if (portletDecoratorModel == null) {
                portletDecoratorModel = PortletDecoratorFactoryUtil.getPortletDecorator(id);
            }
            String name = GetterUtil.getString(portletDecoratorElement.attributeValue("name"), portletDecoratorModel.getName());
            name = portletDecoratorContextReplace.replace(name);
            boolean defaultPortletDecorator = GetterUtil.getBoolean(portletDecoratorElement.elementText("default-portlet-decorator"), portletDecoratorModel.isDefaultPortletDecorator());
            String cssClass = GetterUtil.getString(portletDecoratorElement.elementText("portlet-decorator-css-class"), portletDecoratorModel.getCssClass());
            cssClass = portletDecoratorContextReplace.replace(cssClass);
            portletDecoratorContextReplace.addValue("portlet-decorator-css-class", cssClass);
            String portletDecoratorThumbnailPath = GetterUtil.getString(portletDecoratorElement.elementText("portlet-decorator-thumbnail-path"), portletDecoratorModel.getPortletDecoratorThumbnailPath());
            portletDecoratorThumbnailPath = portletDecoratorContextReplace.replace(portletDecoratorThumbnailPath);
            portletDecoratorContextReplace.addValue("portlet-decorator-thumbnail-path", portletDecoratorThumbnailPath);
            portletDecoratorModel.setName(name);
            portletDecoratorModel.setDefaultPortletDecorator(defaultPortletDecorator);
            portletDecoratorModel.setCssClass(cssClass);
            portletDecoratorModel.setPortletDecoratorThumbnailPath(portletDecoratorThumbnailPath);
            portletDecorators.put(id, portletDecoratorModel);
        }
    }

    private Set<Theme> _readThemes(String servletContextName, ServletContext servletContext, String themesPath, boolean loadFromServletContext, String xml, PluginPackage pluginPackage) throws Exception {
        HashSet<Theme> themes = new HashSet<Theme>();
        if (xml == null) {
            return themes;
        }
        Document document = UnsecureSAXReaderUtil.read(xml, true);
        Element rootElement = document.getRootElement();
        Version portalVersion = this._getVersion(ReleaseInfo.getVersion());
        boolean compatible = false;
        Element compatibilityElement = rootElement.element("compatibility");
        if (compatibilityElement != null) {
            List<Element> versionElements = compatibilityElement.elements("version");
            for (Element versionElement : versionElements) {
                Version version = this._getVersion(versionElement.getTextTrim());
                if (!version.includes(portalVersion)) continue;
                compatible = true;
                break;
            }
        }
        if (!compatible) {
            _log.error("Themes in this WAR are not compatible with " + ReleaseInfo.getServerInfo());
            return themes;
        }
        ThemeCompanyLimit companyLimit = null;
        Element companyLimitElement = rootElement.element("company-limit");
        if (companyLimitElement != null) {
            Element companyExcludesElement;
            companyLimit = new ThemeCompanyLimit();
            Element companyIncludesElement = companyLimitElement.element("company-includes");
            if (companyIncludesElement != null) {
                companyLimit.setIncludes(this._getCompanyLimitIncludes(companyIncludesElement));
            }
            if ((companyExcludesElement = companyLimitElement.element("company-excludes")) != null) {
                companyLimit.setExcludes(this._getCompanyLimitExcludes(companyExcludesElement));
            }
        }
        ThemeGroupLimit groupLimit = null;
        Element groupLimitElement = rootElement.element("group-limit");
        if (groupLimitElement != null) {
            Element groupExcludesElement;
            groupLimit = new ThemeGroupLimit();
            Element groupIncludesElement = groupLimitElement.element("group-includes");
            if (groupIncludesElement != null) {
                groupLimit.setIncludes(this._getGroupLimitIncludes(groupIncludesElement));
            }
            if ((groupExcludesElement = groupLimitElement.element("group-excludes")) != null) {
                groupLimit.setExcludes(this._getGroupLimitExcludes(groupExcludesElement));
            }
        }
        long timestamp = ServletContextUtil.getLastModified(servletContext);
        List<Element> themeElements = rootElement.elements("theme");
        for (Element themeElement : themeElements) {
            String templateExtension;
            ContextReplace themeContextReplace = new ContextReplace();
            themeContextReplace.addValue("themes-path", themesPath);
            String themeId = themeElement.attributeValue("id");
            if (servletContextName != null) {
                themeId = themeId + "_WAR_" + servletContextName;
            }
            themeId = PortalUtil.getJsSafePortletId(themeId);
            themeContextReplace.addValue("theme-id", themeId);
            Theme theme = _themes.get(themeId);
            if (theme == null) {
                theme = ThemeFactoryUtil.getTheme(themeId);
            }
            if (!(templateExtension = GetterUtil.getString(themeElement.elementText("template-extension"), theme.getTemplateExtension())).equals("ftl")) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(StringBundler.concat(templateExtension, " is no longer supported for ", "theme. Please Update theme ", themeId, " to use FreeMarker for forward compatibility."));
                continue;
            }
            theme.setTemplateExtension(templateExtension);
            theme.setTimestamp(timestamp);
            PluginSetting pluginSetting = this.pluginSettingLocalService.getDefaultPluginSetting();
            theme.setPluginPackage(pluginPackage);
            theme.setDefaultPluginSetting(pluginSetting);
            theme.setThemeCompanyLimit(companyLimit);
            theme.setThemeGroupLimit(groupLimit);
            if (servletContextName != null) {
                theme.setServletContextName(servletContextName);
            }
            theme.setLoadFromServletContext(loadFromServletContext);
            String name = GetterUtil.getString(themeElement.attributeValue("name"), theme.getName());
            String rootPath = GetterUtil.getString(themeElement.elementText("root-path"), theme.getRootPath());
            rootPath = themeContextReplace.replace(rootPath);
            themeContextReplace.addValue("root-path", rootPath);
            String templatesPath = GetterUtil.getString(themeElement.elementText("templates-path"), theme.getTemplatesPath());
            templatesPath = themeContextReplace.replace(templatesPath);
            templatesPath = StringUtil.replace(templatesPath, "//", "/");
            themeContextReplace.addValue("templates-path", templatesPath);
            String cssPath = GetterUtil.getString(themeElement.elementText("css-path"), theme.getCssPath());
            cssPath = themeContextReplace.replace(cssPath);
            cssPath = StringUtil.replace(cssPath, "//", "/");
            themeContextReplace.addValue("css-path", cssPath);
            String imagesPath = GetterUtil.getString(themeElement.elementText("images-path"), theme.getImagesPath());
            imagesPath = themeContextReplace.replace(imagesPath);
            imagesPath = StringUtil.replace(imagesPath, "//", "/");
            themeContextReplace.addValue("images-path", imagesPath);
            String javaScriptPath = GetterUtil.getString(themeElement.elementText("javascript-path"), theme.getJavaScriptPath());
            javaScriptPath = themeContextReplace.replace(javaScriptPath);
            javaScriptPath = StringUtil.replace(javaScriptPath, "//", "/");
            themeContextReplace.addValue("javascript-path", javaScriptPath);
            String virtualPath = GetterUtil.getString(themeElement.elementText("virtual-path"), theme.getVirtualPath());
            theme.setName(name);
            theme.setRootPath(rootPath);
            theme.setTemplatesPath(templatesPath);
            theme.setCssPath(cssPath);
            theme.setImagesPath(imagesPath);
            theme.setJavaScriptPath(javaScriptPath);
            theme.setVirtualPath(virtualPath);
            Element settingsElement = themeElement.element("settings");
            if (settingsElement != null) {
                List<Element> settingElements = settingsElement.elements("setting");
                for (Element element : settingElements) {
                    boolean configurable = GetterUtil.getBoolean(element.attributeValue("configurable"));
                    String key = element.attributeValue("key");
                    String[] options = StringUtil.split(element.attributeValue("options"));
                    String type = element.attributeValue("type", "text");
                    String value = element.attributeValue("value", "");
                    String script = element.getTextTrim();
                    theme.addSetting(key, value, configurable, type, options, script);
                }
            }
            theme.setControlPanelTheme(GetterUtil.getBoolean(themeElement.elementText("control-panel-theme")));
            theme.setPageTheme(GetterUtil.getBoolean(themeElement.elementText("page-theme"), true));
            Element rolesElement = themeElement.element("roles");
            if (rolesElement != null) {
                List<Element> roleNameElements = rolesElement.elements("role-name");
                for (Element roleNameElement : roleNameElements) {
                    pluginSetting.addRole(roleNameElement.getText());
                }
            }
            this._readColorSchemes(themeElement, theme.getColorSchemesMap(), themeContextReplace);
            this._readColorSchemes(themeElement, theme.getColorSchemesMap(), themeContextReplace);
            Element layoutTemplatesElement = themeElement.element("layout-templates");
            if (layoutTemplatesElement != null) {
                Element customElement;
                Element element = layoutTemplatesElement.element("standard");
                if (element != null) {
                    this.layoutTemplateLocalService.readLayoutTemplate(servletContextName, servletContext, null, element, true, themeId, pluginPackage);
                }
                if ((customElement = layoutTemplatesElement.element("custom")) != null) {
                    this.layoutTemplateLocalService.readLayoutTemplate(servletContextName, servletContext, null, customElement, false, themeId, pluginPackage);
                }
            }
            this._setSpriteImages(servletContext, theme, imagesPath);
            if (!_themes.containsKey(themeId)) {
                _themes.put(themeId, theme);
            }
            this._readPortletDecorators(themeElement, theme.getPortletDecoratorsMap(), themeContextReplace);
            this._readPortletDecorators(themeElement, theme.getPortletDecoratorsMap(), themeContextReplace);
            themes.add(theme);
        }
        return themes;
    }

    private void _setSpriteImages(ServletContext servletContext, Theme theme, String resourcePath) throws Exception {
        String rootPath;
        String spritePropertiesFileName;
        Set resourcePaths;
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/".concat(resourcePath);
        }
        if ((resourcePaths = servletContext.getResourcePaths(resourcePath)) == null || resourcePaths.isEmpty()) {
            return;
        }
        ArrayList<URL> imageURLs = new ArrayList<URL>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this._setSpriteImages(servletContext, theme, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            URL imageURL = servletContext.getResource(curResourcePath);
            if (imageURL != null) {
                imageURLs.add(imageURL);
                continue;
            }
            _log.error("Resource URL for " + curResourcePath + " is null");
        }
        String spriteRootDirName = PropsValues.SPRITE_ROOT_DIR;
        String spriteFileName = resourcePath.concat(PropsValues.SPRITE_FILE_NAME);
        Properties spriteProperties = SpriteProcessorUtil.generate(servletContext, imageURLs, spriteRootDirName, spriteFileName, spritePropertiesFileName = resourcePath.concat(PropsValues.SPRITE_PROPERTIES_FILE_NAME), rootPath = ServletContextUtil.getRootPath(servletContext), 16, 16, 10240);
        if (spriteProperties == null) {
            return;
        }
        String contextPath = servletContext.getContextPath();
        spriteFileName = contextPath.concat("/sprite").concat(spriteFileName);
        theme.setSpriteImages(spriteFileName, spriteProperties);
    }
}

