/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.TeamServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamServiceImpl
extends TeamServiceBaseImpl {
    @Override
    public Team addTeam(long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_TEAMS");
        return this.teamLocalService.addTeam(this.getUserId(), groupId, name, description, serviceContext);
    }

    @Override
    public void deleteTeam(long teamId) throws PortalException {
        TeamPermissionUtil.check(this.getPermissionChecker(), teamId, "DELETE");
        this.teamLocalService.deleteTeam(teamId);
    }

    @Override
    public List<Team> getGroupTeams(long groupId) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_TEAMS");
        return this.teamLocalService.getGroupTeams(groupId);
    }

    @Override
    public Team getTeam(long teamId) throws PortalException {
        Team team = this.teamLocalService.getTeam(teamId);
        TeamPermissionUtil.check(this.getPermissionChecker(), team, "VIEW");
        return team;
    }

    @Override
    public Team getTeam(long groupId, String name) throws PortalException {
        Team team = this.teamLocalService.getTeam(groupId, name);
        TeamPermissionUtil.check(this.getPermissionChecker(), team, "VIEW");
        return team;
    }

    @Override
    public List<Team> getUserTeams(long userId) throws PortalException {
        UserPermissionUtil.check(this.getPermissionChecker(), userId, "UPDATE");
        return this.teamLocalService.getUserTeams(userId);
    }

    @Override
    public List<Team> getUserTeams(long userId, long groupId) throws PortalException {
        GroupPermissionUtil.check(this.getPermissionChecker(), groupId, "MANAGE_TEAMS");
        return this.teamLocalService.getUserTeams(userId, groupId);
    }

    @Override
    public boolean hasUserTeam(long userId, long teamId) throws PortalException {
        Team team;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains(permissionChecker, (team = this.teamPersistence.findByPrimaryKey(teamId)).getGroupId(), "MANAGE_TEAMS") && !UserPermissionUtil.contains(permissionChecker, userId, "UPDATE")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), teamId, "MANAGE_TEAMS", "UPDATE");
        }
        return this.userPersistence.containsTeam(userId, teamId);
    }

    @Override
    public List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        return this.teamFinder.filterFindByG_N_D(groupId, name, description, params, start, end, obc);
    }

    @Override
    public int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.teamFinder.filterCountByG_N_D(groupId, name, description, params);
    }

    @Override
    public Team updateTeam(long teamId, String name, String description) throws PortalException {
        TeamPermissionUtil.check(this.getPermissionChecker(), teamId, "UPDATE");
        return this.teamLocalService.updateTeam(teamId, name, description);
    }
}

