/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.DuplicateTeamException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.TeamNameException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.TeamLocalServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamLocalServiceImpl
extends TeamLocalServiceBaseImpl {
    @Override
    public Team addTeam(long userId, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validate(0L, groupId, name);
        long teamId = this.counterLocalService.increment();
        Team team = this.teamPersistence.create(teamId);
        team.setUuid(serviceContext.getUuid());
        team.setCompanyId(user.getCompanyId());
        team.setUserId(userId);
        team.setUserName(user.getFullName());
        team.setGroupId(groupId);
        team.setName(name);
        team.setDescription(description);
        this.teamPersistence.update(team);
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, userId, Team.class.getName(), team.getTeamId(), false, true, true);
        this.roleLocalService.addRole(userId, Team.class.getName(), teamId, String.valueOf(teamId), null, null, 4, null, null);
        return team;
    }

    @Override
    public Team deleteTeam(long teamId) throws PortalException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        return this.deleteTeam(team);
    }

    @Override
    public Team deleteTeam(Team team) throws PortalException {
        this.teamPersistence.remove(team);
        this.resourceLocalService.deleteResource(team.getCompanyId(), Team.class.getName(), 4, team.getTeamId());
        List<Group> groups = this.groupPersistence.findByC_S(team.getCompanyId(), true);
        for (Group group : groups) {
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            List<Long> defaultTeamIds = ListUtil.toList(StringUtil.split(typeSettingsProperties.getProperty("defaultTeamIds"), 0L));
            if (!defaultTeamIds.contains(team.getTeamId())) continue;
            defaultTeamIds.remove(team.getTeamId());
            typeSettingsProperties.setProperty("defaultTeamIds", ListUtil.toString(defaultTeamIds, ""));
            this.groupLocalService.updateGroup(group.getGroupId(), typeSettingsProperties.toString());
        }
        Role role = team.getRole();
        this.roleLocalService.deleteRole(role);
        return team;
    }

    @Override
    public void deleteTeams(long groupId) throws PortalException {
        List<Team> teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.deleteTeam(team.getTeamId());
        }
    }

    @Override
    public Team fetchTeam(long groupId, String name) {
        return this.teamPersistence.fetchByG_N(groupId, name);
    }

    @Override
    public List<Team> getGroupTeams(long groupId) {
        return this.teamPersistence.findByGroupId(groupId);
    }

    @Override
    public int getGroupTeamsCount(long groupId) {
        return this.teamPersistence.countByGroupId(groupId);
    }

    @Override
    public Team getTeam(long groupId, String name) throws PortalException {
        return this.teamPersistence.findByG_N(groupId, name);
    }

    @Override
    public List<Team> getUserOrUserGroupTeams(long groupId, long userId) {
        return this.teamFinder.findByG_U(groupId, userId, -1, -1, null);
    }

    @Override
    public List<Team> getUserTeams(long userId, long groupId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersTeams", userId);
        return this.search(groupId, null, null, params, -1, -1, null);
    }

    @Override
    public List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        return this.teamFinder.findByG_N_D(groupId, name, description, params, start, end, obc);
    }

    @Override
    public int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.teamFinder.countByG_N_D(groupId, name, description, params);
    }

    @Override
    public Team updateTeam(long teamId, String name, String description) throws PortalException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        this.validate(teamId, team.getGroupId(), name);
        team.setName(name);
        team.setDescription(description);
        this.teamPersistence.update(team);
        return team;
    }

    protected void validate(long teamId, long groupId, String name) throws PortalException {
        if (Validator.isNull(name) || Validator.isNumber(name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new TeamNameException();
        }
        Team team = this.teamPersistence.fetchByG_N(groupId, name);
        if (team != null && team.getTeamId() != teamId) {
            throw new DuplicateTeamException("{teamId=" + teamId + "}");
        }
    }
}

