/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.SystemEventLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SystemEventLocalServiceImpl
extends SystemEventLocalServiceBaseImpl {
    @Override
    public SystemEvent addSystemEvent(long userId, long groupId, String className, long classPK, String classUuid, String referrerClassName, int type, String extraData) throws PortalException {
        if (userId == 0L) {
            userId = PrincipalThreadLocal.getUserId();
        }
        long companyId = 0L;
        String userName = "";
        if (userId > 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            companyId = user.getCompanyId();
            userName = user.getFullName();
        } else if (groupId > 0L) {
            Group group = this.groupPersistence.findByPrimaryKey(groupId);
            companyId = group.getCompanyId();
        }
        return this.addSystemEvent(userId, companyId, groupId, className, classPK, classUuid, referrerClassName, type, extraData, userName);
    }

    @Override
    public SystemEvent addSystemEvent(long companyId, String className, long classPK, String classUuid, String referrerClassName, int type, String extraData) throws PortalException {
        return this.addSystemEvent(0L, companyId, 0L, className, classPK, classUuid, referrerClassName, type, extraData, "");
    }

    @Override
    public void checkSystemEvents() throws PortalException {
        if (PropsValues.STAGING_SYSTEM_EVENT_MAX_AGE <= 0) {
            return;
        }
        ActionableDynamicQuery actionableDynamicQuery = this.systemEventLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Calendar calendar = Calendar.getInstance();
            calendar.add(10, -PropsValues.STAGING_SYSTEM_EVENT_MAX_AGE);
            dynamicQuery.add(RestrictionsFactoryUtil.lt("createDate", calendar.getTime()));
        });
        actionableDynamicQuery.setPerformActionMethod(systemEvent -> this.deleteSystemEvent((SystemEvent)systemEvent));
        actionableDynamicQuery.performActions();
    }

    @Override
    public void deleteSystemEvents(long groupId) {
        this.systemEventPersistence.removeByGroupId(groupId);
    }

    @Override
    public void deleteSystemEvents(long groupId, long systemEventSetKey) {
        this.systemEventPersistence.removeByG_S(groupId, systemEventSetKey);
    }

    @Override
    public SystemEvent fetchSystemEvent(long groupId, long classNameId, long classPK, int type) {
        return this.systemEventPersistence.fetchByG_C_C_T_First(groupId, classNameId, classPK, type, null);
    }

    @Override
    public List<SystemEvent> getSystemEvents(long groupId, long classNameId, long classPK) {
        return this.systemEventPersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    @Override
    public List<SystemEvent> getSystemEvents(long groupId, long classNameId, long classPK, int type) {
        return this.systemEventPersistence.findByG_C_C_T(groupId, classNameId, classPK, type);
    }

    @Override
    public boolean validateGroup(long groupId) throws PortalException {
        if (groupId > 0L) {
            Group group = this.groupLocalService.getGroup(groupId);
            if (group.hasStagingGroup() && !group.isStagedRemotely()) {
                return false;
            }
            if (group.hasRemoteStagingGroup() && !PropsValues.STAGING_LIVE_GROUP_REMOTE_STAGING_ENABLED) {
                return false;
            }
        }
        return true;
    }

    protected SystemEvent addSystemEvent(long userId, long companyId, long groupId, String className, long classPK, String classUuid, String referrerClassName, int type, String extraData, String userName) throws PortalException {
        Company company;
        Group companyGroup;
        SystemEventHierarchyEntry systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek();
        int action = 0;
        if (systemEventHierarchyEntry != null && (action = systemEventHierarchyEntry.getAction()) == 1 && !systemEventHierarchyEntry.hasTypedModel(className, classPK)) {
            return null;
        }
        if (!CompanyThreadLocal.isDeleteInProcess() && (companyGroup = (company = this.companyPersistence.findByPrimaryKey(companyId)).getGroup()).getGroupId() == groupId) {
            groupId = 0L;
        }
        if (!this.validateGroup(groupId)) {
            return null;
        }
        if (Validator.isNotNull(referrerClassName) && referrerClassName.equals(className)) {
            referrerClassName = null;
        }
        long systemEventId = 0L;
        systemEventId = systemEventHierarchyEntry != null && systemEventHierarchyEntry.hasTypedModel(className, classPK) ? systemEventHierarchyEntry.getSystemEventId() : this.counterLocalService.increment();
        SystemEvent systemEvent = this.systemEventPersistence.create(systemEventId);
        systemEvent.setGroupId(groupId);
        systemEvent.setCompanyId(companyId);
        systemEvent.setUserId(userId);
        systemEvent.setUserName(userName);
        systemEvent.setCreateDate(new Date());
        systemEvent.setClassName(className);
        systemEvent.setClassPK(classPK);
        systemEvent.setClassUuid(classUuid);
        systemEvent.setReferrerClassName(referrerClassName);
        long parentSystemEventId = 0L;
        if (action == 3) {
            parentSystemEventId = systemEventHierarchyEntry.hasTypedModel(className, classPK) ? systemEventHierarchyEntry.getParentSystemEventId() : systemEventHierarchyEntry.getSystemEventId();
        }
        systemEvent.setParentSystemEventId(parentSystemEventId);
        long systemEventSetKey = 0L;
        systemEventSetKey = action == 2 || action == 3 ? systemEventHierarchyEntry.getSystemEventSetKey() : this.counterLocalService.increment();
        systemEvent.setSystemEventSetKey(systemEventSetKey);
        systemEvent.setType(type);
        systemEvent.setExtraData(extraData);
        return this.systemEventPersistence.update(systemEvent);
    }
}

