/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.DuplicateRoleException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredRoleException;
import com.liferay.portal.kernel.exception.RoleNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.RoleLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RoleLocalServiceImpl
extends RoleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(RoleLocalServiceImpl.class);
    private final Map<String, Role> _systemRolesMap = new HashMap<String, Role>();

    @Override
    public Role addRole(long userId, String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        className = GetterUtil.getString(className);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        long roleId = this.counterLocalService.increment();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            classNameId = this.classNameLocalService.getClassNameId(Role.class);
            classPK = roleId;
        }
        this.validate(0L, user.getCompanyId(), classNameId, name);
        Role role = this.rolePersistence.create(roleId);
        if (serviceContext != null) {
            role.setUuid(serviceContext.getUuid());
        }
        role.setCompanyId(user.getCompanyId());
        role.setUserId(user.getUserId());
        role.setUserName(user.getFullName());
        role.setClassNameId(classNameId);
        role.setClassPK(classPK);
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescriptionMap(descriptionMap);
        role.setType(type);
        role.setSubtype(subtype);
        role.setExpandoBridgeAttributes(serviceContext);
        this.rolePersistence.update(role);
        long ownerId = userId;
        if (user.isDefaultUser()) {
            ownerId = 0L;
        }
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, ownerId, Role.class.getName(), role.getRoleId(), false, false, false);
        if (!user.isDefaultUser()) {
            this.resourceLocalService.addResources(user.getCompanyId(), 0L, userId, Role.class.getName(), role.getRoleId(), false, false, false);
            if (!ExportImportThreadLocal.isImportInProcess()) {
                this.reindex(userId);
            }
        }
        return role;
    }

    @Override
    public void addUserRole(long userId, long roleId) throws PortalException {
        this.userPersistence.addRole(userId, roleId);
        this.reindex(userId);
    }

    @Override
    public void addUserRole(long userId, Role role) throws PortalException {
        this.userPersistence.addRole(userId, role);
        this.reindex(userId);
    }

    @Override
    public void addUserRoles(long userId, List<Role> roles) throws PortalException {
        this.userPersistence.addRoles(userId, roles);
        this.reindex(userId);
    }

    @Override
    public void addUserRoles(long userId, long[] roleIds) throws PortalException {
        this.userPersistence.addRoles(userId, roleIds);
        this.reindex(userId);
    }

    @Override
    public void checkSystemRoles() throws PortalException {
        List<Company> companies = this.companyLocalService.getCompanies();
        for (Company company : companies) {
            this.checkSystemRoles(company.getCompanyId());
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemRoles(long companyId) throws PortalException {
        String[] allSystemRoles;
        String[] systemSiteRoles;
        String[] stringArray;
        String[] systemRoles;
        String companyIdHexString = StringUtil.toHexString(companyId);
        List<Role> roles = null;
        try {
            roles = this.roleFinder.findBySystem(companyId);
        }
        catch (Exception e) {
            this.runSQL("alter table Role_ add uuid_ VARCHAR(75) null");
            this.runSQL("alter table Role_ add userId LONG");
            this.runSQL("alter table Role_ add userName VARCHAR(75) null");
            this.runSQL("alter table Role_ add createDate DATE null");
            this.runSQL("alter table Role_ add modifiedDate DATE null");
            roles = this.roleFinder.findBySystem(companyId);
        }
        for (Role role : roles) {
            this._systemRolesMap.put(companyIdHexString.concat(role.getName()), role);
        }
        for (String name : systemRoles = PortalUtil.getSystemRoles()) {
            String key = "system.role." + StringUtil.replace(name, ' ', '.') + ".description";
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), PropsUtil.get(key));
            int type = 1;
            this.checkSystemRole(companyId, name, descriptionMap, type);
        }
        for (String name : stringArray = PortalUtil.getSystemOrganizationRoles()) {
            String key = "system.organization.role." + StringUtil.replace(name, ' ', '.') + ".description";
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), PropsUtil.get(key));
            int type = 3;
            this.checkSystemRole(companyId, name, descriptionMap, type);
        }
        for (String name : systemSiteRoles = PortalUtil.getSystemSiteRoles()) {
            String key = "system.site.role." + StringUtil.replace(name, ' ', '.') + ".description";
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), PropsUtil.get(key));
            int type = 2;
            this.checkSystemRole(companyId, name, descriptionMap, type);
        }
        for (String roleName : allSystemRoles = ArrayUtil.append(systemRoles, stringArray, systemSiteRoles)) {
            Role role = this.getRole(companyId, roleName);
            this.resourceLocalService.addResources(companyId, 0L, 0L, Role.class.getName(), role.getRoleId(), false, false, false);
        }
        Role userRole = this.getRole(companyId, "User");
        for (String roleName : allSystemRoles) {
            Role role = this.getRole(companyId, roleName);
            this.resourcePermissionLocalService.setResourcePermissions(companyId, Role.class.getName(), 4, String.valueOf(role.getRoleId()), userRole.getRoleId(), new String[]{"VIEW"});
        }
    }

    @Override
    public void clearUserRoles(long userId) throws PortalException {
        this.userPersistence.clearRoles(userId);
        this.reindex(userId);
    }

    @Override
    public Role deleteRole(long roleId) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        return this.roleLocalService.deleteRole(role);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Role deleteRole(Role role) throws PortalException {
        if (role.isSystem() && !CompanyThreadLocal.isDeleteInProcess()) {
            throw new RequiredRoleException();
        }
        List<ResourcePermission> resourcePermissions = this.resourcePermissionPersistence.findByRoleId(role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        String className = role.getClassName();
        long classNameId = role.getClassNameId();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            this.resourceLocalService.deleteResource(role.getCompanyId(), Role.class.getName(), 4, role.getRoleId());
        }
        if (role.getType() == 3 || role.getType() == 2) {
            List<Group> groups = this.groupPersistence.findByC_S(role.getCompanyId(), true);
            for (Group group : groups) {
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                List<Long> defaultSiteRoleIds = ListUtil.toList(StringUtil.split(typeSettingsProperties.getProperty("defaultSiteRoleIds"), 0L));
                if (!defaultSiteRoleIds.contains(role.getRoleId())) continue;
                defaultSiteRoleIds.remove(role.getRoleId());
                typeSettingsProperties.setProperty("defaultSiteRoleIds", ListUtil.toString(defaultSiteRoleIds, ""));
                this.groupLocalService.updateGroup(group.getGroupId(), typeSettingsProperties.toString());
            }
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(role.getRoleId());
            this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByRoleId(role.getRoleId());
        }
        this.rolePersistence.remove(role);
        this.expandoRowLocalService.deleteRows(role.getRoleId());
        return role;
    }

    @Override
    public void deleteUserRole(long userId, long roleId) throws PortalException {
        this.userPersistence.removeRole(userId, roleId);
        this.reindex(userId);
    }

    @Override
    public void deleteUserRole(long userId, Role role) throws PortalException {
        this.userPersistence.removeRole(userId, role);
        this.reindex(userId);
    }

    @Override
    public void deleteUserRoles(long userId, List<Role> roles) throws PortalException {
        this.userPersistence.removeRoles(userId, roles);
        this.reindex(userId);
    }

    @Override
    public void deleteUserRoles(long userId, long[] roleIds) throws PortalException {
        this.userPersistence.removeRoles(userId, roleIds);
        this.reindex(userId);
    }

    @Override
    @Transactional(enabled=false)
    public Role fetchRole(long companyId, String name) {
        String companyIdHexString = StringUtil.toHexString(companyId);
        Role role = this._systemRolesMap.get(companyIdHexString.concat(name));
        if (role != null) {
            return role;
        }
        return this.roleLocalService.loadFetchRole(companyId, name);
    }

    @Override
    public int getAssigneesTotal(long roleId) throws PortalException {
        Long count;
        List list;
        Property property;
        int assigneesTotal = 0;
        Role role = this.getRole(roleId);
        int type = role.getType();
        if (type == 1) {
            assigneesTotal += this.groupLocalService.getRoleGroupsCount(roleId);
            assigneesTotal += this.userLocalService.getRoleUsersCount(roleId);
        }
        if (type == 2) {
            DynamicQuery userGroupGroupRoleDynamicQuery = this.userGroupGroupRoleLocalService.dynamicQuery();
            property = PropertyFactoryUtil.forName("primaryKey.roleId");
            userGroupGroupRoleDynamicQuery.add(property.eq(roleId));
            userGroupGroupRoleDynamicQuery.setProjection(ProjectionFactoryUtil.countDistinct("primaryKey.userGroupId"));
            list = this.userGroupRoleLocalService.dynamicQuery(userGroupGroupRoleDynamicQuery);
            count = (Long)list.get(0);
            assigneesTotal += count.intValue();
        }
        if (type == 2 || type == 3) {
            DynamicQuery userGroupRoleDynamicQuery = this.userGroupRoleLocalService.dynamicQuery();
            property = PropertyFactoryUtil.forName("primaryKey.roleId");
            userGroupRoleDynamicQuery.add(property.eq(roleId));
            userGroupRoleDynamicQuery.setProjection(ProjectionFactoryUtil.countDistinct("primaryKey.userId"));
            list = this.userGroupRoleLocalService.dynamicQuery(userGroupRoleDynamicQuery);
            count = (Long)list.get(0);
            assigneesTotal += count.intValue();
        }
        return assigneesTotal;
    }

    @Override
    public Role getDefaultGroupRole(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            Layout layout = this.layoutLocalService.getLayout(group.getClassPK());
            group = layout.getGroup();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        Role role = null;
        role = group.isCompany() ? this.getRole(group.getCompanyId(), "User") : (group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isRegularSite() || group.isSite() ? this.getRole(group.getCompanyId(), "Site Member") : (group.isOrganization() ? this.getRole(group.getCompanyId(), "Organization User") : this.getRole(group.getCompanyId(), "User")));
        return role;
    }

    @Override
    public List<Role> getGroupRelatedRoles(long groupId) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>();
        Group group = this.groupLocalService.getGroup(groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        int[] types = RoleConstants.TYPES_REGULAR;
        if (group.isOrganization()) {
            types = group.isSite() ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE : RoleConstants.TYPES_ORGANIZATION_AND_REGULAR;
        } else if (group.isLayout() || group.isLayoutSetPrototype() || group.isSite() || group.isUser()) {
            types = RoleConstants.TYPES_REGULAR_AND_SITE;
        }
        roles.addAll(this.getRoles(group.getCompanyId(), types));
        roles.addAll(this.getTeamRoles(groupId));
        return roles;
    }

    @Override
    public List<Role> getGroupRolesAndTeamRoles(long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId, int start, int end) {
        return this.roleFinder.findByGroupRoleAndTeamRole(companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId, start, end);
    }

    @Override
    public int getGroupRolesAndTeamRolesCount(long companyId, String keywords, List<String> excludedNames, int[] types, long excludedTeamRoleId, long teamGroupId) {
        return this.roleFinder.countByGroupRoleAndTeamRole(companyId, keywords, excludedNames, types, excludedTeamRoleId, teamGroupId);
    }

    @Override
    @Deprecated
    public List<Role> getResourceBlockRoles(long resourceBlockId, String className, String actionId) {
        return this.roleFinder.findByR_N_A(resourceBlockId, className, actionId);
    }

    @Override
    public Map<String, List<String>> getResourceRoles(long companyId, String name, int scope, String primKey) {
        return this.roleFinder.findByC_N_S_P(companyId, name, scope, primKey);
    }

    @Override
    public List<Role> getResourceRoles(long companyId, String name, int scope, String primKey, String actionId) {
        return this.roleFinder.findByC_N_S_P_A(companyId, name, scope, primKey, actionId);
    }

    @Override
    @Transactional(enabled=false)
    public Role getRole(long companyId, String name) throws PortalException {
        String companyIdHexString = StringUtil.toHexString(companyId);
        Role role = this._systemRolesMap.get(companyIdHexString.concat(name));
        if (role != null) {
            return role;
        }
        return this.roleLocalService.loadGetRole(companyId, name);
    }

    @Override
    public List<Role> getRoles(int type, String subtype) {
        return this.rolePersistence.findByT_S(type, subtype);
    }

    @Override
    public List<Role> getRoles(long companyId) {
        return this.rolePersistence.findByCompanyId(companyId);
    }

    @Override
    public List<Role> getRoles(long companyId, int[] types) {
        return this.rolePersistence.findByC_T(companyId, types);
    }

    @Override
    public List<Role> getRoles(long[] roleIds) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>(roleIds.length);
        for (long roleId : roleIds) {
            Role role = this.getRole(roleId);
            roles.add(role);
        }
        return roles;
    }

    @Override
    public List<Role> getSubtypeRoles(String subtype) {
        return this.rolePersistence.findBySubtype(subtype);
    }

    @Override
    public int getSubtypeRolesCount(String subtype) {
        return this.rolePersistence.countBySubtype(subtype);
    }

    @Override
    public Role getTeamRole(long companyId, long teamId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Team.class);
        return this.rolePersistence.findByC_C_C(companyId, classNameId, teamId);
    }

    @Override
    public Map<Team, Role> getTeamRoleMap(long groupId) throws PortalException {
        return this.getTeamRoleMap(groupId, null);
    }

    @Override
    public List<Role> getTeamRoles(long groupId) throws PortalException {
        return this.getTeamRoles(groupId, null);
    }

    @Override
    public List<Role> getTeamRoles(long groupId, long[] excludedRoleIds) throws PortalException {
        Map<Team, Role> teamRoleMap = this.getTeamRoleMap(groupId, excludedRoleIds);
        Collection<Role> roles = teamRoleMap.values();
        return ListUtil.fromCollection(roles);
    }

    @Override
    public List<Role> getTeamsRoles(long companyId, long[] teamIds) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Team.class);
        return this.rolePersistence.findByC_C_C(companyId, classNameId, teamIds);
    }

    @Override
    public List<Role> getTypeRoles(int type) {
        return this.rolePersistence.findByType(type);
    }

    @Override
    public List<Role> getTypeRoles(int type, int start, int end) {
        return this.rolePersistence.findByType(type, start, end);
    }

    @Override
    public int getTypeRolesCount(int type) {
        return this.rolePersistence.countByType(type);
    }

    @Override
    public List<Role> getUserGroupGroupRoles(long userId, long groupId) {
        return this.roleFinder.findByUserGroupGroupRole(userId, groupId);
    }

    @Override
    public List<Role> getUserGroupGroupRoles(long userId, long groupId, int start, int end) {
        return this.roleFinder.findByUserGroupGroupRole(userId, groupId, start, end);
    }

    @Override
    public int getUserGroupGroupRolesCount(long userId, long groupId) {
        return this.roleFinder.countByUserGroupGroupRole(userId, groupId);
    }

    @Override
    public List<Role> getUserGroupRoles(long userId, long groupId) {
        return this.roleFinder.findByUserGroupRole(userId, groupId);
    }

    @Override
    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptyList();
        }
        return this.roleFinder.findByU_G(userId, groups);
    }

    @Override
    public List<Role> getUserRelatedRoles(long userId, long groupId) {
        return this.roleFinder.findByU_G(userId, groupId);
    }

    @Override
    public List<Role> getUserRelatedRoles(long userId, long[] groupIds) {
        return this.roleFinder.findByU_G(userId, groupIds);
    }

    @Override
    public List<Role> getUserTeamRoles(long userId, long groupId) {
        return this.roleFinder.findByTeamsUser(userId, groupId);
    }

    @Override
    @ThreadLocalCachable
    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException {
        Role role = this.rolePersistence.fetchByC_N(companyId, name);
        if (role == null) {
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat("Role ", name, " with company ID ", companyId, " does not exist"));
            }
            return false;
        }
        if (role.getType() != 1) {
            throw new IllegalArgumentException(name + " is not a regular role");
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        if (userId == defaultUserId) {
            return name.equals("Guest");
        }
        if (inherited) {
            String roleId;
            String key;
            if (this.userPersistence.containsRole(userId, role.getRoleId())) {
                return true;
            }
            ThreadLocalCache<Boolean> threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache(Lifecycle.REQUEST, (Serializable)((Object)RoleLocalServiceImpl.class.getName()));
            Boolean value = (Boolean)threadLocalCache.get(key = (roleId = String.valueOf(role.getRoleId())).concat(String.valueOf(userId)));
            if (value != null) {
                return value;
            }
            value = PermissionCacheUtil.getUserRole(userId, role);
            if (value == null) {
                int count = this.roleFinder.countByR_U(role.getRoleId(), userId);
                value = count > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                PermissionCacheUtil.putUserRole(userId, role, value);
            }
            threadLocalCache.put(key, value);
            return value;
        }
        return this.userPersistence.containsRole(userId, role.getRoleId());
    }

    @Override
    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException {
        for (String name : names) {
            if (!this.hasUserRole(userId, companyId, name, inherited)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Role loadFetchRole(long companyId, String name) {
        return this.rolePersistence.fetchByC_N(companyId, name);
    }

    @Override
    public Role loadGetRole(long companyId, String name) throws PortalException {
        return this.rolePersistence.findByC_N(companyId, name);
    }

    @Override
    public List<Role> search(long companyId, String keywords, Integer[] types, int start, int end, OrderByComparator<Role> obc) {
        return this.search(companyId, keywords, types, new LinkedHashMap<String, Object>(), start, end, obc);
    }

    @Override
    public List<Role> search(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> obc) {
        return this.roleFinder.findByKeywords(companyId, keywords, types, params, start, end, obc);
    }

    @Override
    public List<Role> search(long companyId, String name, String description, Integer[] types, int start, int end, OrderByComparator<Role> obc) {
        return this.search(companyId, name, description, types, new LinkedHashMap<String, Object>(), start, end, obc);
    }

    @Override
    public List<Role> search(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> obc) {
        return this.roleFinder.findByC_N_D_T(companyId, name, description, types, params, true, start, end, obc);
    }

    @Override
    public int searchCount(long companyId, String keywords, Integer[] types) {
        return this.searchCount(companyId, keywords, types, new LinkedHashMap<String, Object>());
    }

    @Override
    public int searchCount(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.countByKeywords(companyId, keywords, types, params);
    }

    @Override
    public int searchCount(long companyId, String name, String description, Integer[] types) {
        return this.searchCount(companyId, name, description, types, new LinkedHashMap<String, Object>());
    }

    @Override
    public int searchCount(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.countByC_N_D_T(companyId, name, description, types, params, true);
    }

    @Override
    public void setUserRoles(long userId, long[] roleIds) throws PortalException {
        roleIds = UsersAdminUtil.addRequiredRoles(userId, roleIds);
        this.userPersistence.setRoles(userId, roleIds);
        this.reindex(userId);
    }

    @Override
    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException {
        roleIds = UsersAdminUtil.removeRequiredRoles(userId, roleIds);
        this.userPersistence.removeRoles(userId, roleIds);
        this.reindex(userId);
    }

    @Override
    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        this.validate(roleId, role.getCompanyId(), role.getClassNameId(), name);
        if (role.isSystem()) {
            name = role.getName();
            subtype = null;
        }
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescriptionMap(descriptionMap);
        role.setSubtype(subtype);
        role.setExpandoBridgeAttributes(serviceContext);
        this.rolePersistence.update(role);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSystemRole(long companyId, String name, Map<Locale, String> descriptionMap, int type) throws PortalException {
        Role role;
        String key;
        block9: {
            String companyIdHexString = StringUtil.toHexString(companyId);
            key = companyIdHexString.concat(name);
            role = this._systemRolesMap.get(key);
            try {
                if (role == null) {
                    role = this.rolePersistence.findByC_N(companyId, name);
                }
                if (!descriptionMap.equals(role.getDescriptionMap())) {
                    role.setDescriptionMap(descriptionMap);
                    this.roleLocalService.updateRole(role);
                }
            }
            catch (NoSuchRoleException nsre) {
                if (_log.isDebugEnabled()) {
                    _log.debug(nsre, nsre);
                }
                User user = this.userLocalService.getDefaultUser(companyId);
                PermissionThreadLocal.setAddResource(false);
                try {
                    role = this.roleLocalService.addRole(user.getUserId(), null, 0L, name, null, descriptionMap, type, null, null);
                }
                finally {
                    PermissionThreadLocal.setAddResource(true);
                }
                if (!name.equals("User")) break block9;
                this.initPersonalControlPanelPortletsPermissions(role);
            }
        }
        this._systemRolesMap.put(key, role);
    }

    protected String[] getDefaultControlPanelPortlets() {
        String myAccountPortletId = PortletProviderUtil.getPortletId("com.liferay.admin.kernel.util.PortalMyAccountApplicationType$MyAccount", PortletProvider.Action.VIEW);
        return new String[]{myAccountPortletId, "com_liferay_layout_admin_web_portlet_MyPagesPortlet", "com_liferay_portal_workflow_instance_web_portlet_MyWorkflowInstancePortlet", "com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet"};
    }

    protected Map<Team, Role> getTeamRoleMap(long groupId, long[] excludedRoleIds) throws PortalException {
        List<Team> teams;
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        if ((teams = this.teamPersistence.findByGroupId(group.getGroupId())).isEmpty()) {
            return Collections.emptyMap();
        }
        Set<Long> roleIds = SetUtil.fromArray(excludedRoleIds);
        LinkedHashMap<Team, Role> teamRoleMap = new LinkedHashMap<Team, Role>();
        for (Team team : teams) {
            Role role = this.getTeamRole(team.getCompanyId(), team.getTeamId());
            if (roleIds.contains(role.getRoleId())) continue;
            teamRoleMap.put(team, role);
        }
        return teamRoleMap;
    }

    protected void initPersonalControlPanelPortletsPermissions(Role role) throws PortalException {
        for (String portletId : this.getDefaultControlPanelPortlets()) {
            ResourceAction resourceAction;
            int count = this.resourcePermissionPersistence.countByC_N_S_P_R(role.getCompanyId(), portletId, 1, String.valueOf(role.getCompanyId()), role.getRoleId());
            if (count > 0 || (resourceAction = this.resourceActionLocalService.fetchResourceAction(portletId, "ACCESS_IN_CONTROL_PANEL")) == null) continue;
            this.setRolePermissions(role, portletId, new String[]{"ACCESS_IN_CONTROL_PANEL"});
        }
    }

    protected void reindex(long userId) throws SearchException {
        Indexer<User> indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        User user = this.userLocalService.fetchUser(userId);
        indexer.reindex(user);
    }

    protected void setRolePermissions(Role role, String name, String[] actionIds) throws PortalException {
        this.resourcePermissionLocalService.setResourcePermissions(role.getCompanyId(), name, 1, String.valueOf(role.getCompanyId()), role.getRoleId(), actionIds);
    }

    protected void validate(long roleId, long companyId, long classNameId, String name) throws PortalException {
        block7: {
            if (classNameId == this.classNameLocalService.getClassNameId(Role.class)) {
                if (Validator.isNull(name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
                    throw new RoleNameException();
                }
                if (Validator.isNumber(name) && !PropsValues.ROLES_NAME_ALLOW_NUMERIC) {
                    throw new RoleNameException();
                }
            }
            try {
                Role role = this.roleFinder.findByC_N(companyId, name);
                if (role.getRoleId() != roleId) {
                    throw new DuplicateRoleException("{roleId=" + roleId + "}");
                }
            }
            catch (NoSuchRoleException nsre) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug(nsre, nsre);
            }
        }
        if (name.equals("PLACEHOLDER_DEFAULT_GROUP_ROLE")) {
            throw new RoleNameException("PLACEHOLDER_DEFAULT_GROUP_ROLE is a temporary placeholder that must not be persisted");
        }
    }
}

