/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.service.base.ResourceLocalServiceBaseImpl;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;

@Transactional(enabled=false)
public class ResourceLocalServiceImpl
extends ResourceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ResourceLocalServiceImpl.class);

    @Override
    public void addModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        this.resourcePermissionLocalService.addModelResourcePermissions(auditedModel, serviceContext);
    }

    @Override
    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, ModelPermissions modelPermissions) throws PortalException {
        this.resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, String.valueOf(primKey), modelPermissions);
    }

    @Override
    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, String.valueOf(primKey), groupPermissions, guestPermissions);
    }

    @Override
    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        this.resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, primKey, modelPermissions);
    }

    @Override
    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourcePermissionLocalService.addModelResourcePermissions(companyId, groupId, userId, name, primKey, groupPermissions, guestPermissions);
    }

    @Override
    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourcePermissionLocalService.addResourcePermissions(companyId, groupId, userId, name, String.valueOf(primKey), portletActions, addGroupPermissions, addGuestPermissions);
    }

    @Override
    public void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourcePermissionLocalService.addResourcePermissions(companyId, groupId, userId, name, primKey, portletActions, addGroupPermissions, addGuestPermissions);
    }

    @Override
    public void addResources(long companyId, long groupId, String name, boolean portletActions) throws PortalException {
        this.resourcePermissionLocalService.addResourcePermissions(companyId, groupId, 0L, name, null, portletActions, false, false);
    }

    @Override
    public void copyModelResources(long companyId, String name, long oldPrimKey, long newPrimKey) throws PortalException {
        this.resourcePermissionLocalService.copyModelResourcePermissions(companyId, name, oldPrimKey, newPrimKey);
    }

    @Override
    public void deleteResource(AuditedModel auditedModel, int scope) throws PortalException {
        this.resourcePermissionLocalService.deleteResourcePermissions(auditedModel.getCompanyId(), auditedModel.getModelClassName(), scope, String.valueOf(auditedModel.getPrimaryKeyObj()));
    }

    @Override
    public void deleteResource(long companyId, String name, int scope, long primKey) throws PortalException {
        this.resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
    }

    @Override
    public void deleteResource(long companyId, String name, int scope, String primKey) throws PortalException {
        this.resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
    }

    @Override
    public Resource getResource(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    @Override
    public boolean hasUserPermissions(long userId, long resourceId, List<Resource> resources, String actionId, long[] roleIds) throws PortalException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean hasUserPermissions = this.resourcePermissionLocalService.hasResourcePermission(resources, roleIds, actionId);
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Checking user permissions for ", userId, " ", resourceId, " ", actionId, " takes ", stopWatch.getTime(), " ms"));
        }
        return hasUserPermissions;
    }

    @Override
    public void updateModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        this.resourcePermissionLocalService.updateModelResourcePermissions(auditedModel, serviceContext);
    }

    @Override
    public void updateResources(long companyId, long groupId, String name, long primKey, ModelPermissions modelPermissions) throws PortalException {
        this.resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, String.valueOf(primKey), modelPermissions);
    }

    @Override
    public void updateResources(long companyId, long groupId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, primKey, groupPermissions, guestPermissions);
    }

    @Override
    public void updateResources(long companyId, long groupId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        this.resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, primKey, modelPermissions);
    }

    @Override
    public void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, name, primKey, groupPermissions, guestPermissions);
    }

    @Override
    public void updateResources(long companyId, String name, int scope, String primKey, String newPrimKey) {
        this.resourcePermissionLocalService.updateResourcePermissions(companyId, name, scope, primKey, newPrimKey);
    }
}

