/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourceActionLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceActionLocalServiceImpl
extends ResourceActionLocalServiceBaseImpl {
    private static final Map<String, ResourceAction> _resourceActions = new ConcurrentHashMap<String, ResourceAction>();

    @Override
    public ResourceAction addResourceAction(String name, String actionId, long bitwiseValue) {
        ResourceAction resourceAction = this.resourceActionPersistence.fetchByN_A(name, actionId);
        if (resourceAction == null) {
            long resourceActionId = this.counterLocalService.increment(ResourceAction.class.getName());
            resourceAction = this.resourceActionPersistence.create(resourceActionId);
            resourceAction.setName(name);
            resourceAction.setActionId(actionId);
            resourceAction.setBitwiseValue(bitwiseValue);
            this.resourceActionPersistence.update(resourceAction);
        }
        return resourceAction;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceActions() {
        List<ResourceAction> resourceActions = this.resourceActionPersistence.findAll();
        for (ResourceAction resourceAction : resourceActions) {
            String key = this.encodeKey(resourceAction.getName(), resourceAction.getActionId());
            _resourceActions.put(key, resourceAction);
        }
    }

    @Override
    public void checkResourceActions(String name, List<String> actionIds) {
        this.checkResourceActions(name, actionIds, false);
    }

    @Override
    public void checkResourceActions(String name, List<String> actionIds, boolean addDefaultActions) {
        if (actionIds.size() > 64 || actionIds.size() == 64 && !actionIds.contains("VIEW")) {
            throw new SystemException("There are too many actions for resource " + name);
        }
        long availableBits = -2L;
        HashMap<String, ResourceAction> resourceActionMap = new HashMap<String, ResourceAction>();
        List<ResourceAction> resourceActions = this.getResourceActions(name);
        for (ResourceAction resourceAction : resourceActions) {
            availableBits &= resourceAction.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL;
            resourceActionMap.put(resourceAction.getActionId(), resourceAction);
        }
        ArrayList<Object[]> keyActionIdAndBitwiseValues = null;
        for (String actionId : actionIds) {
            String key = this.encodeKey(name, actionId);
            ResourceAction resourceAction = _resourceActions.get(key);
            if (resourceAction != null) continue;
            resourceAction = (ResourceAction)resourceActionMap.get(actionId);
            if (resourceAction == null) {
                long bitwiseValue = 1L;
                if (!actionId.equals("VIEW")) {
                    bitwiseValue = Long.lowestOneBit(availableBits);
                    availableBits ^= bitwiseValue;
                }
                if (keyActionIdAndBitwiseValues == null) {
                    keyActionIdAndBitwiseValues = new ArrayList<Object[]>();
                }
                keyActionIdAndBitwiseValues.add(new Object[]{key, actionId, bitwiseValue});
                continue;
            }
            _resourceActions.put(key, resourceAction);
        }
        if (keyActionIdAndBitwiseValues == null) {
            return;
        }
        long l = this.counterLocalService.increment(ResourceAction.class.getName(), keyActionIdAndBitwiseValues.size());
        l -= (long)keyActionIdAndBitwiseValues.size();
        for (Object[] keyActionIdAndBitwiseValue : keyActionIdAndBitwiseValues) {
            String key = (String)keyActionIdAndBitwiseValue[0];
            String actionId = (String)keyActionIdAndBitwiseValue[1];
            long bitwiseValue = (Long)keyActionIdAndBitwiseValue[2];
            ResourceAction resourceAction = null;
            try {
                resourceAction = this.resourceActionPersistence.create(++l);
                resourceAction.setName(name);
                resourceAction.setActionId(actionId);
                resourceAction.setBitwiseValue(bitwiseValue);
                this.resourceActionPersistence.update(resourceAction);
            }
            catch (Throwable t) {
                resourceAction = this.resourceActionLocalService.addResourceAction(name, actionId, bitwiseValue);
            }
            _resourceActions.put(key, resourceAction);
        }
        if (!addDefaultActions) {
            return;
        }
        List<String> groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions(name);
        List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(name);
        long guestBitwiseValue = 0L;
        long ownerBitwiseValue = 0L;
        long siteMemberBitwiseValue = 0L;
        for (Object[] keyActionIdAndBitwiseValue : keyActionIdAndBitwiseValues) {
            String actionId = (String)keyActionIdAndBitwiseValue[1];
            long bitwiseValue = (Long)keyActionIdAndBitwiseValue[2];
            if (guestDefaultActions.contains(actionId)) {
                guestBitwiseValue |= bitwiseValue;
            }
            ownerBitwiseValue |= bitwiseValue;
            if (!groupDefaultActions.contains(actionId)) continue;
            siteMemberBitwiseValue |= bitwiseValue;
        }
        if (guestBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Guest", 4, guestBitwiseValue);
        }
        if (ownerBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Owner", 4, ownerBitwiseValue);
        }
        if (siteMemberBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Site Member", 4, siteMemberBitwiseValue);
        }
    }

    @Override
    public ResourceAction deleteResourceAction(long resourceActionId) throws PortalException {
        return this.deleteResourceAction(this.resourceActionPersistence.findByPrimaryKey(resourceActionId));
    }

    @Override
    public ResourceAction deleteResourceAction(ResourceAction resourceAction) {
        String name = resourceAction.getName();
        long bitwiseValue = resourceAction.getBitwiseValue();
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = dynamicQuery -> {
            Property nameProperty = PropertyFactoryUtil.forName("name");
            dynamicQuery.add(nameProperty.eq(name));
        };
        for (Company company : this.companyLocalService.getCompanies()) {
            ActionableDynamicQuery actionableDynamicQuery = this.resourcePermissionLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(addCriteriaMethod);
            actionableDynamicQuery.setCompanyId(company.getCompanyId());
            actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
                long actionIds = resourcePermission.getActionIds();
                if ((actionIds & bitwiseValue) != 0L) {
                    resourcePermission.setActionIds(actionIds &= bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL);
                    resourcePermission.setViewActionId(actionIds % 2L == 1L);
                    this.resourcePermissionPersistence.update(resourcePermission);
                }
            });
            try {
                actionableDynamicQuery.performActions();
            }
            catch (PortalException pe) {
                throw new SystemException(pe);
            }
        }
        _resourceActions.remove(this.encodeKey(resourceAction.getName(), resourceAction.getActionId()));
        this.resourceActionPersistence.remove(resourceAction);
        PermissionCacheUtil.clearCache();
        return resourceAction;
    }

    @Override
    @Transactional(enabled=false)
    public ResourceAction fetchResourceAction(String name, String actionId) {
        String key = this.encodeKey(name, actionId);
        return _resourceActions.get(key);
    }

    @Override
    @Transactional(enabled=false)
    public ResourceAction getResourceAction(String name, String actionId) throws PortalException {
        String key = this.encodeKey(name, actionId);
        ResourceAction resourceAction = _resourceActions.get(key);
        if (resourceAction == null) {
            throw new NoSuchResourceActionException(key);
        }
        return resourceAction;
    }

    @Override
    public List<ResourceAction> getResourceActions(String name) {
        return this.resourceActionPersistence.findByName(name);
    }

    @Override
    public int getResourceActionsCount(String name) {
        return this.resourceActionPersistence.countByName(name);
    }

    protected String encodeKey(String name, String actionId) {
        return name.concat("#").concat(actionId);
    }
}

