/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.document.library.kernel.exception.RepositoryNameException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryFactoryUtil;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.UndeployedExternalRepositoryException;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.RepositoryLocalServiceBaseImpl;
import java.util.List;

public class RepositoryLocalServiceImpl
extends RepositoryLocalServiceBaseImpl {
    @BeanReference(type=RepositoryProvider.class)
    protected RepositoryProvider repositoryProvider;
    private static final Log _log = LogFactoryUtil.getLog(RepositoryLocalServiceImpl.class);

    @Override
    public Repository addRepository(long userId, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, boolean hidden, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long repositoryId = this.counterLocalService.increment();
        Repository repository = this.repositoryPersistence.create(repositoryId);
        repository.setUuid(serviceContext.getUuid());
        repository.setGroupId(groupId);
        repository.setCompanyId(user.getCompanyId());
        repository.setUserId(user.getUserId());
        repository.setUserName(user.getFullName());
        repository.setClassNameId(classNameId);
        repository.setName(name);
        repository.setDescription(description);
        repository.setPortletId(portletId);
        repository.setTypeSettingsProperties(typeSettingsProperties);
        repository.setDlFolderId(this.getDLFolderId(user, groupId, repositoryId, parentFolderId, name, description, hidden, serviceContext));
        this.repositoryPersistence.update(repository);
        try {
            RepositoryFactoryUtil.createRepository(repositoryId);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e, e);
            }
            throw new InvalidRepositoryException(e);
        }
        return repository;
    }

    @Override
    public void checkRepository(long repositoryId) {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            return;
        }
        try {
            this.repositoryPersistence.findByPrimaryKey(repositoryId);
        }
        catch (NoSuchRepositoryException nsre) {
            throw new InvalidRepositoryIdException(nsre.getMessage());
        }
    }

    @Override
    public void deleteRepositories(long groupId) throws PortalException {
        List<Repository> repositories = this.repositoryPersistence.findByGroupId(groupId);
        for (Repository repository : repositories) {
            this.deleteRepository(repository.getRepositoryId());
        }
    }

    @Override
    public Repository deleteRepository(long repositoryId) throws PortalException {
        Repository repository;
        block4: {
            repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
            if (repository == null) {
                return null;
            }
            try {
                LocalRepository localRepository = this.repositoryProvider.getLocalRepository(repositoryId);
                if (localRepository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
                    RepositoryEventTriggerCapability repositoryEventTriggerCapability = localRepository.getCapability(RepositoryEventTriggerCapability.class);
                    repositoryEventTriggerCapability.trigger(RepositoryEventType.Delete.class, LocalRepository.class, localRepository);
                }
            }
            catch (UndeployedExternalRepositoryException uere) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn("Repository deletion events for this repository will not be triggered", uere);
            }
        }
        return this.repositoryLocalService.deleteRepository(repository);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Repository deleteRepository(Repository repository) {
        this.expandoValueLocalService.deleteValues(Repository.class.getName(), repository.getRepositoryId());
        DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(repository.getDlFolderId());
        if (dlFolder != null) {
            this.dlFolderLocalService.deleteDLFolder(dlFolder);
        }
        this.repositoryPersistence.remove(repository);
        this.repositoryEntryPersistence.removeByRepositoryId(repository.getRepositoryId());
        return repository;
    }

    @Override
    public Repository fetchRepository(long groupId, String portletId) {
        return this.fetchRepository(groupId, portletId, portletId);
    }

    @Override
    public Repository fetchRepository(long groupId, String name, String portletId) {
        return this.repositoryPersistence.fetchByG_N_P(groupId, name, portletId);
    }

    @Override
    public List<Repository> getGroupRepositories(long groupId) {
        return this.repositoryPersistence.findByGroupId(groupId);
    }

    @Override
    public Repository getRepository(long groupId, String portletId) throws PortalException {
        return this.getRepository(groupId, portletId, portletId);
    }

    @Override
    public Repository getRepository(long groupId, String name, String portletId) throws PortalException {
        return this.repositoryPersistence.findByG_N_P(groupId, name, portletId);
    }

    @Override
    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        return repository.getTypeSettingsProperties();
    }

    @Override
    public void updateRepository(long repositoryId, String name, String description) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        repository.setName(name);
        repository.setDescription(description);
        this.repositoryPersistence.update(repository);
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(repository.getDlFolderId());
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        this.dlFolderPersistence.update(dlFolder);
    }

    @Override
    public void updateRepository(long repositoryId, UnicodeProperties typeSettingsProperties) throws PortalException {
        Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        repository.setTypeSettingsProperties(typeSettingsProperties);
        this.repositoryPersistence.update(repository);
    }

    protected long getDLFolderId(User user, long groupId, long repositoryId, long parentFolderId, String name, String description, boolean hidden, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull(name)) {
            throw new RepositoryNameException();
        }
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(user.getUserId(), groupId, repositoryId, true, parentFolderId, name, description, hidden, serviceContext);
        return dlFolder.getFolderId();
    }
}

