/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.NoSuchReleaseException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.ReleaseConstants;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.upgrade.OlderVersionException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.service.base.ReleaseLocalServiceBaseImpl;
import com.liferay.portal.upgrade.PortalUpgradeProcess;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;

public class ReleaseLocalServiceImpl
extends ReleaseLocalServiceBaseImpl {
    private static final String _SQL_GET_BUILD_NUMBER = "select buildNumber from Release_ where releaseId = ?";
    private static final String _SQL_INSERT_RELEASE = "insert into Release_ (releaseId, createDate, modifiedDate, servletContextName, schemaVersion, buildNumber, verified) values (1, ?, ?, ?, ?, ?, ?)";
    private static final String _SQL_TEST_DATABASE_STRING_CASE_SENSITIVITY = "select count(*) from Release_ where releaseId = ? and testString = ?";
    private static final Log _log = LogFactoryUtil.getLog(ReleaseLocalServiceImpl.class);

    @Override
    public Release addRelease(String servletContextName, int buildNumber) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        java.util.Date now = new java.util.Date();
        release.setCreateDate(now);
        release.setModifiedDate(now);
        release.setServletContextName(servletContextName);
        release.setBuildNumber(buildNumber);
        if (servletContextName.equals("portal")) {
            release.setTestString(ReleaseConstants.TEST_STRING);
        }
        this.releasePersistence.update(release);
        return release;
    }

    @Override
    public Release addRelease(String servletContextName, String schemaVersion) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        java.util.Date now = new java.util.Date();
        release.setCreateDate(now);
        release.setModifiedDate(now);
        release.setServletContextName(servletContextName);
        release.setSchemaVersion(schemaVersion);
        if (servletContextName.equals("portal")) {
            release.setTestString(ReleaseConstants.TEST_STRING);
        }
        this.releasePersistence.update(release);
        return release;
    }

    @Override
    public void createTablesAndPopulate() {
        try {
            if (_log.isInfoEnabled()) {
                _log.info("Create tables and populate with default data");
            }
            DB db = DBManagerUtil.getDB();
            db.runSQLTemplate("portal-tables.sql", false);
            db.runSQLTemplate("portal-data-common.sql", false);
            db.runSQLTemplate("portal-data-counter.sql", false);
            db.runSQLTemplate("indexes.sql", false);
            db.runSQLTemplate("sequences.sql", false);
            this.addReleaseInfo();
            StartupHelperUtil.setDbNew(true);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new SystemException(e);
        }
    }

    @Override
    public Release fetchRelease(String servletContextName) {
        if (Validator.isNull(servletContextName)) {
            throw new IllegalArgumentException("Servlet context name is null");
        }
        Release release = null;
        release = servletContextName.equals("portal") ? this.releasePersistence.fetchByPrimaryKey(1L) : this.releasePersistence.fetchByServletContextName(servletContextName);
        return release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public int getBuildNumberOrCreate() throws PortalException {
        DB db;
        block12: {
            db = DBManagerUtil.getDB();
            try {
                db.runSQL("alter table Release_ add schemaVersion VARCHAR(75) null");
                this.populateVersion();
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block12;
                _log.debug(e.getMessage());
            }
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int buildNumber;
            block13: {
                con = DataAccess.getConnection();
                ps = con.prepareStatement(_SQL_GET_BUILD_NUMBER);
                ps.setLong(1, 1L);
                rs = ps.executeQuery();
                buildNumber = 0;
                buildNumber = rs.next() ? rs.getInt("buildNumber") : this.addReleaseInfo();
                if (_log.isDebugEnabled()) {
                    _log.debug("Build number " + buildNumber);
                }
                try {
                    db.runSQL("alter table Release_ add state_ INTEGER");
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block13;
                    _log.debug(e.getMessage());
                }
            }
            this.testSupportsStringCaseSensitiveQuery();
            int n = buildNumber;
            DataAccess.cleanUp(con, ps, rs);
            return n;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e.getMessage());
            }
        }
        finally {
            DataAccess.cleanUp(con, ps, rs);
        }
        if (GetterUtil.getBoolean(PropsUtil.get("schema.run.enabled"))) {
            this.releaseLocalService.createTablesAndPopulate();
            this.testSupportsStringCaseSensitiveQuery();
            Release release = this.fetchRelease("portal");
            return release.getBuildNumber();
        }
        throw new NoSuchReleaseException("The database needs to be populated");
    }

    @Override
    public Release updateRelease(long releaseId, String schemaVersion, int buildNumber, java.util.Date buildDate, boolean verified) throws PortalException {
        Release release = this.releasePersistence.findByPrimaryKey(releaseId);
        release.setModifiedDate(new java.util.Date());
        release.setSchemaVersion(schemaVersion);
        release.setBuildNumber(buildNumber);
        release.setBuildDate(buildDate);
        release.setVerified(verified);
        this.releasePersistence.update(release);
        return release;
    }

    @Override
    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, int buildNumber, int previousBuildNumber, boolean indexOnUpgrade) throws PortalException {
        if (buildNumber <= 0) {
            _log.error("Skipping upgrade processes for " + servletContextName + " because \"release.info.build.number\" is not specified");
            return;
        }
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            release = this.releaseLocalService.addRelease(servletContextName, previousBuildNumber);
        }
        if (buildNumber == release.getBuildNumber()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skipping upgrade processes for " + servletContextName + " because it is already up to date");
            }
        } else {
            if (buildNumber < release.getBuildNumber()) {
                throw new OlderVersionException("Skipping upgrade processes for " + servletContextName + " because you are trying to upgrade with an older version");
            }
            UpgradeProcessUtil.upgradeProcess(release.getBuildNumber(), upgradeProcesses, indexOnUpgrade);
        }
        this.releaseLocalService.updateRelease(release.getReleaseId(), release.getSchemaVersion(), buildNumber, null, true);
    }

    @Override
    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, Properties unfilteredPortalProperties) throws Exception {
        int buildNumber = GetterUtil.getInteger(unfilteredPortalProperties.getProperty("release.info.build.number"));
        int previousBuildNumber = GetterUtil.getInteger(unfilteredPortalProperties.getProperty("release.info.previous.build.number"), buildNumber);
        boolean indexOnUpgrade = GetterUtil.getBoolean(unfilteredPortalProperties.getProperty("index.on.upgrade"), PropsValues.INDEX_ON_UPGRADE);
        this.updateRelease(servletContextName, upgradeProcesses, buildNumber, previousBuildNumber, indexOnUpgrade);
    }

    @Override
    public void updateRelease(String servletContextName, String schemaVersion, String previousSchemaVersion) {
        String currentSchemaVersion;
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            if (previousSchemaVersion.equals("0.0.0")) {
                release = this.releaseLocalService.addRelease(servletContextName, previousSchemaVersion);
            } else {
                throw new IllegalStateException("Unable to update release because it does not exist");
            }
        }
        if (Validator.isNull(currentSchemaVersion = release.getSchemaVersion())) {
            currentSchemaVersion = "0.0.0";
        }
        if (!previousSchemaVersion.equals(currentSchemaVersion)) {
            StringBundler sb = new StringBundler(5);
            sb.append("Unable to update release because the previous schema ");
            sb.append("version ");
            sb.append(previousSchemaVersion);
            sb.append(" does not match the expected schema version ");
            sb.append(currentSchemaVersion);
            throw new IllegalStateException(sb.toString());
        }
        release.setSchemaVersion(schemaVersion);
        this.releasePersistence.update(release);
    }

    protected int addReleaseInfo() throws Exception {
        try (Connection con = DataAccess.getConnection();
             PreparedStatement ps = con.prepareStatement(_SQL_INSERT_RELEASE);){
            Date now = new Date(System.currentTimeMillis());
            ps.setDate(1, now);
            ps.setDate(2, now);
            ps.setString(3, "portal");
            Version latestSchemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
            ps.setString(4, latestSchemaVersion.toString());
            ps.setInt(5, ReleaseInfo.getBuildNumber());
            ps.setBoolean(6, false);
            ps.executeUpdate();
        }
        return ReleaseInfo.getBuildNumber();
    }

    protected void populateVersion() {
    }

    protected void testSupportsStringCaseSensitiveQuery() {
        DB db = DBManagerUtil.getDB();
        int count = this.testSupportsStringCaseSensitiveQuery(ReleaseConstants.TEST_STRING);
        if (count == 0) {
            block9: {
                block8: {
                    try {
                        db.runSQL("alter table Release_ add testString VARCHAR(1024) null");
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) break block8;
                        _log.debug(e.getMessage());
                    }
                }
                try {
                    db.runSQL("update Release_ set testString = '" + ReleaseConstants.TEST_STRING + "'");
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug(e.getMessage());
                }
            }
            count = this.testSupportsStringCaseSensitiveQuery(ReleaseConstants.TEST_STRING);
        }
        if (count == 0) {
            throw new SystemException("Release_ table was not initialized properly");
        }
        count = this.testSupportsStringCaseSensitiveQuery(StringUtil.toUpperCase(ReleaseConstants.TEST_STRING));
        if (count == 0) {
            db.setSupportsStringCaseSensitiveQuery(true);
        } else {
            db.setSupportsStringCaseSensitiveQuery(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int testSupportsStringCaseSensitiveQuery(String testString) {
        int count = 0;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_SQL_TEST_DATABASE_STRING_CASE_SENSITIVITY);
            ps.setLong(1, 1L);
            ps.setString(2, testString);
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            DataAccess.cleanUp(con, ps, rs);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e.getMessage());
            }
        }
        finally {
            DataAccess.cleanUp(con, ps, rs);
        }
        return count;
    }
}

