/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RegionCodeException;
import com.liferay.portal.kernel.exception.RegionNameException;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.RegionServiceBaseImpl;
import java.util.List;

public class RegionServiceImpl
extends RegionServiceBaseImpl {
    @Override
    public Region addRegion(long countryId, String regionCode, String name, boolean active) throws PortalException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(this.getPermissionChecker());
        }
        this.countryPersistence.findByPrimaryKey(countryId);
        if (Validator.isNull(regionCode)) {
            throw new RegionCodeException();
        }
        if (Validator.isNull(name)) {
            throw new RegionNameException();
        }
        long regionId = this.counterLocalService.increment();
        Region region = this.regionPersistence.create(regionId);
        region.setCountryId(countryId);
        region.setRegionCode(regionCode);
        region.setName(name);
        region.setActive(active);
        this.regionPersistence.update(region);
        return region;
    }

    @Override
    public Region fetchRegion(long regionId) {
        return this.regionPersistence.fetchByPrimaryKey(regionId);
    }

    @Override
    public Region fetchRegion(long countryId, String regionCode) {
        return this.regionPersistence.fetchByC_R(countryId, regionCode);
    }

    @Override
    public Region getRegion(long regionId) throws PortalException {
        return this.regionPersistence.findByPrimaryKey(regionId);
    }

    @Override
    public Region getRegion(long countryId, String regionCode) throws PortalException {
        return this.regionPersistence.findByC_R(countryId, regionCode);
    }

    @Override
    public List<Region> getRegions() {
        return this.regionPersistence.findAll();
    }

    @Override
    public List<Region> getRegions(boolean active) {
        return this.regionPersistence.findByActive(active);
    }

    @Override
    public List<Region> getRegions(long countryId) {
        return this.regionPersistence.findByCountryId(countryId);
    }

    @Override
    @AccessControlled(guestAccessEnabled=true)
    public List<Region> getRegions(long countryId, boolean active) {
        return this.regionPersistence.findByC_A(countryId, active);
    }
}

