/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.base.PortletPreferencesServiceBaseImpl;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesServiceImpl
extends PortletPreferencesServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesServiceImpl.class);

    @Override
    public void deleteArchivedPreferences(long portletItemId) throws PortalException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(portletItemId);
        GroupPermissionUtil.check(this.getPermissionChecker(), portletItem.getGroupId(), "MANAGE_ARCHIVED_SETUPS");
        long ownerId = portletItemId;
        int ownerType = 5;
        long plid = 0L;
        String portletId = portletItem.getPortletId();
        this.portletPreferencesLocalService.deletePortletPreferences(ownerId, ownerType, plid, portletId);
        this.portletItemLocalService.deletePortletItem(portletItemId);
    }

    @Override
    public void restoreArchivedPreferences(long groupId, Layout layout, String portletId, long portletItemId, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(portletItemId);
        this.restoreArchivedPreferences(groupId, layout, portletId, portletItem, jxPortletPreferences);
    }

    @Override
    public void restoreArchivedPreferences(long groupId, Layout layout, String portletId, PortletItem portletItem, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletPermissionUtil.check(this.getPermissionChecker(), groupId, layout, portletId, "CONFIGURATION");
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedJxPortletPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, PortletIdCodec.decodePortletName(portletId));
        this.copyPreferences(archivedJxPortletPreferences, jxPortletPreferences);
    }

    @Override
    public void restoreArchivedPreferences(long groupId, String name, Layout layout, String portletId, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletItem portletItem = this.portletItemLocalService.getPortletItem(groupId, name, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        this.restoreArchivedPreferences(groupId, layout, portletId, portletItem, jxPortletPreferences);
    }

    @Override
    public void updateArchivePreferences(long userId, long groupId, String name, String portletId, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletPermissionUtil.check(this.getPermissionChecker(), groupId, 0L, portletId, "CONFIGURATION");
        PortletItem portletItem = this.portletItemLocalService.updatePortletItem(userId, groupId, name, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedJxPortletPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, portletId);
        this.copyPreferences(jxPortletPreferences, archivedJxPortletPreferences);
    }

    protected void copyPreferences(PortletPreferences sourceJxPortletPreferences, PortletPreferences targetJxPortletPreferences) {
        try {
            Map targetJxPortletPreferencesMap = targetJxPortletPreferences.getMap();
            for (String key : targetJxPortletPreferencesMap.keySet()) {
                try {
                    targetJxPortletPreferences.reset(key);
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            Map sourceJxPortletPreferencesMap = sourceJxPortletPreferences.getMap();
            for (String key : sourceJxPortletPreferencesMap.keySet()) {
                try {
                    targetJxPortletPreferences.setValues(key, sourceJxPortletPreferences.getValues(key, new String[0]));
                }
                catch (ReadOnlyException readOnlyException) {}
            }
            targetJxPortletPreferences.store();
        }
        catch (IOException ioe) {
            _log.error("Unable to copy jxPortletPreferences", ioe);
        }
        catch (ValidatorException ve) {
            throw new SystemException(ve);
        }
    }
}

