/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.expando.kernel.model.CustomAttributesDisplay;
import com.liferay.petra.content.ContentUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.application.type.ApplicationType;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletInfo;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.portlet.PortletDependencyFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletContextFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletAppImpl;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.service.base.PortletLocalServiceBaseImpl;
import com.liferay.portal.servlet.ComboServlet;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.UndeployedPortlet;
import com.liferay.portlet.extra.config.ExtraPortletAppConfig;
import com.liferay.portlet.extra.config.ExtraPortletAppConfigRegistry;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.util.JS;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.portlet.PortletMode;
import javax.portlet.PreferencesValidator;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;

public class PortletLocalServiceImpl
extends PortletLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletLocalServiceImpl.class);
    private static final Map<String, PortletApp> _portletApps = new ConcurrentHashMap<String, PortletApp>();
    private static volatile Map<String, String> _portletIdsByStrutsPath;
    private static final Map<String, Portlet> _portletsMap;
    private static final Map<Long, Map<String, Portlet>> _portletsMaps;
    private final AtomicReference<String[]> _friendlyURLMapperRootPortletIds = new AtomicReference<String[]>(new String[0]);
    private ServiceTracker<FriendlyURLMapper, String[]> _serviceTracker;

    @Override
    @Transactional(enabled=false)
    public void addPortletCategory(long companyId, String categoryName) {
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
        if (portletCategory == null) {
            _log.error("Unable to add portlet category for company " + companyId + " because it does not exist");
            return;
        }
        PortletCategory newPortletCategory = new PortletCategory(categoryName);
        if (newPortletCategory.getParentCategory() == null) {
            PortletCategory rootPortletCategory = new PortletCategory();
            rootPortletCategory.addCategory(newPortletCategory);
        }
        portletCategory.merge(newPortletCategory.getRootCategory());
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(objectClass=" + FriendlyURLMapper.class.getName() + ")");
        this._serviceTracker = registry.trackServices(filter, new FriendlyURLMapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Override
    public void checkPortlet(Portlet portlet) throws PortalException {
        this.resourcePermissionLocalService.initPortletDefaultPermissions(portlet);
        this.initPortletAddToPagePermissions(portlet);
    }

    @Override
    public void checkPortlets(long companyId) throws PortalException {
        List<Portlet> portlets = this.getPortlets(companyId);
        for (Portlet portlet : portlets) {
            this.checkPortlet(portlet);
        }
    }

    @Override
    @Transactional(enabled=false)
    public void clearCache() {
        ComboServlet.clearCache();
        _portletIdsByStrutsPath = null;
        this.portletLocalService.clearPortletsMap();
    }

    @Override
    @Clusterable
    @Transactional(enabled=false)
    public void clearPortletsMap() {
        _portletsMaps.clear();
    }

    @Override
    @Transactional(enabled=false)
    public Portlet clonePortlet(String portletId) {
        Portlet portlet = this.getPortletById(portletId);
        return (Portlet)portlet.clone();
    }

    @Override
    public void deletePortlet(long companyId, String portletId, long plid) throws PortalException {
        String rootPortletId = PortletIdCodec.decodePortletName(portletId);
        this.resourceLocalService.deleteResource(companyId, rootPortletId, 4, PortletPermissionUtil.getPrimaryKey(plid, portletId));
        List<PortletPreferences> portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferences(plid, portletId);
        Portlet portlet = this.getPortletById(companyId, portletId);
        PortletLayoutListener portletLayoutListener = null;
        if (portlet != null) {
            portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            PortletInstanceFactoryUtil.delete(portlet);
        }
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            if (portletLayoutListener != null) {
                portletLayoutListener.onRemoveFromLayout(portletPreferences.getPortletId(), plid);
            }
            this.portletPreferencesLocalService.deletePortletPreferences(portletPreferences.getPortletPreferencesId());
        }
    }

    @Override
    public void deletePortlets(long companyId, String[] portletIds, long plid) throws PortalException {
        for (String portletId : portletIds) {
            this.deletePortlet(companyId, portletId, plid);
        }
    }

    @Override
    @Transactional(enabled=false)
    public void deployPortlet(Portlet portlet) throws Exception {
        PortletApp portletApp = portlet.getPortletApp();
        _portletApps.put(portletApp.getServletContextName(), portletApp);
        ServletContext servletContext = portletApp.getServletContext();
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(this._getServletContextClassLoader(servletContext.getServletContextName()));
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(true);
        portletBagFactory.create(portlet, true);
        _portletsMap.put(portlet.getRootPortletId(), portlet);
        this.clearCache();
    }

    @Override
    public Portlet deployRemotePortlet(Portlet portlet, String categoryName) throws PortalException {
        return this.deployRemotePortlet(portlet, new String[]{categoryName});
    }

    @Override
    public Portlet deployRemotePortlet(Portlet portlet, String[] categoryNames) throws PortalException {
        return this.deployRemotePortlet(portlet, categoryNames, true);
    }

    @Override
    public Portlet deployRemotePortlet(Portlet portlet, String[] categoryNames, boolean eagerDestroy) throws PortalException {
        ResourceActionsUtil.check(portlet);
        _portletsMap.put(portlet.getPortletId(), portlet);
        if (eagerDestroy) {
            PortletInstanceFactoryUtil.clear(portlet, false);
            PortletConfigFactoryUtil.destroy(portlet);
        }
        this.clearCache();
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(portlet.getCompanyId(), "PORTLET_CATEGORY");
        if (portletCategory == null) {
            _log.error("Unable to register remote portlet for company " + portlet.getCompanyId() + " because it does not exist");
            return portlet;
        }
        portletCategory.separate(portlet.getPortletId());
        for (String categoryName : categoryNames) {
            PortletCategory newPortletCategory = new PortletCategory(categoryName);
            if (newPortletCategory.getParentCategory() == null) {
                PortletCategory rootPortletCategory = new PortletCategory();
                rootPortletCategory.addCategory(newPortletCategory);
            }
            Set<String> portletIds = newPortletCategory.getPortletIds();
            portletIds.add(portlet.getPortletId());
            portletCategory.merge(newPortletCategory.getRootCategory());
        }
        this.checkPortlet(portlet);
        return portlet;
    }

    @Override
    public void destroy() {
        super.destroy();
        this._serviceTracker.close();
    }

    @Override
    @Transactional(enabled=false)
    public void destroyPortlet(Portlet portlet) {
        _portletsMap.remove(portlet.getRootPortletId());
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp != null) {
            String servletContextName = portletApp.getServletContextName();
            _portletApps.remove(servletContextName);
            ExtraPortletAppConfigRegistry.unregisterExtraPortletAppConfig(servletContextName);
        }
        this.clearCache();
    }

    @Override
    @Transactional(enabled=false)
    public void destroyRemotePortlet(Portlet portlet) {
        this.destroyPortlet(portlet);
    }

    @Override
    @Transactional(enabled=false)
    public Portlet fetchPortletById(long companyId, String portletId) {
        portletId = PortalUtil.getJsSafePortletId(portletId);
        Map<String, Portlet> companyPortletsMap = this.getPortletsMap(companyId);
        String rootPortletId = PortletIdCodec.decodePortletName(portletId);
        if (portletId.equals(rootPortletId)) {
            return companyPortletsMap.get(portletId);
        }
        Portlet portlet = companyPortletsMap.get(rootPortletId);
        if (portlet != null) {
            portlet = portlet.getClonedInstance(portletId);
        }
        return portlet;
    }

    @Override
    @Transactional(enabled=false)
    public List<CustomAttributesDisplay> getCustomAttributesDisplays() {
        ArrayList<CustomAttributesDisplay> customAttributesDisplays = new ArrayList<CustomAttributesDisplay>();
        for (Portlet portlet : this.getPortlets()) {
            List<CustomAttributesDisplay> portletCustomAttributesDisplays;
            if (!portlet.isActive() || !portlet.isInclude() || !portlet.isReady() || portlet.isUndeployedPortlet() || (portletCustomAttributesDisplays = portlet.getCustomAttributesDisplayInstances()) == null || portletCustomAttributesDisplays.isEmpty()) continue;
            customAttributesDisplays.addAll(portletCustomAttributesDisplays);
        }
        return customAttributesDisplays;
    }

    @Override
    @Transactional(enabled=false)
    public PortletCategory getEARDisplay(String xml) {
        try {
            return this.readLiferayDisplayXML(xml);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    @Transactional(enabled=false)
    public List<Portlet> getFriendlyURLMapperPortlets() {
        String[] friendlyURLMapperRootPortletIds = this._friendlyURLMapperRootPortletIds.get();
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(friendlyURLMapperRootPortletIds.length);
        for (String rootPortletId : friendlyURLMapperRootPortletIds) {
            Portlet portlet = _portletsMap.get(rootPortletId);
            if (portlet == null || !portlet.isActive() || !portlet.isInclude() || !portlet.isReady() || portlet.isUndeployedPortlet()) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    @Override
    @Transactional(enabled=false)
    public List<FriendlyURLMapper> getFriendlyURLMappers() {
        ArrayList<FriendlyURLMapper> friendlyURLMappers = new ArrayList<FriendlyURLMapper>();
        for (Portlet portlet : this.getPortlets()) {
            FriendlyURLMapper friendlyURLMapper;
            if (!portlet.isActive() || !portlet.isInclude() || !portlet.isReady() || portlet.isUndeployedPortlet() || (friendlyURLMapper = portlet.getFriendlyURLMapperInstance()) == null) continue;
            friendlyURLMappers.add(friendlyURLMapper);
        }
        return friendlyURLMappers;
    }

    @Override
    @Transactional(enabled=false)
    public PortletApp getPortletApp(String servletContextName) {
        PortletApp portletApp = _portletApps.get(servletContextName);
        if (portletApp == null) {
            portletApp = new PortletAppImpl(servletContextName);
            _portletApps.put(servletContextName, portletApp);
        }
        return portletApp;
    }

    @Override
    @Transactional(enabled=false)
    public Portlet getPortletById(long companyId, String portletId) {
        Portlet portlet = this.fetchPortletById(companyId, portletId);
        if (portlet != null) {
            return portlet;
        }
        if (portletId.equals("LIFERAY_PORTAL")) {
            return portlet;
        }
        if (_portletsMap.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("No portlets are installed");
            }
        } else {
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat("Portlet not found for ", companyId, " ", portletId));
            }
            portlet = new PortletImpl(0L, portletId);
            PortletApp portletApp = this.getPortletApp("");
            portlet.setPortletApp(portletApp);
            portlet.setPortletName(portletId);
            portlet.setDisplayName(portletId);
            portlet.setPortletClass(UndeployedPortlet.class.getName());
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(StringUtil.toLowerCase(PortletMode.VIEW.toString()));
            Map<String, Set<String>> portletModes = portlet.getPortletModes();
            portletModes.put("text/html", mimeTypePortletModes);
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(StringUtil.toLowerCase(WindowState.NORMAL.toString()));
            Map<String, Set<String>> windowStates = portlet.getWindowStates();
            windowStates.put("text/html", mimeTypeWindowStates);
            portlet.setPortletInfo(new PortletInfo(portletId, portletId, portletId, portletId));
            if (PortletIdCodec.hasInstanceId(portletId)) {
                portlet.setInstanceable(true);
            }
            portlet.setActive(true);
            portlet.setUndeployedPortlet(true);
        }
        return portlet;
    }

    @Override
    @Transactional(enabled=false)
    public Portlet getPortletById(String portletId) {
        return _portletsMap.get(PortletIdCodec.decodePortletName(portletId));
    }

    @Override
    @Transactional(enabled=false)
    public Portlet getPortletByStrutsPath(long companyId, String strutsPath) {
        String portletId = this.getPortletId(strutsPath);
        if (portletId == null) {
            return null;
        }
        return this.getPortletById(companyId, portletId);
    }

    @Override
    @Transactional(enabled=false)
    public List<Portlet> getPortlets() {
        return ListUtil.fromMapValues(_portletsMap);
    }

    @Override
    @Transactional(enabled=false)
    public List<Portlet> getPortlets(long companyId) {
        return this.getPortlets(companyId, true, true);
    }

    @Override
    @Transactional(enabled=false)
    public List<Portlet> getPortlets(long companyId, boolean showSystem, boolean showPortal) {
        Map<String, Portlet> portletsMap = this.getPortletsMap(companyId);
        List<Portlet> portlets = ListUtil.fromMapValues(portletsMap);
        if (showSystem && showPortal) {
            return portlets;
        }
        Iterator<Portlet> itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = itr.next();
            String portletId = portlet.getPortletId();
            if (showPortal && portletId.equals("90")) continue;
            if (!showPortal && portletId.equals("90")) {
                itr.remove();
                continue;
            }
            if (showSystem || !portlet.isSystem()) continue;
            itr.remove();
        }
        return portlets;
    }

    @Override
    public int getPortletsCount(long companyId) {
        return this.portletPersistence.countByCompanyId(companyId);
    }

    @Override
    @Transactional(enabled=false)
    public List<Portlet> getScopablePortlets() {
        List<Portlet> portlets = ListUtil.fromMapValues(_portletsMap);
        Iterator<Portlet> itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = itr.next();
            if (portlet.isScopeable()) continue;
            itr.remove();
        }
        return portlets;
    }

    @Override
    @Transactional(enabled=false)
    public PortletCategory getWARDisplay(String servletContextName, String xml) {
        try {
            return this.readLiferayDisplayXML(servletContextName, xml);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    @Transactional(enabled=false)
    public boolean hasPortlet(long companyId, String portletId) {
        portletId = PortalUtil.getJsSafePortletId(portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsMap = this.getPortletsMap(companyId);
        String rootPortletId = PortletIdCodec.decodePortletName(portletId);
        portlet = portletId.equals(rootPortletId) ? companyPortletsMap.get(portletId) : companyPortletsMap.get(rootPortletId);
        return portlet != null;
    }

    @Override
    @Transactional(enabled=false)
    public void initEAR(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        this.portletLocalService.clearPortletsMap();
        _portletApps.clear();
        _portletsMap.clear();
        try {
            PortletApp portletApp = this.getPortletApp("");
            portletApp.setServletContext(servletContext);
            Set<String> servletURLPatterns = this.readWebXML(xmls[4]);
            this._readWebXML(xmls[4], portletApp.getServletContextName());
            Map<String, Portlet> portletsMap = this.readPortletXML("", servletContext, xmls[0], servletURLPatterns, pluginPackage);
            portletsMap.putAll(this.readPortletXML("", servletContext, xmls[1], servletURLPatterns, pluginPackage));
            for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
                _portletsMap.put(entry.getKey(), entry.getValue());
            }
            ConcurrentHashMap<String, String> portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
            Configuration configuration = this._getConfiguration(portletApp);
            Set<String> liferayPortletIds = this.readLiferayPortletXML("", servletContext, xmls[2], portletsMap, portletIdsByStrutsPath, configuration);
            liferayPortletIds.addAll(this.readLiferayPortletXML("", servletContext, xmls[3], portletsMap, portletIdsByStrutsPath, configuration));
            _portletIdsByStrutsPath = portletIdsByStrutsPath;
            for (String portletId : portletsMap.keySet()) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn(StringBundler.concat("Portlet with the name ", portletId, " is described in portlet.xml but does not have a ", "matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletsMap.containsKey(portletId)) continue;
                _log.warn(StringBundler.concat("Portlet with the name ", portletId, " is described in liferay-portlet.xml but does ", "not have a matching entry in portlet.xml"));
            }
            Set<Map.Entry<String, Portlet>> entrySet = _portletsMap.entrySet();
            Iterator<Map.Entry<String, Portlet>> portletPoolsItr = entrySet.iterator();
            while (portletPoolsItr.hasNext()) {
                Map.Entry<String, Portlet> entry = portletPoolsItr.next();
                Portlet portletModel = entry.getValue();
                String portletId = PortletProviderUtil.getPortletId("com.liferay.admin.kernel.util.PortalMyAccountApplicationType$MyAccount", PortletProvider.Action.VIEW);
                if (Objects.equals(portletModel.getPortletId(), "com_liferay_server_admin_web_portlet_ServerAdminPortlet") || Objects.equals(portletModel.getPortletId(), portletId) || portletModel.isInclude()) continue;
                portletPoolsItr.remove();
            }
            this.setSpriteImages(servletContext, portletApp, "/html/icons/");
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Transactional(enabled=false)
    public List<Portlet> initWAR(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        Map<String, Portlet> portletsMap = null;
        Set<String> liferayPortletIds = null;
        PortletApp portletApp = this.getPortletApp(servletContextName);
        try {
            void var9_13;
            Set<String> servletURLPatterns = this.readWebXML(xmls[3]);
            this._readWebXML(xmls[3], servletContextName);
            portletsMap = this.readPortletXML(servletContextName, servletContext, xmls[0], servletURLPatterns, pluginPackage);
            portletsMap.putAll(this.readPortletXML(servletContextName, servletContext, xmls[1], servletURLPatterns, pluginPackage));
            Map<String, String> map = _portletIdsByStrutsPath;
            if (map == null) {
                HashMap hashMap = new HashMap();
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>(map);
            }
            liferayPortletIds = this.readLiferayPortletXML(servletContextName, servletContext, xmls[2], portletsMap, (Map<String, String>)var9_13, this._getConfiguration(portletApp));
        }
        catch (Exception e) {
            _log.error(e, e);
            return Collections.emptyList();
        }
        for (String string : portletsMap.keySet()) {
            if (!_log.isWarnEnabled() || liferayPortletIds.contains(string)) continue;
            _log.warn(StringBundler.concat("Portlet with the name ", string, " is described in portlet.xml but does not have a ", "matching entry in liferay-portlet.xml"));
        }
        for (String string : liferayPortletIds) {
            if (!_log.isWarnEnabled() || portletsMap.containsKey(string)) continue;
            _log.warn(StringBundler.concat("Portlet with the name ", string, " is described in liferay-portlet.xml but does not ", "have a matching entry in portlet.xml"));
        }
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(this._getServletContextClassLoader(servletContextName));
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(true);
        try {
            for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
                Portlet portlet = _portletsMap.remove(entry.getKey());
                if (portlet != null) {
                    PortletInstanceFactoryUtil.clear(portlet);
                    PortletConfigFactoryUtil.destroy(portlet);
                    PortletContextFactoryUtil.destroy(portlet);
                }
                portlet = entry.getValue();
                portletBagFactory.create(portlet, true);
                _portletsMap.put(entry.getKey(), portlet);
            }
            this.setSpriteImages(servletContext, portletApp, "/icons/");
            List<Portlet> list = ListUtil.fromMapValues(portletsMap);
            return list;
        }
        catch (Exception exception) {
            _log.error(exception, exception);
            for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
                Portlet portlet = _portletsMap.remove(entry.getKey());
                if (portlet == null) continue;
                PortletInstanceFactoryUtil.clear(portlet);
                PortletConfigFactoryUtil.destroy(portlet);
                PortletContextFactoryUtil.destroy(portlet);
            }
            List<Portlet> list = Collections.emptyList();
            return list;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public Map<String, Portlet> loadGetPortletsMap(long companyId) {
        ConcurrentHashMap<String, Portlet> portletsMap = new ConcurrentHashMap<String, Portlet>();
        for (Portlet portlet : _portletsMap.values()) {
            portlet = (Portlet)portlet.clone();
            portlet.setCompanyId(companyId);
            portletsMap.put(portlet.getPortletId(), portlet);
        }
        List<Portlet> portlets = this.portletPersistence.findByCompanyId(companyId);
        for (Portlet portlet : portlets) {
            Portlet portletModel = (Portlet)portletsMap.get(portlet.getPortletId());
            if (portletModel == null) continue;
            portletModel.setPluginPackage(portlet.getPluginPackage());
            portletModel.setDefaultPluginSetting(portlet.getDefaultPluginSetting());
            portletModel.setRoles(portlet.getRoles());
            portletModel.setActive(portlet.isActive());
        }
        return portletsMap;
    }

    @Override
    @Clusterable
    @Transactional(enabled=false)
    public void removeCompanyPortletsPool(long companyId) {
        _portletsMaps.remove(companyId);
    }

    @Override
    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) {
        Portlet portlet = this.portletPersistence.fetchByC_P(companyId, portletId = PortalUtil.getJsSafePortletId(portletId));
        if (portlet == null) {
            long id = this.counterLocalService.increment();
            portlet = this.portletPersistence.create(id);
            portlet.setCompanyId(companyId);
            portlet.setPortletId(portletId);
        }
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletPersistence.update(portlet);
        this.portletLocalService.removeCompanyPortletsPool(companyId);
        return portlet;
    }

    @Override
    @Transactional(enabled=false)
    public void visitPortlets(long companyId, Consumer<Portlet> consumer) {
        Map<String, Portlet> portletsMap = this.getPortletsMap(companyId);
        for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
            consumer.accept(entry.getValue());
        }
    }

    protected String getPortletId(String securityPath) {
        String portletId;
        Map<String, String> portletIdsByStrutsPath = _portletIdsByStrutsPath;
        if (portletIdsByStrutsPath == null) {
            portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
            for (Portlet portlet : _portletsMap.values()) {
                String strutsPath = portlet.getStrutsPath();
                String oldPortletId = portletIdsByStrutsPath.put(strutsPath, portlet.getPortletId());
                if (oldPortletId == null || !_log.isWarnEnabled()) continue;
                _log.warn("Duplicate struts path " + strutsPath);
            }
            _portletIdsByStrutsPath = portletIdsByStrutsPath;
        }
        if (Validator.isNull(portletId = portletIdsByStrutsPath.get(securityPath))) {
            for (Map.Entry<String, String> entry : portletIdsByStrutsPath.entrySet()) {
                String strutsPath = entry.getKey();
                if (!securityPath.startsWith(strutsPath.concat("/"))) continue;
                portletId = entry.getValue();
                break;
            }
        }
        if (Validator.isNull(portletId)) {
            _log.error(StringBundler.concat("Struts path ", securityPath, " is not mapped to a portlet in liferay-portlet.xml"));
        }
        return portletId;
    }

    protected List<Portlet> getPortletsByPortletName(String portletName, String servletContextName, Map<String, Portlet> portletsMap) {
        int pos = portletName.indexOf(42);
        if (pos == -1) {
            Portlet portlet;
            String portletId = portletName;
            if (Validator.isNotNull(servletContextName)) {
                portletId = portletId + "_WAR_" + servletContextName;
            }
            if ((portlet = portletsMap.get(portletId = PortalUtil.getJsSafePortletId(portletId))) == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(portlet);
        }
        return this.getPortletsByServletContextName(servletContextName, portletName.substring(0, pos), portletsMap);
    }

    protected List<Portlet> getPortletsByServletContextName(String servletContextName, String portletNamePrefix, Map<String, Portlet> portletsMap) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        String servletContextNameSuffix = null;
        if (Validator.isNotNull(servletContextName)) {
            servletContextNameSuffix = PortalUtil.getJsSafePortletId("_WAR_".concat(servletContextName));
        }
        for (Map.Entry<String, Portlet> entry : portletsMap.entrySet()) {
            String portletId = entry.getKey();
            if (!portletId.startsWith(portletNamePrefix)) continue;
            if (servletContextNameSuffix == null) {
                if (portletId.contains("_WAR_")) continue;
                portlets.add(entry.getValue());
                continue;
            }
            if (!portletId.endsWith(servletContextNameSuffix)) continue;
            portlets.add(entry.getValue());
        }
        return portlets;
    }

    protected Map<String, Portlet> getPortletsMap(long companyId) {
        Map<String, Portlet> portletsMap = _portletsMaps.get(companyId);
        if (portletsMap == null) {
            portletsMap = this.portletLocalService.loadGetPortletsMap(companyId);
            _portletsMaps.put(companyId, portletsMap);
        }
        return portletsMap;
    }

    protected void initPortletAddToPagePermissions(Portlet portlet) throws PortalException {
        if (portlet.isSystem()) {
            return;
        }
        String[] roleNames = portlet.getRolesArray();
        Portlet existingPortlet = this.portletPersistence.fetchByC_P(portlet.getCompanyId(), portlet.getPortletId());
        if (existingPortlet != null) {
            roleNames = existingPortlet.getRolesArray();
        }
        if (roleNames.length == 0) {
            return;
        }
        List<String> actionIds = ResourceActionsUtil.getPortletResourceActions(portlet.getRootPortletId());
        if (actionIds.contains("ADD_TO_PAGE")) {
            List<String> guestUnsupportedActionIds = ResourceActionsUtil.getPortletResourceGuestUnsupportedActions(portlet.getRootPortletId());
            boolean skipGuestRole = guestUnsupportedActionIds.contains("ADD_TO_PAGE");
            for (String roleName : roleNames) {
                if (skipGuestRole && roleName.equals("Guest")) continue;
                Role role = this.roleLocalService.fetchRole(portlet.getCompanyId(), roleName);
                if (role == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn(StringBundler.concat("Portlet ", portlet.getPortletName(), " requires role with company ID ", portlet.getCompanyId(), " and name ", roleName, ". Create the role and redeploy the portlet."));
                    continue;
                }
                this.resourcePermissionLocalService.addResourcePermission(portlet.getCompanyId(), portlet.getRootPortletId(), 1, String.valueOf(portlet.getCompanyId()), role.getRoleId(), "ADD_TO_PAGE");
            }
        }
        this.updatePortlet(portlet.getCompanyId(), portlet.getPortletId(), "");
    }

    protected void readLiferayDisplay(String servletContextName, Element element, PortletCategory portletCategory, Set<String> portletIds) {
        for (Element categoryElement : element.elements("category")) {
            String name = categoryElement.attributeValue("name");
            PortletCategory curPortletCategory = new PortletCategory(name);
            portletCategory.addCategory(curPortletCategory);
            Set<String> curPortletIds = curPortletCategory.getPortletIds();
            for (Element portletElement : categoryElement.elements("portlet")) {
                String portletId = portletElement.attributeValue("id");
                if (Validator.isNotNull(servletContextName)) {
                    portletId = portletId + "_WAR_" + servletContextName;
                }
                portletId = PortalUtil.getJsSafePortletId(portletId);
                portletIds.add(portletId);
                curPortletIds.add(portletId);
            }
            this.readLiferayDisplay(servletContextName, categoryElement, curPortletCategory, portletIds);
        }
    }

    protected PortletCategory readLiferayDisplayXML(String xml) throws Exception {
        return this.readLiferayDisplayXML(null, xml);
    }

    protected PortletCategory readLiferayDisplayXML(String servletContextName, String xml) throws Exception {
        PortletCategory portletCategory = new PortletCategory();
        if (xml == null) {
            Class<?> clazz = this.getClass();
            xml = ContentUtil.get(clazz.getClassLoader(), "com/liferay/portal/deploy/dependencies/liferay-display.xml");
        }
        Document document = UnsecureSAXReaderUtil.read(xml, true);
        Element rootElement = document.getRootElement();
        HashSet<String> portletIds = new HashSet<String>();
        this.readLiferayDisplay(servletContextName, rootElement, portletCategory, portletIds);
        HashSet<String> undefinedPortletIds = new HashSet<String>();
        for (Portlet portlet : _portletsMap.values()) {
            String portletId = portlet.getPortletId();
            PortletApp portletApp = portlet.getPortletApp();
            if (servletContextName != null && portletApp.isWARFile() && portletId.endsWith("_WAR_" + PortalUtil.getJsSafePortletId(servletContextName)) && !portletIds.contains(portletId)) {
                undefinedPortletIds.add(portletId);
                continue;
            }
            if (servletContextName != null || portletApp.isWARFile() || portletId.contains("_WAR_") || portletIds.contains(portletId)) continue;
            undefinedPortletIds.add(portletId);
        }
        if (!undefinedPortletIds.isEmpty()) {
            PortletCategory undefinedCategory = new PortletCategory("category.undefined");
            portletCategory.addCategory(undefinedCategory);
            Set<String> undefinedCategoryPortletIds = undefinedCategory.getPortletIds();
            undefinedCategoryPortletIds.addAll(undefinedPortletIds);
        }
        return portletCategory;
    }

    /*
     * WARNING - void declaration
     */
    protected void readLiferayPortletXML(String servletContextName, ServletContext servletContext, Set<String> liferayPortletIds, Map<String, String> roleMappers, Element portletElement, Map<String, Portlet> portletsMap, Map<String, String> portletIdsByStrutsPath, Configuration configuration) {
        String oldPortletId;
        String portletId = portletElement.elementText("portlet-name");
        if (Validator.isNotNull(servletContextName)) {
            portletId = portletId.concat("_WAR_").concat(servletContextName);
        }
        portletId = PortalUtil.getJsSafePortletId(portletId);
        if (_log.isDebugEnabled()) {
            _log.debug("Reading portlet extension " + portletId);
        }
        liferayPortletIds.add(portletId);
        Portlet portletModel = portletsMap.get(portletId);
        if (portletModel == null) {
            return;
        }
        portletModel.setIcon(GetterUtil.getString(portletElement.elementText("icon"), portletModel.getIcon()));
        portletModel.setVirtualPath(GetterUtil.getString(portletElement.elementText("virtual-path"), portletModel.getVirtualPath()));
        portletModel.setStrutsPath(GetterUtil.getString(portletElement.elementText("struts-path"), portletModel.getStrutsPath()));
        String strutsPath = portletModel.getStrutsPath();
        if (Validator.isNotNull(strutsPath) && (oldPortletId = portletIdsByStrutsPath.put(strutsPath, portletId)) != null && !oldPortletId.equals(portletId) && _log.isWarnEnabled()) {
            _log.warn("Duplicate struts path " + strutsPath);
        }
        portletModel.setParentStrutsPath(GetterUtil.getString(portletElement.elementText("parent-struts-path"), portletModel.getParentStrutsPath()));
        if (Validator.isNotNull(portletElement.elementText("configuration-path"))) {
            _log.error("The configuration-path element is no longer supported. Use configuration-action-class instead.");
        }
        portletModel.setConfigurationActionClass(GetterUtil.getString(portletElement.elementText("configuration-action-class"), portletModel.getConfigurationActionClass()));
        ArrayList<String> indexerClasses = new ArrayList<String>();
        for (Element element : portletElement.elements("indexer-class")) {
            indexerClasses.add(element.getText());
        }
        portletModel.setIndexerClasses(indexerClasses);
        portletModel.setOpenSearchClass(GetterUtil.getString(portletElement.elementText("open-search-class"), portletModel.getOpenSearchClass()));
        for (Element element : portletElement.elements("scheduler-entry")) {
            void var17_29;
            String string = GetterUtil.getString(element.elementText("scheduler-description"));
            String string2 = GetterUtil.getString(element.elementText("scheduler-event-listener-class"));
            Object var17_30 = null;
            Element element2 = element.element("trigger");
            Element element3 = element2.element("cron");
            Element element4 = element2.element("simple");
            if (element3 != null) {
                void var22_66;
                Element element5 = element3.element("property-key");
                Object var22_63 = null;
                if (element5 != null) {
                    String string3 = configuration.get(element5.getTextTrim());
                } else {
                    String string4 = element3.elementText("cron-trigger-value");
                }
                Trigger trigger = TriggerFactoryUtil.createTrigger(string2, string2, (String)var22_66);
            } else if (element4 != null) {
                void var22_70;
                Element element6 = element4.element("property-key");
                Object var22_67 = null;
                if (element6 != null) {
                    String string5 = configuration.get(element6.getTextTrim());
                } else {
                    Element simpleTriggerValueElement = element4.element("simple-trigger-value");
                    String string6 = simpleTriggerValueElement.getTextTrim();
                }
                String timeUnitString = StringUtil.toUpperCase(GetterUtil.getString(element4.elementText("time-unit"), TimeUnit.SECOND.getValue()));
                Trigger trigger = TriggerFactoryUtil.createTrigger(string2, string2, GetterUtil.getIntegerStrict((String)var22_70), TimeUnit.valueOf(timeUnitString));
            }
            SchedulerEntryImpl schedulerEntryImpl = new SchedulerEntryImpl(string2, (Trigger)var17_29, string);
            portletModel.addSchedulerEntry(schedulerEntryImpl);
        }
        portletModel.setPortletURLClass(GetterUtil.getString(portletElement.elementText("portlet-url-class"), portletModel.getPortletURLClass()));
        portletModel.setFriendlyURLMapperClass(GetterUtil.getString(portletElement.elementText("friendly-url-mapper-class"), portletModel.getFriendlyURLMapperClass()));
        portletModel.setFriendlyURLMapping(GetterUtil.getString(portletElement.elementText("friendly-url-mapping"), portletModel.getFriendlyURLMapping()));
        portletModel.setFriendlyURLRoutes(GetterUtil.getString(portletElement.elementText("friendly-url-routes"), portletModel.getFriendlyURLRoutes()));
        portletModel.setURLEncoderClass(GetterUtil.getString(portletElement.elementText("url-encoder-class"), portletModel.getURLEncoderClass()));
        portletModel.setPortletDataHandlerClass(GetterUtil.getString(portletElement.elementText("portlet-data-handler-class"), portletModel.getPortletDataHandlerClass()));
        ArrayList<String> stagedModelDataHandlerClasses = new ArrayList<String>();
        for (Element element : portletElement.elements("staged-model-data-handler-class")) {
            stagedModelDataHandlerClasses.add(element.getText());
        }
        portletModel.setStagedModelDataHandlerClasses(stagedModelDataHandlerClasses);
        portletModel.setTemplateHandlerClass(GetterUtil.getString(portletElement.elementText("template-handler"), portletModel.getTemplateHandlerClass()));
        portletModel.setPortletLayoutListenerClass(GetterUtil.getString(portletElement.elementText("portlet-layout-listener-class"), portletModel.getPortletLayoutListenerClass()));
        portletModel.setPollerProcessorClass(GetterUtil.getString(portletElement.elementText("poller-processor-class"), portletModel.getPollerProcessorClass()));
        portletModel.setPopMessageListenerClass(GetterUtil.getString(portletElement.elementText("pop-message-listener-class"), portletModel.getPopMessageListenerClass()));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : portletElement.elements("social-activity-interpreter-class")) {
            arrayList.add(element.getText());
        }
        portletModel.setSocialActivityInterpreterClasses(arrayList);
        portletModel.setSocialRequestInterpreterClass(GetterUtil.getString(portletElement.elementText("social-request-interpreter-class"), portletModel.getSocialRequestInterpreterClass()));
        portletModel.setUserNotificationDefinitions(GetterUtil.getString(portletElement.elementText("user-notification-definitions"), portletModel.getUserNotificationDefinitions()));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Element element : portletElement.elements("user-notification-handler-class")) {
            arrayList2.add(element.getText());
        }
        portletModel.setUserNotificationHandlerClasses(arrayList2);
        portletModel.setWebDAVStorageToken(GetterUtil.getString(portletElement.elementText("webdav-storage-token"), portletModel.getWebDAVStorageToken()));
        portletModel.setWebDAVStorageClass(GetterUtil.getString(portletElement.elementText("webdav-storage-class"), portletModel.getWebDAVStorageClass()));
        portletModel.setXmlRpcMethodClass(GetterUtil.getString(portletElement.elementText("xml-rpc-method-class"), portletModel.getXmlRpcMethodClass()));
        HashSet<ApplicationType> hashSet = new HashSet<ApplicationType>();
        for (Element element : portletElement.elements("application-type")) {
            try {
                hashSet.add(ApplicationType.parse(element.getText()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Unknown application type " + element.getText());
            }
        }
        if (hashSet.isEmpty()) {
            hashSet.add(ApplicationType.WIDGET);
        }
        portletModel.setApplicationTypes(hashSet);
        portletModel.setControlPanelEntryClass(GetterUtil.getString(portletElement.elementText("control-panel-entry-class"), portletModel.getControlPanelEntryClass()));
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (Element element : portletElement.elements("asset-renderer-factory")) {
            arrayList3.add(element.getText());
        }
        portletModel.setAssetRendererFactoryClasses(arrayList3);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (Element element : portletElement.elements("atom-collection-adapter")) {
            arrayList4.add(element.getText());
        }
        portletModel.setAtomCollectionAdapterClasses(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        for (Element element : portletElement.elements("custom-attributes-display")) {
            arrayList5.add(element.getText());
        }
        portletModel.setCustomAttributesDisplayClasses(arrayList5);
        portletModel.setPermissionPropagatorClass(GetterUtil.getString(portletElement.elementText("permission-propagator"), portletModel.getPermissionPropagatorClass()));
        ArrayList<String> arrayList6 = new ArrayList<String>();
        for (Element element : portletElement.elements("trash-handler")) {
            arrayList6.add(element.getText());
        }
        portletModel.setTrashHandlerClasses(arrayList6);
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (Element workflowHandlerClassElement : portletElement.elements("workflow-handler")) {
            arrayList7.add(workflowHandlerClassElement.getText());
        }
        portletModel.setWorkflowHandlerClasses(arrayList7);
        portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean(portletElement.elementText("preferences-company-wide"), portletModel.isPreferencesCompanyWide()));
        portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean(portletElement.elementText("preferences-unique-per-layout"), portletModel.isPreferencesUniquePerLayout()));
        portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean(portletElement.elementText("preferences-owned-by-group"), portletModel.isPreferencesOwnedByGroup()));
        portletModel.setUseDefaultTemplate(GetterUtil.getBoolean(portletElement.elementText("use-default-template"), portletModel.isUseDefaultTemplate()));
        portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean(portletElement.elementText("show-portlet-access-denied"), portletModel.isShowPortletAccessDenied()));
        portletModel.setShowPortletInactive(GetterUtil.getBoolean(portletElement.elementText("show-portlet-inactive"), portletModel.isShowPortletInactive()));
        portletModel.setActionURLRedirect(GetterUtil.getBoolean(portletElement.elementText("action-url-redirect"), portletModel.isActionURLRedirect()));
        portletModel.setRestoreCurrentView(GetterUtil.getBoolean(portletElement.elementText("restore-current-view"), portletModel.isRestoreCurrentView()));
        portletModel.setMaximizeEdit(GetterUtil.getBoolean(portletElement.elementText("maximize-edit"), portletModel.isMaximizeEdit()));
        portletModel.setMaximizeHelp(GetterUtil.getBoolean(portletElement.elementText("maximize-help"), portletModel.isMaximizeHelp()));
        portletModel.setPopUpPrint(GetterUtil.getBoolean(portletElement.elementText("pop-up-print"), portletModel.isPopUpPrint()));
        portletModel.setLayoutCacheable(GetterUtil.getBoolean(portletElement.elementText("layout-cacheable"), portletModel.isLayoutCacheable()));
        portletModel.setInstanceable(GetterUtil.getBoolean(portletElement.elementText("instanceable"), portletModel.isInstanceable()));
        portletModel.setScopeable(GetterUtil.getBoolean(portletElement.elementText("scopeable"), portletModel.isScopeable()));
        portletModel.setSinglePageApplication(GetterUtil.getBoolean(portletElement.elementText("single-page-application"), portletModel.isSinglePageApplication()));
        portletModel.setUserPrincipalStrategy(GetterUtil.getString(portletElement.elementText("user-principal-strategy"), portletModel.getUserPrincipalStrategy()));
        portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean(portletElement.elementText("private-request-attributes"), portletModel.isPrivateRequestAttributes()));
        portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean(portletElement.elementText("private-session-attributes"), portletModel.isPrivateSessionAttributes()));
        Element element = portletElement.element("autopropagated-parameters");
        HashSet<String> autopropagatedParameters = new HashSet<String>();
        if (element != null) {
            String[] autopropagatedParametersArray;
            for (String string : autopropagatedParametersArray = StringUtil.split(element.getText())) {
                autopropagatedParameters.add(string);
            }
        }
        portletModel.setAutopropagatedParameters(autopropagatedParameters);
        boolean defaultRequiresNamespacedParameters = GetterUtil.getBoolean(servletContext.getInitParameter("com.liferay.portlet.requires-namespaced-parameters"), portletModel.isRequiresNamespacedParameters());
        portletModel.setRequiresNamespacedParameters(GetterUtil.getBoolean(portletElement.elementText("requires-namespaced-parameters"), defaultRequiresNamespacedParameters));
        portletModel.setActionTimeout(GetterUtil.getInteger(portletElement.elementText("action-timeout"), portletModel.getActionTimeout()));
        portletModel.setRenderTimeout(GetterUtil.getInteger(portletElement.elementText("render-timeout"), portletModel.getRenderTimeout()));
        portletModel.setRenderWeight(GetterUtil.getInteger(portletElement.elementText("render-weight"), portletModel.getRenderWeight()));
        portletModel.setAjaxable(GetterUtil.getBoolean(portletElement.elementText("ajaxable"), portletModel.isAjaxable()));
        ArrayList<String> headerPortalCssList = new ArrayList<String>();
        for (Element headerPortalCssElement : portletElement.elements("header-portal-css")) {
            headerPortalCssList.add(headerPortalCssElement.getText());
        }
        portletModel.setHeaderPortalCss(headerPortalCssList);
        ArrayList<String> headerPortletCssList = new ArrayList<String>();
        for (Element element7 : portletElement.elements("header-portlet-css")) {
            headerPortletCssList.add(element7.getText());
        }
        portletModel.setHeaderPortletCss(headerPortletCssList);
        ArrayList<String> headerPortalJavaScriptList = new ArrayList<String>();
        for (Element element8 : portletElement.elements("header-portal-javascript")) {
            headerPortalJavaScriptList.add(element8.getText());
        }
        portletModel.setHeaderPortalJavaScript(headerPortalJavaScriptList);
        ArrayList<String> arrayList8 = new ArrayList<String>();
        for (Element element9 : portletElement.elements("header-portlet-javascript")) {
            arrayList8.add(element9.getText());
        }
        portletModel.setHeaderPortletJavaScript(arrayList8);
        ArrayList<String> arrayList9 = new ArrayList<String>();
        for (Element element10 : portletElement.elements("header-request-attribute-prefix")) {
            arrayList9.add(element10.getText());
        }
        portletModel.setHeaderRequestAttributePrefixes(arrayList9);
        portletModel.setHeaderTimeout(GetterUtil.getInteger(portletElement.elementText("header-timeout"), portletModel.getHeaderTimeout()));
        ArrayList<String> arrayList10 = new ArrayList<String>();
        for (Element element11 : portletElement.elements("footer-portal-css")) {
            arrayList10.add(element11.getText());
        }
        portletModel.setFooterPortalCss(arrayList10);
        ArrayList<String> arrayList11 = new ArrayList<String>();
        for (Element element12 : portletElement.elements("footer-portlet-css")) {
            arrayList11.add(element12.getText());
        }
        portletModel.setFooterPortletCss(arrayList11);
        ArrayList<String> arrayList12 = new ArrayList<String>();
        for (Element element13 : portletElement.elements("footer-portal-javascript")) {
            arrayList12.add(element13.getText());
        }
        portletModel.setFooterPortalJavaScript(arrayList12);
        ArrayList<String> arrayList13 = new ArrayList<String>();
        for (Element footerPortletJavaScriptElement : portletElement.elements("footer-portlet-javascript")) {
            arrayList13.add(footerPortletJavaScriptElement.getText());
        }
        portletModel.setFooterPortletJavaScript(arrayList13);
        portletModel.setPartialActionServeResource(GetterUtil.getBoolean(portletElement.elementText("partial-action-serve-resource"), portletModel.isPartialActionServeResource()));
        portletModel.setPortletDependencyCssEnabled(GetterUtil.getBoolean(portletElement.elementText("portlet-dependency-css-enabled"), portletModel.isPortletDependencyCssEnabled()));
        portletModel.setPortletDependencyJavaScriptEnabled(GetterUtil.getBoolean(portletElement.elementText("portlet-dependency-javascript-enabled"), portletModel.isPortletDependencyJavaScriptEnabled()));
        portletModel.setCssClassWrapper(GetterUtil.getString(portletElement.elementText("css-class-wrapper"), portletModel.getCssClassWrapper()));
        portletModel.setAddDefaultResource(GetterUtil.getBoolean(portletElement.elementText("add-default-resource"), portletModel.isAddDefaultResource()));
        portletModel.setSystem(GetterUtil.getBoolean(portletElement.elementText("system"), portletModel.isSystem()));
        portletModel.setActive(GetterUtil.getBoolean(portletElement.elementText("active"), portletModel.isActive()));
        portletModel.setInclude(GetterUtil.getBoolean(portletElement.elementText("include"), portletModel.isInclude()));
        if (Validator.isNull(servletContextName)) {
            portletModel.setReady(true);
        }
        if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
            portletModel.setRenderWeight(1);
        }
        Map<String, String> map = portletModel.getRoleMappers();
        map.putAll(roleMappers);
        portletModel.linkRoles();
    }

    protected Set<String> readLiferayPortletXML(String servletContextName, ServletContext servletContext, String xml, Map<String, Portlet> portletsMap, Map<String, String> portletIdsByStrutsPath, Configuration configuration) throws Exception {
        HashSet<String> liferayPortletIds = new HashSet<String>();
        if (xml == null) {
            return liferayPortletIds;
        }
        Document document = UnsecureSAXReaderUtil.read(xml, true);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this.getPortletApp(servletContextName);
        HashMap<String, String> roleMappers = new HashMap<String, String>();
        for (Element roleMapperElement : rootElement.elements("role-mapper")) {
            String roleName = roleMapperElement.elementText("role-name");
            String roleLink = roleMapperElement.elementText("role-link");
            roleMappers.put(roleName, roleLink);
        }
        Map<String, String> customUserAttributes = portletApp.getCustomUserAttributes();
        for (Element customUserAttributeElement : rootElement.elements("custom-user-attribute")) {
            String customClass = customUserAttributeElement.elementText("custom-class");
            for (Element nameElement : customUserAttributeElement.elements("name")) {
                String name = nameElement.getText();
                customUserAttributes.put(name, customClass);
            }
        }
        for (Element portletElement : rootElement.elements("portlet")) {
            this.readLiferayPortletXML(servletContextName, servletContext, liferayPortletIds, roleMappers, portletElement, portletsMap, portletIdsByStrutsPath, configuration);
        }
        return liferayPortletIds;
    }

    protected void readPortletXML(String servletContextName, PluginPackage pluginPackage, PortletApp portletApp, Element portletElement, Map<String, Portlet> portletsMap, Set<String> validCustomPortletModes) throws PortletIdException {
        String name;
        Portlet portletModel;
        String portletId;
        String portletName;
        block27: {
            portletId = portletName = portletElement.elementText("portlet-name");
            if (Validator.isNotNull(servletContextName)) {
                portletId = portletId.concat("_WAR_").concat(servletContextName);
            }
            if ((portletId = PortalUtil.getJsSafePortletId(portletId)).length() > PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH) {
                throw new PortletIdException(StringBundler.concat("Portlet ID ", portletId, " has more than ", PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH, " characters"));
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Reading portlet " + portletId);
            }
            if ((portletModel = _portletsMap.get(portletId)) == null) {
                portletModel = new PortletImpl(0L, portletId);
            }
            portletModel.setPluginPackage(pluginPackage);
            portletModel.setPortletApp(portletApp);
            portletModel.setPortletName(portletName);
            portletModel.setDisplayName(GetterUtil.getString(portletElement.elementText("display-name"), portletModel.getDisplayName()));
            portletModel.setPortletClass(GetterUtil.getString(portletElement.elementText("portlet-class")));
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParamElement : portletElement.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            portletModel.setInitParams(initParams);
            Element expirationCacheElement = portletElement.element("expiration-cache");
            if (expirationCacheElement != null) {
                portletModel.setExpCache(GetterUtil.getInteger(expirationCacheElement.getText()));
            }
            HashMap<String, Set<String>> portletModes = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> windowStates = new HashMap<String, Set<String>>();
            for (Element element : portletElement.elements("supports")) {
                String mimeType = element.elementText("mime-type");
                HashSet<String> mimeTypePortletModes = new HashSet<String>();
                mimeTypePortletModes.add(StringUtil.toLowerCase(PortletMode.VIEW.toString()));
                for (Element portletModeElement : element.elements("portlet-mode")) {
                    String portletMode = StringUtil.toLowerCase(portletModeElement.getTextTrim());
                    if (this._isCustomPortletMode(portletMode) && !validCustomPortletModes.contains(portletMode)) continue;
                    mimeTypePortletModes.add(portletMode);
                }
                portletModes.put(mimeType, mimeTypePortletModes);
                HashSet<String> mimeTypeWindowStates = new HashSet<String>();
                mimeTypeWindowStates.add(StringUtil.toLowerCase(WindowState.NORMAL.toString()));
                List<Element> windowStateElements = element.elements("window-state");
                if (windowStateElements.isEmpty()) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase(WindowState.MAXIMIZED.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase(WindowState.MINIMIZED.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase(LiferayWindowState.EXCLUSIVE.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase(LiferayWindowState.POP_UP.toString()));
                }
                for (Element windowStateElement : windowStateElements) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase(windowStateElement.getTextTrim()));
                }
                windowStates.put(mimeType, mimeTypeWindowStates);
            }
            portletModel.setPortletModes(portletModes);
            portletModel.setWindowStates(windowStates);
            HashSet<String> supportedLocales = new HashSet<String>();
            for (Element supportedLocaleElement : portletElement.elements("supported-locale")) {
                String supportedLocale = supportedLocaleElement.getText();
                supportedLocales.add(supportedLocale);
            }
            portletModel.setSupportedLocales(supportedLocales);
            portletModel.setResourceBundle(portletElement.elementText("resource-bundle"));
            Element element = portletElement.element("portlet-info");
            String portletInfoTitle = null;
            String portletInfoShortTitle = null;
            String portletInfoKeyWords = null;
            String portletInfoDescription = null;
            if (element != null) {
                portletInfoTitle = element.elementText("title");
                portletInfoShortTitle = element.elementText("short-title");
                portletInfoKeyWords = element.elementText("keywords");
            }
            PortletInfo portletInfo = new PortletInfo(portletInfoTitle, portletInfoShortTitle, portletInfoKeyWords, portletInfoDescription);
            portletModel.setPortletInfo(portletInfo);
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            String defaultPreferences = null;
            String preferencesValidator = null;
            if (portletPreferencesElement != null) {
                Element preferencesValidatorElement = portletPreferencesElement.element("preferences-validator");
                if (preferencesValidatorElement != null) {
                    preferencesValidator = preferencesValidatorElement.getText();
                    portletPreferencesElement.remove(preferencesValidatorElement);
                }
                defaultPreferences = portletPreferencesElement.asXML();
            }
            portletModel.setDefaultPreferences(defaultPreferences);
            portletModel.setPreferencesValidator(preferencesValidator);
            if (!portletApp.isWARFile() && Validator.isNotNull(preferencesValidator) && PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                try {
                    PreferencesValidator preferencesValidatorObj = PortalUtil.getPreferencesValidator(portletModel);
                    preferencesValidatorObj.validate(PortletPreferencesFactoryUtil.fromDefaultXML(defaultPreferences));
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block27;
                    _log.warn("Portlet with the name " + portletId + " does not have valid default preferences");
                }
            }
        }
        HashSet<String> unlinkedRoles = new HashSet<String>();
        for (Element element : portletElement.elements("security-role-ref")) {
            unlinkedRoles.add(element.elementText("role-name"));
        }
        portletModel.setUnlinkedRoles(unlinkedRoles);
        HashSet<QName> processingEvents = new HashSet<QName>();
        for (Element element : portletElement.elements("supported-processing-event")) {
            Element element2 = element.element("qname");
            Element nameElement = element.element("name");
            QName qName = PortletQNameUtil.getQName(element2, nameElement, portletApp.getDefaultNamespace());
            processingEvents.add(qName);
            Set<EventDefinition> eventDefinitions = portletApp.getEventDefinitions();
            for (EventDefinition eventDefinition : eventDefinitions) {
                Set<QName> qNames = eventDefinition.getQNames();
                if (!qNames.contains(qName)) continue;
                processingEvents.addAll(qNames);
            }
        }
        portletModel.setProcessingEvents(processingEvents);
        HashSet<QName> hashSet = new HashSet<QName>();
        for (Element element : portletElement.elements("supported-publishing-event")) {
            Element qNameElement = element.element("qname");
            Element nameElement = element.element("name");
            QName qName = PortletQNameUtil.getQName(qNameElement, nameElement, portletApp.getDefaultNamespace());
            hashSet.add(qName);
        }
        portletModel.setPublishingEvents(hashSet);
        HashSet<PublicRenderParameter> hashSet2 = new HashSet<PublicRenderParameter>();
        for (Element supportedPublicRenderParameter : portletElement.elements("supported-public-render-parameter")) {
            String identifier = supportedPublicRenderParameter.getTextTrim();
            PublicRenderParameter publicRenderParameter = portletApp.getPublicRenderParameter(identifier);
            if (publicRenderParameter == null) {
                _log.error("Supported public render parameter references unknown identifier " + (String)identifier);
                continue;
            }
            hashSet2.add(publicRenderParameter);
        }
        portletModel.setPublicRenderParameters(hashSet2);
        Map<String, String[]> map = portletApp.getContainerRuntimeOptions();
        String containerRuntimeOptionPrefix = LiferayPortletConfig.class.getName();
        containerRuntimeOptionPrefix = containerRuntimeOptionPrefix.concat(portletName);
        for (Element containerRuntimeOptionElement : portletElement.elements("container-runtime-option")) {
            name = GetterUtil.getString(containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            map.put(containerRuntimeOptionPrefix.concat(name), values.toArray(new String[0]));
        }
        for (Element dependencyElement : portletElement.elements("dependency")) {
            name = GetterUtil.getString(dependencyElement.elementText("name"));
            String scope = GetterUtil.getString(dependencyElement.elementText("scope"));
            String version = GetterUtil.getString(dependencyElement.elementText("version"));
            portletModel.addPortletDependency(PortletDependencyFactoryUtil.createPortletDependency(name, scope, version));
        }
        portletModel.setAsyncSupported(GetterUtil.getBoolean(portletElement.elementText("async-supported")));
        Element multipartConfigElement = portletElement.element("multipart-config");
        if (multipartConfigElement != null) {
            portletModel.setMultipartFileSizeThreshold(GetterUtil.getInteger(multipartConfigElement.elementText("file-size-threshold")));
            portletModel.setMultipartLocation(multipartConfigElement.elementText("location"));
            portletModel.setMultipartMaxFileSize(GetterUtil.getLong(multipartConfigElement.elementText("max-file-size"), -1L));
            portletModel.setMultipartMaxRequestSize(GetterUtil.getLong(multipartConfigElement.elementText("max-request-size"), -1L));
        }
        portletsMap.put(portletId, portletModel);
    }

    protected Map<String, Portlet> readPortletXML(String servletContextName, ServletContext servletContext, String xml, Set<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        QName qName;
        String[] versionAttributeParts;
        HashMap<String, Portlet> portletsMap = new HashMap<String, Portlet>();
        if (xml == null) {
            return portletsMap;
        }
        Document document = UnsecureSAXReaderUtil.read(xml, PropsValues.PORTLET_XML_VALIDATE);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this.getPortletApp(servletContextName);
        portletApp.addServletURLPatterns(servletURLPatterns);
        portletApp.setServletContext(servletContext);
        portletApp.setSpecMajorVersion(2);
        portletApp.setSpecMinorVersion(0);
        Attribute versionAttribute = rootElement.attribute("version");
        if (versionAttribute != null && (versionAttributeParts = StringUtil.split(versionAttribute.getValue(), '.')).length > 0) {
            portletApp.setSpecMajorVersion(GetterUtil.getInteger(versionAttributeParts[0], 2));
            if (versionAttributeParts.length > 1) {
                portletApp.setSpecMinorVersion(GetterUtil.getInteger(versionAttributeParts[1]));
            }
        }
        Set<String> userAttributes = portletApp.getUserAttributes();
        for (Element element : rootElement.elements("user-attribute")) {
            String string = element.elementText("name");
            userAttributes.add(string);
        }
        String defaultNamespace = rootElement.elementText("default-namespace");
        if (Validator.isNotNull(defaultNamespace)) {
            portletApp.setDefaultNamespace(defaultNamespace);
        }
        for (Element element : rootElement.elements("event-definition")) {
            Element element2 = element.element("qname");
            Element element3 = element.element("name");
            String string = element.elementText("value-type");
            qName = PortletQNameUtil.getQName(element2, element3, portletApp.getDefaultNamespace());
            EventDefinitionImpl eventDefinition = new EventDefinitionImpl(qName, string, portletApp);
            List<Element> aliases = element.elements("alias");
            for (Element element4 : aliases) {
                qName = PortletQNameUtil.getQName(element4, null, portletApp.getDefaultNamespace());
                eventDefinition.addAliasQName(qName);
            }
            portletApp.addEventDefinition(eventDefinition);
        }
        for (Element element : rootElement.elements("public-render-parameter")) {
            String string = element.elementText("identifier");
            Element element5 = element.element("qname");
            Element element6 = element.element("name");
            qName = PortletQNameUtil.getQName(element5, element6, portletApp.getDefaultNamespace());
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(string, qName, portletApp);
            portletApp.addPublicRenderParameter(publicRenderParameter);
        }
        for (Element element : rootElement.elements("container-runtime-option")) {
            String string = GetterUtil.getString(element.elementText("name"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Element valueElement : element.elements("value")) {
                arrayList.add(valueElement.getTextTrim());
            }
            Map<String, String[]> map = portletApp.getContainerRuntimeOptions();
            map.put(string, arrayList.toArray(new String[0]));
            if (!string.equals("com.liferay.portal.portalContext") || arrayList.isEmpty() || !GetterUtil.getBoolean((String)arrayList.get(0))) continue;
            portletApp.setWARFile(false);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Element element : rootElement.elements("custom-portlet-mode")) {
            String string = StringUtil.toLowerCase(element.elementTextTrim("portlet-mode"));
            boolean bl = Boolean.valueOf(element.elementText("portal-managed"));
            if (this._isCustomPortletMode(string) && bl) continue;
            hashSet.add(string);
        }
        for (Element element : rootElement.elements("portlet")) {
            this.readPortletXML(servletContextName, pluginPackage, portletApp, element, portletsMap, hashSet);
        }
        ArrayList<PortletFilterImpl> arrayList = new ArrayList<PortletFilterImpl>();
        for (Element element : rootElement.elements("filter")) {
            String string = element.elementText("filter-name");
            String filterClass = element.elementText("filter-class");
            int ordinal = GetterUtil.getInteger(element.elementText("ordinal"));
            LinkedHashSet<String> lifecycles = new LinkedHashSet<String>();
            for (Element element7 : element.elements("lifecycle")) {
                lifecycles.add(element7.getText());
            }
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParamElement : element.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            arrayList.add(new PortletFilterImpl(string, filterClass, ordinal, lifecycles, initParams, portletApp));
        }
        Collections.sort(arrayList, Comparator.comparingInt(PortletFilter::getOrdinal));
        for (PortletFilter portletFilter : arrayList) {
            portletApp.addPortletFilter(portletFilter);
        }
        for (Element element : rootElement.elements("filter-mapping")) {
            String string = element.elementText("filter-name");
            PortletFilter portletFilter = portletApp.getPortletFilter(string);
            if (portletFilter == null) {
                _log.error("Filter mapping references unknown filter name " + string);
                continue;
            }
            for (Element portletNameElement : element.elements("portlet-name")) {
                String portletName = portletNameElement.getTextTrim();
                List<Portlet> list = this.getPortletsByPortletName(portletName, servletContextName, portletsMap);
                if (list.isEmpty()) {
                    _log.error(StringBundler.concat("Filter mapping with filter name ", string, " references unknown portlet name ", portletName));
                }
                for (Portlet portletModel : list) {
                    Map<String, PortletFilter> portletFiltersMap = portletModel.getPortletFilters();
                    portletFiltersMap.put(string, portletFilter);
                }
            }
        }
        ArrayList<PortletURLListenerImpl> arrayList2 = new ArrayList<PortletURLListenerImpl>();
        for (Element element : rootElement.elements("listener")) {
            String listenerClass = element.elementText("listener-class");
            int ordinal = GetterUtil.getInteger(element.elementText("ordinal"));
            arrayList2.add(new PortletURLListenerImpl(listenerClass, ordinal, portletApp));
        }
        Collections.sort(arrayList2, Comparator.comparingInt(PortletURLListener::getOrdinal));
        for (PortletURLListener portletURLListener : arrayList2) {
            portletApp.addPortletURLListener(portletURLListener);
        }
        return portletsMap;
    }

    protected Set<String> readWebXML(String xml) throws Exception {
        LinkedHashSet<String> servletURLPatterns = new LinkedHashSet<String>();
        if (xml == null) {
            return servletURLPatterns;
        }
        Document document = UnsecureSAXReaderUtil.read(xml);
        Element rootElement = document.getRootElement();
        for (Element servletMappingElement : rootElement.elements("servlet-mapping")) {
            String urlPattern = servletMappingElement.elementText("url-pattern");
            servletURLPatterns.add(urlPattern);
        }
        return servletURLPatterns;
    }

    protected void setSpriteImages(ServletContext servletContext, PortletApp portletApp, String resourcePath) throws Exception {
        String rootPath;
        String spritePropertiesFileName;
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths == null || resourcePaths.isEmpty()) {
            return;
        }
        ArrayList<URL> imageURLs = new ArrayList<URL>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this.setSpriteImages(servletContext, portletApp, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            URL imageURL = servletContext.getResource(curResourcePath);
            if (imageURL != null) {
                imageURLs.add(imageURL);
                continue;
            }
            _log.error("Resource URL for " + curResourcePath + " is null");
        }
        String spriteRootDirName = PropsValues.SPRITE_ROOT_DIR;
        String spriteFileName = resourcePath.concat(PropsValues.SPRITE_FILE_NAME);
        Properties spriteProperties = SpriteProcessorUtil.generate(servletContext, imageURLs, spriteRootDirName, spriteFileName, spritePropertiesFileName = resourcePath.concat(PropsValues.SPRITE_PROPERTIES_FILE_NAME), rootPath = ServletContextUtil.getRootPath(servletContext), 16, 16, 10240);
        if (spriteProperties == null) {
            return;
        }
        String contextPath = servletContext.getContextPath();
        spriteFileName = contextPath.concat("/sprite").concat(spriteFileName);
        portletApp.setSpriteImages(spriteFileName, spriteProperties);
    }

    protected Portlet updatePortlet(long companyId, String portletId, String roles) {
        Portlet existingPortlet = this.portletPersistence.fetchByC_P(companyId, portletId);
        boolean active = true;
        if (existingPortlet != null) {
            active = existingPortlet.isActive();
        }
        return this.updatePortlet(companyId, portletId, roles, active);
    }

    private Configuration _getConfiguration(PortletApp portletApp) {
        ServletContext servletContext;
        ClassLoader classLoader;
        String propertyFileName = "portal";
        if (portletApp.isWARFile()) {
            propertyFileName = "portlet";
        }
        if ((classLoader = (servletContext = portletApp.getServletContext()).getClassLoader()).getResource(propertyFileName + ".properties") == null) {
            return null;
        }
        return ConfigurationFactoryUtil.getConfiguration(classLoader, propertyFileName);
    }

    private ClassLoader _getServletContextClassLoader(String servletContextName) {
        ClassLoader classLoader = ServletContextClassLoaderPool.getClassLoader(servletContextName);
        if (classLoader == null) {
            throw new IllegalStateException("Unable to find class loader for servlet context " + servletContextName);
        }
        return classLoader;
    }

    private boolean _isCustomPortletMode(String portletModeName) {
        return PortalUtil.isCustomPortletMode(new PortletMode(portletModeName));
    }

    private void _readWebXML(String xml, String servletContextName) throws Exception {
        HashMap<String, String> localeEncodings = new HashMap<String, String>();
        Document document = UnsecureSAXReaderUtil.read(xml);
        Element rootElement = document.getRootElement();
        for (Element localeEncodingMappingListElement : rootElement.elements("locale-encoding-mapping-list")) {
            for (Element localeEncodingMappingElement : localeEncodingMappingListElement.elements("locale-encoding-mapping")) {
                String locale = GetterUtil.getString(localeEncodingMappingElement.elementText("locale"));
                String encoding = GetterUtil.getString(localeEncodingMappingElement.elementText("encoding"));
                localeEncodings.put(locale, encoding);
            }
        }
        ExtraPortletAppConfig extraPortletAppConfig = new ExtraPortletAppConfig(localeEncodings);
        ExtraPortletAppConfigRegistry.registerExtraPortletAppConfig(servletContextName, extraPortletAppConfig);
    }

    static {
        _portletsMap = new ConcurrentHashMap<String, Portlet>();
        _portletsMaps = new ConcurrentHashMap<Long, Map<String, Portlet>>();
    }

    private class FriendlyURLMapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<FriendlyURLMapper, String[]> {
        private FriendlyURLMapperServiceTrackerCustomizer() {
        }

        @Override
        public String[] addingService(ServiceReference<FriendlyURLMapper> serviceReference) {
            Object propertyValue = serviceReference.getProperty("javax.portlet.name");
            if (propertyValue == null) {
                return null;
            }
            if (propertyValue instanceof String) {
                Object[] newFriendlyURLMapperRootPortletIds;
                String[] friendlyURLMapperRootPortletIds;
                String portletId = (String)propertyValue;
                String rootPortletId = PortletIdCodec.decodePortletName(portletId);
                rootPortletId = JS.getSafeName(rootPortletId);
                do {
                    friendlyURLMapperRootPortletIds = (String[])PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.get();
                    newFriendlyURLMapperRootPortletIds = ArrayUtil.append(friendlyURLMapperRootPortletIds, rootPortletId);
                    Arrays.sort(newFriendlyURLMapperRootPortletIds);
                } while (!PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.compareAndSet(friendlyURLMapperRootPortletIds, newFriendlyURLMapperRootPortletIds));
                return new String[]{rootPortletId};
            }
            if (propertyValue instanceof String[]) {
                Object[] newFriendlyURLMapperRootPortletIds;
                String[] friendlyURLMapperRootPortletIds;
                String[] portletIds = (String[])propertyValue;
                String[] rootPortletIds = new String[portletIds.length];
                for (int i = 0; i < portletIds.length; ++i) {
                    String rootPortletId = PortletIdCodec.decodePortletName(portletIds[i]);
                    rootPortletIds[i] = JS.getSafeName(rootPortletId);
                }
                do {
                    friendlyURLMapperRootPortletIds = (String[])PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.get();
                    newFriendlyURLMapperRootPortletIds = ArrayUtil.append(friendlyURLMapperRootPortletIds, rootPortletIds);
                    Arrays.sort(newFriendlyURLMapperRootPortletIds);
                } while (!PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.compareAndSet(friendlyURLMapperRootPortletIds, newFriendlyURLMapperRootPortletIds));
                return rootPortletIds;
            }
            return null;
        }

        @Override
        public void modifiedService(ServiceReference<FriendlyURLMapper> serviceReference, String[] rootPortletIds) {
            this.removedService(serviceReference, rootPortletIds);
            this.addingService(serviceReference);
        }

        @Override
        public void removedService(ServiceReference<FriendlyURLMapper> serviceReference, String[] rootPortletIds) {
            String[] newFriendlyURLMapperRootPortletIds;
            String[] friendlyURLMapperRootPortletIds;
            do {
                newFriendlyURLMapperRootPortletIds = friendlyURLMapperRootPortletIds = (String[])PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.get();
                for (String rootPortletId : rootPortletIds) {
                    newFriendlyURLMapperRootPortletIds = ArrayUtil.remove(newFriendlyURLMapperRootPortletIds, rootPortletId);
                }
            } while (!PortletLocalServiceImpl.this._friendlyURLMapperRootPortletIds.compareAndSet(friendlyURLMapperRootPortletIds, newFriendlyURLMapperRootPortletIds));
        }
    }
}

