/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortalPreferencesLocalServiceBaseImpl;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import javax.portlet.PortletPreferences;

public class PortalPreferencesLocalServiceImpl
extends PortalPreferencesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalPreferencesLocalServiceImpl.class);

    @Override
    public com.liferay.portal.kernel.model.PortalPreferences addPortalPreferences(long ownerId, int ownerType, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences;
        block5: {
            com.liferay.portal.kernel.model.PortalPreferences previousPortalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
            if (previousPortalPreferences != null) {
                throw new IllegalArgumentException("Duplicate owner ID and owner type exists in " + previousPortalPreferences);
            }
            PortalPreferencesWrapperCacheUtil.remove(ownerId, ownerType);
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
            if (Validator.isNull(defaultPreferences)) {
                defaultPreferences = "<portlet-preferences />";
            }
            portalPreferences.setPreferences(defaultPreferences);
            try {
                this.portalPreferencesPersistence.update(portalPreferences);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn(StringBundler.concat("Add failed, fetch {ownerId=", ownerId, ", ownerType=", ownerType, "}"));
                }
                if ((portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType, false)) != null) break block5;
                throw se;
            }
        }
        return portalPreferences;
    }

    @Override
    public com.liferay.portal.kernel.model.PortalPreferences fetchPortalPreferences(long ownerId, int ownerType) {
        return this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
    }

    @Override
    public PortletPreferences getPreferences(long ownerId, int ownerType) {
        return this.getPreferences(ownerId, ownerType, null);
    }

    @Override
    public PortletPreferences getPreferences(long ownerId, int ownerType, String defaultPreferences) {
        PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
        if (portalPreferencesWrapper != null) {
            return portalPreferencesWrapper.clone();
        }
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            portalPreferences = this.portalPreferencesLocalService.addPortalPreferences(ownerId, ownerType, defaultPreferences);
        }
        PortalPreferencesImpl portalPreferencesImpl = new PortalPreferencesImpl(portalPreferences, false);
        portalPreferencesWrapper = new PortalPreferencesWrapper(portalPreferencesImpl);
        PortalPreferencesWrapperCacheUtil.put(ownerId, ownerType, portalPreferencesWrapper);
        return portalPreferencesWrapper.clone();
    }

    @Override
    public com.liferay.portal.kernel.model.PortalPreferences updatePreferences(long ownerId, int ownerType, PortalPreferences portalPreferences) {
        String xml = PortletPreferencesFactoryUtil.toXML(portalPreferences);
        return this.updatePreferences(ownerId, ownerType, xml);
    }

    @Override
    public com.liferay.portal.kernel.model.PortalPreferences updatePreferences(long ownerId, int ownerType, String xml) {
        PortalPreferencesWrapperCacheUtil.remove(ownerId, ownerType);
        com.liferay.portal.kernel.model.PortalPreferences portalPreferences = this.portalPreferencesPersistence.fetchByO_O(ownerId, ownerType);
        if (portalPreferences == null) {
            long portalPreferencesId = this.counterLocalService.increment();
            portalPreferences = this.portalPreferencesPersistence.create(portalPreferencesId);
            portalPreferences.setOwnerId(ownerId);
            portalPreferences.setOwnerType(ownerType);
        }
        portalPreferences.setPreferences(xml);
        return this.portalPreferencesPersistence.update(portalPreferences);
    }
}

