/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Plugin;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.model.impl.PluginSettingImpl;
import com.liferay.portal.service.base.PluginSettingLocalServiceBaseImpl;

public class PluginSettingLocalServiceImpl
extends PluginSettingLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PluginSettingLocalServiceImpl.class);

    @Override
    public void checkPermission(long userId, String pluginId, String pluginType) throws PortalException {
        if (!this.hasPermission(userId, pluginId, pluginType)) {
            throw new PrincipalException.MustHavePermission(userId, pluginType, pluginId);
        }
    }

    @Override
    public PluginSetting getDefaultPluginSetting() {
        PluginSettingImpl pluginSetting = new PluginSettingImpl();
        pluginSetting.setRoles("");
        pluginSetting.setActive(true);
        return pluginSetting;
    }

    @Override
    public PluginSetting getPluginSetting(long companyId, String pluginId, String pluginType) {
        PluginSetting pluginSetting = this.pluginSettingPersistence.fetchByC_I_T(companyId, pluginId, pluginType);
        if (pluginSetting != null) {
            return pluginSetting;
        }
        Plugin plugin = null;
        if (pluginType.equals("layouttpl")) {
            plugin = this.layoutTemplateLocalService.getLayoutTemplate(pluginId, false, null);
        } else if (pluginType.equals("theme")) {
            plugin = this.themeLocalService.getTheme(companyId, pluginId);
        }
        if (plugin == null || plugin.getDefaultPluginSetting() == null) {
            pluginSetting = this.getDefaultPluginSetting();
            pluginSetting.setCompanyId(companyId);
        } else {
            pluginSetting = plugin.getDefaultPluginSetting(companyId);
        }
        return pluginSetting;
    }

    @Override
    public boolean hasPermission(long userId, String pluginId, String pluginType) {
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            PluginSetting pluginSetting = this.getPluginSetting(user.getCompanyId(), pluginId, pluginType);
            return pluginSetting.hasPermission(userId);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Could not check permissions for " + pluginId, e);
            }
            return false;
        }
    }

    @Override
    public PluginSetting updatePluginSetting(long companyId, String pluginId, String pluginType, String roles, boolean active) {
        PluginSetting pluginSetting = this.pluginSettingPersistence.fetchByC_I_T(companyId, pluginId = PortalUtil.getJsSafePortletId(pluginId), pluginType);
        if (pluginSetting == null) {
            long pluginSettingId = this.counterLocalService.increment();
            pluginSetting = this.pluginSettingPersistence.create(pluginSettingId);
            pluginSetting.setCompanyId(companyId);
            pluginSetting.setPluginId(pluginId);
            pluginSetting.setPluginType(pluginType);
        }
        pluginSetting.setRoles(roles);
        pluginSetting.setActive(active);
        this.pluginSettingPersistence.update(pluginSetting);
        return pluginSetting;
    }
}

